/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.util;

import com.alachisoft.ncache.runtime.util.HelperFxn;
import com.google.protobuf.ByteString;
import java.util.List;

public class VirtualArray {
    private List<ByteString> _baseArray;
    private long _size;

    public VirtualArray(List<ByteString> array) {
        this._baseArray = array;
        for (int i = 0; i < array.size(); ++i) {
            byte[] tmp = array.get(i).toByteArray();
            if (tmp == null) continue;
            this._size += (long)tmp.length;
        }
    }

    public int CopyData(byte[] buffer, int offset, int length) throws IllegalArgumentException {
        int dataToCopy;
        if (offset + length > buffer.length) {
            throw new IllegalArgumentException("Length plus offset is greater than buffer size");
        }
        int dataCopied = dataToCopy = (int)((long)length >= this._size ? this._size : (long)length);
        int i = 0;
        while (dataToCopy > 0) {
            byte[] binarChunk = this._baseArray.get(i).toByteArray();
            if (binarChunk != null) {
                int copyCount = Math.min(binarChunk.length, dataToCopy);
                HelperFxn.BlockCopy((byte[])binarChunk, (int)0, (byte[])buffer, (int)offset, (int)copyCount);
                offset += copyCount;
                dataToCopy -= copyCount;
            }
            ++i;
        }
        return dataCopied;
    }
}

