/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.util;

import Alachisoft.NCache.Common.ServicePropValues;
import Alachisoft.NCache.Config.Mapping;
import com.alachisoft.ncache.client.CacheConnectionOptions;
import com.alachisoft.ncache.client.CacheManager;
import com.alachisoft.ncache.client.ClientCacheSyncMode;
import com.alachisoft.ncache.client.LogLevel;
import com.alachisoft.ncache.client.ServerInfo;
import com.alachisoft.ncache.client.internal.util.DirectoryUtil;
import com.alachisoft.ncache.client.internal.util.Search;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tangible.DotNetToJavaStringHelper;
import tangible.OutObject;

public final class ClientConfiguration {
    private boolean _balanceNodes = true;
    private boolean _loadServersFromConfigFile = true;
    private boolean _loadCacheConfiguration = true;
    private int _serverPort = 9800;
    private int _clientRequestTimeout = 90000;
    private int _connectionTimeout = 5000;
    private int _retries = 5;
    private int _retryInternal = 1000;
    private int _itemSizeThreshHold = 0;
    private double _retryConnectionDelay = 10.0;
    private String _cacheId;
    private String _clientCacheID = "";
    private String _defaultReadThruProvider;
    private String _defaultWriteThruProvider;
    private ArrayList _servers = new ArrayList();
    private Hashtable _compactTypes = new Hashtable();
    private ClientCacheSyncMode _clientCacheSyncMode = ClientCacheSyncMode.Optimistic;
    private CacheConnectionOptions _cacheConnectionOptions;
    private Hashtable _mappedServer = new Hashtable();
    private Search _search = Search.LocalSearch;
    private Search _result = Search.LocalSearch;
    private String _localServerIP;
    private boolean enableClientLogs;
    private boolean enableDetailedClientLogs;
    private boolean iPMappingConfigured;
    private int currentServerIndex;
    private boolean importHashmap = true;
    private String clientCacheID;
    private int configServerPort = 9800;
    private int commandRetries = 1;
    private float commandRetryInterval;
    private boolean _enableKeepAlive = false;
    private int keepAliveInterval = 30;
    private LogLevel logLevels;
    private static String _installDir = null;
    String _configFile = "client.ncconf";
    private boolean _skipUnAvailableClientCache = true;
    private int _retryL1ConnectionInterval = 10;

    public boolean isSkipUnAvailableClientCache() {
        return this._skipUnAvailableClientCache;
    }

    public void setSkipUnAvailableClientCache(boolean skipUnAvailableClientCache) {
        this._skipUnAvailableClientCache = skipUnAvailableClientCache;
    }

    public int getRetryL1ConnectionInterval() {
        return this._retryL1ConnectionInterval;
    }

    public void setRetryL1ConnectionInterval(int retryL1ConnectionInterval) {
        this._retryL1ConnectionInterval = this._retryL1ConnectionInterval;
    }

    public ClientConfiguration(String cacheId) {
        this._cacheId = cacheId;
        this._cacheConnectionOptions = null;
    }

    public ClientConfiguration(String cacheId, CacheConnectionOptions cacheConnectionOptions) {
        this._cacheId = cacheId;
        this._cacheConnectionOptions = (CacheConnectionOptions)cacheConnectionOptions.clone();
        if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.getServerList() != null && this._cacheConnectionOptions.getServerList().size() > 0) {
            for (ServerInfo serverInfo : this._cacheConnectionOptions.getServerList()) {
                serverInfo.setIsUserProvidedInternal(true);
                this.addServer(serverInfo);
            }
            this._loadServersFromConfigFile = false;
        }
    }

    public CacheConnectionOptions getCacheConnectionOptions() {
        return this._cacheConnectionOptions;
    }

    public void setLoadCacheConfiguration(boolean load) {
        this._loadCacheConfiguration = load;
    }

    public String getLocalServerIP() {
        return this._localServerIP;
    }

    public void setLocalServerIP(String ip) {
        this._localServerIP = ip;
    }

    public boolean getEnableClientLogs() {
        return this.enableClientLogs;
    }

    public void setEnableClientLogs(boolean value) {
        this.enableClientLogs = value;
    }

    public boolean getEnableDetailedClientLogs() {
        return this.enableDetailedClientLogs;
    }

    public void setEnableDetailedClientLogs(boolean value) {
        this.enableDetailedClientLogs = value;
    }

    public boolean getIPMappingConfigured() {
        return this.iPMappingConfigured;
    }

    public void setIPMappingConfigured(boolean value) {
        this.iPMappingConfigured = value;
    }

    public int getServerCount() {
        return this._servers.size();
    }

    public int getCurrentServerIndex() {
        return this.currentServerIndex;
    }

    public void setCurrentServerIndex(int value) {
        this.currentServerIndex = value;
    }

    public int getItemSizeThreshHold() {
        return this._itemSizeThreshHold;
    }

    public boolean getBalanceNodes() {
        if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.IsSet("balanceNodes")) {
            return this._cacheConnectionOptions.getLoadBalance();
        }
        return this._balanceNodes;
    }

    public void setBalanceNodes(boolean value) {
        this._balanceNodes = value;
    }

    public boolean getImportHashmap() {
        return this.importHashmap;
    }

    public void setImportHashmap(boolean value) {
        this.importHashmap = value;
    }

    public boolean getClientCache() {
        return this.getClientCacheID().trim().length() > 0;
    }

    public String getClientCacheID() {
        return this.clientCacheID;
    }

    public void setClientCacheID(String value) {
        this.clientCacheID = value;
    }

    public ClientCacheSyncMode getCacheSyncMode() {
        if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.IsSet("cacheSyncMode")) {
            return this._cacheConnectionOptions.getClientCacheMode();
        }
        return this._clientCacheSyncMode;
    }

    public void setCacheSyncMode(ClientCacheSyncMode value) {
        this._clientCacheSyncMode = value;
    }

    public String getDefaultReadThru() {
        if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.IsSet("defaultReadThruProvider")) {
            return this._cacheConnectionOptions.getDefaultReadThruProvider();
        }
        return this._defaultReadThruProvider;
    }

    public String getDefaultWriteThru() {
        if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.IsSet("defaultWriteThruProvider")) {
            return this._cacheConnectionOptions.getDefaultWriteThruProvider();
        }
        return this._defaultWriteThruProvider;
    }

    public String getBindIP() {
        File file;
        if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.IsSet("bindIP")) {
            return this._cacheConnectionOptions.getClientBindIP();
        }
        String bindIP = "";
        try {
            String path = DirectoryUtil.getBaseFilePath("client.ncconf");
            file = new File(path);
        }
        catch (Exception e) {
            return bindIP;
        }
        Document configuration = null;
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            NamedNodeMap attributes;
            Node childNode;
            NodeList clientNodes;
            builder = builderFactory.newDocumentBuilder();
            configuration = builder.parse(file);
            NodeList clientNodesServer = configuration.getElementsByTagName("ncache-server");
            NodeList clientNodesClient = configuration.getElementsByTagName("ncache-client");
            NodeList nodeList = clientNodes = clientNodesClient != null && clientNodesClient.getLength() > 0 ? clientNodesClient : clientNodesServer;
            if (clientNodes != null && clientNodes.getLength() > 0 && (childNode = clientNodes.item(0)) != null && (attributes = childNode.getAttributes()) != null) {
                String currentAttrib = "";
                if (attributes.getNamedItem("local-server-ip") != null && (currentAttrib = attributes.getNamedItem("local-server-ip").getNodeValue()) != null) {
                    bindIP = currentAttrib;
                }
            }
            return bindIP;
        }
        catch (Exception ex) {
            return bindIP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getServerList() {
        ArrayList arrayList = this._servers;
        synchronized (arrayList) {
            Object tempVar = this._servers.clone();
            return (ArrayList)(tempVar instanceof ArrayList ? tempVar : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInfo getServerAt(int index) {
        ServerInfo nextServer = null;
        ArrayList arrayList = this._servers;
        synchronized (arrayList) {
            if (this._servers != null && this._servers.size() > 0 && index < this._servers.size()) {
                nextServer = this._servers.get(index) instanceof ServerInfo ? this._servers.get(index) : null;
            }
        }
        return nextServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInfo getNextServer() {
        ServerInfo nextServer = null;
        ArrayList arrayList = this._servers;
        synchronized (arrayList) {
            if (this._servers != null && this._servers.size() > 0) {
                if (this.getCurrentServerIndex() > this._servers.size()) {
                    this.setCurrentServerIndex(0);
                }
                if (this.getCurrentServerIndex() < 0) {
                    this.setCurrentServerIndex(0);
                }
                nextServer = this._servers.get(this.getCurrentServerIndex()) instanceof ServerInfo ? this._servers.get(this.getCurrentServerIndex()) : null;
                this.setCurrentServerIndex(this.getCurrentServerIndex() + 1);
                if (this.getCurrentServerIndex() > this._servers.size() - 1) {
                    this.setCurrentServerIndex(0);
                }
            }
        }
        return nextServer;
    }

    public int getConfigServerPort() {
        return this.configServerPort;
    }

    private void setConfigServerPort(int value) {
        this.configServerPort = value;
    }

    public int getClientRequestTimeout() {
        if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.IsSet("opTimeOut")) {
            return (int)this._cacheConnectionOptions.getClientRequestTimeOut().getTotalMiliSeconds();
        }
        return this._clientRequestTimeout;
    }

    public int getConnectionTimeout() {
        if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.IsSet("connectionTimeOut")) {
            return (int)this._cacheConnectionOptions.getConnectionTimeout().getTotalMiliSeconds();
        }
        return this._connectionTimeout;
    }

    public double getRetryConnectionDelay() {
        if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.IsSet("retryConnectionDelay")) {
            return this._cacheConnectionOptions.getRetryConnectionDelay().getTotalMinutes();
        }
        return this._retryConnectionDelay;
    }

    public int getConnectionRetries() {
        if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.IsSet("connectionRetries")) {
            return this._cacheConnectionOptions.getConnectionRetries();
        }
        return this._retries;
    }

    public int getRetryInterval() {
        if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.IsSet("retryInterval")) {
            return (int)this._cacheConnectionOptions.getRetryInterval().getTotalMiliSeconds();
        }
        return this._retryInternal;
    }

    public int getCommandRetries() {
        return this.commandRetries;
    }

    private void setCommandRetries(int value) {
        this.commandRetries = value;
    }

    public float getCommandRetryInterval() {
        return this.commandRetryInterval;
    }

    private void setCommandRetryInterval(float value) {
        this.commandRetryInterval = value;
    }

    public boolean getEnableKeepAlive() {
        return this._enableKeepAlive;
    }

    public void setEnableKeepAlive(boolean value) {
        this._enableKeepAlive = value;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    private void setKeepAliveInterval(int value) {
        this.keepAliveInterval = value;
    }

    public LogLevel getLogLevels() {
        return this.logLevels;
    }

    private void setLogLevels(LogLevel value) {
        this.logLevels = value;
    }

    public int getServerPort() {
        if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.IsSet("port")) {
            return this._cacheConnectionOptions.getPort();
        }
        return this._serverPort;
    }

    public void setServerPort(int value) {
        this._serverPort = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServer(ServerInfo server) {
        if (!(this._servers == null || DotNetToJavaStringHelper.isNullOrEmpty((String)server.getName()) && server.getIP() == null)) {
            ArrayList arrayList = this._servers;
            synchronized (arrayList) {
                if (!this._servers.contains(server)) {
                    this._servers.add(server);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServer(ServerInfo server) {
        if (this._servers != null && server != null) {
            ArrayList arrayList = this._servers;
            synchronized (arrayList) {
                ServerInfo existingServer;
                if (this._servers.contains(server) && !(existingServer = (ServerInfo)this._servers.get(this._servers.indexOf(server))).getIsUserProvidedInternal()) {
                    if (this.getCurrentServerIndex() == this._servers.size() - 1) {
                        int index = this.getCurrentServerIndex();
                        this.setCurrentServerIndex(index--);
                    }
                    this._servers.remove(server);
                }
            }
        }
    }

    public ServerInfo getMappedServer(String ip, int port) {
        ServerInfo mapping = null;
        if (this._mappedServer != null || !this._mappedServer.isEmpty()) {
            for (ServerInfo rm : this._mappedServer.keySet()) {
                if (!rm.getName().equals(ip)) continue;
                mapping = new ServerInfo();
                mapping = (ServerInfo)this._mappedServer.get(rm);
            }
        }
        if (mapping == null) {
            mapping = new ServerInfo(ip, port);
        }
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRemoteServerConfig(NodeList cacheConfig) {
        try {
            if (!this._loadServersFromConfigFile) {
                return;
            }
            int PriorityCounter = 1;
            for (int i = 0; i < cacheConfig.getLength(); ++i) {
                Node currentConfig = cacheConfig.item(i);
                if (!currentConfig.getNodeName().equals("server")) continue;
                ServerInfo remoteServer = new ServerInfo();
                try {
                    remoteServer.setName(currentConfig.getAttributes().getNamedItem("name").getNodeValue());
                    remoteServer.setPriorityInternal((short)PriorityCounter);
                    ++PriorityCounter;
                    if (currentConfig.getAttributes().getNamedItem("port-range") != null) {
                        remoteServer.setPortRangeInternal(Short.parseShort(currentConfig.getAttributes().getNamedItem("port-range").getNodeValue()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                remoteServer.setPort(this.getServerPort());
                if (remoteServer.getName() == null && remoteServer.getIP() == null || remoteServer.getPort() == -1) continue;
                ArrayList arrayList = this._servers;
                synchronized (arrayList) {
                    if (!this._servers.contains(remoteServer)) {
                        if (this._mappedServer != null && this._mappedServer.size() != 0) {
                            ServerInfo rm = this.getMappedServer(remoteServer.getName(), remoteServer.getPort());
                            remoteServer.setName(rm.getName());
                            remoteServer.setPort(rm.getPort());
                            if (!this._servers.contains(remoteServer)) {
                                this._servers.add(remoteServer);
                            }
                        } else {
                            remoteServer.setIsUserProvidedInternal(true);
                            this._servers.add(remoteServer);
                        }
                    }
                    continue;
                }
            }
            ArrayList arrayList = this._servers;
            synchronized (arrayList) {
                Collections.sort(this._servers);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRemoteServerMappingConfig(NodeList cacheConfig) {
        Hashtable<ServerInfo, ServerInfo> updatedServerMap = new Hashtable<ServerInfo, ServerInfo>();
        try {
            for (int i = 0; i < cacheConfig.getLength(); ++i) {
                Node currentConfig = cacheConfig.item(i);
                if (!currentConfig.getNodeName().equals("server-end-point")) continue;
                NodeList _mappingConfig = currentConfig.getChildNodes();
                for (int j = 0; j < _mappingConfig.getLength(); ++j) {
                    Node mapNodeConfig = _mappingConfig.item(j);
                    if (!mapNodeConfig.getNodeName().equals("end-point")) continue;
                    ServerInfo publicServer = new ServerInfo();
                    ServerInfo privateServer = new ServerInfo();
                    try {
                        privateServer.setName(mapNodeConfig.getAttributes().getNamedItem("private-ip").getNodeValue());
                        privateServer.setPort(Integer.parseInt(mapNodeConfig.getAttributes().getNamedItem("private-port").getNodeValue()));
                        publicServer.setName(mapNodeConfig.getAttributes().getNamedItem("public-ip").getNodeValue());
                        publicServer.setPort(Integer.parseInt(mapNodeConfig.getAttributes().getNamedItem("public-port").getNodeValue()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (privateServer.getName() == null) continue;
                    Hashtable hashtable = this._mappedServer;
                    synchronized (hashtable) {
                        if (this._mappedServer.size() != 0) {
                            for (ServerInfo rm : (ArrayList)((Object)this._mappedServer.keySet())) {
                                if (rm.getName().equals(privateServer.getName())) continue;
                                updatedServerMap.put(privateServer, publicServer);
                            }
                        } else {
                            this._mappedServer.put(privateServer, publicServer);
                        }
                        continue;
                    }
                }
                this.setIPMappingConfigured(true);
            }
            for (ServerInfo rms : (ArrayList)((Object)updatedServerMap.keySet())) {
                this._mappedServer.put(rms, updatedServerMap.get(rms));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMappedServers(ArrayList<Mapping> mappedServerList) {
        Hashtable<ServerInfo, ServerInfo> updatedServerMap = new Hashtable<ServerInfo, ServerInfo>();
        if (mappedServerList != null) {
            for (Mapping node : mappedServerList) {
                ServerInfo publicServer = new ServerInfo();
                ServerInfo privateServer = new ServerInfo();
                privateServer.setName(node.getPrivateIP());
                privateServer.setPort(node.getPrivatePort());
                publicServer.setName(node.getPublicIP());
                publicServer.setPort(node.getPublicPort());
                if (privateServer.getName() == null) continue;
                Hashtable hashtable = this._mappedServer;
                synchronized (hashtable) {
                    if (this._mappedServer.size() != 0) {
                        boolean keyExists = false;
                        for (ServerInfo rm : (ArrayList)((Object)this._mappedServer.keySet())) {
                            String newServer;
                            if (!rm.getName().equals(privateServer.getName())) {
                                keyExists = false;
                                continue;
                            }
                            keyExists = true;
                            ServerInfo originalPublicServer = (ServerInfo)this._mappedServer.get(rm);
                            String existingServer = originalPublicServer.getName() + ":" + originalPublicServer.getPort();
                            if (existingServer.equals(newServer = publicServer.getName() + ":" + publicServer.getPort())) break;
                            updatedServerMap.put(privateServer, publicServer);
                            break;
                        }
                        if (!keyExists) {
                            updatedServerMap.put(privateServer, publicServer);
                        }
                    } else {
                        this._mappedServer.put(privateServer, publicServer);
                    }
                }
            }
            for (ServerInfo rms : (ArrayList)((Object)updatedServerMap.keySet())) {
                this._mappedServer.put(rms, updatedServerMap.get(rms));
            }
        }
    }

    public boolean isDifferentParamPort(int usedParamPort) {
        return usedParamPort != this.getConfigServerPort();
    }

    public void loadConfiguration() throws ConfigurationException {
        String c_configFileName = null;
        try {
            Node ncacheServerDetails;
            if (this._cacheId == null && this._loadCacheConfiguration) {
                return;
            }
            OutObject tempOut_Result = new OutObject();
            c_configFileName = DirectoryUtil.getBaseFilePath("client.ncconf", this._search, (OutObject<Search>)tempOut_Result);
            this._result = (Search)((Object)tempOut_Result.argValue);
            String path = this.getConfigPath();
            File f = new File(path);
            if (!f.exists()) {
                throw new Exception("'client.ncconf' not found or does not contain server information");
            }
            Document response = null;
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            try {
                builder = builderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            response = builder.parse(f);
            boolean serverPortFound = false;
            NodeList serverPortNL = response.getElementsByTagName("ncache-server");
            if (serverPortNL != null && serverPortNL.getLength() > 0 && (ncacheServerDetails = serverPortNL.item(0)) != null) {
                NamedNodeMap attributes = ncacheServerDetails.getAttributes();
                if (attributes != null) {
                    String currentAttributes = "";
                    if (attributes.getNamedItem("port") != null && attributes.getNamedItem("port").getNodeValue() != null) {
                        this.setConfigServerPort(Integer.parseInt(attributes.getNamedItem("port").getNodeValue()));
                    }
                    if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.getPort() != null) {
                        this.setServerPort(this._cacheConnectionOptions.getPort());
                    } else {
                        this.setServerPort(this.getConfigServerPort());
                    }
                    if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.getClientRequestTimeOut() != null) {
                        this._clientRequestTimeout = Math.toIntExact(this._cacheConnectionOptions.getClientRequestTimeOut().getTotalMiliSeconds());
                    } else if (attributes.getNamedItem("client-request-timeout") != null && attributes.getNamedItem("client-request-timeout").getNodeValue() != null) {
                        this._clientRequestTimeout = Integer.parseInt(attributes.getNamedItem("client-request-timeout").getNodeValue()) * 1000;
                    }
                    if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.getConnectionRetries() != null) {
                        this._retries = this._cacheConnectionOptions.getConnectionRetries();
                    } else if (attributes.getNamedItem("connection-retries") != null && attributes.getNamedItem("connection-retries").getNodeValue() != null) {
                        this._retries = Integer.parseInt(attributes.getNamedItem("connection-retries").getNodeValue());
                    }
                    if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.getRetryInterval() != null) {
                        this._retryInternal = Math.toIntExact(this._cacheConnectionOptions.getRetryInterval().getTotalMiliSeconds());
                    } else if (attributes.getNamedItem("retry-interval") != null && attributes.getNamedItem("retry-interval").getNodeValue() != null) {
                        this._retryInternal = Integer.parseInt(attributes.getNamedItem("retry-interval").getNodeValue()) * 1000;
                    }
                    if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.getCommandRetries() != null) {
                        this.setCommandRetries(this._cacheConnectionOptions.getCommandRetries());
                    } else if (attributes.getNamedItem("command-retries") != null && attributes.getNamedItem("command-retries").getNodeValue() != null) {
                        this.setCommandRetries(Integer.parseInt(attributes.getNamedItem("command-retries").getNodeValue()));
                    }
                    if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.IsSet("commandRetryInterval")) {
                        this.setCommandRetryInterval(new Double(this._cacheConnectionOptions.getCommandRetryInterval().getTotalSeconds()).floatValue());
                    } else if (attributes.getNamedItem("command-retry-interval") != null && attributes.getNamedItem("command-retry-interval").getNodeValue() != null) {
                        this.setCommandRetryInterval(Float.parseFloat(attributes.getNamedItem("command-retry-interval").getNodeValue()));
                    }
                    if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.IsSet("enableKeepAlive")) {
                        this.setEnableKeepAlive(this._cacheConnectionOptions.getEnableKeepAlive());
                    } else if (attributes.getNamedItem("enable-keep-alive") != null && attributes.getNamedItem("enable-keep-alive").getNodeValue() != null) {
                        this.setEnableKeepAlive(Boolean.parseBoolean(attributes.getNamedItem("enable-keep-alive").getNodeValue()));
                    }
                    if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.IsSet("keepAliveInterval")) {
                        this.setKeepAliveInterval((int)this._cacheConnectionOptions.getKeepAliveInterval().getTotalSeconds());
                    } else if (attributes.getNamedItem("keep-alive-interval") != null && attributes.getNamedItem("keep-alive-interval").getNodeValue() != null) {
                        this.setKeepAliveInterval(Integer.parseInt(attributes.getNamedItem("keep-alive-interval").getNodeValue()));
                        if (this.getKeepAliveInterval() < 1 || this.getKeepAliveInterval() > 7200) {
                            this.setKeepAliveInterval(30);
                        }
                    }
                    if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.getConnectionTimeout() != null) {
                        this._connectionTimeout = (int)this._cacheConnectionOptions.getConnectionTimeout().getTotalMiliSeconds();
                    } else if (attributes.getNamedItem("connection-timeout") != null && attributes.getNamedItem("connection-timeout").getNodeValue() != null) {
                        this._connectionTimeout = Integer.parseInt(attributes.getNamedItem("connection-timeout").getNodeValue()) * 1000;
                    }
                    if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.IsSet("retryConnectionDelay")) {
                        this._retryConnectionDelay = (int)this._cacheConnectionOptions.getRetryConnectionDelay().getTotalMinutes();
                    } else if (attributes.getNamedItem("retry-connection-delay") != null && attributes.getNamedItem("retry-connection-delay").getNodeValue() != null) {
                        this._retryConnectionDelay = Integer.parseInt(attributes.getNamedItem("retry-connection-delay").getNodeValue()) / 60;
                    }
                }
                serverPortFound = true;
                Node localServerIPNode = attributes.getNamedItem("local-server-ip");
                if (localServerIPNode != null) {
                    this.setLocalServerIP(localServerIPNode.getTextContent());
                }
            }
            if (!this._loadCacheConfiguration) {
                return;
            }
            if (!serverPortFound) {
                throw new ConfigurationException("ncache-server missing in client confiugration");
            }
            NodeList cacheNL = response.getElementsByTagName("cache");
            if (cacheNL.getLength() == 0) {
                throw new Exception("'client.ncconf' not found or does not contain server information");
            }
            NodeList serversNL = null;
            Node cacheN = null;
            for (int i = 0; i < cacheNL.getLength(); ++i) {
                cacheN = cacheNL.item(i);
                NamedNodeMap attributes = cacheN.getAttributes();
                if (!attributes.getNamedItem("id").getNodeValue().toLowerCase().equals(this._cacheId.toLowerCase())) continue;
                if (attributes.getNamedItem("load-balance") != null) {
                    this._balanceNodes = Boolean.parseBoolean(attributes.getNamedItem("load-balance").getNodeValue());
                }
                if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.getLoadBalance() != null) {
                    this._balanceNodes = this._cacheConnectionOptions.getLoadBalance();
                }
                if (attributes.getNamedItem("client-cache-id") != null) {
                    this.setClientCacheID(attributes.getNamedItem("client-cache-id").getNodeValue());
                }
                if (attributes.getNamedItem("default-readthru-provider") != null) {
                    this._defaultReadThruProvider = attributes.getNamedItem("default-readthru-provider").getNodeValue();
                }
                if (this._cacheConnectionOptions != null && !DotNetToJavaStringHelper.isNullOrEmpty((String)this._cacheConnectionOptions.getDefaultReadThruProvider())) {
                    this._defaultReadThruProvider = this._cacheConnectionOptions.getDefaultReadThruProvider();
                }
                if (attributes.getNamedItem("default-writethru-provider") != null) {
                    this._defaultWriteThruProvider = attributes.getNamedItem("default-writethru-provider").getNodeValue();
                }
                if (this._cacheConnectionOptions != null && !DotNetToJavaStringHelper.isNullOrEmpty((String)this._cacheConnectionOptions.getDefaultWriteThruProvider())) {
                    this._defaultWriteThruProvider = this._cacheConnectionOptions.getDefaultWriteThruProvider();
                }
                if (attributes.getNamedItem("client-cache-syncmode") != null) {
                    ClientCacheSyncMode clientCacheSyncMode = this._clientCacheSyncMode = attributes.getNamedItem("client-cache-syncmode").getNodeValue().toLowerCase().equals("pessimistic") ? ClientCacheSyncMode.Pessimistic : ClientCacheSyncMode.Optimistic;
                }
                if (attributes.getNamedItem("reconnect-client-cache-interval") != null && attributes.getNamedItem("skip-client-cache-if-unavailable").getNodeValue() != null) {
                    this._retryL1ConnectionInterval = Integer.parseInt(attributes.getNamedItem("reconnect-client-cache-interval").getNodeValue());
                }
                if (attributes.getNamedItem("skip-client-cache-if-unavailable") != null) {
                    this._skipUnAvailableClientCache = Boolean.parseBoolean(attributes.getNamedItem("skip-client-cache-if-unavailable").getNodeValue());
                }
                if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.getClientCacheMode() != null) {
                    this._clientCacheSyncMode = this._cacheConnectionOptions.getClientCacheMode();
                }
                if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.getEnableClientLogs() != null) {
                    this.setEnableClientLogs(this._cacheConnectionOptions.getEnableClientLogs());
                } else if (attributes.getNamedItem("enable-client-logs") != null) {
                    this.setEnableClientLogs(Boolean.parseBoolean(attributes.getNamedItem("enable-client-logs").getNodeValue()));
                }
                if (this._cacheConnectionOptions != null && this._cacheConnectionOptions.getLogLevel() != null) {
                    this.setLogLevels(this._cacheConnectionOptions.getLogLevel());
                    switch (this.getLogLevels()) {
                        case Debug: 
                        case Info: {
                            this.setEnableDetailedClientLogs(true);
                            break;
                        }
                        case Error: {
                            this.setEnableDetailedClientLogs(false);
                        }
                    }
                } else if (attributes.getNamedItem("log-level") != null) {
                    String logLevel = attributes.getNamedItem("log-level").getNodeValue().toLowerCase();
                    if (logLevel.equals("info")) {
                        this.setLogLevels(LogLevel.Info);
                        this.setEnableDetailedClientLogs(true);
                    } else if (logLevel.equals("debug")) {
                        this.setLogLevels(LogLevel.Debug);
                        this.setEnableDetailedClientLogs(true);
                    } else if (logLevel.equals("error")) {
                        this.setLogLevels(LogLevel.Error);
                        this.setEnableDetailedClientLogs(false);
                    }
                }
                this.setImportHashmap(true);
                serversNL = cacheN.getChildNodes();
                break;
            }
            if (serversNL == null) {
                if (!DotNetToJavaStringHelper.isNullOrEmpty((String)this._cacheId) && this._result != Search.GlobalSearch) {
                    this._search = Search.forValue(this._result.getValue() + 1);
                    this.loadConfiguration();
                }
                return;
            }
            this._search = this._result;
            this.loadRemoteServerMappingConfig(serversNL);
            this.loadRemoteServerConfig(serversNL);
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    private String getConfigPath() throws Exception {
        String separator = System.getProperty("file.separator");
        Object path = "";
        path = CacheManager.getConfigPath();
        if (path != null && !((String)path).equalsIgnoreCase("")) {
            if (!((String)path).endsWith(separator)) {
                path = ((String)path).concat(separator);
            }
            return ((String)path).concat(this._configFile);
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            path = System.getProperty("user.dir");
            if (path != null) {
                if (!((String)path).endsWith(separator)) {
                    path = ((String)path).concat(separator);
                }
                if (this.fileExists((String)(path = ((String)path).concat(this._configFile)))) {
                    return path;
                }
            }
            if ((path = this.getInstallDir()) != null && path != null) {
                if (!((String)path).endsWith(separator)) {
                    path = ((String)path).concat(separator);
                }
                if (this.fileExists((String)(path = ((String)path).concat("config" + separator + this._configFile)))) {
                    return path;
                }
            }
            String delim = "ncache" + separator + "bin";
            String librarypath = System.getProperty("java.library.path");
            String[] tokans = librarypath.toLowerCase().split(System.getProperty("path.separator"));
            for (int i = 0; i < tokans.length; ++i) {
                if (!tokans[i].contains(delim)) continue;
                path = tokans[i].substring(0, tokans[i].lastIndexOf("bin"));
                path = (String)path + "config";
                break;
            }
        } else {
            path = CacheManager.getConfigPath();
            if (path != null && !((String)path).equalsIgnoreCase("")) {
                return ((String)path).concat(separator + this._configFile);
            }
            path = ServicePropValues.getTGHome();
            if (path != null && !((String)path).equalsIgnoreCase("")) {
                path = ((String)path).concat(separator + "config");
            } else {
                path = ServicePropValues.INSTALLDIR_DIR;
                if (path != null && !((String)path).equalsIgnoreCase("")) {
                    path = ((String)path).concat(separator + "config");
                }
            }
            if (path == null || ((String)path).equalsIgnoreCase("")) {
                path = "/opt/ncache/config/" + this._configFile;
                if (this.fileExists((String)path)) {
                    return path;
                }
                path = System.getProperty("user.dir");
                if (path != null) {
                    if (!((String)path).endsWith(separator)) {
                        path = ((String)path).concat(separator);
                    }
                    if (this.fileExists((String)(path = ((String)path).concat(this._configFile)))) {
                        return path;
                    }
                }
            }
        }
        if (path == null) {
            throw new Exception("Unable to find " + this._configFile + "; please reset Enviorment variables");
        }
        return ((String)path).concat(separator + this._configFile);
    }

    private boolean fileExists(String path) {
        File check = new File(path);
        try {
            return check.exists();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private String getInstallDir() {
        if (_installDir == null) {
            _installDir = ServicePropValues.getTGHome();
        }
        return _installDir;
    }

    public void loadLocalServerIP() throws ConfigurationException {
        try {
            OutObject tempOut_Result = new OutObject();
            String path = DirectoryUtil.getBaseFilePath("client.ncconf", this._search, (OutObject<Search>)tempOut_Result);
            File f = new File(path);
            if (!f.exists()) {
                throw new Exception("'client.ncconf' not found or does not contain server information");
            }
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document response = builder.parse(f);
            NodeList serverPortNL = response.getElementsByTagName("ncache-server");
            if (serverPortNL == null && serverPortNL.getLength() < 0) {
                return;
            }
            Node ncacheServerDetails = serverPortNL.item(0);
            if (ncacheServerDetails == null) {
                return;
            }
            NamedNodeMap attributes = ncacheServerDetails.getAttributes();
            if (attributes == null) {
                return;
            }
            Node localServerIPNode = attributes.getNamedItem("local-server-ip");
            if (localServerIPNode == null) {
                return;
            }
            this.setLocalServerIP(localServerIPNode.getTextContent());
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex.toString());
        }
    }
}

