/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.statistics;

import Alachisoft.NCache.Caching.Statistics.StatsMetricsUtil;
import Alachisoft.NCache.Common.Enum.Time;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Monitoring.Category;
import Alachisoft.NCache.Common.Monitoring.Counter;
import Alachisoft.NCache.Common.Monitoring.MetricsPublisher;
import Alachisoft.NCache.Common.Monitoring.MonitorableEntity;
import Alachisoft.NCache.Common.ServiceConfiguration;
import Alachisoft.NCache.Common.Stats.UsageStats;
import Alachisoft.NCache.Management.CacheConfigManager;
import Alachisoft.NCache.Management.ICacheServer;
import Alachisoft.NCache.Management.NCacheRPCService;
import Alachisoft.NCache.Management.Statistics.StatisticsCounter;
import com.alachisoft.ncache.common.caching.statistics.ClientCounters;
import com.alachisoft.ncache.common.caching.statistics.customcounters.AverageCounter;
import com.alachisoft.ncache.common.caching.statistics.customcounters.FlipManager;
import com.alachisoft.ncache.common.caching.statistics.customcounters.NumberOfItemCounter;
import com.alachisoft.ncache.common.caching.statistics.customcounters.PerformanceCounter;
import com.alachisoft.ncache.common.caching.statistics.customcounters.PerformanceCounterBase;
import com.alachisoft.ncache.common.caching.statistics.customcounters.RateOfCounter;
import com.alachisoft.ncache.common.caching.statistics.monitoring.ClientMonitor;
import com.alachisoft.ncache.common.caching.statistics.monitoring.CounterCreationData;
import com.alachisoft.ncache.common.caching.statistics.monitoring.CounterIDMap;
import com.alachisoft.ncache.common.caching.statistics.monitoring.Monitor;
import com.alachisoft.ncache.common.caching.statistics.operations.ClientOperations;
import com.alachisoft.ncache.common.caching.statistics.operations.Operations;
import com.alachisoft.ncache.common.monitoring.ClientCustomCounters;
import com.alachisoft.ncache.common.monitoring.CounterMetadataCollection;
import com.alachisoft.ncache.common.monitoring.CounterMonitorableEntity;
import com.alachisoft.ncache.common.monitoring.IntervalCounterDataCollection;
import com.alachisoft.ncache.common.monitoring.MonitoringEntityType;
import com.alachisoft.ncache.common.monitoring.Publisher;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class PerfStatsCollector
implements StatisticsCounter,
IDisposable,
CounterMonitorableEntity {
    private String _cacheID;
    private String _port;
    Monitor monitor;
    private MetricsPublisher statsPublisher;
    ArrayList<PerformanceCounter> _availableCounters = new ArrayList();
    HashMap<String, PerformanceCounter> _ncacheClientCounters = new HashMap();
    private CounterIDMap _counterIDMap;
    private Thread _publishingThread;
    private boolean _publish = false;
    private Date _lastPublish = new Date();
    private static final int _publishingInterval = 1;
    private final Object _lockObj = new Object();
    private long _version;
    private NCacheRPCService NCache;
    private ICacheServer _cacheServer = null;
    private String PC_CATEGORY = "NCache Client";
    private ArrayList<String> _pubsubCountersList = new ArrayList();
    private PerformanceCounter _pcClientRequestsPerSec;
    private PerformanceCounterBase _pcClientResponsesPerSec;
    private PerformanceCounterBase _pcTotalClientRequestsPerSec;
    private PerformanceCounterBase _pcTotalClientResponsesPerSec;
    private PerformanceCounter _pcAddPerSec;
    private PerformanceCounter _pcGetPerSec;
    private PerformanceCounter _pcUpdPerSec;
    private PerformanceCounter _pcDelPerSec;
    private PerformanceCounter _pcReadOperationsPerSec;
    private PerformanceCounter _pcWriteOperationsPerSec;
    private PerformanceCounter _pcEventProcesedPerSec;
    private PerformanceCounter _pcEventTriggeredPerSec;
    private AverageCounter _pcMsecPerAddBulkAvg;
    private PerformanceCounter _pcMsecPerAddBulkBase;
    private AverageCounter _pcMsecPerUpdBulkAvg;
    private PerformanceCounter _pcMsecPerUpdBulkBase;
    private AverageCounter _pcMsecPerGetBulkAvg;
    private PerformanceCounter _pcMsecPerGetBulkBase;
    private AverageCounter _pcMsecPerDelBulkAvg;
    private PerformanceCounter _pcMsecPerDelBulkBase;
    private AverageCounter _pcMsecPerGetAvg;
    private PerformanceCounter _pcMsecPerGetBase;
    private AverageCounter _pcMsecPerAddAvg;
    private PerformanceCounter _pcMsecPerAddBase;
    private AverageCounter _pcMsecPerUpdAvg;
    private PerformanceCounter _pcMsecPerUpdBase;
    private AverageCounter _pcMsecPerDelAvg;
    private PerformanceCounter _pcMsecPerDelBase;
    private UsageStats _usMsecPerGet = new UsageStats();
    private UsageStats _usMsecPerDel = new UsageStats();
    private UsageStats _usMsecPerUpd = new UsageStats();
    private UsageStats _usMsecPerAdd = new UsageStats();
    private UsageStats _usMsecPerEvent = new UsageStats();
    private AverageCounter _pcMsecPerEventAvg;
    private PerformanceCounter _pcMsecPerEventBase;
    private AverageCounter _pcMsecPerCompressionAvg;
    private PerformanceCounter _pcMsecPerCompressionAvgBase;
    private AverageCounter _pcMsecPerDecompressionAvg = null;
    private PerformanceCounter _pcMsecPerDecompressionAvgBase = null;
    private PerformanceCounter _pcCompressionPerSec;
    private PerformanceCounter _pcAvgCompressedItemSize;
    private PerformanceCounterBase _pcAvgCompressedItemSizeBase;
    private AverageCounter _pcMsecPerSerializationAvg;
    private AverageCounter _pcMsecPerDeserializationAvg;
    private PerformanceCounter _pcMsecPerSerializationAvgBase;
    private PerformanceCounter _pcMsecPerDeserializationAvgBase;
    private AverageCounter _pcMsecPerDecryptionAvg;
    private PerformanceCounter _pcMsecPerDecryptionBase;
    private AverageCounter _pcMsecPerEncryptionAvg;
    private PerformanceCounter _pcMsecPerEncryptionBase;
    private AverageCounter _pcAvgItemSize;
    private PerformanceCounter _pcAvgItemSizeBase;
    private AverageCounter _pcMsecPerMessagePublishAvg;
    private PerformanceCounterBase _pcMsecPerMessagePublishBase;
    private PerformanceCounterBase _pcMessagePublishPerSec = null;
    private PerformanceCounterBase _pcMessageDeliverPerSec = null;
    private PerformanceCounter _pcReqrQueueSize;
    private PerformanceCounter _pcCpuUsage;
    private PerformanceCounter _pcMemoryUsage;
    private PerformanceCounter _pcNetworkUsage;
    private PerformanceCounter _pcRequestsPerSec;
    private PerformanceCounter _pollRequestsSent = null;
    private PerformanceCounter _pollLastUpdates = null;
    private PerformanceCounter _pollLastRemoves = null;
    private AverageCounter _pcMsecPerDecryptionAvgBase = null;
    private UsageStats _usMsecPerDecryption;
    private UsageStats _usMsecPerEncryption;
    private String _instanceName;
    private int GettingCacheServerIntervalDelay;
    private Category _privateCategory;

    public Category getCategory() {
        return this._privateCategory;
    }

    public void setCategory(Category category) {
        this._privateCategory = category;
    }

    public PerfStatsCollector(String instance, boolean inproc) {
        this._instanceName = this.GetInstanceName(instance, 0, inproc);
        this._cacheID = instance;
    }

    public PerfStatsCollector(String instanceName, int port, String cacheId) {
        this._port = ":" + Integer.toString(port);
        this._instanceName = this.GetInstanceName(instanceName, port, false);
        this._cacheID = cacheId;
    }

    public PerfStatsCollector(String instance, int port, boolean inproc) {
        this._instanceName = this.GetInstanceName(instance, port, inproc);
    }

    public final String GetInstanceName(String instanceName, int port, boolean inProc) {
        return !inProc ? instanceName : instanceName + " - " + ManagementFactory.getRuntimeMXBean().getName() + " - " + port;
    }

    public void initializePerfCounters(boolean inproc) throws Exception {
        FlipManager.Start();
        this.monitor = new ClientMonitor(this._instanceName);
        this.monitor.startJMX();
        this.monitor.registerNode();
        this._pcClientRequestsPerSec = new RateOfCounter(this.PC_CATEGORY, "Client Requests/sec", this._instanceName);
        this._pcClientResponsesPerSec = new RateOfCounter(this.PC_CATEGORY, "Client Responses/sec", this._instanceName);
        this._pcTotalClientRequestsPerSec = new RateOfCounter(this.PC_CATEGORY, "Total Client Requests/sec", "_Total_ client stats");
        this._pcTotalClientResponsesPerSec = new RateOfCounter(this.PC_CATEGORY, "Total Client Responses/sec", "_Total_ client stats");
        this._pcAddPerSec = new RateOfCounter(this.PC_CATEGORY, "Additions/sec", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.AddsPerSec, this._pcAddPerSec);
        this._pcGetPerSec = new RateOfCounter(this.PC_CATEGORY, "Fetches/sec", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.GetPerSec, this._pcGetPerSec);
        this._pcUpdPerSec = new RateOfCounter(this.PC_CATEGORY, "Updates/sec", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.UpdPerSec, this._pcUpdPerSec);
        this._pcDelPerSec = new RateOfCounter(this.PC_CATEGORY, "Deletes/sec", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.DelPerSec, this._pcDelPerSec);
        this._pcEventProcesedPerSec = new RateOfCounter(this.PC_CATEGORY, "Events Processed/sec", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.EventProcessedPerSec, this._pcEventProcesedPerSec);
        this._pcEventTriggeredPerSec = new RateOfCounter(this.PC_CATEGORY, "Events Triggered/sec", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.EventTriggeredPerSec, this._pcEventTriggeredPerSec);
        this._pcReadOperationsPerSec = new RateOfCounter(this.PC_CATEGORY, "Read Operations/sec", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.ReadOperationsPerSec, this._pcReadOperationsPerSec);
        this._pcWriteOperationsPerSec = new RateOfCounter(this.PC_CATEGORY, "Write Operations/sec", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.WriteOperationsPerSec, this._pcWriteOperationsPerSec);
        this._pcMsecPerAddBulkAvg = new AverageCounter(this.PC_CATEGORY, "Average us/addbulk", this._instanceName);
        this._pcMsecPerAddBulkBase = new RateOfCounter(this.PC_CATEGORY, "Average us/addbulk base", this._instanceName);
        this._pcMsecPerGetBulkAvg = new AverageCounter(this.PC_CATEGORY, "Average us/fetchbulk", this._instanceName);
        this._pcMsecPerGetBulkBase = new RateOfCounter(this.PC_CATEGORY, "Average us/fetchbulk base", this._instanceName);
        this._pcMsecPerUpdBulkAvg = new AverageCounter(this.PC_CATEGORY, "Average us/insertbulk", this._instanceName);
        this._pcMsecPerUpdBulkBase = new RateOfCounter(this.PC_CATEGORY, "Average us/insertbulk base", this._instanceName);
        this._pcMsecPerDelBulkAvg = new AverageCounter(this.PC_CATEGORY, "Average us/removebulk", this._instanceName);
        this._pcMsecPerDelBulkBase = new RateOfCounter(this.PC_CATEGORY, "Average us/removebulk base", this._instanceName);
        this._pcMsecPerUpdAvg = new AverageCounter(this.PC_CATEGORY, "Average us/insert", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.MSecPerUpdateAvg, (PerformanceCounter)this._pcMsecPerUpdAvg);
        this._usMsecPerUpd = new UsageStats();
        this._pcMsecPerUpdBase = new RateOfCounter("Average ms/insert base", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.MSecPerUpdateBase, this._pcMsecPerUpdBase);
        this._pcMsecPerDelAvg = new AverageCounter(this.PC_CATEGORY, "Average us/remove", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.MSecPerDelAvg, (PerformanceCounter)this._pcMsecPerDelAvg);
        this._usMsecPerDel = new UsageStats();
        this._pcMsecPerDelBase = new RateOfCounter("Average ms/remove base", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.MSecPerDelBase, this._pcMsecPerDelBase);
        this._pcMsecPerAddAvg = new AverageCounter(this.PC_CATEGORY, "Average us/add", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.MSecPerAddAvg, (PerformanceCounter)this._pcMsecPerAddAvg);
        this._usMsecPerAdd = new UsageStats();
        this._pcMsecPerAddBase = new RateOfCounter(this.PC_CATEGORY, "Average us/add base", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.MSecPerAddBase, this._pcMsecPerAddBase);
        this._pcMsecPerGetAvg = new AverageCounter(this.PC_CATEGORY, "Average us/fetch", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.MSecPerGetAvg, (PerformanceCounter)this._pcMsecPerGetAvg);
        this._pcMsecPerGetBase = new AverageCounter(this.PC_CATEGORY, "Average us/fetch base", this._instanceName);
        this._usMsecPerGet = new UsageStats();
        this._pcMsecPerDelBase = new RateOfCounter(this.PC_CATEGORY, "Average us/remove base", this._instanceName);
        this._pcMsecPerEventAvg = new AverageCounter(this.PC_CATEGORY, "Average us/event", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.AvgEventPerSec, (PerformanceCounter)this._pcMsecPerEventAvg);
        this._pcMsecPerEventBase = new RateOfCounter(this.PC_CATEGORY, "Average us/event base", this._instanceName);
        this._usMsecPerEvent = new UsageStats();
        this._pcMsecPerCompressionAvg = new AverageCounter(this.PC_CATEGORY, "Average us/compression", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.MsecPerCompressionAvg, (PerformanceCounter)this._pcMsecPerCompressionAvg);
        this._pcMsecPerCompressionAvgBase = new RateOfCounter(this.PC_CATEGORY, "Average us/compression base", this._instanceName);
        this._pcMsecPerDecompressionAvg = new AverageCounter(this.PC_CATEGORY, "Average us/decompression", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.MSecPerDecompressionAvg, (PerformanceCounter)this._pcMsecPerDecompressionAvg);
        this._pcMsecPerDecompressionAvgBase = new RateOfCounter(this.PC_CATEGORY, "Average us/decompression base", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.MSecPerDecompressionAvgBase, this._pcMsecPerDecompressionAvgBase);
        this._pcCompressionPerSec = new RateOfCounter(this.PC_CATEGORY, "Compression/sec", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.CompressionPerSec, this._pcCompressionPerSec);
        this._pcAvgCompressedItemSize = new AverageCounter(this.PC_CATEGORY, "Average Compressed Item Size", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.AvgCompressedItemSize, this._pcAvgCompressedItemSize);
        this._pcAvgCompressedItemSizeBase = new RateOfCounter(this.PC_CATEGORY, "Average Compressed Item Size base", this._instanceName);
        this._pcMsecPerDecryptionAvg = new AverageCounter(this.PC_CATEGORY, "Average us/decryption", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.MSecPerDecryptionAvg, (PerformanceCounter)this._pcMsecPerDecryptionAvg);
        this._pcMsecPerDecryptionAvgBase = new AverageCounter(this.PC_CATEGORY, "Average us/decryption base", this._instanceName);
        this._usMsecPerDecryption = new UsageStats();
        this._pcMsecPerDecryptionBase = new RateOfCounter(this.PC_CATEGORY, "Average ms/decryption base", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.MSecPerDecryptionBase, this._pcMsecPerDecryptionBase);
        this._pcMsecPerEncryptionAvg = new AverageCounter(this.PC_CATEGORY, "Average us/encryption", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.MSecPerEncryptionAvg, (PerformanceCounter)this._pcMsecPerEncryptionAvg);
        this._usMsecPerEncryption = new UsageStats();
        this._pcMsecPerEncryptionBase = new AverageCounter(this.PC_CATEGORY, "Average ms/encryption base", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.MSecPerEncryptionBase, this._pcMsecPerEncryptionBase);
        this._pcAvgItemSize = new AverageCounter(this.PC_CATEGORY, "Average Item Size", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.AvgItemSize, (PerformanceCounter)this._pcAvgItemSize);
        this._pcAvgItemSizeBase = new RateOfCounter(this.PC_CATEGORY, "Average Item Size base", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.AvgItemSizeBase, this._pcAvgItemSizeBase);
        this._pcMsecPerMessagePublishAvg = new AverageCounter(this.PC_CATEGORY, "Average us/Published Messages", this._instanceName);
        this._pcMsecPerMessagePublishBase = new RateOfCounter(this.PC_CATEGORY, "Average us/Published Messages Base", this._instanceName);
        this._pcMessagePublishPerSec = new RateOfCounter(this.PC_CATEGORY, "Messages Published/sec", this._instanceName);
        this._pcMessageDeliverPerSec = new RateOfCounter(this.PC_CATEGORY, "Messages Delivered/sec", this._instanceName);
        this._pcReqrQueueSize = new NumberOfItemCounter(this.PC_CATEGORY, "Request queue size", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.RequestQueueSize, this._pcReqrQueueSize);
        this._pcRequestsPerSec = new RateOfCounter(this.PC_CATEGORY, "Requests Per Sec", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.RequestsPerSec, this._pcRequestsPerSec);
        this._pollRequestsSent = new NumberOfItemCounter(this.PC_CATEGORY, "# of Sync Poll Requests", this._instanceName);
        this._pollLastUpdates = new NumberOfItemCounter(this.PC_CATEGORY, "# of Last Sync Poll Updates", this._instanceName);
        this._pollLastRemoves = new NumberOfItemCounter(this.PC_CATEGORY, "# of Last Sync Poll Removes", this._instanceName);
        this._pcMsecPerSerializationAvg = new AverageCounter(this.PC_CATEGORY, "Average us/serialization", this._instanceName);
        this.monitor.registerCounter((Operations)ClientOperations.MsecPerSerializationAvg, (PerformanceCounter)this._pcMsecPerSerializationAvg);
        this._pcMsecPerDeserializationAvg = new AverageCounter(this.PC_CATEGORY, "Average us/deserialization", this._instanceName);
        this._pcMsecPerSerializationAvgBase = new RateOfCounter(this.PC_CATEGORY, "Average us/serialization base", this._instanceName);
        this._pcMsecPerDeserializationAvgBase = new RateOfCounter(this.PC_CATEGORY, "Average us/deserialization base", this._instanceName);
        this._pubsubCountersList.add(this._pcMsecPerMessagePublishAvg.getName());
        this._pubsubCountersList.add(this._pcMessagePublishPerSec.getName());
        this._pubsubCountersList.add(this._pcMessageDeliverPerSec.getName());
        this.setPollRequestsCount(0L);
        this.setPollLastUpdates(0L);
        this.setPollLastRemoves(0L);
        this.StoreCounters();
    }

    private void StoreCounters() {
        this._ncacheClientCounters.put(this._pcTotalClientRequestsPerSec.getName(), (PerformanceCounter)this._pcTotalClientRequestsPerSec);
        this._ncacheClientCounters.put(this._pcTotalClientResponsesPerSec.getName(), (PerformanceCounter)this._pcTotalClientResponsesPerSec);
        this._ncacheClientCounters.put(this._pcAddPerSec.getName(), this._pcAddPerSec);
        this._ncacheClientCounters.put(this._pcGetPerSec.getName(), this._pcGetPerSec);
        this._ncacheClientCounters.put(this._pcUpdPerSec.getName(), this._pcUpdPerSec);
        this._ncacheClientCounters.put(this._pcDelPerSec.getName(), this._pcDelPerSec);
        this._ncacheClientCounters.put(this._pcEventTriggeredPerSec.getName(), this._pcEventTriggeredPerSec);
        this._ncacheClientCounters.put(this._pcEventProcesedPerSec.getName(), this._pcEventProcesedPerSec);
        this._ncacheClientCounters.put(this._pcReadOperationsPerSec.getName(), this._pcReadOperationsPerSec);
        this._ncacheClientCounters.put(this._pcWriteOperationsPerSec.getName(), this._pcWriteOperationsPerSec);
        this._ncacheClientCounters.put(this._pcMsecPerAddBulkAvg.getName(), (PerformanceCounter)this._pcMsecPerAddBulkAvg);
        this._ncacheClientCounters.put(this._pcMsecPerAddBulkBase.getName(), this._pcMsecPerAddBulkBase);
        this._ncacheClientCounters.put(this._pcMsecPerGetBulkAvg.getName(), (PerformanceCounter)this._pcMsecPerGetBulkAvg);
        this._ncacheClientCounters.put(this._pcMsecPerGetBulkBase.getName(), this._pcMsecPerGetBulkBase);
        this._ncacheClientCounters.put(this._pcMsecPerUpdBulkAvg.getName(), (PerformanceCounter)this._pcMsecPerUpdBulkAvg);
        this._ncacheClientCounters.put(this._pcMsecPerUpdBulkBase.getName(), this._pcMsecPerUpdBulkBase);
        this._ncacheClientCounters.put(this._pcMsecPerDelBulkAvg.getName(), (PerformanceCounter)this._pcMsecPerDelBulkAvg);
        this._ncacheClientCounters.put(this._pcMsecPerDelBulkBase.getName(), this._pcMsecPerDelBulkBase);
        this._ncacheClientCounters.put(this._pcMsecPerGetAvg.getName(), (PerformanceCounter)this._pcMsecPerGetAvg);
        this._ncacheClientCounters.put(this._pcMsecPerGetBase.getName(), this._pcMsecPerGetBase);
        this._ncacheClientCounters.put(this._pcMsecPerAddAvg.getName(), (PerformanceCounter)this._pcMsecPerAddAvg);
        this._ncacheClientCounters.put(this._pcMsecPerAddBase.getName(), this._pcMsecPerAddBase);
        this._ncacheClientCounters.put(this._pcMsecPerUpdAvg.getName(), (PerformanceCounter)this._pcMsecPerUpdAvg);
        this._ncacheClientCounters.put(this._pcMsecPerUpdBase.getName(), this._pcMsecPerUpdBase);
        this._ncacheClientCounters.put(this._pcMsecPerDelAvg.getName(), (PerformanceCounter)this._pcMsecPerDelAvg);
        this._ncacheClientCounters.put(this._pcMsecPerDelBase.getName(), this._pcMsecPerDelBase);
        this._ncacheClientCounters.put(this._pcReqrQueueSize.getName(), this._pcReqrQueueSize);
        this._ncacheClientCounters.put(this._pcCompressionPerSec.getName(), this._pcCompressionPerSec);
        this._ncacheClientCounters.put(this._pcAvgItemSize.getName(), (PerformanceCounter)this._pcAvgItemSize);
        this._ncacheClientCounters.put(this._pcMsecPerEventAvg.getName(), (PerformanceCounter)this._pcMsecPerEventAvg);
        this._ncacheClientCounters.put(this._pcMsecPerEventBase.getName(), this._pcMsecPerEventBase);
        this._ncacheClientCounters.put(this._pcMsecPerCompressionAvg.getName(), (PerformanceCounter)this._pcMsecPerCompressionAvg);
        this._ncacheClientCounters.put(this._pcMsecPerCompressionAvgBase.getName(), this._pcMsecPerCompressionAvgBase);
        this._ncacheClientCounters.put(this._pcMsecPerDecompressionAvg.getName(), (PerformanceCounter)this._pcMsecPerDecompressionAvg);
        this._ncacheClientCounters.put(this._pcMsecPerDecompressionAvgBase.getName(), this._pcMsecPerDecompressionAvgBase);
        this._ncacheClientCounters.put(this._pcAvgCompressedItemSize.getName(), this._pcAvgCompressedItemSize);
        this._ncacheClientCounters.put(this._pcAvgCompressedItemSizeBase.getName(), (PerformanceCounter)this._pcAvgCompressedItemSizeBase);
        this._ncacheClientCounters.put(this._pcMsecPerSerializationAvg.getName(), (PerformanceCounter)this._pcMsecPerSerializationAvg);
        this._ncacheClientCounters.put(this._pcMsecPerSerializationAvgBase.getName(), this._pcMsecPerSerializationAvgBase);
        this._ncacheClientCounters.put(this._pcMsecPerDeserializationAvg.getName(), (PerformanceCounter)this._pcMsecPerDeserializationAvg);
        this._ncacheClientCounters.put(this._pcMsecPerDeserializationAvgBase.getName(), this._pcMsecPerDeserializationAvgBase);
        this._ncacheClientCounters.put(this._pcMsecPerEncryptionAvg.getName(), (PerformanceCounter)this._pcMsecPerEncryptionAvg);
        this._ncacheClientCounters.put(this._pcMsecPerEncryptionBase.getName(), this._pcMsecPerEncryptionBase);
        this._ncacheClientCounters.put(this._pcMsecPerDecryptionAvg.getName(), (PerformanceCounter)this._pcMsecPerDecryptionAvg);
        this._ncacheClientCounters.put(this._pcMsecPerDecryptionAvgBase.getName(), (PerformanceCounter)this._pcMsecPerDecryptionAvgBase);
        this._ncacheClientCounters.put(this._pollRequestsSent.getName(), this._pollRequestsSent);
        this._ncacheClientCounters.put(this._pollLastUpdates.getName(), this._pollLastUpdates);
        this._ncacheClientCounters.put(this._pollLastRemoves.getName(), this._pollLastRemoves);
        this._ncacheClientCounters.put(this._pcMsecPerMessagePublishAvg.getName(), (PerformanceCounter)this._pcMsecPerMessagePublishAvg);
        this._ncacheClientCounters.put(this._pcMsecPerMessagePublishBase.getName(), (PerformanceCounter)this._pcMsecPerMessagePublishBase);
        this._ncacheClientCounters.put(this._pcMessagePublishPerSec.getName(), (PerformanceCounter)this._pcMessagePublishPerSec);
        this._ncacheClientCounters.put(this._pcMessageDeliverPerSec.getName(), (PerformanceCounter)this._pcMessageDeliverPerSec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementClientRequestsPerSecStatsBy(long requests) {
        if (this._pcRequestsPerSec != null) {
            PerformanceCounter performanceCounter = this._pcRequestsPerSec;
            synchronized (performanceCounter) {
                this._pcRequestsPerSec.incrementBy((double)requests);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementAddPerSecStats() {
        PerformanceCounter performanceCounter;
        if (this._pcAddPerSec != null) {
            performanceCounter = this._pcAddPerSec;
            synchronized (performanceCounter) {
                this._pcAddPerSec.increment();
            }
        }
        if (this._pcWriteOperationsPerSec != null) {
            performanceCounter = this._pcWriteOperationsPerSec;
            synchronized (performanceCounter) {
                this._pcWriteOperationsPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementGetPerSecStats() {
        PerformanceCounter performanceCounter;
        if (this._pcGetPerSec != null) {
            performanceCounter = this._pcGetPerSec;
            synchronized (performanceCounter) {
                this._pcGetPerSec.increment();
            }
        }
        if (this._pcReadOperationsPerSec != null) {
            performanceCounter = this._pcReadOperationsPerSec;
            synchronized (performanceCounter) {
                this._pcReadOperationsPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementUpdPerSecStats() {
        PerformanceCounter performanceCounter;
        if (this._pcUpdPerSec != null) {
            performanceCounter = this._pcUpdPerSec;
            synchronized (performanceCounter) {
                this._pcUpdPerSec.increment();
            }
        }
        if (this._pcWriteOperationsPerSec != null) {
            performanceCounter = this._pcWriteOperationsPerSec;
            synchronized (performanceCounter) {
                this._pcWriteOperationsPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementDelPerSecStats() {
        PerformanceCounter performanceCounter;
        if (this._pcDelPerSec != null) {
            performanceCounter = this._pcDelPerSec;
            synchronized (performanceCounter) {
                this._pcDelPerSec.increment();
            }
        }
        if (this._pcWriteOperationsPerSec != null) {
            performanceCounter = this._pcWriteOperationsPerSec;
            synchronized (performanceCounter) {
                this._pcWriteOperationsPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementCompressionPerSec() {
        if (this._pcCompressionPerSec != null) {
            PerformanceCounter performanceCounter = this._pcCompressionPerSec;
            synchronized (performanceCounter) {
                this._pcCompressionPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mSecPerGetBeginSample() {
        if (this._pcMsecPerGetAvg != null) {
            UsageStats usageStats = this._usMsecPerGet;
            synchronized (usageStats) {
                this._usMsecPerGet.BeginSample();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mSecPerGetEndSample() {
        if (this._pcMsecPerGetAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerGetAvg;
            synchronized (averageCounter) {
                this._usMsecPerGet.EndSample();
                this._pcMsecPerGetAvg.incrementBy(Time.toMicroSeconds((long)this._usMsecPerGet.getCurrent(), (Time)Time.nSEC));
                this._pcMsecPerGetBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mSecPerAddBeginSample() {
        if (this._pcMsecPerAddAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerAddAvg;
            synchronized (averageCounter) {
                this._usMsecPerAdd.BeginSample();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mSecPerAddEndSample() {
        if (this._pcMsecPerAddAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerAddAvg;
            synchronized (averageCounter) {
                this._usMsecPerAdd.EndSample();
                this._pcMsecPerAddAvg.incrementBy(Time.toMicroSeconds((long)this._usMsecPerAdd.getCurrent(), (Time)Time.nSEC));
                this._pcMsecPerAddBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mSecPerDecryptionBeginSample() {
        if (this._pcMsecPerDecryptionAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerDecryptionAvg;
            synchronized (averageCounter) {
                this._usMsecPerDecryption.BeginSample();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mSecPerDecryptionEndSample() {
        if (this._pcMsecPerDecryptionAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerDecryptionAvg;
            synchronized (averageCounter) {
                this._usMsecPerDecryption.EndSample();
                this._pcMsecPerDecryptionAvg.incrementBy(Time.toMicroSeconds((long)this._usMsecPerDecryption.getCurrent(), (Time)Time.nSEC));
                this._pcMsecPerDecryptionBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mSecPerEncryptionBeginSample() {
        if (this._pcMsecPerEncryptionAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerEncryptionAvg;
            synchronized (averageCounter) {
                this._usMsecPerEncryption.BeginSample();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mSecPerEncryptionEndSample() {
        if (this._pcMsecPerEncryptionAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerEncryptionAvg;
            synchronized (averageCounter) {
                this._usMsecPerEncryption.EndSample();
                this._pcMsecPerEncryptionAvg.incrementBy(Time.toMicroSeconds((long)this._usMsecPerEncryption.getCurrent(), (Time)Time.nSEC));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mSecPerUpdateBeginSample() {
        if (this._pcMsecPerUpdAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerUpdAvg;
            synchronized (averageCounter) {
                this._usMsecPerUpd.BeginSample();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mSecPerUpdateEndSample() {
        if (this._pcMsecPerUpdAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerUpdAvg;
            synchronized (averageCounter) {
                this._usMsecPerUpd.EndSample();
                this._pcMsecPerUpdAvg.incrementBy(Time.toMicroSeconds((long)this._usMsecPerUpd.getCurrent(), (Time)Time.nSEC));
                this._pcMsecPerUpdBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mSecPerDelBeginSample() {
        if (this._pcMsecPerDelAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerDelAvg;
            synchronized (averageCounter) {
                this._usMsecPerDel.BeginSample();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mSecPerDelEndSample() {
        if (this._pcMsecPerDelAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerDelAvg;
            synchronized (averageCounter) {
                this._usMsecPerDel.EndSample();
                this._pcMsecPerDelAvg.incrementBy(Time.toMicroSeconds((long)this._usMsecPerDel.getCurrent(), (Time)Time.nSEC));
                this._pcMsecPerDelBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMsecPerCompression(long value) {
        if (this._pcMsecPerCompressionAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerCompressionAvg;
            synchronized (averageCounter) {
                this._pcMsecPerCompressionAvg.incrementBy(Time.toMicroSeconds((long)(value * 1000000L), (Time)Time.nSEC));
                this._pcMsecPerCompressionAvgBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementAvgCompressedItemSize(long value) {
        if (this._pcAvgCompressedItemSize != null) {
            PerformanceCounter performanceCounter = this._pcAvgCompressedItemSize;
            synchronized (performanceCounter) {
                this._pcAvgCompressedItemSize.incrementBy((double)value);
                this._pcAvgCompressedItemSizeBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMSecPerEvent(long value) {
        if (this._pcMsecPerEventAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerEventAvg;
            synchronized (averageCounter) {
                this._pcMsecPerEventAvg.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMSecPerEvent() {
        if (this._pcMsecPerEventAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerEventAvg;
            synchronized (averageCounter) {
                this._pcMsecPerEventAvg.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementEventProcessedPerSec(long value) {
        if (this._pcEventProcesedPerSec != null) {
            PerformanceCounter performanceCounter = this._pcEventProcesedPerSec;
            synchronized (performanceCounter) {
                this._pcEventProcesedPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementEventProcessedPerSec() {
        if (this._pcEventProcesedPerSec != null) {
            PerformanceCounter performanceCounter = this._pcEventProcesedPerSec;
            synchronized (performanceCounter) {
                this._pcEventProcesedPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementEventTriggeredPerSec(long value) {
        if (this._pcEventTriggeredPerSec != null) {
            PerformanceCounter performanceCounter = this._pcEventTriggeredPerSec;
            synchronized (performanceCounter) {
                this._pcEventTriggeredPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementEventTriggeredPerSec() {
        if (this._pcEventTriggeredPerSec != null) {
            PerformanceCounter performanceCounter = this._pcEventTriggeredPerSec;
            synchronized (performanceCounter) {
                this._pcEventTriggeredPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementAvgItemSize(long itemSize) {
        if (this._pcAvgItemSize != null) {
            AverageCounter averageCounter = this._pcAvgItemSize;
            synchronized (averageCounter) {
                this._pcAvgItemSize.incrementBy((double)itemSize);
                this._pcAvgItemSizeBase.incrementBy((double)itemSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msecPerGetBeginSample() {
        if (this._pcMsecPerGetAvg != null) {
            UsageStats usageStats = this._usMsecPerGet;
            synchronized (usageStats) {
                this._usMsecPerGet.BeginSample();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRequestQueueSize() {
        if (this._pcReqrQueueSize != null) {
            PerformanceCounter performanceCounter = this._pcReqrQueueSize;
            synchronized (performanceCounter) {
                this._pcReqrQueueSize.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementRequestQueueSize() {
        if (this._pcReqrQueueSize != null) {
            PerformanceCounter performanceCounter = this._pcReqrQueueSize;
            synchronized (performanceCounter) {
                if (this._pcReqrQueueSize.getValue() > 0.0) {
                    this._pcReqrQueueSize.decrement();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMsecPerSerialization(long value) {
        if (this._pcMsecPerSerializationAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerSerializationAvg;
            synchronized (averageCounter) {
                this._pcMsecPerSerializationAvg.incrementBy(Time.toMicroSeconds((long)(value * 1000000L), (Time)Time.nSEC));
                this._pcMsecPerSerializationAvgBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementMsecPerEncryptionSample(long value) {
        if (this._pcMsecPerEncryptionAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerEncryptionAvg;
            synchronized (averageCounter) {
                this._pcMsecPerEncryptionAvg.incrementBy((double)(value * 1000L));
                this._pcMsecPerEncryptionBase.increment();
            }
        }
    }

    public void msecPerUpdBeginSample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementMsecPerAddBulkSample(long value) {
        if (this._pcMsecPerAddBulkAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerAddBulkAvg;
            synchronized (averageCounter) {
                this._pcMsecPerAddBulkAvg.incrementBy(Time.toMicroSeconds((long)value, (Time)Time.nSEC));
                this._pcMsecPerAddBulkBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementByAddPerSecStats(long value) {
        PerformanceCounter performanceCounter;
        if (this._pcAddPerSec != null) {
            performanceCounter = this._pcAddPerSec;
            synchronized (performanceCounter) {
                this._pcAddPerSec.incrementBy((double)value);
            }
        }
        if (this._pcWriteOperationsPerSec != null) {
            performanceCounter = this._pcWriteOperationsPerSec;
            synchronized (performanceCounter) {
                this._pcWriteOperationsPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementMsecPerUpdBulkSample(long value) {
        if (this._pcMsecPerUpdBulkAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerUpdBulkAvg;
            synchronized (averageCounter) {
                this._pcMsecPerUpdBulkAvg.incrementBy(Time.toMicroSeconds((long)value, (Time)Time.nSEC));
                this._pcMsecPerUpdBulkBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementMsecPerUpdBulkSample(long value, long baseValue) {
        if (this._pcMsecPerUpdBulkAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerUpdBulkAvg;
            synchronized (averageCounter) {
                this._pcMsecPerUpdBulkAvg.incrementBy((double)(value * 1000000L));
                this._pcMsecPerUpdBulkAvg.incrementBy((double)baseValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementMsecPerDelBulkSample(long value) {
        if (this._pcMsecPerDelBulkAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerDelBulkAvg;
            synchronized (averageCounter) {
                this._pcMsecPerDelBulkAvg.incrementBy(Time.toMicroSeconds((long)value, (Time)Time.nSEC));
                this._pcMsecPerDelBulkBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRequestQueueSizeStats() {
        if (this._pcReqrQueueSize != null) {
            PerformanceCounter performanceCounter = this._pcReqrQueueSize;
            synchronized (performanceCounter) {
                this._pcReqrQueueSize.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementRequestQueueSizeStats() {
        if (this._pcReqrQueueSize != null) {
            PerformanceCounter performanceCounter = this._pcReqrQueueSize;
            synchronized (performanceCounter) {
                if (this._pcReqrQueueSize.getValue() > 0.0) {
                    this._pcReqrQueueSize.decrement();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPollRequestsCount(long value) {
        PerformanceCounter performanceCounter = this._pollRequestsSent;
        synchronized (performanceCounter) {
            this._pollRequestsSent.setValue((double)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementByUpdPerSecStats(long value) {
        PerformanceCounter performanceCounter;
        if (this._pcUpdPerSec != null) {
            performanceCounter = this._pcUpdPerSec;
            synchronized (performanceCounter) {
                this._pcUpdPerSec.incrementBy((double)value);
            }
        }
        if (this._pcWriteOperationsPerSec != null) {
            performanceCounter = this._pcWriteOperationsPerSec;
            synchronized (performanceCounter) {
                this._pcWriteOperationsPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementByDelPerSecStats(long value) {
        PerformanceCounter performanceCounter;
        if (this._pcDelPerSec != null) {
            performanceCounter = this._pcDelPerSec;
            synchronized (performanceCounter) {
                this._pcDelPerSec.incrementBy((double)value);
            }
        }
        if (this._pcWriteOperationsPerSec != null) {
            performanceCounter = this._pcWriteOperationsPerSec;
            synchronized (performanceCounter) {
                this._pcWriteOperationsPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementAvgEventProcessingSample(long value) {
        if (this._pcMsecPerEventAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerEventAvg;
            synchronized (averageCounter) {
                this._pcMsecPerEventAvg.incrementBy(Time.toMicroSeconds((long)(value * 1000000L), (Time)Time.nSEC));
                this._pcMsecPerEventBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementEventsProcessedPerSec() {
        if (this._pcEventProcesedPerSec != null) {
            PerformanceCounter performanceCounter = this._pcEventProcesedPerSec;
            synchronized (performanceCounter) {
                this._pcEventProcesedPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementEventsTriggeredPerSeconds() {
        if (this._pcEventTriggeredPerSec != null) {
            PerformanceCounter performanceCounter = this._pcEventTriggeredPerSec;
            synchronized (performanceCounter) {
                this._pcEventTriggeredPerSec.increment();
            }
        }
    }

    public String getInstanceName() {
        return null;
    }

    public void setInstanceName(String value) {
    }

    public String getInstanceName(String instanceName, int port, boolean inProc) {
        return null;
    }

    public boolean getUserHasAccessRights() {
        return false;
    }

    public boolean getIsEnabled() {
        return false;
    }

    public void setIsEnabled(boolean value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            PerfStatsCollector perfStatsCollector = this;
            synchronized (perfStatsCollector) {
                if (this.monitor != null) {
                    if (this._pcAddPerSec != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.AddsPerSec);
                    }
                    if (this._pcMsecPerUpdBase != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.MSecPerUpdateBase);
                    }
                    if (this._pcAvgItemSize != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.AvgItemSize);
                    }
                    if (this._pcMsecPerCompressionAvg != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.MsecPerCompressionAvg);
                    }
                    if (this._pcCompressionPerSec != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.CompressionPerSec);
                    }
                    if (this._pcAvgCompressedItemSize != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.AvgCompressedItemSize);
                    }
                    if (this._pcMsecPerSerializationAvg != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.MsecPerSerialization);
                    }
                    if (this._pcMsecPerEventAvg != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.AvgEventPerSec);
                    }
                    if (this._pcEventProcesedPerSec != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.EventProcessedPerSec);
                    }
                    if (this._pcEventTriggeredPerSec != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.EventTriggeredPerSec);
                    }
                    if (this._pcMsecPerUpdBase != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.MSecPerUpdateBase);
                    }
                    if (this._pcMsecPerAddBase != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.MSecPerAddBase);
                    }
                    if (this._pcMsecPerDecompressionAvg != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.MSecPerDecompressionAvg);
                    }
                    if (this._pcMsecPerDecompressionAvgBase != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.MSecPerDecompressionAvgBase);
                    }
                    if (this._pcMsecPerEventAvg != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.AvgEventPerSec);
                    }
                    if (this._pcMsecPerGetAvg != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.MSecPerGet);
                    }
                    if (this._pcMsecPerGetAvg != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.MSecPerGetAvg);
                    }
                    if (this._pcMsecPerAddAvg != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.MSecPerAddAvg);
                    }
                    if (this._pcMsecPerEncryptionAvg != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.MSecPerEncryptionAvg);
                    }
                    if (this._pcMsecPerCompressionAvg != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.MsecPerCompressionAvg);
                    }
                    if (this._pcMsecPerSerializationAvg != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.MsecPerSerializationAvg);
                    }
                    if (this._pcAvgItemSizeBase != null) {
                        this.monitor.unRegisterCounter((Operations)ClientOperations.AvgItemSizeBase);
                    }
                    this.monitor.unRegisterNode();
                    this.monitor.stopJMX();
                    this.monitor = null;
                }
                FlipManager.Stop();
            }
            if (this.statsPublisher != null) {
                this.statsPublisher.dispose();
            }
            this._pcClientRequestsPerSec.reset();
            this._pcClientResponsesPerSec.reset();
            this._pcTotalClientRequestsPerSec.reset();
            this._pcTotalClientResponsesPerSec.reset();
            this._pcAddPerSec.reset();
            this._pcGetPerSec.reset();
            this._pcUpdPerSec.reset();
            this._pcDelPerSec.reset();
            this._pcEventTriggeredPerSec.reset();
            this._pcEventProcesedPerSec.reset();
            this._pcReadOperationsPerSec.reset();
            this._pcWriteOperationsPerSec.reset();
            this._pcMsecPerAddBulkAvg.reset();
            this._pcMsecPerGetBulkAvg.reset();
            this._pcMsecPerUpdBulkAvg.reset();
            this._pcMsecPerDelBulkAvg.reset();
            this._pcMsecPerGetAvg.reset();
            this._usMsecPerGet = new UsageStats();
            this._pcMsecPerAddAvg.reset();
            this._usMsecPerAdd.reset();
            this._pcMsecPerUpdAvg.reset();
            this._usMsecPerUpd.reset();
            this._pcMsecPerDelAvg.reset();
            this._usMsecPerDel.reset();
            this._pcReqrQueueSize.reset();
            this._pcCompressionPerSec.reset();
            this._pcAvgItemSize.reset();
            this._pcMsecPerEventAvg.reset();
            this._usMsecPerEvent.reset();
            this._usMsecPerDel.reset();
            this._pcMsecPerCompressionAvg.reset();
            this._pcMsecPerDecompressionAvg.reset();
            this._pcAvgCompressedItemSize.reset();
            this._pcMsecPerSerializationAvg.reset();
            this._pcMsecPerDeserializationAvg.reset();
            this._pcMsecPerEncryptionAvg.reset();
            this._pcMsecPerDecryptionAvg.reset();
            this._pollRequestsSent.reset();
            this._pollLastUpdates.reset();
            this._pollLastRemoves.reset();
            this._pcMsecPerMessagePublishAvg.reset();
            this._pcMessagePublishPerSec.reset();
            this._pcMessageDeliverPerSec.reset();
            this._pcMsecPerAddBase.reset();
            this._pcMsecPerDelBase.reset();
            this._pcMsecPerGetBase.reset();
            this._pcMsecPerUpdBase.reset();
            this._pcMsecPerAddBulkBase.reset();
            this._pcMsecPerGetBulkBase.reset();
            this._pcMsecPerUpdBulkBase.reset();
            this._pcMsecPerDelBulkBase.reset();
            this._pcAvgItemSizeBase.reset();
            this._pcMsecPerEventBase.reset();
            this._pcMsecPerCompressionAvgBase.reset();
            this._pcMsecPerDecompressionAvgBase.reset();
            this._pcAvgCompressedItemSizeBase.reset();
            this._pcMsecPerSerializationAvgBase.reset();
            this._pcMsecPerDeserializationAvgBase.reset();
            this._pcMsecPerDecryptionAvgBase.reset();
            this._pcMsecPerEncryptionBase.reset();
            if (this._publishingThread != null && this._publishingThread.isAlive()) {
                this._publish = false;
                this._publishingThread.interrupt();
            }
            if (this._cacheServer != null) {
                this._cacheServer.dispose();
            }
            this._cacheServer = null;
            if (this.NCache != null) {
                this.NCache.dispose();
            }
            this.NCache = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMsecPerDelSample(long current) {
        if (this._pcMsecPerDelAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerDelAvg;
            synchronized (averageCounter) {
                this._pcMsecPerDelAvg.incrementBy(Time.toMicroSeconds((long)current, (Time)Time.nSEC));
                this._pcMsecPerDelBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMsecPerDelSample(long value, long baseValue) {
        if (this._pcMsecPerDelAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerDelAvg;
            synchronized (averageCounter) {
                this._pcMsecPerDelAvg.incrementBy(Time.toMicroSeconds((long)value, (Time)Time.nSEC));
                this._pcMsecPerDelBase.incrementBy((double)baseValue);
            }
        }
    }

    public void msecPerDelEndSample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementMsecPerGetSample(long value) {
        if (this._pcMsecPerDelAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerGetAvg;
            synchronized (averageCounter) {
                this._pcMsecPerGetAvg.incrementBy(Time.toMicroSeconds((long)value, (Time)Time.nSEC));
                this._pcMsecPerGetBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMsecPerGetSample(long value, long baseValue) {
        if (this._pcMsecPerDelAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerGetAvg;
            synchronized (averageCounter) {
                this._pcMsecPerGetAvg.incrementBy(Time.toMicroSeconds((long)value, (Time)Time.nSEC));
                this._pcMsecPerGetBase.incrementBy((double)baseValue);
            }
        }
    }

    public void msecPerGetEndSample() {
    }

    public void msecPerAddBeginSample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMsecPerDecryptionSample(long value) {
        if (this._pcMsecPerDecryptionAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerDecryptionAvg;
            synchronized (averageCounter) {
                this._pcMsecPerDecryptionAvg.incrementBy((double)(value * 1000L));
                this._pcMsecPerDecryptionAvgBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementMsecPerDeserialization(long value) {
        if (this._pcMsecPerDeserializationAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerDeserializationAvg;
            synchronized (averageCounter) {
                this._pcMsecPerDeserializationAvg.incrementBy((double)(value * 1000000L));
                this._pcMsecPerDeserializationAvgBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementMsecPerGetBulkSample(long value) {
        if (this._pcMsecPerGetBulkAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerGetBulkAvg;
            synchronized (averageCounter) {
                this._pcMsecPerGetBulkAvg.incrementBy(Time.toMicroSeconds((long)value, (Time)Time.nSEC));
                this._pcMsecPerGetBulkBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementByGetPerSecStats(long value) {
        PerformanceCounter performanceCounter;
        if (this._pcGetPerSec != null) {
            performanceCounter = this._pcGetPerSec;
            synchronized (performanceCounter) {
                this._pcGetPerSec.incrementBy((double)value);
            }
        }
        if (this._pcReadOperationsPerSec != null) {
            performanceCounter = this._pcReadOperationsPerSec;
            synchronized (performanceCounter) {
                this._pcReadOperationsPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMessageDeliverPerSec(long value) {
        PerformanceCounter performanceCounter;
        if (this._pubsubCountersList != null && this._pubsubCountersList.size() > 0 && this._pubsubCountersList.contains("Messages Delivered/sec") && (performanceCounter = this._ncacheClientCounters.get("Messages Delivered/sec")) != null) {
            PerformanceCounter performanceCounter2 = performanceCounter;
            synchronized (performanceCounter2) {
                performanceCounter.incrementBy((double)value);
            }
        }
    }

    public void startPublishingCounters(String bindIp) {
        if (!this._publish) {
            if (bindIp == null) {
                bindIp = ServiceConfiguration.getBindToClusterIP();
            }
            if (this.NCache == null) {
                try {
                    this.NCache = new NCacheRPCService(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.NCache.setServerName(bindIp);
            if (this.NCache.getServerName() == null) {
                return;
            }
            if (this.NCache.getUseTcp()) {
                this.NCache.setPort((long)CacheConfigManager.getTcpPort());
            } else {
                this.NCache.setPort((long)CacheConfigManager.getHttpPort());
            }
        }
        this._publish = true;
        if (this._publishingThread == null) {
            this._publishingThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    PerfStatsCollector.this.PublishCounters();
                }
            });
            this._publishingThread.setDaemon(true);
            this._publishingThread.setName("CountersPublishingThread");
        }
        this._publishingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DecrementRequestQueueSizeStats() {
        if (this._pcReqrQueueSize != null) {
            PerformanceCounter performanceCounter = this._pcReqrQueueSize;
            synchronized (performanceCounter) {
                if (this._pcReqrQueueSize.getValue() > 0.0) {
                    this._pcReqrQueueSize.decrement();
                }
            }
        }
    }

    public void IncrementEventsTriggeredPerSeconds(long pcEventTriggeredPerSec) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IncrementClientRequestsPerSecStats(long requests) {
        if (this._pcClientRequestsPerSec != null) {
            PerformanceCounter performanceCounter = this._pcClientRequestsPerSec;
            synchronized (performanceCounter) {
                this._pcClientRequestsPerSec.incrementBy((double)requests);
                this.incrementTotalClientRequestsPerSecStats(requests);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IncrementClientResponsesPerSecStats(long value) {
        if (this._pcClientResponsesPerSec != null) {
            PerformanceCounterBase performanceCounterBase = this._pcClientResponsesPerSec;
            synchronized (performanceCounterBase) {
                this._pcClientResponsesPerSec.incrementBy((double)value);
                this.incrementTotalClientResponsesPerSecStats(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IncrementTotalClientRequestsPerSecStats(long value) {
        if (this._pcTotalClientRequestsPerSec != null) {
            PerformanceCounterBase performanceCounterBase = this._pcTotalClientRequestsPerSec;
            synchronized (performanceCounterBase) {
                this._pcTotalClientRequestsPerSec.incrementBy((double)value);
                this.incrementTotalClientRequestsPerSecStats(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IncrementTotalClientResponsesPerSecStats(long value) {
        if (this._pcTotalClientResponsesPerSec != null) {
            PerformanceCounterBase performanceCounterBase = this._pcTotalClientResponsesPerSec;
            synchronized (performanceCounterBase) {
                this._pcTotalClientResponsesPerSec.incrementBy((double)value);
                this.incrementTotalClientResponsesPerSecStats(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IncrementByGetPerSecStats(long value) {
        PerformanceCounter performanceCounter;
        if (this._pcGetPerSec != null) {
            performanceCounter = this._pcGetPerSec;
            synchronized (performanceCounter) {
                this._pcGetPerSec.incrementBy((double)value);
            }
        }
        if (this._pcReadOperationsPerSec != null) {
            performanceCounter = this._pcReadOperationsPerSec;
            synchronized (performanceCounter) {
                this._pcReadOperationsPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IncrementByAddPerSecStats(long value) {
        PerformanceCounter performanceCounter;
        if (this._pcAddPerSec != null) {
            performanceCounter = this._pcAddPerSec;
            synchronized (performanceCounter) {
                this._pcAddPerSec.incrementBy((double)value);
            }
        }
        if (this._pcWriteOperationsPerSec != null) {
            performanceCounter = this._pcWriteOperationsPerSec;
            synchronized (performanceCounter) {
                this._pcWriteOperationsPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IncrementByUpdPerSecStats(long value) {
        PerformanceCounter performanceCounter;
        if (this._pcUpdPerSec != null) {
            performanceCounter = this._pcUpdPerSec;
            synchronized (performanceCounter) {
                this._pcUpdPerSec.incrementBy((double)value);
            }
        }
        if (this._pcWriteOperationsPerSec != null) {
            performanceCounter = this._pcWriteOperationsPerSec;
            synchronized (performanceCounter) {
                this._pcWriteOperationsPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IncrementByDelPerSecStats(long value) {
        PerformanceCounter performanceCounter;
        if (this._pcDelPerSec != null) {
            performanceCounter = this._pcDelPerSec;
            synchronized (performanceCounter) {
                this._pcDelPerSec.incrementBy((double)value);
            }
        }
        if (this._pcWriteOperationsPerSec != null) {
            performanceCounter = this._pcWriteOperationsPerSec;
            synchronized (performanceCounter) {
                this._pcWriteOperationsPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IncrementEventsProcessedPerSec(long value) {
        if (this._pcEventProcesedPerSec != null) {
            PerformanceCounter performanceCounter = this._pcEventProcesedPerSec;
            synchronized (performanceCounter) {
                this._pcEventProcesedPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IncrementCompressionPerSec(long value) {
        if (this._pcCompressionPerSec != null) {
            PerformanceCounter performanceCounter = this._pcCompressionPerSec;
            synchronized (performanceCounter) {
                this._pcCompressionPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IncrementMsecPerMessagePublish(long value, long messageCount) {
        PerformanceCounter performanceCounter;
        if (this._pubsubCountersList != null && this._pubsubCountersList.contains("Average us/Published Messages") && (performanceCounter = this._ncacheClientCounters.get("Average us/Published Messages")) != null) {
            PerformanceCounter performanceCounter2 = performanceCounter;
            synchronized (performanceCounter2) {
                performanceCounter.incrementBy((double)(value * 1000000L / 600000000L));
                this.IncrementMessageCounter("Average us/Published Messages Base", messageCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IncrementMessageDeliverPerSec(long value) {
        PerformanceCounter performanceCounter;
        if (this._pubsubCountersList != null && this._pubsubCountersList.size() > 0 && this._pubsubCountersList.contains("Messages Delivered/sec") && (performanceCounter = this._ncacheClientCounters.get("Messages Delivered/sec")) != null) {
            PerformanceCounter performanceCounter2 = performanceCounter;
            synchronized (performanceCounter2) {
                performanceCounter.incrementBy((double)value);
            }
        }
    }

    public void IncrementMessageCounter(String counterName, long value) {
        PerformanceCounter performanceCounter;
        if (this._pubsubCountersList != null && this._pubsubCountersList.contains(counterName) && (performanceCounter = this._ncacheClientCounters.get(counterName)) != null) {
            performanceCounter.incrementBy((double)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMsecPerMessagePublish(long value) {
        PerformanceCounter performanceCounter;
        if (this._pubsubCountersList != null && this._pubsubCountersList.contains("Average us/Published Messages") && (performanceCounter = this._ncacheClientCounters.get("Average us/Published Messages")) != null) {
            PerformanceCounter performanceCounter2 = performanceCounter;
            synchronized (performanceCounter2) {
                performanceCounter.incrementBy((double)(value * 1000000L));
                this.incrementMessageCounter("Average us/Published Messages Base", 1);
            }
        }
    }

    public void incrementMessageCounter(String counterName, int incrementedValue) {
        PerformanceCounter performanceCounter;
        if (this._pubsubCountersList != null && this._pubsubCountersList.contains(counterName) && (performanceCounter = this._ncacheClientCounters.get(counterName)) != null) {
            performanceCounter.incrementBy((double)incrementedValue);
        }
    }

    public void incrementMessagePublishedPerSec(int value) {
        this.incrementMessageCounter("Messages Published/sec", value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMsecPerUpdSample(long current) {
        if (this._pcMsecPerUpdAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerUpdAvg;
            synchronized (averageCounter) {
                this._pcMsecPerUpdAvg.incrementBy(Time.toMicroSeconds((long)current, (Time)Time.nSEC));
                this._pcMsecPerUpdBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMsecPerUpdSample(long value, long baseValue) {
        if (this._pcMsecPerUpdAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerUpdAvg;
            synchronized (averageCounter) {
                this._pcMsecPerUpdAvg.incrementBy(Time.toMicroSeconds((long)value, (Time)Time.nSEC));
                this._pcMsecPerUpdBase.incrementBy((double)baseValue);
            }
        }
    }

    public void msecPerUpdEndSample() {
    }

    public void msecPerDelBeginSample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMsecPerAddSample(long current) {
        if (this._pcMsecPerAddAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerAddAvg;
            synchronized (averageCounter) {
                this._pcMsecPerAddAvg.incrementBy(Time.toMicroSeconds((long)current, (Time)Time.nSEC));
                this._pcMsecPerAddBase.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMsecPerAddSample(long value, long baseValue) {
        if (this._pcMsecPerAddAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerAddAvg;
            synchronized (averageCounter) {
                this._pcMsecPerAddAvg.incrementBy(Time.toMicroSeconds((long)value, (Time)Time.nSEC));
                this._pcMsecPerAddBase.incrementBy((double)baseValue);
            }
        }
    }

    public void msecPerAddEndSample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMsecPerDecompression(long value) {
        if (this._pcMsecPerDecompressionAvg != null) {
            AverageCounter averageCounter = this._pcMsecPerDecompressionAvg;
            synchronized (averageCounter) {
                this._pcMsecPerDecompressionAvg.incrementBy(Time.toMicroSeconds((long)(value * 1000000L), (Time)Time.nSEC));
                this._pcMsecPerDecompressionAvgBase.increment();
            }
        }
    }

    public void incrementClientRequestsPerSecStats(long requests) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementClientResponsesPerSecStats(long responses) {
        if (this._pcClientResponsesPerSec != null) {
            PerformanceCounterBase performanceCounterBase = this._pcClientResponsesPerSec;
            synchronized (performanceCounterBase) {
                this._pcClientResponsesPerSec.incrementBy((double)responses);
                this.incrementTotalClientResponsesPerSecStats(responses);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementTotalClientRequestsPerSecStats(long requests) {
        if (this._pcTotalClientRequestsPerSec != null) {
            PerformanceCounterBase performanceCounterBase = this._pcTotalClientRequestsPerSec;
            synchronized (performanceCounterBase) {
                this._pcTotalClientRequestsPerSec.incrementBy((double)requests);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementTotalClientResponsesPerSecStats(long responses) {
        if (this._pcTotalClientResponsesPerSec != null) {
            PerformanceCounterBase performanceCounterBase = this._pcTotalClientResponsesPerSec;
            synchronized (performanceCounterBase) {
                this._pcTotalClientResponsesPerSec.incrementBy((double)responses);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementPollRequestCount() {
        if (this._pollRequestsSent != null) {
            PerformanceCounter performanceCounter = this._pollRequestsSent;
            synchronized (performanceCounter) {
                this._pollRequestsSent.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPollLastUpdates(long value) {
        if (this._pollLastUpdates != null) {
            PerformanceCounter performanceCounter = this._pollLastUpdates;
            synchronized (performanceCounter) {
                this._pollLastUpdates.setValue((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPollLastRemoves(long value) {
        if (this._pollLastRemoves != null) {
            PerformanceCounter performanceCounter = this._pollLastRemoves;
            synchronized (performanceCounter) {
                this._pollLastRemoves.setValue((double)value);
            }
        }
    }

    public MetricsPublisher getStatsPublisher() {
        return this.statsPublisher;
    }

    public void setStatsPublisher(MetricsPublisher value) {
        this.statsPublisher = value;
    }

    public final void RegisterOnMetricsPublisher() {
        this.populateCounters();
        this.RegisterAsMonitorableEntity();
    }

    private void populateCounters() {
        try {
            if (this.getCategory() != null && this.getCategory().getPublish()) {
                for (Counter counter : this.getCategory().getCounters()) {
                    PerformanceCounter performanceCounter;
                    if (!counter.getPublish() || !this._ncacheClientCounters.containsKey(counter.getName()) || this._availableCounters.contains(performanceCounter = this._ncacheClientCounters.get(counter.getName()))) continue;
                    this._availableCounters.add(performanceCounter);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void RegisterAsMonitorableEntity() {
        if (this._privateCategory != null && this._privateCategory.getPublish()) {
            this.statsPublisher.RegisterMonitorableEntity((MonitorableEntity)this);
        }
    }

    private void GenerateIDMap(CounterMetadataCollection counterMetadataCollection) {
        this._counterIDMap = new CounterIDMap();
        this._counterIDMap.assignAndAddCounters(counterMetadataCollection.getCounters());
    }

    public Publisher getPublisherType() {
        return Publisher.NCacheClient;
    }

    public boolean getMergeCounters() {
        return false;
    }

    public CounterMetadataCollection getMetadata() {
        CounterMetadataCollection counterMetadataCollection = StatsMetricsUtil.Metadata((CounterCreationData[])ClientCounters.GetCounterCreationData(), (Publisher)Publisher.NCacheClient, (Category)this.getCategory());
        this.GenerateIDMap(counterMetadataCollection);
        counterMetadataCollection.setCategory(Publisher.NCacheClient);
        counterMetadataCollection.setInstanceName(ServiceConfiguration.getBindToClientServerIP().toString());
        counterMetadataCollection.setVersion("5.1");
        return counterMetadataCollection;
    }

    public IntervalCounterDataCollection getData() {
        HashMap<Short, Double> counterData = new HashMap<Short, Double>();
        ArrayList<PerformanceCounter> arrayList = this._availableCounters;
        synchronized (arrayList) {
            for (PerformanceCounter data : this._availableCounters) {
                if (data == null) continue;
                if (data.getName().equals("Request Queue Size") || data.getName().equals("Average \u00c2\u00b5s/Published Messages")) {
                    // empty if block
                }
                if (this._counterIDMap.getCounterID(data.getName()) == -10) continue;
                counterData.put(this._counterIDMap.getCounterID(data.getName()), data.getValue());
            }
            IntervalCounterDataCollection tempVar = new IntervalCounterDataCollection();
            tempVar.setValues(counterData);
            tempVar.setTimestamp(NCDateTime.getUTCNow());
            tempVar.setPublisherType(Publisher.NCacheClient);
            return tempVar;
        }
    }

    public MonitoringEntityType getGetEntityType() {
        return MonitoringEntityType.Stats;
    }

    public boolean getIsPrimary() {
        return true;
    }

    private void PublishCounters() {
        try {
            long currentVersion = -1L;
            boolean error = false;
            TimeSpan normalPublishingInterval = TimeSpan.FromSeconds((double)1.0);
            TimeSpan errorRecoveryInterval = TimeSpan.FromSeconds((double)5.0);
            while (this._publish) {
                if (Thread.currentThread().isInterrupted()) {
                    this._publish = false;
                    break;
                }
                try {
                    if (this._cacheServer == null) {
                        this._cacheServer = this.NCache.GetCacheServer(new TimeSpan(0, 0, 0, 30));
                    }
                    TimeSpan sleepInterval = !error ? normalPublishingInterval : errorRecoveryInterval;
                    Thread.sleep(sleepInterval.getTotalMiliSeconds());
                    this.PublishCountersToNCacheService();
                    error = false;
                }
                catch (InterruptedException interruptedException) {
                    this._publish = false;
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception e) {
                    if (this._cacheServer == null) {
                        Thread.sleep(this.GettingCacheServerIntervalDelay);
                        continue;
                    }
                    error = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void PublishCountersToNCacheService() {
        ClientCustomCounters counters = new ClientCustomCounters();
        if (this._pcClientRequestsPerSec != null) {
            counters._pcClientRequestsPerSec = this._pcClientRequestsPerSec.getValue();
        }
        if (this._pcClientResponsesPerSec != null) {
            counters._pcClientResponsesPerSec = this._pcClientResponsesPerSec.getValue();
        }
        if (this._pcTotalClientRequestsPerSec != null) {
            counters._pcTotalClientRequestsPerSec = this._pcTotalClientRequestsPerSec.getValue();
        }
        if (this._pcTotalClientResponsesPerSec != null) {
            counters._pcTotalClientResponsesPerSec = this._pcTotalClientResponsesPerSec.getValue();
        }
        if (this._pcAddPerSec != null) {
            counters._pcAddPerSec = this._pcAddPerSec.getValue();
        }
        if (this._pcGetPerSec != null) {
            counters._pcGetPerSec = this._pcGetPerSec.getValue();
        }
        if (this._pcGetPerSec != null) {
            counters._pcUpdPerSec = this._pcUpdPerSec.getValue();
        }
        if (this._pcDelPerSec != null) {
            counters._pcDelPerSec = this._pcDelPerSec.getValue();
        }
        if (this._pcEventTriggeredPerSec != null) {
            counters._pcEventTriggeredPerSec = this._pcEventTriggeredPerSec.getValue();
        }
        if (this._pcEventProcesedPerSec != null) {
            counters._pcEventProcesedPerSec = this._pcEventProcesedPerSec.getValue();
        }
        if (this._pcReadOperationsPerSec != null) {
            counters._pcReadOperationsPerSec = this._pcReadOperationsPerSec.getValue();
        }
        if (this._pcWriteOperationsPerSec != null) {
            counters._pcWriteOperationsPerSec = this._pcWriteOperationsPerSec.getValue();
        }
        if (this._pcMemoryUsage != null) {
            counters._pcMemoryUsage = this._pcMemoryUsage.getValue() * 1000000.0;
        }
        if (this._pcCpuUsage != null) {
            counters._pcCpuUsage = this._pcCpuUsage.getValue();
        }
        if (this._pcMsecPerAddBulkAvg != null) {
            counters._pcMsecPerAddBulkAvg = this._pcMsecPerAddBulkAvg.getSum();
            counters._pcMsecPerAddBulkBase = this._pcMsecPerAddBulkAvg.getTotalCount();
        }
        if (this._pcMsecPerGetBulkAvg != null) {
            counters._pcMsecPerGetBulkAvg = this._pcMsecPerGetBulkAvg.getSum();
            counters._pcMsecPerGetBulkBase = this._pcMsecPerGetBulkAvg.getTotalCount();
        }
        if (this._pcMsecPerUpdBulkAvg != null) {
            counters._pcMsecPerUpdBulkAvg = this._pcMsecPerUpdBulkAvg.getSum();
            counters._pcMsecPerUpdBulkBase = this._pcMsecPerUpdBulkAvg.getTotalCount();
        }
        if (this._pcMsecPerDelBulkAvg != null) {
            counters._pcMsecPerDelBulkAvg = this._pcMsecPerDelBulkAvg.getSum();
            counters._pcMsecPerDelBulkBase = this._pcMsecPerDelBulkAvg.getTotalCount();
        }
        if (this._pcMsecPerGetAvg != null) {
            counters._pcMsecPerGetAvg = this._pcMsecPerGetAvg.getSum();
            counters._pcMsecPerGetBase = this._pcMsecPerGetAvg.getTotalCount();
        }
        if (this._pcMsecPerAddAvg != null) {
            counters._pcMsecPerAddAvg = this._pcMsecPerAddAvg.getSum();
            counters._pcMsecPerAddBase = this._pcMsecPerAddAvg.getTotalCount();
        }
        if (this._pcMsecPerUpdAvg != null) {
            counters._pcMsecPerUpdAvg = this._pcMsecPerUpdAvg.getSum();
            counters._pcMsecPerUpdBase = this._pcMsecPerUpdAvg.getTotalCount();
        }
        if (this._pcMsecPerDelAvg != null) {
            counters._pcMsecPerDelAvg = this._pcMsecPerDelAvg.getSum();
            counters._pcMsecPerDelBase = this._pcMsecPerDelAvg.getTotalCount();
        }
        if (this._pcReqrQueueSize != null) {
            counters._pcReqrQueueSize = this._pcReqrQueueSize.getValue();
        }
        if (this._pcCompressionPerSec != null) {
            counters._pcCompressionPerSec = this._pcCompressionPerSec.getValue();
        }
        if (this._pcAvgItemSize != null) {
            counters._pcAvgItemSize = this._pcAvgItemSize.getSum();
            counters._pcAvgItemSizeBase = this._pcAvgItemSize.getTotalCount();
        }
        if (this._pcMsecPerEventAvg != null) {
            counters._pcMsecPerEventAvg = this._pcMsecPerEventAvg.getTotalCount();
            counters._pcMsecPerEventBase = this._pcMsecPerEventAvg.getTotalCount();
        }
        if (this._pcMsecPerCompressionAvg != null) {
            counters._pcMsecPerCompressionAvg = this._pcMsecPerCompressionAvg.getSum();
            counters._pcMsecPerCompressionAvgBase = this._pcMsecPerCompressionAvg.getTotalCount();
        }
        if (this._pcMsecPerDecompressionAvg != null) {
            counters._pcMsecPerDecompressionAvg = this._pcMsecPerDecompressionAvg.getSum();
            counters._pcMsecPerDecompressionAvgBase = this._pcMsecPerDecompressionAvg.getTotalCount();
        }
        if (this._pcAvgCompressedItemSize != null) {
            counters._pcAvgCompressedItemSize = this._pcAvgCompressedItemSize.getValue();
        }
        if (this._pcMsecPerSerializationAvg != null) {
            counters._pcMsecPerSerializationAvg = this._pcMsecPerSerializationAvg.getSum();
            counters._pcMsecPerSerializationAvgBase = this._pcMsecPerSerializationAvg.getTotalCount();
        }
        if (this._pcMsecPerDeserializationAvg != null) {
            counters._pcMsecPerDeserializationAvg = this._pcMsecPerDeserializationAvg.getSum();
            counters._pcMsecPerDeserializationAvgBase = this._pcMsecPerDeserializationAvg.getTotalCount();
        }
        if (this._pcMsecPerEncryptionAvg != null) {
            counters._pcMsecPerEncryptionAvg = this._pcMsecPerEncryptionAvg.getSum();
            counters._pcMsecPerEncryptionAvgBase = this._pcMsecPerEncryptionAvg.getTotalCount();
        }
        if (this._pcMsecPerDecryptionAvg != null) {
            counters._pcMsecPerDecryptionAvg = this._pcMsecPerDecryptionAvg.getSum();
            counters._pcMsecPerDecryptionAvgBase = this._pcMsecPerDecryptionAvg.getTotalCount();
        }
        if (this._pollRequestsSent != null) {
            counters._pollRequestsSent = this._pollRequestsSent.getValue();
        }
        if (this._pollLastUpdates != null) {
            counters._pollLastUpdates = this._pollLastUpdates.getValue();
        }
        if (this._pollLastRemoves != null) {
            counters._pollLastRemoves = this._pollLastRemoves.getValue();
        }
        if (this._pcMsecPerMessagePublishAvg != null) {
            counters._pcMsecPerMessagePublishAvg = this._pcMsecPerMessagePublishAvg.getSum();
            counters._pcMsecPerMessagePublishBase = this._pcMsecPerMessagePublishAvg.getTotalCount();
        }
        if (this._pcMessagePublishPerSec != null) {
            counters._pcMessagePublishPerSec = this._pcMessagePublishPerSec.getValue();
        }
        if (this._pcMessageDeliverPerSec != null) {
            counters._pcMessageDeliverPerSec = this._pcMessageDeliverPerSec.getValue();
        }
        if (this._cacheServer != null) {
            this._cacheServer.PublishCustomClientCounters(this._cacheID, counters);
        }
    }

    public void UpdateCounters(ClientCustomCounters counters) {
        this.IncrementClientRequestsPerSecStats((long)counters._pcClientRequestsPerSec);
        this.IncrementClientResponsesPerSecStats((long)counters._pcClientResponsesPerSec);
        this.IncrementTotalClientRequestsPerSecStats((long)counters._pcTotalClientRequestsPerSec);
        this.IncrementTotalClientResponsesPerSecStats((long)counters._pcTotalClientResponsesPerSec);
        this.IncrementByGetPerSecStats((long)counters._pcGetPerSec);
        this.IncrementByAddPerSecStats((long)counters._pcAddPerSec);
        this.IncrementByUpdPerSecStats((long)counters._pcUpdPerSec);
        this.IncrementByDelPerSecStats((long)counters._pcDelPerSec);
        this.IncrementEventsProcessedPerSec((long)counters._pcEventProcesedPerSec);
        this.IncrementEventsTriggeredPerSeconds((long)counters._pcEventTriggeredPerSec);
        this.IncrementCompressionPerSec((long)counters._pcCompressionPerSec);
        this._pcReqrQueueSize.setValue(counters._pcReqrQueueSize);
        this._pollRequestsSent.setValue(counters._pollRequestsSent);
        this._pollLastUpdates.setValue(counters._pollLastUpdates);
        this._pollLastRemoves.setValue(counters._pollLastRemoves);
        this.IncrementMsecPerMessagePublish((long)counters._pcMessagePublishPerSec, 1L);
        this.IncrementMessageDeliverPerSec((long)counters._pcMessageDeliverPerSec);
        if (this._pcMsecPerAddAvg != null) {
            this._pcMsecPerAddAvg.incrementBy(counters._pcMsecPerAddAvg, counters._pcMsecPerAddBase);
        }
        if (this._pcMsecPerAddBulkAvg != null) {
            this._pcMsecPerAddBulkAvg.incrementBy(counters._pcMsecPerAddBulkAvg, counters._pcMsecPerAddBulkBase);
        }
        if (this._pcMsecPerGetBulkAvg != null) {
            this._pcMsecPerGetBulkAvg.incrementBy(counters._pcMsecPerGetBulkAvg, counters._pcMsecPerGetBulkBase);
        }
        if (this._pcMsecPerUpdBulkAvg != null) {
            this._pcMsecPerUpdBulkAvg.incrementBy(counters._pcMsecPerUpdBulkAvg, counters._pcMsecPerUpdBulkBase);
        }
        if (this._pcMsecPerUpdBulkAvg != null) {
            this._pcMsecPerUpdBulkAvg.incrementBy(counters._pcMsecPerUpdBulkAvg, counters._pcMsecPerUpdBulkBase);
        }
        if (this._pcMsecPerDelBulkAvg != null) {
            this._pcMsecPerDelBulkAvg.incrementBy(counters._pcMsecPerDelBulkAvg, counters._pcMsecPerDelBulkBase);
        }
        if (this._pcMsecPerGetAvg != null) {
            this._pcMsecPerGetAvg.incrementBy(counters._pcMsecPerGetAvg, counters._pcMsecPerGetBase);
        }
        if (this._pcMsecPerUpdAvg != null) {
            this._pcMsecPerUpdAvg.incrementBy(counters._pcMsecPerUpdAvg, counters._pcMsecPerUpdBase);
        }
        if (this._pcMsecPerDelAvg != null) {
            this._pcMsecPerDelAvg.incrementBy(counters._pcMsecPerDelAvg, counters._pcMsecPerDelBase);
        }
        if (this._pcAvgItemSize != null) {
            this._pcAvgItemSize.incrementBy(counters._pcAvgItemSize, counters._pcAvgItemSizeBase);
        }
        if (this._pcMsecPerEventAvg != null) {
            this._pcMsecPerEventAvg.incrementBy(counters._pcMsecPerEventAvg, counters._pcMsecPerEventBase);
        }
        if (this._pcMsecPerCompressionAvg != null) {
            this._pcMsecPerCompressionAvg.incrementBy(counters._pcMsecPerCompressionAvg, counters._pcMsecPerCompressionAvgBase);
        }
        if (this._pcMsecPerCompressionAvg != null) {
            this._pcMsecPerCompressionAvg.incrementBy(counters._pcMsecPerCompressionAvg, counters._pcMsecPerCompressionAvgBase);
        }
        if (this._pcMsecPerDecompressionAvg != null) {
            this._pcMsecPerDecompressionAvg.incrementBy(counters._pcMsecPerDecompressionAvg, counters._pcMsecPerDecompressionAvgBase);
        }
        if (this._pcMsecPerSerializationAvg != null) {
            this._pcMsecPerSerializationAvg.incrementBy(counters._pcMsecPerSerializationAvg, counters._pcMsecPerSerializationAvgBase);
        }
        if (this._pcMsecPerDeserializationAvg != null) {
            this._pcMsecPerDeserializationAvg.incrementBy(counters._pcMsecPerDeserializationAvg, counters._pcMsecPerDeserializationAvgBase);
        }
        if (this._pcMsecPerEncryptionAvg != null) {
            this._pcMsecPerEncryptionAvg.incrementBy(counters._pcMsecPerEncryptionAvg, counters._pcMsecPerEncryptionAvgBase);
        }
        if (this._pcMsecPerDecryptionAvg != null) {
            this._pcMsecPerDecryptionAvg.incrementBy(counters._pcMsecPerDecryptionAvg, counters._pcMsecPerDecryptionAvgBase);
        }
        if (this._pcMsecPerMessagePublishAvg != null) {
            this._pcMsecPerMessagePublishAvg.incrementBy(counters._pcMsecPerMessagePublishAvg, counters._pcMsecPerMessagePublishBase);
        }
    }
}

