/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.datastructure;

import Alachisoft.NCache.Common.DataTypes.Queue.QueueDequeueOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueueEnqueueOperation;
import com.alachisoft.ncache.client.datastructures.DistributedQueue;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedCollectionIteratorImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedDataStructureImpl;
import com.alachisoft.ncache.runtime.caching.DistributedDataStructure;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.events.DataStructureDataChangeListener;
import com.alachisoft.ncache.runtime.events.DataTypeEventDataFilter;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

class DistributedQueueImpl<T>
extends DistributedDataStructureImpl
implements DistributedQueue<T> {
    public DistributedQueueImpl(String key, CacheImpl cache, WriteThruOptions options, Class cls) {
        super(key, cache, options, cls);
    }

    @Override
    protected DistributedDataStructure getDataType() {
        return DistributedDataStructure.Queue;
    }

    @Override
    public void copyTo(T[] array, int arrayIndex) {
        this.CopyToInternal(this, array, arrayIndex, this.size());
    }

    @Override
    public boolean contains(Object item) {
        if (item == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: item");
        }
        this.validateTypeNotCacheItem(item.getClass());
        return this.getCache().queueSearch(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, item);
    }

    @Override
    public Iterator<T> iterator() {
        return new DistributedCollectionIteratorImpl(this.getCache(), this.getKey(), DistributedDataStructure.Queue, this._valueType);
    }

    @Override
    public Object[] toArray() {
        Object[] objArr = new Object[this.size()];
        Iterator<T> iterator = this.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            objArr[index++] = iterator.next();
        }
        return objArr;
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        Object[] elementData = this.toArray();
        int size = elementData.length;
        if (a.length < size) {
            return Arrays.copyOf(elementData, size, a.getClass());
        }
        System.arraycopy(elementData, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean add(T item) {
        if (item == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: item");
        }
        this.validateTypeNotCacheItem(item.getClass());
        return this.getCache().queueEnqueue(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, item, QueueEnqueueOperation.OpType.Enqueue, this.getWriteThruOptions());
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("containsAll");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll");
    }

    @Override
    public boolean offer(T item) {
        return this.add(item);
    }

    @Override
    public T remove() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("element");
        }
        return this.poll();
    }

    @Override
    public T poll() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getCache().queueDequeue(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, QueueDequeueOperation.OpType.Dequeue, this.getWriteThruOptions(), this._valueType);
    }

    @Override
    public T element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("element");
        }
        return this.peek();
    }

    @Override
    public T peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getCache().queuePeek(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, this._valueType);
    }

    @Override
    public void addChangeListener(DataStructureDataChangeListener dataTypeDataNotificationCallback, EnumSet<EventType> eventType, DataTypeEventDataFilter datafilter) throws CacheException {
        if (eventType.contains(EventType.ItemUpdated)) {
            throw new IllegalArgumentException("Registration for update event is not supported for this data type.");
        }
        super.addChangeListener(dataTypeDataNotificationCallback, eventType, datafilter);
    }

    private void validateClass(Object o) {
        if (o.getClass() != this.getClass()) {
            throw new ClassCastException("Object class is not the same as this class");
        }
    }
}

