/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.datastructure;

import Alachisoft.NCache.Caching.Util.CollectionUtil;
import Alachisoft.NCache.Common.DataTypes.List.ListAddWithPivotOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListAddWithoutIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListGetItemOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListInsertWithIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListRemoveWithIndexOperation;
import com.alachisoft.ncache.client.datastructures.DistributedList;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedCollectionIteratorImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedDataStructureImpl;
import com.alachisoft.ncache.runtime.caching.DistributedDataStructure;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.events.DataStructureDataChangeListener;
import com.alachisoft.ncache.runtime.events.DataTypeEventDataFilter;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.exceptions.AggregateException;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.runtime.OperationFailedRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

class DistributedListImpl<T>
extends DistributedDataStructureImpl
implements DistributedList<T> {
    public DistributedListImpl(String key, CacheImpl cache, WriteThruOptions options, Class<?> cls) {
        super(key, cache, options, cls);
    }

    @Override
    protected DistributedDataStructure getDataType() {
        return DistributedDataStructure.List;
    }

    @Override
    public void trim(int start, int end) {
        this.validateIndex(start);
        this.validateIndex(end);
        this.getCache().listRemoveWithIndex(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, start, end, ListRemoveWithIndexOperation.OpType.Trim, this.getWriteThruOptions());
    }

    @Override
    public List<T> getRange(int start, int count) {
        this.validateIndex(start);
        this.validateIndex(count);
        return this.getCache().listGetBulk(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, start, count, this._valueType);
    }

    @Override
    public void addRange(Collection<? extends T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: collection");
        }
        CollectionUtil.verifyCollection(collection);
        this.getCache().listAddWithoutIndex(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, collection, ListAddWithoutIndexOperation.OpType.AddRange, this.getWriteThruOptions());
    }

    @Override
    public void removeRange(int index, int count) {
        this.validateIndex(index);
        if (count < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values");
        }
        this.getCache().listRemoveWithIndex(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, index, count, ListRemoveWithIndexOperation.OpType.RemoveRange, this.getWriteThruOptions());
    }

    @Override
    public int removeRange(Collection<?> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: collection");
        }
        return this.getCache().listRemoveWithoutIndex(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, collection, this.getWriteThruOptions());
    }

    @Override
    public boolean insertAfter(T pivot, T value) {
        if (pivot == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: pivot");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
        }
        this.validateTypeNotCacheItem(value.getClass());
        return this.getCache().listAddWithPivot(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, pivot, value, ListAddWithPivotOperation.OpType.InsertAfter, this.getWriteThruOptions());
    }

    @Override
    public boolean insertBefore(T pivot, T value) {
        if (pivot == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: pivot");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
        }
        this.validateTypeNotCacheItem(value.getClass());
        return this.getCache().listAddWithPivot(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, pivot, value, ListAddWithPivotOperation.OpType.InsertBefore, this.getWriteThruOptions());
    }

    @Override
    public T first() {
        return this.getCache().listGetItem(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, -1, ListGetItemOperation.OpType.First, this._valueType);
    }

    @Override
    public T last() {
        return this.getCache().listGetItem(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, -1, ListGetItemOperation.OpType.Last, this._valueType);
    }

    @Override
    public void insertAtHead(T value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
        }
        this.validateTypeNotCacheItem(value.getClass());
        ArrayList<T> arr = new ArrayList<T>();
        arr.add(value);
        this.getCache().listAddWithoutIndex(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, arr, ListAddWithoutIndexOperation.OpType.InsertAtHead, this.getWriteThruOptions());
    }

    @Override
    public void insertAtTail(T value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
        }
        this.validateTypeNotCacheItem(value.getClass());
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.add(value);
        this.getCache().listAddWithoutIndex(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, arrayList, ListAddWithoutIndexOperation.OpType.InsertAtTail, this.getWriteThruOptions());
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new DistributedCollectionIteratorImpl(this.getCache(), this.getKey(), DistributedDataStructure.List, this._valueType);
    }

    @Override
    public Object[] toArray() {
        Object[] objArr = new Object[this.size()];
        Iterator<T> iterator = this.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            objArr[index++] = iterator.next();
        }
        return objArr;
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        int size = this.size();
        Object[] elementData = this.toArray();
        if (a.length < size) {
            return Arrays.copyOf(elementData, size, a.getClass());
        }
        System.arraycopy(elementData, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean add(T item) {
        if (item == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: item");
        }
        this.validateTypeNotCacheItem(item.getClass());
        ArrayList<T> list = new ArrayList<T>();
        list.add(item);
        this.addRange(list);
        return true;
    }

    @Override
    public boolean remove(Object item) {
        if (item == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: item");
        }
        this.validateTypeNotCacheItem(item.getClass());
        ArrayList<Object> list = new ArrayList<Object>(Collections.singletonList(item));
        return this.removeAll(list);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("containsAll");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.addRange(c);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.removeRange(c) != 0;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll");
    }

    @Override
    public T get(int index) {
        this.validateIndex(index);
        return this.getCache().listGetItem(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, index, ListGetItemOperation.OpType.Index, this._valueType);
    }

    @Override
    public T set(int index, T element) {
        this.validateIndex(index);
        if (element == null) {
            throw new NullPointerException("Value cannot be null.\nParameter name: element");
        }
        this.getCache().listInsertWithIndex(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, index, element, ListInsertWithIndexOperation.OpType.Update, this.getWriteThruOptions());
        return element;
    }

    @Override
    public void add(int index, T element) {
        this.validateIndex(index);
        if (element == null) {
            throw new NullPointerException("Value cannot be null.\nParameter name: element");
        }
        this.validateTypeNotCacheItem(element.getClass());
        this.getCache().listInsertWithIndex(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, index, element, ListInsertWithIndexOperation.OpType.Add, this.getWriteThruOptions());
    }

    @Override
    public T remove(int index) {
        this.validateIndex(index);
        T previous = this.get(index);
        this.getCache().listRemoveWithIndex(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, index, index, ListRemoveWithIndexOperation.OpType.RemoveAt, this.getWriteThruOptions());
        return previous;
    }

    @Override
    public int indexOf(Object item) {
        if (item == null) {
            throw new NullPointerException("Value cannot be null.\nParameter name: item");
        }
        this.validateTypeNotCacheItem(item.getClass());
        return this.getCache().listSearch(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, item);
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("lastIndexOf");
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("listIterator");
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException("listIterator");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        this.validateIndex(fromIndex);
        this.validateIndex(toIndex);
        return this.getRange(fromIndex, toIndex - fromIndex);
    }

    @Override
    public void copyTo(T[] array, int arrayIndex) {
        try {
            this.CopyToInternal(this, array, arrayIndex, this.CountInternal(DistributedDataStructure.List));
        }
        catch (AggregateException | GeneralFailureException | OperationFailedException e) {
            throw new OperationFailedRuntimeException();
        }
    }

    @Override
    public void addChangeListener(DataStructureDataChangeListener dataTypeDataNotificationCallback, EnumSet<EventType> eventType, DataTypeEventDataFilter datafilter) throws CacheException {
        super.addChangeListener(dataTypeDataNotificationCallback, eventType, datafilter);
    }

    @Override
    public void removeChangeListener(DataStructureDataChangeListener dataTypeDataNotificationCallback, EnumSet<EventType> eventType) throws Exception {
        super.removeChangeListener(dataTypeDataNotificationCallback, eventType);
    }

    private void validateIndex(int index) throws IllegalArgumentException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index was out of range. Must be non-negative and less than the size of the collection.");
        }
    }
}

