/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.datastructure;

import Alachisoft.NCache.Caching.Util.CollectionUtil;
import Alachisoft.NCache.Common.DataTypes.CollectionCreateOrGetOperation;
import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import com.alachisoft.ncache.client.datastructures.DistributedHashSet;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedCollectionIteratorImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedDataStructureImpl;
import com.alachisoft.ncache.runtime.caching.DistributedDataStructure;
import com.alachisoft.ncache.runtime.caching.ReadMode;
import com.alachisoft.ncache.runtime.caching.ReadThruOptions;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.events.DataStructureDataChangeListener;
import com.alachisoft.ncache.runtime.events.DataTypeEventDataFilter;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.exceptions.AggregateException;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.ConnectionException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.runtime.GeneralFailureRuntimeException;
import com.alachisoft.ncache.runtime.exceptions.runtime.OperationFailedRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;

class DistributedHashSetImpl<T>
extends DistributedDataStructureImpl
implements DistributedHashSet<T> {
    public DistributedHashSetImpl(String key, CacheImpl cache, WriteThruOptions options, Class<?> cls) {
        super(key, cache, options, cls);
    }

    @Override
    protected DistributedDataStructure getDataType() {
        return DistributedDataStructure.Set;
    }

    @Override
    public void addRange(Collection<T> collection) {
        this.addOrInsertOperation(collection);
    }

    @Override
    public T removeRandom() {
        return this.removeRandomOperation();
    }

    @Override
    public T getRandom() {
        return this.getRandomOperation(1)[0];
    }

    @Override
    public T[] getRandom(int count) {
        return this.getRandomOperation(count);
    }

    @Override
    public int remove(Collection<T> items) {
        return this.removeOperation(items);
    }

    @Override
    public Collection<T> union(String other) throws CacheException {
        HashSet<T> tmp = new HashSet<T>(this.GetOtherSet(other, this._valueType));
        if (tmp == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: other");
        }
        tmp.addAll(this);
        return tmp;
    }

    @Override
    public Collection<T> intersect(String other) throws CacheException {
        HashSet<T> tmp = new HashSet<T>(this.GetOtherSet(other, this._valueType));
        if (tmp == null) {
            throw new OperationFailedException(other + " does not exist.");
        }
        HashSet<T> result = new HashSet<T>();
        for (T item : this) {
            if (!tmp.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    @Override
    public Collection<T> difference(String other) throws CacheException {
        DistributedHashSet<T> otherHashSet = this.GetOtherSet(other, this._valueType);
        if (otherHashSet == null) {
            throw new OperationFailedException(other + " does not exist.");
        }
        HashSet setA = new HashSet(this);
        setA.removeAll(otherHashSet);
        return setA;
    }

    @Override
    public DistributedHashSet<T> storeUnion(String destination, String other) throws CacheException {
        DistributedHashSet<T> finalSet = this.GetOrCreateOtherSet(destination, this._valueType);
        DistributedHashSet<T> otherHashSet = this.GetOtherSet(other, this._valueType);
        if (otherHashSet == null) {
            throw new OperationFailedException(other + " does not exist.");
        }
        finalSet.addRange(this.union(other));
        return finalSet;
    }

    @Override
    public DistributedHashSet<T> storeDifference(String destination, String other) throws CacheException {
        DistributedHashSet<T> finalSet = this.GetOrCreateOtherSet(destination, this._valueType);
        DistributedHashSet<T> otherHashSet = this.GetOtherSet(other, this._valueType);
        if (otherHashSet == null) {
            throw new OperationFailedException(other + " does not exist.");
        }
        finalSet.addRange(this.difference(other));
        return finalSet;
    }

    @Override
    public DistributedHashSet<T> storeIntersection(String destination, String other) throws CacheException {
        DistributedHashSet<T> finalSet = this.GetOrCreateOtherSet(destination, this._valueType);
        DistributedHashSet<T> otherHashSet = this.GetOtherSet(other, this._valueType);
        if (otherHashSet == null) {
            throw new OperationFailedException(other + " does not exist.");
        }
        finalSet.addRange(this.intersect(other));
        return finalSet;
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    @Override
    public boolean contains(Object o) {
        try {
            return this.containsOperation(o);
        }
        catch (GeneralFailureException e) {
            throw new GeneralFailureRuntimeException((Throwable)e);
        }
        catch (AggregateException | OperationFailedException e) {
            throw new OperationFailedRuntimeException(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new DistributedCollectionIteratorImpl(this.getCache(), this.getKey(), DistributedDataStructure.Set, this._valueType);
    }

    @Override
    public Object[] toArray() {
        int queueCount = this.size();
        Object[] array = new Object[queueCount];
        int x = 0;
        for (T t : this) {
            array[x++] = t;
        }
        return array;
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        int size = this.size();
        Object[] elementData = this.toArray();
        if (a.length < size) {
            return Arrays.copyOf(elementData, size, a.getClass());
        }
        System.arraycopy(elementData, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean add(T item) {
        if (item == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: item");
        }
        HashSet<T> hashSet = new HashSet<T>();
        hashSet.add(item);
        this.addOrInsertOperation(hashSet);
        return false;
    }

    @Override
    public boolean remove(Object o) {
        ArrayList<Object> arr = new ArrayList<Object>();
        arr.add(o);
        return this.removeOperation(arr) > 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("containsAll");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.addOrInsertOperation(c);
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll");
    }

    @Override
    public final void copyTo(T[] array, int arrayIndex) {
        try {
            this.CopyToInternal(this, array, arrayIndex, this.CountInternal(DistributedDataStructure.Set));
        }
        catch (AggregateException | GeneralFailureException | OperationFailedException e) {
            throw new OperationFailedRuntimeException();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.remove(c);
    }

    private void addOrInsertOperation(Collection<? extends T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: collection");
        }
        for (T item : collection) {
            if (item == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: item");
            }
            this.validateTypeNotCacheItem(item.getClass());
        }
        this.verifyItemsType(collection);
        this.getCache().hashSetAdd(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, collection, this.getWriteThruOptions());
    }

    private void verifyItemsType(Collection<? extends T> collection) {
        for (T item : collection) {
            CollectionUtil.validateTypeForHashSet(item.getClass());
        }
    }

    private int removeOperation(Collection<T> items) {
        if (items == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: items");
        }
        for (T item : items) {
            if (item == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: item");
            }
            this.validateTypeNotCacheItem(item.getClass());
        }
        return this.getCache().hashSetRemove(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, items, this.getWriteThruOptions());
    }

    private T removeRandomOperation() {
        return this.getCache().hashSetRemoveRandom(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, this.getWriteThruOptions(), this._valueType);
    }

    private boolean containsOperation(T value) throws ConnectionException, GeneralFailureException, OperationFailedException, AggregateException {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
        }
        this.validateTypeNotCacheItem(value.getClass());
        return this.getCache().hashSetContains(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, value);
    }

    private T[] getRandomOperation(int count) {
        if (count <= 0) {
            throw new OperationFailedRuntimeException(45006, ErrorMessages.getErrorMessage((int)45006, (String[])new String[0]));
        }
        return this.getCache().hashSetGetRandom(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, count, this._valueType);
    }

    private DistributedHashSet<T> GetOtherSet(String other, Class<?> cls) throws CacheException {
        CollectionCreateOrGetOperation tempVar = new CollectionCreateOrGetOperation(other, DistributedDataStructure.Set);
        tempVar.setReadThruOptions(new ReadThruOptions(ReadMode.None));
        if (this.getCache().getDataType(tempVar)) {
            return new DistributedHashSetImpl<T>(other, this.getCache(), null, cls);
        }
        return null;
    }

    private DistributedHashSet<T> GetOrCreateOtherSet(String other, Class<?> cls) throws CacheException {
        if (this.GetOtherSet(other, cls) == null) {
            CollectionCreateOrGetOperation tempVar = new CollectionCreateOrGetOperation(other, DistributedDataStructure.Set);
            tempVar.setReadThruOptions(new ReadThruOptions(ReadMode.None));
            CollectionCreateOrGetOperation operation = tempVar;
            this.getCache().createDataType(operation, null);
        }
        return new DistributedHashSetImpl<T>(other, this.getCache(), null, cls);
    }

    @Override
    public void addChangeListener(DataStructureDataChangeListener dataTypeDataNotificationCallback, EnumSet<EventType> eventType, DataTypeEventDataFilter datafilter) throws CacheException {
        if (eventType.contains(EventType.ItemUpdated)) {
            throw new IllegalArgumentException("Registration for update event is not supported for this data type.");
        }
        super.addChangeListener(dataTypeDataNotificationCallback, eventType, datafilter);
    }
}

