/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.datastructure;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.DataTypes.Responses.GetCollectionChunkResponse;
import Alachisoft.NCache.Common.DataTypes.Responses.GetCollectionChunkResponseBase;
import Alachisoft.NCache.Common.Enum.UserObjectType;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.runtime.caching.DistributedDataStructure;
import com.alachisoft.ncache.runtime.exceptions.AggregateException;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.ConnectionException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.runtime.GeneralFailureRuntimeException;
import com.alachisoft.ncache.runtime.exceptions.runtime.OperationFailedRuntimeException;
import java.util.Iterator;

class DistributedCollectionIteratorImpl<T>
implements Iterator<T> {
    protected int _index;
    protected String _key;
    protected CacheImpl _cache;
    int _size;
    T _current;
    private Class _valueType;
    DistributedDataStructure _collectionType;
    GetCollectionChunkResponseBase _response;

    DistributedCollectionIteratorImpl(CacheImpl cache, String key, DistributedDataStructure collectionType, Class<?> cls) {
        this._key = key;
        this._cache = cache;
        this._size = 0;
        this._index = 0;
        this._current = null;
        this._valueType = cls;
        this._collectionType = collectionType;
    }

    protected boolean moveNextInternal(boolean peekOnly) throws ConnectionException, OperationFailedException, AggregateException, GeneralFailureException {
        Object temp;
        if (this._index >= this._size && !this.getNextAvailableChunk()) {
            return this.MoveNextRare();
        }
        GetCollectionChunkResponse response = (GetCollectionChunkResponse)this._response;
        try {
            temp = this._cache.safeDeserialize(response.getDataChunk().get(this._index), this._cache.getSerializationContext(), new BitSet(32), UserObjectType.DistributedDataType, this._valueType);
        }
        catch (CacheException e) {
            return false;
        }
        if (peekOnly) {
            return true;
        }
        this._current = temp;
        ++this._index;
        return true;
    }

    protected boolean getNextAvailableChunk() throws ConnectionException, OperationFailedException, GeneralFailureException, AggregateException {
        if (this._response == null || !this._response.getIsLastChunk()) {
            this._response = this._cache.getCollectionChunkResponse(this._key, this._collectionType, this._response != null ? this._response.getVersion() : 0, this._response != null ? this._response.getNextIndex() : 0);
            GetCollectionChunkResponse response = (GetCollectionChunkResponse)this._response;
            if (response.getDataChunk().size() == 0) {
                return false;
            }
            this._size = response.getDataChunk().size();
            this._index = 0;
            return true;
        }
        return false;
    }

    boolean MoveNextRare() {
        this._index = this._size + 1;
        this._current = null;
        return false;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.moveNextInternal(true);
        }
        catch (AggregateException | OperationFailedException e) {
            throw new OperationFailedRuntimeException(e);
        }
        catch (GeneralFailureException e) {
            throw new GeneralFailureRuntimeException((Throwable)e);
        }
    }

    @Override
    public T next() {
        try {
            this.moveNextInternal(false);
        }
        catch (AggregateException | OperationFailedException e) {
            throw new OperationFailedRuntimeException(e);
        }
        catch (GeneralFailureException e) {
            throw new GeneralFailureRuntimeException((Throwable)e);
        }
        return this._current;
    }
}

