/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.datastructure;

import Alachisoft.NCache.Common.DataTypes.Counter.CounterOperation;
import com.alachisoft.ncache.client.datastructures.Counter;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedDataStructureImpl;
import com.alachisoft.ncache.runtime.caching.DistributedDataStructure;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.events.DataStructureDataChangeListener;
import com.alachisoft.ncache.runtime.events.DataTypeEventDataFilter;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import java.util.EnumSet;

class CounterImpl
extends DistributedDataStructureImpl
implements Counter {
    public CounterImpl(String key, CacheImpl cache, WriteThruOptions options, Class<?> cls) {
        super(key, cache, options, cls);
    }

    @Override
    public long setValue(long value) {
        return this.getCache().counterOperations(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, value, CounterOperation.OpType.SetValue, this.getWriteThruOptions());
    }

    @Override
    public long getValue() {
        return this.getCache().counterGetOperation(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout);
    }

    @Override
    public long increment() {
        return this.getCache().counterOperations(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, 1L, CounterOperation.OpType.IncrementBy, this.getWriteThruOptions());
    }

    @Override
    public long decrement() {
        return this.getCache().counterOperations(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, 1L, CounterOperation.OpType.DecrementBy, this.getWriteThruOptions());
    }

    @Override
    public long incrementBy(long value) {
        if (value == 0L) {
            throw new IllegalArgumentException("value cannot be " + value);
        }
        return this.getCache().counterOperations(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, value, CounterOperation.OpType.IncrementBy, this.getWriteThruOptions());
    }

    @Override
    public long decrementBy(long value) {
        if (value == 0L) {
            throw new IllegalArgumentException("value cannot be " + value);
        }
        return this.getCache().counterOperations(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, value, CounterOperation.OpType.DecrementBy, this.getWriteThruOptions());
    }

    @Override
    protected DistributedDataStructure getDataType() {
        return DistributedDataStructure.Counter;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return -1;
        }
        if (Counter.class.isAssignableFrom(o.getClass())) {
            return Long.compare(((Counter)o).getValue(), this.getValue());
        }
        if (Long.TYPE.isAssignableFrom(o.getClass())) {
            return Long.compare((Long)o, this.getValue());
        }
        return -1;
    }

    @Override
    public void addChangeListener(DataStructureDataChangeListener dataTypeDataChangeListener, EnumSet<EventType> eventType, DataTypeEventDataFilter dataFilter) throws CacheException {
        if (eventType.contains(EventType.ItemAdded) || eventType.contains(EventType.ItemRemoved)) {
            throw new IllegalArgumentException("Registration for Add and Remove event is not supported for this dataType.");
        }
        super.addChangeListener(dataTypeDataChangeListener, eventType, dataFilter);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (Counter.class.isAssignableFrom(obj.getClass())) {
            return ((Counter)obj).getValue() == this.getValue();
        }
        if (Long.TYPE.isAssignableFrom(obj.getClass())) {
            return ((Long)obj).longValue() == this.getValue();
        }
        return false;
    }
}

