/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import Alachisoft.NCache.Common.DataStructures.NewHashmap;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.Threading.Monitor;
import com.alachisoft.ncache.client.ServerInfo;
import com.alachisoft.ncache.client.internal.communication.Broker;
import com.alachisoft.ncache.client.internal.communication.Connection;
import com.alachisoft.ncache.client.internal.communication.ShutDownServerInfo;
import com.alachisoft.ncache.runtime.exceptions.InternalCommandException;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import tangible.RefObject;

class UpdateHashmapAsync
implements Runnable {
    private final Broker _broker;
    private byte[] serializedMap;
    private NewHashmap _newHashMap;

    public UpdateHashmapAsync(Broker broker) {
        this._broker = broker;
    }

    @Override
    public void run() {
        this.updateHashmap();
    }

    public void setData(byte[] value) {
        this.serializedMap = value;
    }

    public void sethashmap(NewHashmap newHashmap) {
        this._newHashMap = newHashmap;
    }

    private void updateHashmap() {
        block4: {
            byte[] serializedMap = this.serializedMap;
            try {
                if (serializedMap != null) {
                    this._newHashMap = NewHashmap.DeserializeString((byte[])serializedMap, (String)this._broker.getCache().getName());
                }
                if (this._newHashMap != null) {
                    this.NewHashmapRecieved(this._newHashMap);
                }
            }
            catch (Exception e) {
                if (!this._broker.getLogger().getIsErrorLogsEnabled()) break block4;
                this._broker.getLogger().getNCacheLog().Error("Broker.UpdateHashmapAsync", "An error occurred while installing updated hashmap. Error :" + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void NewHashmapRecieved(NewHashmap newHashmap) {
        if (newHashmap == null) {
            if (this._broker.getLogger().getIsErrorLogsEnabled()) {
                this._broker.getLogger().getNCacheLog().CriticalInfo("Broker.NewHashmapReceived", "Hashmap is null... returning");
            }
            return;
        }
        try {
            this._broker.getlock().AcquireWriterLock();
            Object object = this._broker.getHashmapUpdateMutex();
            synchronized (object) {
                block42: {
                    block41: {
                        long oldId;
                        if (this._broker.getLogger().getIsDetailedLogsEnabled()) {
                            this._broker.getLogger().getNCacheLog().Debug("Broker.NewHashmapReceived", "Hashmap " + newHashmap.toString());
                        }
                        long l = oldId = this._broker.getPool() != null ? this._broker.getPool().getLastViewId() : -2L;
                        if (newHashmap.getLastViewId() != this._broker.getPool().getLastViewId()) break block41;
                        if (newHashmap.isForcefulUpdate()) {
                            if (this._broker.getLogger() != null && this._broker.getLogger().getNCacheLog() != null) {
                                this._broker.getLogger().getNCacheLog().CriticalInfo("Broker.NewHashmapReceived", "Hashmap is same as current pool. Pool " + this._broker.getPool().toString() + " New Hashmap " + newHashmap.toString() + " ... is being installed forcefully");
                            }
                            break block41;
                        }
                        if (this._broker.getLogger() != null && this._broker.getLogger().getNCacheLog() != null) {
                            this._broker.getLogger().getNCacheLog().CriticalInfo("Broker.NewHashmapReceived", "Hashmap is same as current pool. Pool " + this._broker.getPool().toString() + " New Hashmap " + newHashmap.toString() + " ... returning");
                        }
                        return;
                    }
                    try {
                        if (this._broker.getClientConfig().getIPMappingConfigured()) {
                            this._broker.GetServerMapping(null, false);
                        }
                        for (int i = 0; i < newHashmap.getMembers().size(); ++i) {
                            Object ip = (String)newHashmap.getMembers().get(i);
                            int serverPort = this._broker.getPort();
                            if (this._broker.getClientConfig().getIPMappingConfigured()) {
                                ServerInfo server = this._broker.getClientConfig().getMappedServer((String)ip, serverPort);
                                ip = server.getName();
                                serverPort = server.getPort();
                                newHashmap.getMembers().add(i, (String)ip + ":" + Integer.valueOf(serverPort).toString());
                            }
                            Address addr = new Address((String)ip, serverPort);
                            if (!this._broker.getPool().Contains(addr)) {
                                InetAddress address = null;
                                Connection connection = null;
                                try {
                                    address = InetAddress.getByName((String)ip);
                                    connection = new Connection(this._broker);
                                    Exception exception = null;
                                    RefObject tempRef_exception = new RefObject(exception);
                                    boolean tempVar3 = this._broker.ConnectRemoteServer(connection, address, serverPort, false, false, false, (RefObject<Exception>)tempRef_exception, true);
                                    exception = (Exception)tempRef_exception.argvalue;
                                    if (tempVar3) {
                                        this._broker.getPool().Add(addr, connection);
                                        this._broker._clientConfig.addServer(new ServerInfo(address, serverPort));
                                        if (!this._broker.getLogger().getIsDetailedLogsEnabled()) continue;
                                        this._broker.getLogger().getNCacheLog().Debug("Broker.NewHashmapRecieved", "Connection made to " + (String)ip + ", and added to pool");
                                        continue;
                                    }
                                    if (exception == null || !this._broker.getLogger().getIsErrorLogsEnabled()) continue;
                                    this._broker.getLogger().getNCacheLog().Error("Broker.NewHashmapRecieved", "Could not connect to " + (String)ip + ". " + exception.toString());
                                }
                                catch (SecurityException sxc) {
                                    if (!this._broker.getLogger().getIsErrorLogsEnabled()) continue;
                                    this._broker.getLogger().getNCacheLog().Error("Broker.NewHashmapRecieved", "You do not have permissions to perform the operation on " + (String)ip + ". " + sxc.toString());
                                }
                                catch (InternalCommandException ex) {
                                    if (!this._broker.getLogger().getIsErrorLogsEnabled()) continue;
                                    this._broker.getLogger().getNCacheLog().Error("Broker.NewHashmapRecieved", ex.toString());
                                }
                                catch (LicensingException ex) {
                                    if (!this._broker.getLogger().getIsErrorLogsEnabled()) continue;
                                    this._broker.getLogger().getNCacheLog().Error("Broker.NewHashmapRecieved", ex.toString());
                                }
                                catch (Exception exc) {
                                    this._broker.getPool().Add(addr, connection);
                                    this._broker._clientConfig.addServer(new ServerInfo(address, serverPort));
                                    if (!this._broker.getLogger().getIsErrorLogsEnabled()) continue;
                                    this._broker.getLogger().getNCacheLog().Error("Broker.NewHashmapRecieved", exc.toString());
                                }
                                continue;
                            }
                            Connection connection = this._broker.getPool().getItem(addr);
                            if (connection != null && !connection.getIsConnected()) {
                                if (this._broker.getLogger().getIsDetailedLogsEnabled()) {
                                    this._broker.getLogger().getNCacheLog().Debug("Broker.NewHashmapRecieved", "Not connected to " + (String)ip + " in the pool");
                                }
                                try {
                                    Exception exception = null;
                                    RefObject tempRef_exception2 = new RefObject(exception);
                                    this._broker.TryConnecting(connection, (RefObject<Exception>)tempRef_exception2, 0, true, false);
                                    exception = (Exception)tempRef_exception2.argvalue;
                                }
                                catch (Exception exc) {
                                    if (!this._broker.getLogger().getIsErrorLogsEnabled()) continue;
                                    this._broker.getLogger().getNCacheLog().Error("Broker.NewHashmapRecieved", exc.toString());
                                }
                                continue;
                            }
                            if (!this._broker.getLogger().getIsDetailedLogsEnabled()) continue;
                            this._broker.getLogger().getNCacheLog().Debug("Broker.NewHashmapRecieved", "Already connected to " + (String)ip + " in the pool");
                        }
                        if (this._broker.getImportHashmap()) {
                            ArrayList<Address> invalidIPConnection = new ArrayList<Address>();
                            for (Address ipAddress : this._broker.getPool().getServers()) {
                                if (this._broker._clientConfig.getIPMappingConfigured()) {
                                    if (newHashmap.getMembers().contains(ipAddress.getIpAddress().getHostAddress() + ":" + ipAddress.getPort())) continue;
                                    invalidIPConnection.add(ipAddress);
                                    continue;
                                }
                                if (newHashmap.getMembers().contains(ipAddress.getIpAddress().getHostAddress())) continue;
                                invalidIPConnection.add(ipAddress);
                            }
                            for (Address ip : invalidIPConnection) {
                                this._broker.getPool().getItem(ip).Disconnect();
                                this._broker.getPool().Remove(ip);
                                Connection tempConnection = this._broker.getConnection();
                                if (tempConnection != null && tempConnection.getAddress().equals(ip.getIpAddress())) {
                                    this._broker.setConnection(this._broker.getPool().GetAnyConnection());
                                }
                                if (this._broker.getShutdownServers().containsKey(ip)) {
                                    ShutDownServerInfo ssInfo = this._broker.getShutdownServers().get(ip);
                                    Object object2 = ssInfo.getWaitForBlockedActivity();
                                    synchronized (object2) {
                                        Monitor.pulse((Object)ssInfo.getWaitForBlockedActivity());
                                        this._broker.getShutdownServers().remove(ip);
                                    }
                                }
                                if (!this._broker.getLogger().getIsDetailedLogsEnabled()) continue;
                                this._broker.getLogger().getNCacheLog().Debug("Broker.NewHashmapRecieved", "Disconnected from " + ip + ", and removed from pool");
                            }
                        }
                        ServerInfo srvr = new ServerInfo();
                        String add = null;
                        HashMap map = newHashmap.getMap();
                        for (int key = 0; key < map.size(); ++key) {
                            add = (String)map.get(key);
                            srvr = this._broker._clientConfig.getMappedServer(add, this._broker.getPort());
                            map.put(key, new Address(InetAddress.getByName(srvr.getName()), srvr.getPort()));
                        }
                        this._broker.getPool().SetHashmap(newHashmap);
                        if (this._broker.getLogger().getIsDetailedLogsEnabled()) {
                            this._broker.getLogger().getNCacheLog().Debug("Broker.NewHashmapReceived", "Hashmap applied " + newHashmap.toString() + " Pool " + this._broker.getPool().toString());
                        }
                    }
                    catch (Exception exc) {
                        if (!this._broker.getLogger().getIsErrorLogsEnabled()) break block42;
                        this._broker.getLogger().getNCacheLog().Error("Broker.NewHashmapRecieved", exc.getMessage());
                    }
                }
            }
        }
        finally {
            this._broker.getlock().ReleaseWriterLock();
        }
        this._broker.getHashMapStatus().SetStatusBit((byte)1, (byte)2);
    }
}

