/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import Alachisoft.NCache.Common.Net.Address;
import com.alachisoft.ncache.client.ServerInfo;
import com.alachisoft.ncache.client.internal.command.CommandResponse;
import com.alachisoft.ncache.client.internal.communication.Broker;
import com.alachisoft.ncache.client.internal.communication.Request;
import java.util.HashMap;
import tangible.RefObject;

class StartBalancingClients
implements Runnable {
    private Broker _parent;
    private CommandResponse response;

    StartBalancingClients() {
    }

    @Override
    public void run() {
        this.balancingClients();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void balancingClients() {
        block19: {
            try {
                Address clusterAddress = null;
                Address serverAddress = null;
                ServerInfo newServerJoined = new ServerInfo();
                if (this.response.getServerPort() > 0) {
                    if (this._parent._clientConfig.getIPMappingConfigured()) {
                        ServerInfo rm;
                        this._parent.GetServerMapping(null, false);
                        newServerJoined = rm = this._parent._clientConfig.getMappedServer(this.response.getIp().toString(), this.response.getServerPort());
                    } else {
                        newServerJoined = new ServerInfo(this.response.getIp(), this.response.getServerPort());
                    }
                    this._parent._clientConfig.addServer(newServerJoined);
                }
                clusterAddress = new Address(newServerJoined.getIP(), newServerJoined.getPort());
                serverAddress = new Address(newServerJoined.getIP(), newServerJoined.getPort());
                this._parent.setNodeIP(serverAddress.getIpAddress());
                this._parent.setNewServerPort(serverAddress.getPort());
                this._parent.getCache().getCacheClusterEventsListener().OnMemberJoined(clusterAddress, serverAddress);
                if (this._parent.getLogger().getIsDetailedLogsEnabled()) {
                    this._parent.getLogger().getNCacheLog().Info("Broker.StartBalancingClients", "response.isReconnectClients(): " + this.response.isReconnectClients() + " ;; _parent._clientConfig.getBalanceNodes(): " + this._parent._clientConfig.getBalanceNodes() + " ;; serverAddress.getIpAddress(): " + serverAddress.getIpAddress() + " ;; serverAddress.getPort(): " + serverAddress.getPort());
                }
                if (!this.response.isReconnectClients() || !this._parent._clientConfig.getBalanceNodes()) break block19;
                boolean isReleaseLock = false;
                try {
                    this._parent.getlock().AcquireWriterLock();
                    isReleaseLock = true;
                    this._parent.getConnection().getStatusLatch().SetStatusBit((byte)9, (byte)6);
                    int totalTimeToWait = this._parent.getOperationTimeout();
                    int timeSlice = 2000;
                    RefObject tempRef_totalTimeToWait = new RefObject((Object)totalTimeToWait);
                    int nextInterval = this._parent.NextWaitInterval((RefObject<Integer>)tempRef_totalTimeToWait, timeSlice);
                    totalTimeToWait = (Integer)tempRef_totalTimeToWait.argvalue;
                    do {
                        if (this._parent.getLogger().getIsDetailedLogsEnabled()) {
                            this._parent.getLogger().getNCacheLog().Info("Broker.StartBalancingClients", "total wait time remaining: " + new Integer(totalTimeToWait).toString());
                            this._parent.getLogger().getNCacheLog().Info("Broker.StartBalancingClients", "current wait interval: " + new Integer(nextInterval).toString());
                        }
                        Thread.sleep(nextInterval);
                        HashMap<Long, Request> hashMap = this._parent.getRequestTable();
                        synchronized (hashMap) {
                            if (this._parent.getRequestTable().size() == 0) {
                                break;
                            }
                            if (this._parent.getLogger().getIsDetailedLogsEnabled()) {
                                this._parent.getLogger().getNCacheLog().Info("Broker.StartBalancingClients", "Responses remaining: " + this._parent.getRequestTable().size());
                            }
                        }
                        RefObject tempRef_totalTimeToWait2 = new RefObject((Object)totalTimeToWait);
                        nextInterval = this._parent.NextWaitInterval((RefObject<Integer>)tempRef_totalTimeToWait2, timeSlice);
                        totalTimeToWait = (Integer)tempRef_totalTimeToWait2.argvalue;
                    } while (nextInterval > 0);
                    this._parent.ResetBroker(this._parent.getServerIP());
                    this._parent.getConnection().getStatusLatch().SetStatusBit((byte)1, (byte)8);
                    this._parent.getConnection().Disconnect();
                    Thread.sleep(5000L);
                    Exception exception = null;
                    RefObject tempRef_exception = new RefObject(exception);
                    boolean tempVar = !this._parent.ConnectRemoteServer(this._parent.getConnection(), this._parent.getNodeIP(), this._parent.getNewServerPort(), false, false, true, (RefObject<Exception>)tempRef_exception, true);
                    exception = (Exception)tempRef_exception.argvalue;
                    if (tempVar) {
                        this._parent.getlock().ReleaseWriterLock();
                        isReleaseLock = false;
                        this._parent.TryNextServer();
                    } else {
                        this._parent.getConnection().getStatusLatch().SetStatusBit((byte)2, (byte)1);
                    }
                }
                finally {
                    if (isReleaseLock) {
                        this._parent.getlock().ReleaseWriterLock();
                    }
                }
            }
            catch (Exception e) {
                if (!this._parent.getLogger().getIsErrorLogsEnabled()) break block19;
                this._parent.getLogger().getNCacheLog().Error("Broker.StartBalancingClients", "Error: " + e);
            }
        }
    }

    public void setResponse(CommandResponse response) {
        this.response = response;
    }

    public void setParent(Broker broker) {
        this._parent = broker;
    }
}

