/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import Alachisoft.NCache.Caching.EventId;
import Alachisoft.NCache.Common.DataStructures.SlidingIndex;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

class PersistenceManager {
    private SlidingIndex<EventId> _index = new SlidingIndex(30);
    private boolean isStoreEventsEnabled = false;
    private HashMap _duplicateEventLog;
    private boolean _checkEventDuplication = false;
    private Date _eventDuplicationStartTime = new Date(0L);

    public PersistenceManager(int interval) {
        this._index = new SlidingIndex(interval, true);
    }

    public final void StartEventDuplicationCheck() {
    }

    public final boolean StopEventDuplicationCheck() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean CheckEventDuplication(EventId eventId) {
        PersistenceManager persistenceManager = this;
        synchronized (persistenceManager) {
            if (this._checkEventDuplication && !this.StopEventDuplicationCheck()) {
                if (this._duplicateEventLog.containsKey(eventId)) {
                    return true;
                }
                this._duplicateEventLog.put(eventId, null);
            }
            return false;
        }
    }

    public final boolean PersistEvent(EventId evtId) {
        if (evtId != null) {
            return this._index.AddToIndex((Object)evtId);
        }
        return true;
    }

    public final ArrayList<EventId> GetPersistedEventsList() {
        Iterator en = this._index.GetCurrentData();
        ArrayList<EventId> events = new ArrayList<EventId>();
        while (en.hasNext()) {
            EventId evtId = (EventId)en.next();
            events.add(evtId);
        }
        return events;
    }

    public final void dispose() {
        this._index = null;
    }
}

