/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.DataStructures.NewHashmap;
import Alachisoft.NCache.Common.DataStructures.QueueDictionary;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.Partition;
import Alachisoft.NCache.Common.Net.Address;
import com.alachisoft.ncache.client.internal.communication.Connection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

final class ConnectionPool {
    private ConcurrentHashMap<Address, Connection> _connections;
    private QueueDictionary<Address> loadBalancerQueue;
    private HashMap _hashMap;
    private ArrayList<String> _hashMapMember;
    private ArrayList<Partition> _partitions = new ArrayList();
    private int _bucketSize = 0;
    private long _lastViewId = -1L;

    public ConnectionPool() {
        this._connections = new ConcurrentHashMap();
        this.loadBalancerQueue = new QueueDictionary();
        this._hashMap = new HashMap();
        this._hashMapMember = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getItem(Address ip) {
        ConcurrentHashMap<Address, Connection> concurrentHashMap = this._connections;
        synchronized (concurrentHashMap) {
            return this._connections.get(ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItem(Address ip, Connection value) {
        ConcurrentHashMap<Address, Connection> concurrentHashMap = this._connections;
        synchronized (concurrentHashMap) {
            this._connections.put(ip, value);
            this.loadBalancerQueue.Enqueue((Object)ip);
        }
    }

    public ArrayList<Partition> getPartitins() {
        return this._partitions;
    }

    public int getBucketSize() {
        return this._bucketSize;
    }

    public void setBucketSize(int value) {
        this._bucketSize = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        ConcurrentHashMap<Address, Connection> concurrentHashMap = this._connections;
        synchronized (concurrentHashMap) {
            return this._connections.size();
        }
    }

    public ConcurrentHashMap getConnections() {
        return this._connections;
    }

    public long getLastViewId() {
        return this._lastViewId;
    }

    public void setLastViewId(long value) {
        this._lastViewId = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection GetConnection(String key) {
        Object ip = this.GetIpInternal(key);
        Connection connection = null;
        if (ip != null) {
            ConcurrentHashMap<Address, Connection> concurrentHashMap = this._connections;
            synchronized (concurrentHashMap) {
                connection = this._connections.get(ip);
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Address> getServers() {
        ConcurrentHashMap<Address, Connection> concurrentHashMap = this._connections;
        synchronized (concurrentHashMap) {
            return this._connections.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UpdateBulkThreshold() {
        ConcurrentHashMap<Address, Connection> concurrentHashMap = this._connections;
        synchronized (concurrentHashMap) {
            for (Connection conn : this._connections.values()) {
                conn.UpdateBulkThreshold();
            }
        }
    }

    public Connection GetAnyConnection() {
        Connection connection = null;
        Connection firstConnection = null;
        for (Connection conn : this._connections.values()) {
            if (firstConnection == null) {
                firstConnection = conn;
            }
            if (!conn.getIsConnected()) continue;
            connection = conn;
            break;
        }
        if (connection == null) {
            connection = firstConnection;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object GetIpInternal(String key) {
        if (key == null || key.equals("")) {
            return null;
        }
        if (this._hashMap == null || this._bucketSize == 0) {
            return null;
        }
        int hashCode = AppUtil.hashCode((String)key);
        int index = hashCode / this._bucketSize;
        if (index < 0) {
            index *= -1;
        }
        HashMap hashMap = this._hashMap;
        synchronized (hashMap) {
            return this._hashMap.get(index);
        }
    }

    public Address GetIp(String key) {
        Object tempVar = this.GetIpInternal(key);
        return (Address)(tempVar instanceof Address ? tempVar : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetHashmap(NewHashmap hashMap) {
        this._lastViewId = hashMap.getLastViewId();
        AbstractMap abstractMap = this._hashMap;
        synchronized (abstractMap) {
            this._hashMap = hashMap.getMap();
        }
        abstractMap = this._connections;
        synchronized (abstractMap) {
            this._hashMapMember = hashMap.getMembers();
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            for (String ip : this._hashMapMember) {
                Partition partition = new Partition();
                partition.setAddress(new Address(ip, 9800));
                partitions.add(partition);
            }
            this._partitions = partitions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Add(Address ip, Connection connection) {
        ConcurrentHashMap<Address, Connection> concurrentHashMap = this._connections;
        synchronized (concurrentHashMap) {
            this._connections.put(ip, connection);
            this.loadBalancerQueue.Enqueue((Object)ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Remove(Address ip) {
        ConcurrentHashMap<Address, Connection> concurrentHashMap = this._connections;
        synchronized (concurrentHashMap) {
            this._connections.remove(ip);
            this.loadBalancerQueue.Remove((Object)ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Contains(Address ip) {
        ConcurrentHashMap<Address, Connection> concurrentHashMap = this._connections;
        synchronized (concurrentHashMap) {
            return this._connections.containsKey(ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentHashMap CloneConnectionTable() {
        ConcurrentHashMap<Address, Connection> concurrentHashMap = this._connections;
        synchronized (concurrentHashMap) {
            return new ConcurrentHashMap<Address, Connection>(this._connections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFullyConnnected() {
        ConcurrentHashMap<Address, Connection> concurrentHashMap = this._connections;
        synchronized (concurrentHashMap) {
            if (this._hashMapMember.size() != this._connections.size()) {
                return false;
            }
            for (Connection conn : this._connections.values()) {
                if (conn.getIsConnected()) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFullyDisConnnected() {
        ConcurrentHashMap<Address, Connection> concurrentHashMap = this._connections;
        synchronized (concurrentHashMap) {
            for (Connection conn : this._connections.values()) {
                if (!conn.getIsConnected()) continue;
                return false;
            }
            return true;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ (");
        builder.append(this._lastViewId);
        builder.append(") ");
        builder.append("[");
        for (Address ip : this._connections.keySet()) {
            builder.append(ip.getIpAddress().toString());
            builder.append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("] }");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address GetNextAddress() {
        ConcurrentHashMap<Address, Connection> concurrentHashMap = this._connections;
        synchronized (concurrentHashMap) {
            Connection conn;
            Address node = (Address)this.loadBalancerQueue.Dequeue();
            if (node == null) {
                Connection connection = this.GetAnyConnection();
                if (connection == null || !connection.getIsConnected()) {
                    return null;
                }
                for (Address ad : this._connections.keySet()) {
                    this.loadBalancerQueue.Enqueue((Object)ad);
                }
            }
            if ((conn = this._connections.get(node)) == null || !conn.getIsConnected()) {
                conn = this.GetAnyConnection();
                if (conn == null || !conn.getIsConnected()) {
                    return null;
                }
            } else {
                this.loadBalancerQueue.Enqueue((Object)node);
            }
            return conn.getServerAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MarkConnectionsIdle() {
        ConcurrentHashMap<Address, Connection> concurrentHashMap = this._connections;
        synchronized (concurrentHashMap) {
            for (Connection conn : this._connections.values()) {
                conn.setIsIdle(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Connection> GetIdleConnections() {
        ArrayList<Connection> conList = new ArrayList<Connection>();
        ConcurrentHashMap<Address, Connection> concurrentHashMap = this._connections;
        synchronized (concurrentHashMap) {
            for (Connection conn : this._connections.values()) {
                if (!conn.getIsIdle()) continue;
                conList.add(conn);
            }
        }
        return conList;
    }
}

