/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import Alachisoft.NCache.Common.Communication.Secure.SecureStream;
import Alachisoft.NCache.Common.DataStructures.Queue;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.StopWatch;
import Alachisoft.NCache.Common.Streams.BufferedStream;
import Alachisoft.NCache.Common.Threading.Latch;
import Alachisoft.NCache.Common.Threading.Monitor;
import Alachisoft.NCache.Management.Statistics.StatisticsCounter;
import Util.ResponseHelper;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandResponse;
import com.alachisoft.ncache.client.internal.communication.Broker;
import com.alachisoft.ncache.client.internal.communication.CommandQueue;
import com.alachisoft.ncache.client.internal.communication.ErrorType;
import com.alachisoft.ncache.client.internal.communication.ExType;
import com.alachisoft.ncache.client.internal.communication.Extensions;
import com.alachisoft.ncache.client.internal.communication.NagglingManager;
import com.alachisoft.ncache.client.internal.communication.Request;
import com.alachisoft.ncache.client.internal.communication.RequestInformation;
import com.alachisoft.ncache.client.internal.communication.ResponseIntegrator;
import com.alachisoft.ncache.client.internal.communication.SendError;
import com.alachisoft.ncache.client.internal.communication.ServerLostListener;
import com.alachisoft.ncache.client.internal.communication.WriteResult;
import com.alachisoft.ncache.client.internal.util.Logs;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.exceptions.ConnectionException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;

public final class Connection {
    public static final int CmdSizeHolderBytesCount = 10;
    public static final int ValSizeHolderBytesCount = 10;
    public static final int ValTypeHolderBytesCount = 4;
    public static final int TotSizeHolderBytesCount = 20;
    private static final int MessageHeader = 10;
    private static final int MaxCmdsThreshold = 100;
    public static long s_receiveBufferSize = 2048000L;
    public static boolean WriteRequestIdInResponse = true;
    private static SocketAddress _bindIP;
    private final CommandQueue _queue = new CommandQueue();
    AtomicInteger inWriteQueue = new AtomicInteger(0);
    private ServerLostListener _serverLost = null;
    private boolean _isConnected = true;
    private Socket _primaryClient = null;
    private Socket _secondaryClient = null;
    private InetAddress _address;
    private String _ipAddress = "";
    private String _intendedRecipientIPAddress = "";
    private int _port = 0;
    private Object _connectionMutex = new Object();
    private Latch _connectionStatusLatch = new Latch(4);
    private long _processID = ProcessHandle.current().pid();
    private String _cacheId;
    private Thread _primaryReceiveThread = null;
    private Thread _secondaryReceiveThread = null;
    private boolean _notificationsRegistered = false;
    private boolean _isReconnecting = false;
    private boolean _forcedDisconnect = false;
    private boolean _nagglingEnabled = false;
    private long _nagglingSize = 512000L;
    private NagglingManager _priNagglingMgr;
    private NagglingManager _secNagglingMgr;
    private Queue _msgQueue;
    private boolean _supportDualSocket = false;
    private Object _syncLock = new Object();
    private Logs _logger;
    private ResponseIntegrator _responseIntegrator;
    private Address _serverAddress;
    private Broker _container;
    private StatisticsCounter _perfStatsColl = null;
    private Object _socketSelectionMutex = new Object();
    private boolean _usePrimary = true;
    private boolean _requestLoggingEnabled;
    private boolean _optimized = false;
    private int _hostPort;
    private boolean _isIdle = false;
    private String _targetHost;
    private boolean _provideCert;
    private String[] tlsProtocols = new String[]{"TLSv1", "SSLv3"};
    private SecureStream privatePrimarySecureStream;
    private SecureStream privateSecondarySecureStream;
    private boolean privateIsSecured;
    private BufferedStream _bufferedStream;
    private AtomicInteger activeWriters = new AtomicInteger(0);
    private InetAddress _localEndpoint;
    private RequestInformation _requestInformation;
    private LinkedList<Command> _retrySendQueue = new LinkedList();
    private LinkedList<Command> _outstandingQueue = new LinkedList();

    public Connection(Broker container, Logs logs, StatisticsCounter perfStatsCollector, ResponseIntegrator rspIntegraotr, String bindIP, String cacheName) {
        this._connectionStatusLatch = new Latch(4);
        this.Initialize(container, logs, perfStatsCollector, rspIntegraotr, bindIP, cacheName);
    }

    public Connection(Broker broker) {
        this(broker, broker.getLogger(), broker._perfStatsColl, broker.getResponseIntegrator(), broker.getClientConfig().getBindIP(), broker.getCache().getName());
    }

    private void Initialize(Broker container, Logs logs, StatisticsCounter perfStatsCollector, ResponseIntegrator rspIntegraotr, String bindIP, String cacheName) {
        this._serverLost = container;
        this._isConnected = true;
        this._primaryClient = null;
        this._secondaryClient = null;
        this._ipAddress = "";
        this._intendedRecipientIPAddress = "";
        this._port = 0;
        this._connectionMutex = new Object();
        s_receiveBufferSize = 2048000L;
        this._processID = ProcessHandle.current().pid();
        this._primaryReceiveThread = null;
        this._secondaryReceiveThread = null;
        this._notificationsRegistered = false;
        this._isReconnecting = false;
        this._forcedDisconnect = false;
        this._nagglingEnabled = false;
        this._nagglingSize = 512000L;
        this._supportDualSocket = false;
        this._syncLock = new Object();
        this._perfStatsColl = null;
        this._socketSelectionMutex = new Object();
        this._usePrimary = true;
        this._optimized = false;
        this._isIdle = false;
        this._container = container;
        this._logger = logs;
        this._responseIntegrator = rspIntegraotr;
        this._cacheId = cacheName;
        this._perfStatsColl = perfStatsCollector;
        this._requestInformation = new RequestInformation();
        this.SetBindIP(bindIP);
        if (System.getProperty("EnableNaggling") != null) {
            this._nagglingEnabled = Boolean.parseBoolean(System.getProperty("EnableNaggling"));
        }
        if (System.getProperty("NagglingSize") != null) {
            this._nagglingSize = 1024L * Long.parseLong(System.getProperty("NagglingSize"));
        }
        if (System.getProperty("EnableDualSockets") != null) {
            this._supportDualSocket = Boolean.parseBoolean(System.getProperty("EnableDualSockets"));
        }
    }

    public boolean getIsSecured() {
        return this.privateIsSecured;
    }

    public void setIsSecured(boolean value) {
        this.privateIsSecured = value;
    }

    public SecureStream getPrimarySecureStream() {
        return this.privatePrimarySecureStream;
    }

    public void setPrimarySecureStream(SecureStream value) {
        this.privatePrimarySecureStream = value;
    }

    public SecureStream getSecondarySecureStream() {
        return this.privateSecondarySecureStream;
    }

    public void setSecondarySecureStream(SecureStream value) {
        this.privateSecondarySecureStream = value;
    }

    public void UpdateBulkThreshold() {
        if (this._requestInformation != null) {
            this._requestInformation.UpdateBulkThreshold();
        }
    }

    public AtomicInteger getInWriteQueue() {
        return this.inWriteQueue;
    }

    public int GetBulkThreshold() {
        if (this._requestInformation != null && this._requestInformation.getBulkingEnabled()) {
            return this._requestInformation.getBulkThreshold();
        }
        return 1;
    }

    public String getClientLocalIP() {
        String ip = "";
        if (this.getPrimaryClientSocket() != null && this.getIsConnected()) {
            InetAddress add = this.getPrimaryClientSocket().getInetAddress();
            ip = add.getAddress().toString();
        }
        return ip;
    }

    public boolean HasMinimumCommands() {
        return this._queue.Count() >= this.GetBulkThreshold();
    }

    public boolean getOptimized() {
        return this._optimized;
    }

    public void setOptimized(boolean value) {
        this._optimized = value;
    }

    private boolean getDoNaggling() {
        return this._nagglingEnabled && this._priNagglingMgr != null;
    }

    public boolean getSupportDualSocket() {
        return this._supportDualSocket;
    }

    public Socket getPrimaryClientSocket() {
        return this._primaryClient;
    }

    public Socket getSecondaryClientSocket() {
        return this._secondaryClient;
    }

    public Latch getStatusLatch() {
        return this._connectionStatusLatch;
    }

    public boolean getRequestInquiryEnabled() {
        return this._requestLoggingEnabled;
    }

    public void setRequestInquiryEnabled(boolean value) {
        this._requestLoggingEnabled = value;
    }

    public boolean getIsConnected() {
        return this._connectionStatusLatch.IsAnyBitsSet((byte)2);
    }

    public String getIpAddress() {
        return this._ipAddress;
    }

    public InetAddress getAddress() {
        return this._address;
    }

    public Address getServerAddress() {
        return this._serverAddress;
    }

    public void setServerAddress(Address value) {
        this._serverAddress = value;
    }

    public String getIntendedRecipientIPAddress() {
        return this._intendedRecipientIPAddress;
    }

    public void setIntendedRecipientIPAddress(String value) {
        this._intendedRecipientIPAddress = value;
    }

    public int getPort() {
        return this._port;
    }

    private void setPort(int value) {
        this._port = value;
    }

    public boolean getNotifRegistered() {
        return this._notificationsRegistered;
    }

    public void setNotifRegistered(boolean value) {
        this._notificationsRegistered = value;
    }

    public boolean getIsReconnecting() {
        return this._isReconnecting;
    }

    public void setIsReconnecting(boolean value) {
        this._isReconnecting = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket getCommunicationSocket() {
        Socket selectedSocket = this._primaryClient;
        if (this.getSupportDualSocket()) {
            selectedSocket = this._primaryClient;
            Object object = this._socketSelectionMutex;
            synchronized (object) {
                if (!this._usePrimary) {
                    selectedSocket = this._secondaryClient;
                }
                this._usePrimary = !this._usePrimary;
            }
        }
        return selectedSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsIdle() {
        Object object = this._connectionMutex;
        synchronized (object) {
            return this._isIdle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsIdle(boolean value) {
        Object object = this._connectionMutex;
        synchronized (object) {
            this._isIdle = value;
        }
    }

    public void SetBindIP(String value) {
        if (value != null && !value.equals("")) {
            try {
                _bindIP = new InetSocketAddress(InetAddress.getByName(value.trim()), this._port);
            }
            catch (RuntimeException | UnknownHostException exception) {
                // empty catch block
            }
        }
    }

    public boolean equals(Object obj) {
        Connection connection = (Connection)(obj instanceof Connection ? obj : null);
        return connection != null && this.getIpAddress().equals(connection.getIpAddress());
    }

    public void dispose() {
        if (this._msgQueue != null && !this._msgQueue.getClosed()) {
            this._msgQueue.close(true);
            this._msgQueue = null;
        }
        try {
            if (this._priNagglingMgr != null && this._priNagglingMgr.isAlive()) {
                this._priNagglingMgr.interrupt();
            }
            if (this._secNagglingMgr != null && this._secNagglingMgr.isAlive()) {
                this._secNagglingMgr.interrupt();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(InetAddress ipAddress, int port) {
        this.setOptimized(false);
        this._ipAddress = ipAddress.toString();
        this._address = ipAddress;
        this._port = port;
        this._serverAddress = new Address(ipAddress, port);
        Object object = this._connectionMutex;
        synchronized (object) {
            this._primaryClient = this.PrepareToConnect(this._primaryClient);
            InetSocketAddress endPoint = null;
            endPoint = new InetSocketAddress(ipAddress, port);
            for (int retry = 0; retry < 3; ++retry) {
                try {
                    this._primaryClient.connect(endPoint);
                    this._bufferedStream = new BufferedStream(this._primaryClient, false);
                    InetAddress inetAddress = this._localEndpoint = this._primaryClient.getInetAddress() instanceof InetAddress ? this._primaryClient.getLocalAddress() : null;
                    if (this._logger != null && this._logger.getIsErrorLogsEnabled()) {
                        this._logger.getNCacheLog().CriticalInfo("Connection.Connect", String.format("established TCP connection with %s:%d. Local endpoint: {%s}", this._ipAddress, this._port, this._localEndpoint.getHostAddress()));
                    }
                    return true;
                }
                catch (IOException | RuntimeException e) {
                    if (this._logger != null && this._logger.getIsErrorLogsEnabled()) {
                        this._logger.getNCacheLog().Error("Connection.Connect", " can not connect to " + ipAddress + ":" + port + ". error: " + e.toString());
                    }
                    if (e.getMessage().contains("A connection attempt failed because the connected party did not properly respond after a period of time")) {
                        continue;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public void Init() {
        this.StartThread();
    }

    private Socket PrepareToConnect(Socket client) {
        client = new Socket();
        try {
            client.setTcpNoDelay(false);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (_bindIP != null) {
            try {
                client.bind(_bindIP);
            }
            catch (IOException | RuntimeException e) {
                throw new RuntimeException("Invalid bind-ip-address specified in client configuration");
            }
        }
        this._forcedDisconnect = false;
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Secure(String targetHost, boolean provideCert) {
        Object object = this._connectionMutex;
        synchronized (object) {
            if (!this.getIsSecured()) {
                this.setPrimarySecureStream(new SecureStream(this._primaryClient));
                this._targetHost = targetHost;
                this._provideCert = provideCert;
                this.getPrimarySecureStream().InitializeAsClient(this._targetHost, this._provideCert);
                this.setIsSecured(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ConnectSecondarySocket(InetAddress address, int port) {
        block6: {
            this._secondaryClient = this.PrepareToConnect(this._secondaryClient);
            InetSocketAddress socketAddress = new InetSocketAddress(address, port);
            try {
                this._secondaryClient.connect(socketAddress);
            }
            catch (IOException | RuntimeException e) {
                if (!this._logger.getIsErrorLogsEnabled()) break block6;
                this._logger.getNCacheLog().Error("Connection.Connect", " can not connect to " + address + ":" + port + ". error: " + e.toString());
            }
        }
        Object object = this._connectionMutex;
        synchronized (object) {
            if (this.getIsSecured()) {
                this.setSecondarySecureStream(new SecureStream(this._secondaryClient));
                this.getSecondarySecureStream().InitializeAsClient(this._targetHost, this._provideCert);
            }
        }
    }

    public boolean SwitchTo(Broker container, Logs logs, StatisticsCounter perfStatsCollector, ResponseIntegrator rspIntegraotr, String bindIP, String cacheName, InetAddress ipAddress, int cachePort) {
        int oldPort = this.getPort();
        this.Initialize(container, logs, perfStatsCollector, rspIntegraotr, bindIP, cacheName);
        if (this.connect(this.getAddress(), cachePort)) {
            this._hostPort = cachePort;
            this.setPort(oldPort);
            this._serverAddress = new Address(ipAddress, oldPort);
            return true;
        }
        this.setPort(oldPort);
        this._serverAddress = new Address(ipAddress, oldPort);
        return false;
    }

    public void Disconnect() {
        this.Disconnect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Disconnect(boolean changeStatus) {
        this._forcedDisconnect = true;
        if (changeStatus) {
            this._connectionStatusLatch.SetStatusBit((byte)4, (byte)2);
        }
        if (this._primaryReceiveThread != null && this._primaryReceiveThread.getState() != Thread.State.TERMINATED) {
            this._primaryReceiveThread.interrupt();
            this._primaryReceiveThread = null;
        }
        if (this._primaryClient != null && this._primaryClient.isConnected()) {
            try {
                this._primaryClient.shutdownInput();
                this._primaryClient.shutdownOutput();
            }
            catch (SocketException socketException) {
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this._primaryClient.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this._secondaryReceiveThread != null && this._secondaryReceiveThread.getState() != Thread.State.TERMINATED) {
            this._secondaryReceiveThread.interrupt();
            this._secondaryReceiveThread = null;
        }
        if (this._secondaryClient != null && this._secondaryClient.isConnected()) {
            try {
                this._secondaryClient.shutdownInput();
                this._secondaryClient.shutdownOutput();
            }
            catch (SocketException socketException) {
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this._secondaryClient.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.setIsSecured(false);
        this.setSecondarySecureStream(null);
        this.setPrimarySecureStream(null);
    }

    public CommandResponse RecieveCommandResponse(boolean _usingSecondary) throws ConnectionException {
        if (this.getIsSecured()) {
            if (_usingSecondary) {
                return this.SecureRecieveCommandResponse(this.getSecondarySecureStream());
            }
            return this.SecureRecieveCommandResponse(this.getPrimarySecureStream());
        }
        if (_usingSecondary) {
            return this.RecieveCommandResponse(this._secondaryClient);
        }
        return this.RecieveCommandResponse(this._primaryClient);
    }

    private CommandResponse RecieveCommandResponse(Socket client) throws ConnectionException {
        CommandResponse cmdRespose = null;
        try {
            byte[] value = this.AssureRecieve(client, this.getOptimized());
            ResponseProtocol.Response response = ResponseProtocol.Response.parseFrom((byte[])value);
            if (response != null && response.getResponseType() == ResponseProtocol.Response.Type.RESPONSE_FRAGMENT) {
                response = this._responseIntegrator.AddResponseFragment(this._serverAddress, response.getGetResponseFragment());
            }
            if (response != null) {
                cmdRespose = new CommandResponse(false, new Address());
                cmdRespose.setCacheId(this._cacheId);
                cmdRespose.setResult(response);
            }
        }
        catch (CacheException | IOException e) {
            throw new ConnectionException(e.getMessage(), this._serverAddress.getIpAddress(), this._serverAddress.getPort());
        }
        return cmdRespose;
    }

    private CommandResponse SecureRecieveCommandResponse(SecureStream client) throws ConnectionException {
        byte[] value = null;
        CommandResponse cmdRespose = null;
        try {
            value = this.AssureSecureRecieve(client, this.getOptimized());
            ResponseProtocol.Response response = ResponseProtocol.Response.parseFrom((byte[])value);
            if (response != null && response.getResponseType() == ResponseProtocol.Response.Type.RESPONSE_FRAGMENT) {
                response = this._responseIntegrator.AddResponseFragment(this._serverAddress, response.getGetResponseFragment());
            }
            if (response != null) {
                cmdRespose = new CommandResponse(false, new Address());
                cmdRespose.setCacheId(this._cacheId);
                cmdRespose.setResult(response);
            }
        }
        catch (CacheException | IOException e) {
            throw new ConnectionException(e.getMessage(), this._serverAddress.getIpAddress(), this._serverAddress.getPort());
        }
        return cmdRespose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void AssureSendDirect(byte[] buffer, Socket client, boolean checkConnected) throws IOException, ConnectionException {
        boolean dataSent = false;
        int dataLeft = buffer.length;
        Object object = this._connectionMutex;
        synchronized (object) {
            if (checkConnected && this._connectionStatusLatch.IsAnyBitsSet((byte)5)) {
                throw new ConnectionException(this._serverAddress.getIpAddress(), this._serverAddress.getPort());
            }
            OutputStream outputStream = client.getOutputStream();
            synchronized (outputStream) {
                try {
                    client.getOutputStream().write(buffer);
                    client.getOutputStream().flush();
                }
                catch (IOException se) {
                    if (this._logger.getIsErrorLogsEnabled()) {
                        this._logger.getNCacheLog().Error("Connection.AssureSendDirect() ", se.toString());
                    }
                    this._connectionStatusLatch.SetStatusBit((byte)4, (byte)2);
                    throw new ConnectionException(this._serverAddress.getIpAddress(), this._serverAddress.getPort());
                }
            }
        }
    }

    public void AssureSendToBufferedStream(byte[] buffer, Socket client, boolean checkConnected) throws ConnectionException {
        int dataSent = 0;
        int dataLeft = buffer.length;
        if (checkConnected && this._connectionStatusLatch.IsAnyBitsSet((byte)5)) {
            throw new ConnectionException(this._serverAddress.getIpAddress(), this._serverAddress.getPort());
        }
        try {
            this._bufferedStream.write(buffer, dataSent, dataLeft);
            this.setIsIdle(false);
        }
        catch (IOException se) {
            if (this._logger.getIsErrorLogsEnabled()) {
                this._logger.getNCacheLog().Error("Connection.AssureSend() ", se.toString());
            }
            this._connectionStatusLatch.SetStatusBit((byte)4, (byte)2);
            throw new ConnectionException(this._serverAddress.getIpAddress(), this._serverAddress.getPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void AssureSendNaggledData(Socket client, byte[] buffer, int bytesToSent, boolean checkConnected) throws ConnectionException {
        int dataSent = 0;
        int dataLeft = bytesToSent;
        Object object = this._connectionMutex;
        synchronized (object) {
            if (checkConnected && this._connectionStatusLatch.IsAnyBitsSet((byte)5)) {
                throw new ConnectionException(this._serverAddress.getIpAddress(), this._serverAddress.getPort());
            }
            while (dataSent < bytesToSent) {
                try {
                    dataLeft = bytesToSent - dataSent;
                    client.getOutputStream().write(buffer, dataSent, dataLeft);
                }
                catch (IOException se) {
                    if (this._logger.getIsErrorLogsEnabled()) {
                        this._logger.getNCacheLog().Error("Connection.AssureSendDirect() ", se.toString());
                    }
                    this._connectionStatusLatch.SetStatusBit((byte)4, (byte)2);
                    throw new ConnectionException(this._serverAddress.getIpAddress(), this._serverAddress.getPort());
                }
            }
            this.setIsIdle(false);
        }
    }

    private byte[] AssureRecieve(Socket client, boolean optimized) throws IOException, ConnectionException {
        byte[] buffer = new byte[10 + (optimized ? 10 : 0)];
        this.AssureRecieve(buffer, client);
        String s = new String(buffer, 0 + (optimized ? 10 : 0), 10);
        int commandSize = 0;
        try {
            commandSize = Integer.parseInt(s.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (commandSize == 0) {
            return new byte[0];
        }
        buffer = new byte[commandSize];
        this.AssureRecieve(buffer, client);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void AssureRecieve(byte[] buffer, Socket client) throws ConnectionException {
        int bytesRecieved = 0;
        try {
            InputStream inputStream = client.getInputStream();
            synchronized (inputStream) {
                while ((bytesRecieved += client.getInputStream().read(buffer, bytesRecieved, buffer.length - bytesRecieved)) != -1 && bytesRecieved < buffer.length) {
                }
            }
        }
        catch (Exception e) {
            this._connectionStatusLatch.SetStatusBit((byte)4, (byte)2);
            throw new ConnectionException("Disconnected: can not receive." + e.toString());
        }
        this.setIsIdle(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void AssureSendSecure(byte[] buffer, SecureStream stream, boolean checkConnected) throws ConnectionException {
        Object object = this._connectionMutex;
        synchronized (object) {
            if (checkConnected && this._connectionStatusLatch.IsAnyBitsSet((byte)5)) {
                throw new ConnectionException(this._serverAddress.getIpAddress(), this._serverAddress.getPort());
            }
            try {
                stream.write(buffer);
            }
            catch (IOException se) {
                if (this._logger.getIsErrorLogsEnabled()) {
                    this._logger.getNCacheLog().Error("Connection.AssureSendSecure() ", se.toString());
                }
                this._connectionStatusLatch.SetStatusBit((byte)4, (byte)2);
                throw new ConnectionException(this._serverAddress.getIpAddress(), this._serverAddress.getPort());
            }
            this.setIsIdle(false);
        }
    }

    private byte[] AssureSecureRecieve(SecureStream client, boolean optimized) throws IOException, ConnectionException {
        byte[] buffer = new byte[10 + (optimized ? 10 : 0)];
        this.AssureSecureRecieve(buffer, client);
        String s = new String(buffer, 0 + (optimized ? 10 : 0), 10);
        int commandSize = 0;
        try {
            commandSize = Integer.parseInt(s.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (commandSize == 0) {
            return new byte[0];
        }
        buffer = new byte[commandSize];
        this.AssureSecureRecieve(buffer, client);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void AssureSecureRecieve(byte[] buffer, SecureStream client) throws IOException, ConnectionException {
        int bytesRecieved = 0;
        try {
            InputStream inputStream = client.getInputStream();
            synchronized (inputStream) {
                while ((bytesRecieved += client.getInputStream().read(buffer, bytesRecieved, buffer.length - bytesRecieved)) != -1 && bytesRecieved < buffer.length) {
                }
            }
        }
        catch (Exception e) {
            this._connectionStatusLatch.SetStatusBit((byte)4, (byte)2);
            throw new ConnectionException("Disconnected: can not receive." + e.toString());
        }
        this.setIsIdle(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SendCommand(byte[] commandBytes, boolean checkConnected) throws ConnectionException {
        if (this._perfStatsColl.getIsEnabled()) {
            this._perfStatsColl.IncrementClientRequestsPerSecStats(1L);
        }
        byte[] dataWithSize = new byte[commandBytes.length + 10];
        byte[] lengthBytes = HelperFxn.toBytes((int)commandBytes.length);
        System.arraycopy(lengthBytes, 0, dataWithSize, 0, lengthBytes.length);
        System.arraycopy(commandBytes, 0, dataWithSize, 10, commandBytes.length);
        if (this.getDoNaggling()) {
            this._msgQueue.add((Object)commandBytes);
        } else if (this.getIsSecured()) {
            if (this.getSupportDualSocket()) {
                SecureStream selectedStream = this.getPrimarySecureStream();
                Object object = this._socketSelectionMutex;
                synchronized (object) {
                    if (!this._usePrimary) {
                        selectedStream = this.getSecondarySecureStream();
                    }
                    this._usePrimary = !this._usePrimary;
                }
                this.AssureSendSecure(dataWithSize, selectedStream, checkConnected);
            } else {
                this.AssureSendSecure(dataWithSize, this.getPrimarySecureStream(), checkConnected);
            }
        } else if (this.getSupportDualSocket()) {
            Socket selectedSocket = this._primaryClient;
            Object object = this._socketSelectionMutex;
            synchronized (object) {
                if (!this._usePrimary) {
                    selectedSocket = this._secondaryClient;
                }
                this._usePrimary = !this._usePrimary;
            }
            this.AssureSendToBufferedStream(dataWithSize, selectedSocket, checkConnected);
        } else {
            this.AssureSendToBufferedStream(dataWithSize, this._primaryClient, checkConnected);
        }
    }

    public void StartThread() {
        this._primaryReceiveThread = new Thread(() -> {
            Object client = this.getIsSecured() ? this.getPrimarySecureStream() : this._primaryClient;
            this.RecieveThread((Socket)client);
        });
        this._primaryReceiveThread.setPriority(5);
        this._primaryReceiveThread.setDaemon(true);
        this._primaryReceiveThread.start();
        if (this.getSupportDualSocket()) {
            this._secondaryReceiveThread = new Thread(() -> {
                Object client = this.getIsSecured() ? this.getSecondarySecureStream() : this._secondaryClient;
                this.RecieveThread((Socket)client);
            });
            this._secondaryReceiveThread.setPriority(5);
            this._secondaryReceiveThread.setDaemon(true);
            this._secondaryReceiveThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void RecieveThread(Socket client) {
        Socket clientSocket = client instanceof Socket ? client : null;
        SecureStream stream = (SecureStream)(client instanceof SecureStream ? client : null);
        try {
            block8: while (true) {
                int count = 0;
                byte[] cmdBytes = clientSocket != null ? this.AssureRecieve(clientSocket, false) : this.AssureSecureRecieve(stream, false);
                ByteArrayInputStream targetStream = new ByteArrayInputStream(cmdBytes);
                try {
                    while (true) {
                        if (((InputStream)targetStream).available() <= 0) continue block8;
                        this.ProcessResponse(targetStream);
                        ++count;
                    }
                }
                finally {
                    ((InputStream)targetStream).close();
                    continue;
                }
                break;
            }
        }
        catch (SocketException se) {
            this.OnConnectionBroken(se, ExType.Socket);
        }
        catch (IOException ie) {
            this.OnConnectionBroken(ie, ExType.Socket);
        }
        catch (ConnectionException ce) {
            this.OnConnectionBroken((Exception)((Object)ce), ExType.Connection);
        }
        catch (Exception e) {
            this.OnConnectionBroken(e, ExType.General);
        }
    }

    private void OnConnectionBroken(Exception e, ExType exType) {
        if (this._logger != null) {
            switch (exType) {
                case Socket: 
                case Connection: {
                    if (this._forcedDisconnect) {
                        if (this._logger.getIsErrorLogsEnabled()) {
                            this._logger.getNCacheLog().Error("Connection.ReceivedThread", "Connection with server lost gracefully");
                        }
                    } else if (this._logger.getIsErrorLogsEnabled()) {
                        this._logger.getNCacheLog().Error("Connection.ReceivedThread", "An established connection with the server " + this._serverAddress + " is lost. Error:" + e.toString());
                    }
                    if (!this._forcedDisconnect) {
                        this._connectionStatusLatch.SetStatusBit((byte)4, (byte)2);
                    }
                    this._primaryReceiveThread = null;
                    this._serverLost.OnServerLost(this._serverAddress, this._forcedDisconnect);
                    break;
                }
                case Interrupt: 
                case Abort: {
                    if (this._forcedDisconnect && this._logger.getIsErrorLogsEnabled()) {
                        this._logger.getNCacheLog().Error("Connection.ReceivedThread", "Connection with server lost gracefully");
                        this._logger.getNCacheLog().Flush();
                    }
                    if (!this._forcedDisconnect) {
                        this._connectionStatusLatch.SetStatusBit((byte)4, (byte)2);
                    }
                    this._serverLost.OnServerLost(this._serverAddress, this._forcedDisconnect);
                    break;
                }
                case General: {
                    if (this._logger.getIsErrorLogsEnabled()) {
                        this._logger.getNCacheLog().Error("Connection.ReceivedThread", e.toString());
                        this._logger.getNCacheLog().Flush();
                    }
                    if (!this._forcedDisconnect) {
                        this._connectionStatusLatch.SetStatusBit((byte)4, (byte)2);
                    }
                    this._serverLost.OnServerLost(this._serverAddress, this._forcedDisconnect);
                }
            }
        }
        this.setIsSecured(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ProcessResponse(InputStream stream) throws IOException, OperationFailedException {
        long requestId = 0L;
        if (WriteRequestIdInResponse) {
            byte[] requestIdBytes = new byte[10];
            stream.read(requestIdBytes, 0, requestIdBytes.length);
            String s = new String(requestIdBytes, 0, requestIdBytes.length);
            requestId = Long.parseLong(s.trim());
        }
        byte[] responseTypeBytes = new byte[4];
        stream.read(responseTypeBytes, 0, responseTypeBytes.length);
        String responseTypeString = new String(responseTypeBytes, 0, responseTypeBytes.length);
        int requestType = Integer.parseInt(responseTypeString.trim());
        ResponseProtocol.Response.Type responseType = ResponseProtocol.Response.Type.values()[requestType];
        byte[] cmdSzBytes = new byte[10];
        stream.read(cmdSzBytes, 0, 10);
        String s = new String(cmdSzBytes, 0, cmdSzBytes.length);
        int commandSize = Integer.parseInt(s.trim());
        byte[] cmdBytes = new byte[commandSize];
        stream.read(cmdBytes, 0, commandSize);
        CommandResponse cmdRespose = new CommandResponse(false, new Address());
        cmdRespose.setCacheId(this._cacheId);
        cmdRespose.setSourceAddress(this.getServerAddress());
        if (WriteRequestIdInResponse) {
            cmdRespose.setNeedsDeserialization(true);
            cmdRespose.setRequestId(requestId);
            cmdRespose.setRawResult(cmdBytes);
            cmdRespose.setType(responseType);
        } else {
            ResponseProtocol.Response response;
            try (ByteArrayInputStream targetStream = new ByteArrayInputStream(cmdBytes);){
                response = ResponseHelper.deserializeResponse((ResponseProtocol.Response.Type)responseType, (InputStream)targetStream);
            }
            cmdRespose.setNeedsDeserialization(false);
            if (response != null) {
                cmdRespose.setResult(response);
            }
        }
        if (this._perfStatsColl.getIsEnabled()) {
            this._perfStatsColl.incrementClientResponsesPerSecStats(1L);
        }
        if (cmdRespose != null) {
            this._container.ProcessResponse(cmdRespose, this._serverAddress);
        }
    }

    public boolean TryEnqueue(Command command, boolean checkConnected) {
        boolean reqWrite;
        if (this._requestInformation != null) {
            this._requestInformation.AddRequest();
        }
        if (reqWrite = this._queue.Push(command)) {
            this._container.getSocketManagerHandler().RequestWrite(this, false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteResult WriteQueue(int maxWork) {
        SendError sendError;
        boolean weAreWriter = false;
        try {
            boolean bl = weAreWriter = this.activeWriters.compareAndExchange(0, 1) == 0;
            if (!weAreWriter) {
                WriteResult writeResult = WriteResult.CompetingWriter;
                return writeResult;
            }
            if (this._bufferedStream == null) {
                WriteResult writeResult = WriteResult.NoConnection;
                return writeResult;
            }
            int count = 0;
            do {
                Command command;
                if ((command = this._queue.Dequeue()) == null) {
                    if (count == 0) {
                        this.Flush();
                        WriteResult writeResult = WriteResult.NothingToDo;
                        return writeResult;
                    }
                    WriteResult writeResult = WriteResult.QueueEmptyAfterWrite;
                    return writeResult;
                }
                command.setFinalDestinationAddress(this._serverAddress);
                if (command.getPulseOnSend()) {
                    this._retrySendQueue.offer(command);
                } else {
                    this._outstandingQueue.offer(command);
                }
                long prevWriteCount = this._bufferedStream.getWriteCount();
                if (!this.WriteMessageDirect(command)) {
                    WriteResult writeResult = WriteResult.NoConnection;
                    return writeResult;
                }
                long currentWriteCount = this._bufferedStream.getWriteCount();
                if (currentWriteCount <= prevWriteCount) continue;
                this.OnWriteSuccess();
            } while (maxWork <= 0 || ++count < maxWork);
            this.Flush();
        }
        catch (IOException ce) {
            if (this._logger.getIsErrorLogsEnabled()) {
                this._logger.getNCacheLog().Error("Connection.AssureSend().IOException ", ce.toString());
            }
            this._connectionStatusLatch.SetStatusBit((byte)4, (byte)2);
            sendError = new SendError(ErrorType.ConnectionException, (Exception)((Object)new ConnectionException(this._serverAddress.getIpAddress(), this._serverAddress.getPort())));
            this.OnWriteFailure(sendError);
        }
        catch (ConnectionException exs) {
            sendError = new SendError(ErrorType.ConnectionException, (Exception)((Object)exs));
            this.OnWriteFailure(sendError);
        }
        catch (Exception ex) {
            sendError = new SendError(ErrorType.Exception, ex);
            this.OnWriteFailure(sendError);
        }
        finally {
            if (weAreWriter) {
                this.activeWriters.set(0);
            }
        }
        return this._queue.Any() ? WriteResult.MoreWork : WriteResult.QueueEmptyAfterWrite;
    }

    private void OnWriteSuccess() {
        this.PulseRetrySendCommands(null);
        this._outstandingQueue.clear();
    }

    private void OnWriteFailure(SendError sendError) {
        this.PulseRetrySendCommands(sendError);
        this.SendFailureResponse(sendError);
    }

    public void Flush() throws IOException {
        this._bufferedStream.flush();
        this.OnWriteSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void PulseRetrySendCommands(SendError sendError) {
        while (this._retrySendQueue.size() != 0) {
            Command command;
            Command command2 = command = this._retrySendQueue.poll();
            synchronized (command2) {
                command.setSendError(sendError);
                command.setSentOverWire(true);
                Monitor.pulse((Object)command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SendFailureResponse(SendError sendError) {
        while (this._outstandingQueue.size() != 0) {
            Command command = this._outstandingQueue.poll();
            command.setSendError(sendError);
            Request request = this._container.GetRequest(command.getRequestId());
            if (request == null) continue;
            Request request2 = request;
            synchronized (request2) {
                request.InitializeFailedSendResponse(this._serverAddress, command);
                Monitor.pulse((Object)request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ConfirmRemoveFromWriteQueue() {
        Object object = this._queue.getSyncLock();
        synchronized (object) {
            if (this._queue.Count() == 0) {
                this.inWriteQueue.set(0);
                return true;
            }
        }
        return false;
    }

    private boolean WriteMessageDirect(Command command) throws CommandException, ConnectionException, IOException {
        this.SendCommand(command.toByte(command.getAcknowledgmentId(), this.getRequestInquiryEnabled()), true);
        return true;
    }

    public void WaitUntillPipelineFilled() {
        int iterations = 10;
        long elapsedTime = 0L;
        int spinWaitCount = 0;
        int timeout = Extensions.getTimeout();
        StopWatch watch = new StopWatch();
        watch.start();
        while ((long)timeout > elapsedTime && !this.HasMinimumCommands()) {
            while (spinWaitCount++ < iterations) {
                Thread.yield();
            }
            elapsedTime = watch.getElapsedTime();
            spinWaitCount = 0;
            if (elapsedTime >= 10L) continue;
            iterations *= 2;
        }
    }
}

