/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.DataTypes.Queue.QueueEnqueueOperation;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.QueueCommandBase;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CollectionItemProtocol;
import com.alachisoft.ncache.common.protobuf.QueueCommandProtocol;
import com.alachisoft.ncache.common.protobuf.QueueEnqueueProtocol;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class QueueEnqueueCommand
extends QueueCommandBase {
    private QueueEnqueueOperation.OpType _operationType;
    private List<ExtendedJsonValueBase> _collection;
    private QueueEnqueueProtocol.QueueEnqueue.Builder _queueEnqueue;

    public QueueEnqueueCommand(QueueEnqueueOperation operation) {
        this.name = "QueueEnqueue";
        this.key = operation.getName();
        this._writeThruOption = operation.getWriteThruOptions();
        this._lockId = (String)operation.getLockId();
        this._lockTimeout = operation.getLockTimeout();
        this._operationType = operation.getOperationType();
        this._collection = operation.getCollection();
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicWrite;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.DATA_TYPE;
    }

    @Override
    protected void createCommand() {
        this._queueEnqueue = QueueEnqueueProtocol.QueueEnqueue.newBuilder();
        if (this._collection != null) {
            UserBinaryObject valueObject = UserBinaryObject.createUserBinaryObject((byte[])this._collection.get(0).toJson().getBytes(StandardCharsets.UTF_8));
            CollectionItemProtocol.CollectionItem.Builder valueItem = CollectionItemProtocol.CollectionItem.newBuilder();
            for (byte[] bytes : valueObject.getDataList()) {
                valueItem.addData(ByteString.copyFrom((byte[])bytes));
            }
            this._queueEnqueue.setItem(valueItem);
        }
        switch (this._operationType) {
            case Enqueue: {
                this._queueEnqueue.setOperationType(QueueEnqueueProtocol.QueueEnqueue.OperationType.Enqueue);
                break;
            }
            case TryEnqueueMilliSeconds: {
                this._queueEnqueue.setOperationType(QueueEnqueueProtocol.QueueEnqueue.OperationType.TryEnqueueMilliSeconds);
                break;
            }
            case TryEnqueueTimespan: {
                this._queueEnqueue.setOperationType(QueueEnqueueProtocol.QueueEnqueue.OperationType.TryEnqueueTimespan);
            }
        }
        super.createCommand();
        this._queueCommandBuilder.setType(QueueCommandProtocol.QueueCommand.Type.QUEUE_ENQUEUE);
        this._queueCommandBuilder.setQueueEnqueue(this._queueEnqueue);
    }
}

