/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.DataTypes.Queue.QueueDequeueOperation;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.QueueCommandBase;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CollectionItemProtocol;
import com.alachisoft.ncache.common.protobuf.QueueCommandProtocol;
import com.alachisoft.ncache.common.protobuf.QueueDequeueProtocol;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;

public class QueueDequeueCommand
extends QueueCommandBase {
    private QueueDequeueOperation.OpType _operationType;
    private ExtendedJsonValueBase _value;
    private QueueDequeueProtocol.QueueDequeue.Builder _queueDequeue;

    public QueueDequeueCommand(QueueDequeueOperation operation) {
        this.name = "QueueDequeue";
        this.key = operation.getName();
        this._writeThruOption = operation.getWriteThruOptions();
        this._lockId = (String)operation.getLockId();
        this._lockTimeout = operation.getLockTimeout();
        this._operationType = operation.getOperationType();
        this._value = operation.getItem();
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicWrite;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.DATA_TYPE;
    }

    @Override
    protected void createCommand() {
        this._queueDequeue = QueueDequeueProtocol.QueueDequeue.newBuilder();
        if (this._value != null) {
            UserBinaryObject valueObject = UserBinaryObject.createUserBinaryObject((byte[])this._value.toJson().getBytes(StandardCharsets.UTF_8));
            CollectionItemProtocol.CollectionItem.Builder valueItem = CollectionItemProtocol.CollectionItem.newBuilder();
            for (byte[] bytes : valueObject.getDataList()) {
                valueItem.addData(ByteString.copyFrom((byte[])bytes));
            }
            this._queueDequeue.setItem(valueItem);
        }
        switch (this._operationType) {
            case Dequeue: {
                this._queueDequeue.setOperationType(QueueDequeueProtocol.QueueDequeue.OperationType.Dequeue);
                break;
            }
            case TryDequeueMilliSeconds: {
                this._queueDequeue.setOperationType(QueueDequeueProtocol.QueueDequeue.OperationType.TryDequeueMilliSeconds);
                break;
            }
            case TryDequeueTimespan: {
                this._queueDequeue.setOperationType(QueueDequeueProtocol.QueueDequeue.OperationType.TryDequeueTimespan);
            }
        }
        super.createCommand();
        this._queueCommandBuilder.setType(QueueCommandProtocol.QueueCommand.Type.QUEUE_DEQUEUE);
        this._queueCommandBuilder.setQueueDequeue(this._queueDequeue);
    }
}

