/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.Util.DependencyHelper;
import com.alachisoft.ncache.client.StreamMode;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.OpenStreamCommandProtocol;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.caching.expiration.ExpirationConstants;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public final class OpenStreamCommand
extends Command {
    private OpenStreamCommandProtocol.OpenStreamCommand.Builder openStreamCommand;
    private String _key;
    private StreamMode _mode;
    private String _group;
    private Date _absExpiration;
    private TimeSpan _slidingExpiration;
    private CacheDependency _dependency;
    private CacheItemPriority _priority;
    private int _methodOverload;
    protected OpenStreamCommandProtocol.OpenStreamCommand _commandInstance;

    public OpenStreamCommand(String key, StreamMode mode, String group, Date absoluteExpiration, TimeSpan slidingExpiration, CacheDependency dependency, CacheItemPriority priority, int methodOverload) {
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (key.equals("")) {
            throw new IllegalArgumentException("Value cannot be empty.\nParameter name: key");
        }
        if (slidingExpiration._ticks != 0L && absoluteExpiration != ExpirationConstants.AbsoluteNoneExpiration) {
            throw new IllegalArgumentException("You cannot set both sliding and absolute expirations on the same cached item");
        }
        this._key = key;
        this._mode = mode;
        this._group = group;
        this._absExpiration = absoluteExpiration;
        this._slidingExpiration = slidingExpiration;
        this._dependency = dependency;
        this._priority = priority;
        this._methodOverload = methodOverload;
        this.openStreamCommand = OpenStreamCommandProtocol.OpenStreamCommand.newBuilder();
    }

    @Override
    public void createCommand() throws CommandException {
        this.openStreamCommand.setKey(this._key);
        if (this._group != null) {
            this.openStreamCommand.setGroup(this._group);
        }
        this.openStreamCommand.setStreamMode(this._mode.ordinal());
        long sldExp = 0L;
        long absExp = 0L;
        absExp = this._absExpiration != CacheImpl.NoAbsoluteExpiration ? HelperFxn.getUTCTicks((Date)this._absExpiration) : 0L;
        sldExp = this._slidingExpiration != CacheImpl.NoSlidingExpiration ? this._slidingExpiration.getTotalTicks() : 0L;
        this.openStreamCommand.setAbsoluteExpiration(absExp);
        this.openStreamCommand.setSlidingExpiration(sldExp);
        this.openStreamCommand.setPriority(this._priority.value());
        if (this._dependency != null) {
            try {
                this.openStreamCommand = this.openStreamCommand.setDependency(DependencyHelper.getDependencyProtocol((CacheDependency)this._dependency));
            }
            catch (Exception ex) {
                throw new CommandException(ex.getMessage());
            }
        }
        this._commandInstance = this.openStreamCommand.setRequestId(this.getRequestId()).setMethodOverload(this._methodOverload).build();
    }

    public boolean parseCommand() {
        return true;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.OPEN_STREAM;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicWrite;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.OPEN_STREAM.getNumber();
    }
}

