/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Caching.Messaging.Message;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.MessagePublishBulkCommandProtocol;
import com.alachisoft.ncache.common.protobuf.MessagePublishCommandProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MessagePublishBulkCommand
extends Command {
    public MessagePublishBulkCommandProtocol.MessagePublishBulkCommand _commandInstance;
    MessagePublishBulkCommandProtocol.MessagePublishBulkCommand.Builder messageBulkCommand = MessagePublishBulkCommandProtocol.MessagePublishBulkCommand.newBuilder();

    public MessagePublishBulkCommand(String topicName, Collection<Message> serverMessages, boolean notifyDeliveryFailure) {
        this.name = "PublishMessageBulkCommand";
        this.messageBulkCommand.setTopicName(topicName);
        this.messageBulkCommand.setNotifyDeliveryFailure(notifyDeliveryFailure);
        for (Message message : serverMessages) {
            UserBinaryObject ubObject = UserBinaryObject.createUserBinaryObject((byte[])((byte[])message.getPayLoad()));
            List dataList = ubObject.getDataList();
            int noOfChunks = dataList.size();
            ArrayList<ByteString> dataChunks = new ArrayList<ByteString>();
            for (int i = 0; i < noOfChunks; ++i) {
                dataChunks.add(ByteString.copyFrom((byte[])((byte[])dataList.get(i))));
            }
            MessagePublishCommandProtocol.MessagePublishCommand.Builder messageCommand = MessagePublishCommandProtocol.MessagePublishCommand.newBuilder();
            messageCommand.setMessageId(message.getMessageId()).addAllData(dataChunks).setFlag((int)message.getFlagMap().getData()).setExpiration(message.getMessageMetaData().getExpirationTime()).setCreationTime(message.getCreationTime().getTime()).setDeliveryOption(message.getMessageMetaData().getDeliveryOption().getValue());
            this.messageBulkCommand.addMessagePublishCommand(messageCommand);
        }
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.PUBLISHMESSAGEBULK;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicWrite;
    }

    @Override
    public boolean getIsSafe() {
        return false;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.MESSAGE_PUBLISH_BULK.getNumber();
    }

    @Override
    protected void createCommand() throws CommandException {
        if (this.getIntendedRecipient() != null) {
            this.messageBulkCommand.setIntendedRecipient(this.getIntendedRecipient());
        }
        this.messageBulkCommand.setClientLastViewId(this.getClientLastViewId()).setVersion(VERSION).setCommandVersion(1).setRequestId(this.getRequestId());
        this._commandInstance = this.messageBulkCommand.build();
    }
}

