/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.BitSetConstants;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Util.DependencyHelper;
import com.alachisoft.ncache.client.CacheSyncDependency;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.InsertCommandProtocol;
import com.alachisoft.ncache.common.protobuf.ObjectQueryInfoProtocol;
import com.alachisoft.ncache.common.protobuf.SyncDependencyProtocol;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.events.ListenerType;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.security.encryption.EncryptionMgr;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public final class InsertCommand
extends Command {
    private int _methodOverload = 0;
    private final ListenerType _listenerType;
    private String group;
    private String subGroup;
    private Date absoluteExpiration;
    private TimeSpan slidingExpiration;
    private boolean isResyncExpiredItems;
    private CacheItemPriority priority;
    private int remCallbackID;
    private int upCallbackID;
    private int dsItemUpdateCallbackID;
    private CacheSyncDependency syncDependency;
    private CacheDependency dependency;
    private HashMap queryInfo;
    private int flagMap;
    private String _lockId;
    private LockAccessType _accessType;
    private long _version;
    private String providerName;
    private String resyncProviderName;
    private boolean encryption;
    private String cacheId;
    private int updateCallbackFilter;
    private int removeCallbackFilter;
    private final String groupType;
    private String _clientId;
    protected InsertCommandProtocol.InsertCommand _commandInstance;

    public InsertCommand(String key, byte[] value, CacheDependency dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, short removeCallback, short updateCallback, short dsItemsUpdateCallbackId, boolean isResyncExpiredItems, String group, short itemUpdated, boolean isAsync, HashMap queryInfo, BitSet flagMap, String lockId, long version, LockAccessType accessType, String providerName, String resyncProviderName, boolean encryption, String cacheId, EventDataFilter updateCallbackFilter, EventDataFilter removeCallabackFilter, int methodOverload, String clientId, String typeName, ListenerType listenerType) {
        this.name = "InsertCommand";
        this.asyncCallbackSpecified = this.isAsync && itemUpdated != -1;
        this.key = key;
        this.value = value;
        this.dependency = dependency;
        this.syncDependency = syncDependency;
        this.absoluteExpiration = absoluteExpiration;
        this.slidingExpiration = slidingExpiration;
        this.priority = priority;
        this.remCallbackID = removeCallback;
        this.upCallbackID = updateCallback;
        this.dsItemUpdateCallbackID = dsItemsUpdateCallbackId;
        this.isResyncExpiredItems = isResyncExpiredItems;
        this.group = group;
        this.subGroup = this.subGroup;
        this.asyncCallbackId = itemUpdated;
        this.isAsync = isAsync;
        this.queryInfo = queryInfo;
        this.flagMap = BitSetConstants.getBitSetData((BitSet)flagMap);
        this.dsItemUpdateCallbackID = dsItemsUpdateCallbackId;
        this._lockId = lockId;
        this._version = version;
        this._accessType = accessType;
        this.providerName = providerName;
        this.resyncProviderName = resyncProviderName;
        this.encryption = encryption;
        this.cacheId = cacheId;
        this.updateCallbackFilter = updateCallbackFilter.getValue();
        this.removeCallbackFilter = removeCallabackFilter.getValue();
        this._methodOverload = methodOverload;
        this._clientId = clientId;
        this.groupType = typeName;
        this._listenerType = listenerType;
    }

    @Override
    public void createCommand() throws CommandException {
        if (this.key == null) {
            throw new NullPointerException("key");
        }
        if (this.value == null) {
            throw new NullPointerException("values");
        }
        if (this.key.equals("")) {
            throw new IllegalArgumentException("key");
        }
        if (this.group == null && this.subGroup != null) {
            throw new NullPointerException("group must be specified for sub group");
        }
        long sldExp = 0L;
        long absExp = 0L;
        try {
            absExp = this.absoluteExpiration.equals(NCDateTime.getUTCDate((Date)CacheImpl.defaultAbsolute)) ? 1L : (this.absoluteExpiration.equals(NCDateTime.getUTCDate((Date)CacheImpl.defaultAbsoluteLonger)) ? 2L : (this.absoluteExpiration != CacheImpl.NoAbsoluteExpiration ? new NCDateTime(this.absoluteExpiration).getTicks() : 0L));
            sldExp = this.slidingExpiration.equals(CacheImpl.DefaultSliding) ? 1L : (this.slidingExpiration.equals(CacheImpl.DefaultSlidingLonger) ? 2L : (this.slidingExpiration != CacheImpl.NoSlidingExpiration ? this.slidingExpiration.getTotalTicks() : 0L));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        UserBinaryObject userBin = UserBinaryObject.createUserBinaryObject((byte[])this.value);
        List dataList = userBin.getDataList();
        int noOfChunks = dataList.size();
        ArrayList<ByteString> dataChunks = new ArrayList<ByteString>();
        for (int i = 0; i < noOfChunks; ++i) {
            dataChunks.add(ByteString.copyFrom((byte[])((byte[])dataList.get(i))));
        }
        InsertCommandProtocol.InsertCommand.Builder builder = InsertCommandProtocol.InsertCommand.newBuilder().setKey(this.key).addAllData(dataChunks).setRequestId(super.getRequestId()).setRemoveCallbackId(this.remCallbackID).setUpdateCallbackId(this.upCallbackID).setUpdateDataFilter(this.updateCallbackFilter).setRemoveDataFilter(this.removeCallbackFilter).setDatasourceUpdatedCallbackId(this.dsItemUpdateCallbackID).setIsAsync(this.isAsync).setPriority(this.priority.value()).setFlag(this.flagMap).setItemVersion(this._version).setLockAccessType(this._accessType.getValue()).setCallbackType(this._listenerType.getValue()).setAbsExpiration(absExp).setSldExpiration(sldExp).setIsResync(this.isResyncExpiredItems);
        if (this._lockId != null) {
            builder.setLockId(this._lockId);
        }
        if (this.group != null) {
            builder = builder.setGroup(this.group);
            if (this.subGroup != null) {
                builder = builder.setSubGroup(this.subGroup);
            }
            if (this.groupType != null) {
                builder = builder.setGroupType(this.groupType);
            }
        }
        if (this.providerName != null) {
            builder = builder.setProviderName(this.providerName);
        }
        if (this.resyncProviderName != null) {
            builder = builder.setResyncProviderName(this.resyncProviderName);
        }
        if (this._clientId != null) {
            builder = builder.setClientID(this._clientId);
        }
        if (this.syncDependency != null) {
            SyncDependencyProtocol.SyncDependency protoSyncDep = SyncDependencyProtocol.SyncDependency.newBuilder().setCacheId(this.syncDependency.getCacheId()).setKey(this.syncDependency.getKey()).setPort(this.syncDependency.getPort()).setServer(this.syncDependency.getServer() == null ? "" : this.syncDependency.getServer()).build();
            builder = builder.setSyncDependency(protoSyncDep);
        }
        ObjectQueryInfoProtocol.ObjectQueryInfo.Builder objectQueryInfoBuilder = ObjectQueryInfoProtocol.ObjectQueryInfo.newBuilder();
        if (this.queryInfo.get("query-info") != null) {
            objectQueryInfoBuilder = objectQueryInfoBuilder.setQueryInfo(Command.getQueryInfoObj((HashMap)this.queryInfo.get("query-info")));
        }
        if (this.queryInfo.get("tag-info") != null) {
            objectQueryInfoBuilder = objectQueryInfoBuilder.setTagInfo(Command.getTagInfo((HashMap)this.queryInfo.get("tag-info")));
        }
        if (this.queryInfo.get("named-tag-info") != null) {
            objectQueryInfoBuilder = objectQueryInfoBuilder.setNamedTagInfo(Command.GetNamedTagInfoObj((HashMap)this.queryInfo.get("named-tag-info")));
        }
        if (this.encryption & (objectQueryInfoBuilder.getNamedTagInfo() != null || objectQueryInfoBuilder.getQueryInfo() != null || objectQueryInfoBuilder.getTagInfo() != null)) {
            byte[] encryptedResult = EncryptionMgr.Encryption((byte[])objectQueryInfoBuilder.build().toByteArray(), (String)this.cacheId);
            builder = builder.addObjectQueryInfoEncrypted(ByteString.copyFrom((byte[])encryptedResult));
        } else {
            builder = builder.setObjectQueryInfo(objectQueryInfoBuilder.build());
        }
        if (this.dependency != null) {
            try {
                builder = builder.setDependency(DependencyHelper.getDependencyProtocol((CacheDependency)this.dependency));
            }
            catch (Exception ex) {
                throw new CommandException(ex.getMessage());
            }
        }
        this._commandInstance = builder.setCommandID(this.getCommandID()).setVersion(VERSION).setMethodOverload(this._methodOverload).build();
    }

    @Override
    public boolean getIsSafe() {
        return false;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.INSERT;
    }

    public int AsycItemUpdatedOpComplete() {
        return this.asyncCallbackId;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicWrite;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.INSERT.getNumber();
    }
}

