/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.BitSetConstants;
import Alachisoft.NCache.Common.CompressionUtil;
import Alachisoft.NCache.Common.DataStructures.BridgeOperation;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.HybridBulkCommandProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.serialization.standard.CompactBinaryFormatter;
import com.google.protobuf.ByteString;
import java.io.IOException;
import tangible.RefObject;

public class HybridBulkCommand
extends Command {
    private byte[] data;
    private int flags;

    public HybridBulkCommand(BridgeOperation[] bridgeOperations, boolean compress, String cacheContext) {
        this.name = "HybridBulkCommand";
        byte[] buffer = null;
        BitSet flagMap = null;
        super.setBridgeOperations(bridgeOperations);
        try {
            buffer = CompactBinaryFormatter.toByteBuffer((Object)bridgeOperations, (String)cacheContext);
            flagMap = new BitSet();
            RefObject tempRef_flagMap = new RefObject((Object)flagMap);
            if (compress) {
                buffer = CompressionUtil.Compress((byte[])buffer, (BitSet)flagMap);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (buffer != null) {
            this.data = buffer;
        }
        if (flagMap != null) {
            this.flags = BitSetConstants.getBitSetData((BitSet)flagMap);
        }
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.HYBRID_BULK;
    }

    @Override
    protected void createCommand() throws CommandException {
        HybridBulkCommandProtocol.HybridBulkCommand.Builder builder = HybridBulkCommandProtocol.HybridBulkCommand.newBuilder();
        builder.addData(ByteString.copyFrom((byte[])this.data)).setFlag(this.flags).setRequestId(this.getRequestId());
        CommandProtocol.Command.Builder commandBuilder = CommandProtocol.Command.newBuilder();
        try {
            commandBuilder = commandBuilder.setHybridBulkCommand(builder).setRequestID(this.getRequestId()).setType(CommandProtocol.Command.Type.HYBRID_BULK);
            this.commandBytes = this.constructCommand(commandBuilder.build().toByteArray());
        }
        catch (IOException ex) {
            throw new CommandException(ex.getMessage());
        }
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.KeyBulkRead;
    }
}

