/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.BitSetConstants;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.GetCacheItemCommandProtocol;
import com.alachisoft.ncache.common.protobuf.LockInfoProtocol;
import com.alachisoft.ncache.runtime.caching.ReadMode;
import com.alachisoft.ncache.runtime.caching.ReadThruOptions;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class GetCacheItemCommand
extends Command {
    private final int _methodOverload;
    private int _flagMap;
    private String group;
    private LockAccessType _accessType;
    private String _lockId;
    private TimeSpan _lockTimeout;
    private String _providerName;
    private long _version;
    protected GetCacheItemCommandProtocol.GetCacheItemCommand _commandInstance;
    private ReadMode _readMode;

    public GetCacheItemCommand(String key, BitSet flagMap, String group, LockAccessType accessType, String lockId, TimeSpan lockTimeout, long cacheItemVersion, ReadThruOptions readOption, int methodOverLoad) {
        this.name = "GetCacheItemCommand";
        this.key = key;
        this._flagMap = BitSetConstants.getBitSetData((BitSet)flagMap);
        this.group = group;
        this._accessType = accessType;
        this._lockId = lockId;
        this._lockTimeout = lockTimeout;
        this._version = cacheItemVersion;
        this._providerName = readOption.getProviderName();
        this._readMode = readOption.getReadMode();
        this._methodOverload = methodOverLoad;
    }

    protected boolean parseCommand() {
        return true;
    }

    @Override
    protected void createCommand() throws CommandException {
        if (this.key == null) {
            throw new NullPointerException("Key");
        }
        if (this.key.equals("")) {
            throw new IllegalArgumentException("key");
        }
        GetCacheItemCommandProtocol.GetCacheItemCommand.Builder builder = GetCacheItemCommandProtocol.GetCacheItemCommand.newBuilder();
        builder = builder.setKey(this.key).setRequestId(this.getRequestId()).setFlag(this._flagMap);
        if (this.group != null) {
            builder = builder.setGroup(this.group);
        }
        long ticks = 0L;
        if (this._lockTimeout != CacheImpl.NoLockingExpiration && (ticks = this._lockTimeout.getTotalTicks()) < 0L) {
            ticks = 0L;
        }
        LockInfoProtocol.LockInfo.Builder lockInfoBuilder = LockInfoProtocol.LockInfo.newBuilder();
        if (this._lockId != null) {
            lockInfoBuilder = lockInfoBuilder.setLockId(this._lockId);
        }
        if (this._providerName != null) {
            builder = builder.setProviderName(this._providerName);
        }
        builder.setReadMode(this._readMode.getValue()).setFlag(this._flagMap).setVersion(this._version);
        lockInfoBuilder.setLockAccessType(this._accessType.getValue()).setLockTimeout(ticks);
        builder.setLockInfo(lockInfoBuilder);
        this._commandInstance = builder.build();
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.GET_CACHE_ITEM;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicRead;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.GET_CACHE_ITEM.getNumber();
    }
}

