/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.ContainBulkCommandProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class ContainsBulkCommand
extends Command {
    private final int _methodOverload;
    private String[] keys;
    protected ContainBulkCommandProtocol.ContainsBulkCommand _commandInstance;

    public ContainsBulkCommand(String[] keys, int methodOverload) {
        this.name = "ContainsBulkCommand";
        if (keys == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: keys");
        }
        if (keys.length == 0) {
            throw new IllegalArgumentException("There is no key present in keys array");
        }
        this.keys = keys;
        this._methodOverload = methodOverload;
    }

    @Override
    protected void createCommand() throws CommandException {
        ContainBulkCommandProtocol.ContainsBulkCommand.Builder builder = ContainBulkCommandProtocol.ContainsBulkCommand.newBuilder();
        this._commandInstance = builder.setRequestId(super.getRequestId()).addAllKeys(Arrays.asList(this.keys)).setMethodOverload(this._methodOverload).build();
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.CONTAINS_BULK;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.KeyBulkRead;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.CONTAINS_BULK.getNumber();
    }
}

