/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.DataStructures.BridgeOperation;
import Alachisoft.NCache.Common.Net.Address;
import com.alachisoft.ncache.client.internal.command.CommandResponse;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.client.internal.communication.Request;
import com.alachisoft.ncache.client.internal.communication.SendError;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.NamedTagInfoProtocol;
import com.alachisoft.ncache.common.protobuf.QueryInfoProtocol;
import com.alachisoft.ncache.common.protobuf.TagInfoProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Command {
    protected byte[] value = null;
    protected byte[] commandBytes = null;
    protected byte[] internalCommandSize = null;
    private long requestId = -1L;
    private String[] bulkKeys;
    private BridgeOperation[] bridgeOperations;
    private CommandResponse result = null;
    private String _cacheId;
    static String NC_NULL_VAL = "NLV";
    static String VERSION = "4200";
    protected String name;
    private long clientLastViewId = -1L;
    private String intendedRecipient;
    protected String key;
    public boolean isAsync = false;
    public boolean asyncCallbackSpecified = false;
    private String ip = "";
    protected boolean inquiryEnabled;
    protected CommandProtocol.Command _command;
    protected int _commandID = 0;
    private byte[] serialized;
    private Address _finalDestinationAddress;
    private boolean isSurrogationSupported;
    private boolean isRetry;
    private Request _parent;
    private boolean supportsAcknowledgement;
    private long acknowledgmentId;
    public boolean pulseOnSend;
    public boolean sentOverWire;
    private SendError sendError;
    protected int asyncCallbackId = -1;

    public int getCommandID() {
        return this._commandID;
    }

    public void setCommandID(int value) {
        this._commandID = value;
    }

    public byte[] getSerialized() {
        return this.serialized;
    }

    public void setSerialized(byte[] value) {
        this.serialized = value;
    }

    public Address getFinalDestinationAddress() {
        return this._finalDestinationAddress;
    }

    public void setFinalDestinationAddress(Address finalDestinationAddress) {
        this._finalDestinationAddress = finalDestinationAddress;
    }

    public boolean getSupportsSurrogation() {
        return this.isSurrogationSupported;
    }

    public void setSupportsSurrogation(boolean surrogationSupported) {
        this.isSurrogationSupported = surrogationSupported;
    }

    public boolean getIsRetry() {
        return this.isRetry;
    }

    public void setIsRetry(boolean retry) {
        this.isRetry = retry;
    }

    public Request getParent() {
        return this._parent;
    }

    public void setParent(Request _parent) {
        this._parent = _parent;
    }

    public boolean getIsInternalCommand() {
        return this.getCommandRequestType() == RequestType.InternalCommand;
    }

    public abstract RequestType getCommandRequestType();

    public abstract CommandType getCommandType();

    public CommandProtocol.Command.Type getType() {
        return this._command.getType();
    }

    public long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(long value) {
        this.requestId = value;
    }

    public boolean getSupportsAacknowledgement() {
        return this.supportsAcknowledgement;
    }

    public void setSupportsAacknowledgement(boolean supportsAcknowledgement) {
        this.supportsAcknowledgement = supportsAcknowledgement;
    }

    public long getClientLastViewId() {
        return this.clientLastViewId;
    }

    public void setClientLastViewId(long clientLastViewId) {
        this.clientLastViewId = clientLastViewId;
    }

    public String getIntendedRecipient() {
        return this.intendedRecipient;
    }

    public void setIntendedRecipient(String intendedRecipient) {
        this.intendedRecipient = intendedRecipient;
    }

    public CommandResponse getResponse() {
        return this.result;
    }

    public void setResponse(CommandResponse res) {
        this.result = res;
    }

    public String getKey() {
        return this.key;
    }

    public String[] getBulkKeys() {
        return this.bulkKeys;
    }

    public void setBulkKeys(String[] bulkKeys) {
        this.bulkKeys = bulkKeys;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(byte[] bytes) {
        this.value = bytes;
    }

    public BridgeOperation[] getBridgeOperations() {
        return this.bridgeOperations;
    }

    public void setBridgeOperations(BridgeOperation[] bridgeOperations) {
        this.bridgeOperations = bridgeOperations;
    }

    public String getCommandName() {
        return this.name;
    }

    public boolean getIsSafe() {
        return true;
    }

    protected boolean getIsKeyBased() {
        return true;
    }

    public long getAcknowledgmentId() {
        return this.acknowledgmentId;
    }

    public void setAcknowledgmentId(long acknowledgmentId) {
        this.acknowledgmentId = acknowledgmentId;
    }

    public boolean getPulseOnSend() {
        return this.pulseOnSend;
    }

    public void setPulseOnSend(boolean pulseOnSend) {
        this.pulseOnSend = pulseOnSend;
    }

    public boolean getSentOverWire() {
        return this.sentOverWire;
    }

    public void setSentOverWire(boolean sentOverWire) {
        this.sentOverWire = sentOverWire;
    }

    public SendError getSendError() {
        return this.sendError;
    }

    public void setSendError(SendError sendError) {
        this.sendError = sendError;
    }

    public String getCacheId() {
        return this._cacheId;
    }

    public void setCacheId(String _cacheId) {
        this._cacheId = _cacheId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] constructCommand(byte[] serializedCommand) throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            byte[] discardingBuffer = new byte[20];
            stream.write(discardingBuffer);
            byte[] size = new byte[10];
            byte[] commandSize = String.valueOf(serializedCommand.length).getBytes(StandardCharsets.UTF_8);
            System.arraycopy(commandSize, 0, size, 0, commandSize.length);
            stream.write(size);
            stream.write(serializedCommand);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }

    protected abstract void createCommand() throws CommandException;

    public int getAcknowledgementOffset() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByte(long acknowledgement, boolean requestInquiryEnabled) throws CommandException, IOException {
        Command command = this;
        synchronized (command) {
            if (this.commandBytes == null || this.inquiryEnabled != requestInquiryEnabled) {
                this.inquiryEnabled = requestInquiryEnabled;
                this.createCommand();
                this.serializeCommand();
            }
            if (this.getSupportsAacknowledgement() && this.inquiryEnabled) {
                byte[] acknowledgementBuffer = String.valueOf(acknowledgement).getBytes(StandardCharsets.UTF_8);
                System.arraycopy(acknowledgementBuffer, 0, this.commandBytes, this.getAcknowledgementOffset(), acknowledgementBuffer.length);
            }
            return this.commandBytes;
        }
    }

    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._command.writeTo((OutputStream)stream);
    }

    protected short getCommandHandle() {
        return 0;
    }

    protected void serializeCommand() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        byte[] acknowledgementBuffer = this.getSupportsAacknowledgement() && this.inquiryEnabled ? new byte[20] : new byte[]{};
        stream.write(acknowledgementBuffer, 0, acknowledgementBuffer.length);
        byte[] commandType = HelperFxn.writeShort((short)this.getCommandHandle());
        stream.write(commandType, 0, commandType.length);
        byte[] size = new byte[10];
        stream.write(size, 0, size.length);
        this.serializeCommandInternal(stream);
        this.commandBytes = stream.toByteArray();
        int messageLen = stream.size() - (size.length + acknowledgementBuffer.length + commandType.length);
        size = String.valueOf(messageLen).getBytes(StandardCharsets.UTF_8);
        int offset = acknowledgementBuffer.length + commandType.length;
        System.arraycopy(size, 0, this.commandBytes, offset, size.length);
        stream.close();
    }

    public void resetCommand() {
        if (this._parent != null) {
            this.commandBytes = null;
            this._commandID = this._parent.getNextCommandID();
        }
    }

    public static Command getDedicatedCommand(Collection<Command> commands, String address) {
        Command dedicatedCommand = null;
        ArrayList<Command> commandsList = new ArrayList<Command>(commands);
        dedicatedCommand = ((Command)commandsList.get(0)).getMergedCommand(commandsList);
        dedicatedCommand.commandBytes = null;
        dedicatedCommand.setClientLastViewId(-5L);
        dedicatedCommand.getParent().getCommands().clear();
        dedicatedCommand.getParent().addCommand(new Address(address, 9800), dedicatedCommand);
        return dedicatedCommand;
    }

    public byte[] getSerializedSurrogateCommand() throws IOException, CommandException {
        byte[] serializedbytes = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.createCommand();
        if (this._command != null) {
            this._command.writeTo((OutputStream)stream);
        }
        serializedbytes = stream.toByteArray();
        return serializedbytes;
    }

    protected Command getMergedCommand(List<Command> commands) {
        return commands != null && commands.size() > 0 ? commands.get(0) : null;
    }

    protected String rebuildCommandWithTagInfo(HashMap tagInfo) {
        StringBuilder cmdString = new StringBuilder();
        cmdString.append(tagInfo.get("type") + "\"");
        Object obj = tagInfo.get("tags-list");
        if (obj instanceof ArrayList) {
            ArrayList tagsList = (ArrayList)obj;
            cmdString.append(tagsList.size() + "\"");
            for (Object current : tagsList) {
                if (current != null) {
                    cmdString.append(current.toString() + "\"");
                    continue;
                }
                cmdString.append(NC_NULL_VAL + "\"");
            }
        }
        return cmdString.toString();
    }

    protected String rebuildCommandWithQueryInfo(HashMap queryInfo) {
        StringBuilder cmdString = new StringBuilder();
        for (Map.Entry entry : queryInfo.entrySet()) {
            cmdString.append(entry.getKey()).append("\"");
            ArrayList values = (ArrayList)entry.getValue();
            cmdString.append(values.size()).append("\"");
            for (int i = 0; i < values.size(); ++i) {
                cmdString.append(values.get(i)).append("\"");
            }
        }
        return cmdString.toString();
    }

    public String toString() {
        return this.name + " : " + this.requestId;
    }

    public static QueryInfoProtocol.QueryInfo getQueryInfoObj(HashMap queryInfoDic) {
        if (queryInfoDic == null) {
            return null;
        }
        if (queryInfoDic.size() == 0) {
            return null;
        }
        QueryInfoProtocol.QueryInfo.Builder builder = QueryInfoProtocol.QueryInfo.newBuilder();
        Iterator queryInfoEnum = queryInfoDic.keySet().iterator();
        while (queryInfoEnum.hasNext()) {
            builder = builder.setHandleId(((Integer)queryInfoEnum.next()).intValue());
            ArrayList values = (ArrayList)queryInfoDic.get(builder.getHandleId());
            int valuesListSize = values.size();
            for (int i = 0; i < valuesListSize; ++i) {
                Object val = values.get(i);
                if (val != null) {
                    if (val instanceof Date) {
                        val = HelperFxn.getTicks((Date)((Date)val));
                    }
                    builder = builder.addAttributes(val.toString());
                    continue;
                }
                builder = builder.addAttributes("NCNULL");
            }
        }
        return builder.build();
    }

    public static TagInfoProtocol.TagInfo getTagInfo(HashMap tagInfoDic) {
        if (tagInfoDic == null || tagInfoDic.size() == 0) {
            return null;
        }
        TagInfoProtocol.TagInfo.Builder builder = TagInfoProtocol.TagInfo.newBuilder();
        builder = builder.setType(String.valueOf(tagInfoDic.get("type")));
        Object obj = tagInfoDic.get("tags-list");
        if (obj instanceof ArrayList) {
            for (Object current : (ArrayList)obj) {
                if (current == null) continue;
                builder = builder.addTags(current.toString());
            }
        }
        return builder.build();
    }

    public static NamedTagInfoProtocol.NamedTagInfo GetNamedTagInfoObj(HashMap namedTagInfoDic) {
        if (namedTagInfoDic == null || namedTagInfoDic.size() == 0) {
            return null;
        }
        NamedTagInfoProtocol.NamedTagInfo.Builder builder = NamedTagInfoProtocol.NamedTagInfo.newBuilder();
        builder = builder.setType(String.valueOf(namedTagInfoDic.get("type")));
        HashMap tagsList = (HashMap)namedTagInfoDic.get("named-tags-list");
        HashMap tagsTypeList = (HashMap)namedTagInfoDic.get("named-tags-types-list");
        for (Object current : tagsList.keySet()) {
            if (current == null) continue;
            Object val = tagsList.get(current);
            if (val == null) {
                builder = builder.addNames(current.toString());
                builder = builder.addTypes(((Class)tagsTypeList.get(current)).getCanonicalName());
            } else {
                builder = builder.addNames(current.toString());
                builder = builder.addTypes(val.getClass().getCanonicalName());
            }
            if (val instanceof Date) {
                val = HelperFxn.getTicks((Date)((Date)val));
            }
            builder = builder.addVals(val == null ? "NCNULL" : val.toString());
        }
        return builder.build();
    }
}

