/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.common.protobuf.CollectionCommandProtocol;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.LockInfoProtocol;
import com.alachisoft.ncache.runtime.caching.DistributedDataStructure;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class CollectionCommandBase
extends Command {
    protected String _lockId;
    protected TimeSpan _lockTimeout;
    protected WriteThruOptions _writeThruOption;
    protected CollectionCommandProtocol.CollectionCommand.Builder _collectionCommandBuilder;

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.COLLECTION_COMMAND.getNumber();
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._collectionCommandBuilder.build().writeTo((OutputStream)stream);
    }

    @Override
    protected void createCommand() {
        this._collectionCommandBuilder = CollectionCommandProtocol.CollectionCommand.newBuilder();
        this._collectionCommandBuilder.setRequestId(super.getRequestId());
        this._collectionCommandBuilder.setName(this.key);
        LockInfoProtocol.LockInfo.Builder lockBuilder = LockInfoProtocol.LockInfo.newBuilder();
        if (this._lockId != null) {
            lockBuilder.setLockId(this._lockId);
        }
        if (this._lockTimeout != null) {
            lockBuilder.setLockTimeout(this._lockTimeout.getTotalTicks());
        }
        this._collectionCommandBuilder.setLockInfo(lockBuilder);
        if (this._writeThruOption != null) {
            this._collectionCommandBuilder.setDsWriteOption(this._writeThruOption.getMode().getValue());
            if (this._writeThruOption.getProviderName() != null) {
                this._collectionCommandBuilder.setProviderName(this._writeThruOption.getProviderName());
            }
        }
    }

    protected static CollectionCommandProtocol.CollectionCommand.Type getCollectionType(DistributedDataStructure _collectionType) {
        switch (_collectionType) {
            case List: {
                return CollectionCommandProtocol.CollectionCommand.Type.LIST;
            }
            case Queue: {
                return CollectionCommandProtocol.CollectionCommand.Type.QUEUE;
            }
            case Map: {
                return CollectionCommandProtocol.CollectionCommand.Type.DICTIONARY;
            }
            case Set: {
                return CollectionCommandProtocol.CollectionCommand.Type.SET;
            }
        }
        throw new RuntimeException("Invalid data type specified.");
    }
}

