/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Common.DataStructures.EnumerationDataChunk;
import Alachisoft.NCache.Common.DataStructures.EnumerationPointer;
import Alachisoft.NCache.Common.DataStructures.GroupEnumerationPointer;
import Alachisoft.NCache.Common.IDisposable;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.Entry;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

class WebCacheEnumerator
implements Enumeration,
IDisposable {
    private CacheImpl _cache;
    private ArrayList<EnumerationDataChunk> _currentChunks;
    private Iterator<String> _currentChunkEnumerator;
    private String _group;
    private String _serializationContext;
    private String _subGroup;
    private Entry _de;
    private Class serializationClass;

    public WebCacheEnumerator(String serializationContext, String group, String subGroup, CacheImpl cache, Class<?> cls) {
        this._serializationContext = serializationContext;
        this._cache = cache;
        this._group = group;
        this._subGroup = subGroup;
        this._de = new Entry();
        this.serializationClass = cls;
        this.Initialize(this._group, this._subGroup);
    }

    public void Initialize(String group, String subGroup) {
        ArrayList<EnumerationPointer> pointers = new ArrayList<EnumerationPointer>();
        if (group != null && !group.equals("")) {
            pointers.add((EnumerationPointer)new GroupEnumerationPointer(group, subGroup));
        } else {
            pointers.add(new EnumerationPointer());
        }
        this._currentChunks = this._cache.getNextChunk(pointers);
        ArrayList data = new ArrayList();
        for (int i = 0; i < this._currentChunks.size(); ++i) {
            EnumerationDataChunk chunk = this._currentChunks.get(i);
            if (chunk == null || chunk.getData() == null) continue;
            data.addAll(chunk.getData());
        }
        this._currentChunkEnumerator = data.iterator();
    }

    @Override
    public boolean hasMoreElements() {
        boolean result = false;
        if (this._currentChunkEnumerator != null && !(result = this._currentChunkEnumerator.hasNext())) {
            ArrayList<EnumerationPointer> pointers;
            if (this._currentChunks != null && !this.isLastChunk(this._currentChunks)) {
                this._currentChunks = this._cache.getNextChunk(this.getPointerList(this._currentChunks));
                ArrayList data = new ArrayList();
                for (int i = 0; i < this._currentChunks.size(); ++i) {
                    if (this._currentChunks.get(i) == null || this._currentChunks.get(i).getData() == null) continue;
                    data.addAll(this._currentChunks.get(i).getData());
                }
                if (data != null && data.size() > 0) {
                    this._currentChunkEnumerator = data.iterator();
                    result = this._currentChunkEnumerator.hasNext();
                }
            } else if (this._currentChunks != null && this._currentChunks.size() > 0 && (pointers = this.getPointerList(this._currentChunks)).size() > 0) {
                this._cache.getNextChunk(pointers);
            }
        }
        return result;
    }

    public Object nextElement() {
        String key = (String)this.getKey();
        this._de.setKey(key);
        this._de.setValue(this.getValue(key));
        return this._de;
    }

    public Object getKey() {
        String key = null;
        if (this._currentChunkEnumerator != null) {
            key = this._currentChunkEnumerator.next();
        }
        return key;
    }

    public Object getValue(String key) {
        Object value = null;
        try {
            value = this._cache.get(key, this.serializationClass);
        }
        catch (Exception ex) {
            if (ex.getMessage().startsWith("Connection with server lost")) {
                try {
                    value = this._cache.get(key, this.serializationClass);
                }
                catch (Exception inner) {
                    throw new RuntimeException(inner);
                }
            }
            throw new RuntimeException(ex);
        }
        return value;
    }

    private boolean isLastChunk(List<EnumerationDataChunk> chunks) {
        for (int i = 0; i < chunks.size(); ++i) {
            if (chunks.get(i).isLastChunk()) continue;
            return false;
        }
        return true;
    }

    private ArrayList<EnumerationPointer> getPointerList(ArrayList<EnumerationDataChunk> chunks) {
        ArrayList<EnumerationPointer> pointers = new ArrayList<EnumerationPointer>();
        for (int i = 0; i < chunks.size(); ++i) {
            if (chunks.get(i).isLastChunk()) continue;
            pointers.add(chunks.get(i).getPointer());
        }
        return pointers;
    }

    private ArrayList<EnumerationDataChunk> getChunk(ArrayList<EnumerationPointer> pointer) {
        ArrayList<EnumerationDataChunk> chunks = null;
        try {
            chunks = this._cache.getNextChunk(pointer);
        }
        catch (Exception ex) {
            for (int i = 0; i < pointer.size(); ++i) {
                pointer.get(i).setDisposable(true);
            }
            try {
                this._cache.getNextChunk(pointer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return chunks;
    }

    public void dispose() {
        ArrayList<EnumerationPointer> pointerlist;
        if (this._cache != null && this._currentChunks != null && (pointerlist = this.getPointerList(this._currentChunks)).size() > 0) {
            this._cache.getNextChunk(pointerlist);
        }
        this._serializationContext = null;
        this._cache = null;
        this._group = null;
        this._subGroup = null;
    }
}

