/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Common.Threading.ThreadPool;
import com.alachisoft.ncache.client.internal.caching.Shorter;
import com.alachisoft.ncache.client.internal.caching.TopicImpl;
import com.alachisoft.ncache.runtime.caching.MessageEventArgs;
import com.alachisoft.ncache.runtime.caching.SubscriptionPolicy;
import com.alachisoft.ncache.runtime.caching.SubscriptionPolicyType;
import com.alachisoft.ncache.runtime.caching.Topic;
import com.alachisoft.ncache.runtime.caching.TopicSubscription;
import com.alachisoft.ncache.runtime.caching.messaging.DeliveryMode;
import com.alachisoft.ncache.runtime.caching.messaging.DurableTopicSubscription;
import com.alachisoft.ncache.runtime.caching.messaging.MessageReceivedListener;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import java.util.ArrayList;

public class TopicSubscriptionImpl
implements TopicSubscription,
DurableTopicSubscription {
    private final TopicImpl topic;
    private final String subscriberId;
    private final MessageReceivedListener listener;
    private String _subscriptionName;
    private SubscriptionPolicyType _subscriptionPolicyType;
    private int count = 1;
    private long _expiration;
    private long _creationTime;
    private SubscriptionPolicy _subscriptionPolicy;
    private ArrayList<MessageReceivedListener> messageReceivedListeners = new ArrayList();
    private DeliveryMode _deliveryMode;

    public TopicSubscriptionImpl(TopicImpl topic, String subscriptionName, SubscriptionPolicyType subscriptionPolicyType, MessageReceivedListener listener, DeliveryMode deliveryMode) {
        this.topic = topic;
        this.listener = listener;
        this._subscriptionName = subscriptionName;
        this._subscriptionPolicyType = subscriptionPolicyType;
        this.messageReceivedListeners.add(listener);
        this.subscriberId = new Shorter().getGuidString();
        this._deliveryMode = deliveryMode;
    }

    public TopicSubscriptionImpl(TopicImpl topic, String subscriptionName, SubscriptionPolicyType subscriptionPolicyType, MessageReceivedListener listener) {
        this(topic, subscriptionName, subscriptionPolicyType, listener, DeliveryMode.Sync);
    }

    public Topic getTopic() {
        return this.topic;
    }

    public DeliveryMode getDeliveryMode() {
        return this._deliveryMode;
    }

    public void addMessageReceivedListener(MessageReceivedListener messageReceivedListener) throws CacheException {
        this.messageReceivedListeners.add(messageReceivedListener);
    }

    public void removeMessageReceivedListener(MessageReceivedListener messageReceivedListener) throws CacheException {
        this.messageReceivedListeners.remove(messageReceivedListener);
    }

    public void OnMessageRecieved(final MessageEventArgs args) {
        try {
            if (this.messageReceivedListeners != null && !this.messageReceivedListeners.isEmpty()) {
                for (final MessageReceivedListener t : this.messageReceivedListeners) {
                    if (this._deliveryMode.equals((Object)DeliveryMode.Sync)) {
                        t.onMessageReceived((Object)this, args);
                        continue;
                    }
                    ThreadPool.getInstance().executeTask(new Runnable(){

                        @Override
                        public void run() {
                            t.onMessageReceived((Object)this, args);
                        }
                    });
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public String getSubscriberId() {
        return this.subscriberId;
    }

    public String getSubscriptionName() {
        return this._subscriptionName;
    }

    public SubscriptionPolicyType getSubscriptionPolicyType() {
        return this._subscriptionPolicyType;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public void setExpiration(long value) {
        this._expiration = value;
    }

    public long getCreationTime() {
        return this._creationTime;
    }

    public void setCreationTime(long value) {
        this._creationTime = value;
    }

    public SubscriptionPolicy getSubscriptionPolicy() {
        return this._subscriptionPolicy;
    }

    public void setSubscriptionPolicy(SubscriptionPolicyType subscriptionPolicyType) {
        this._subscriptionPolicyType = subscriptionPolicyType;
    }

    public void UpdateCount() {
        ++this.count;
    }

    public final void unSubscribe() throws Exception {
        if (this.count == 1) {
            this.topic.unSubscribe(this, true);
        } else {
            --this.count;
        }
    }

    public void unSubscribeEventTopic() throws Exception {
        this.topic.unSubscribeEventTopic(this, true);
    }

    public void onMessageRecieved(final MessageEventArgs args) {
        if (this.listener != null) {
            if (this._deliveryMode.equals((Object)DeliveryMode.Sync)) {
                this.listener.onMessageReceived((Object)this, args);
            } else {
                ThreadPool.getInstance().executeTask(new Runnable(){

                    @Override
                    public void run() {
                        TopicSubscriptionImpl.this.listener.onMessageReceived((Object)this, args);
                    }
                });
            }
        }
    }

    public void dispose() {
        try {
            this.topic.unSubscribe(this, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

