/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.CompressionUtil;
import Alachisoft.NCache.Common.Enum.SubscriptionType;
import Alachisoft.NCache.Common.Enum.UserObjectType;
import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import Alachisoft.NCache.Common.Messaging.MessageMetaData;
import Alachisoft.NCache.Common.Messaging.SubscriptionIdentifier;
import Alachisoft.NCache.Common.Stats.UsageStats;
import Alachisoft.NCache.Common.Threading.ThreadPool;
import Alachisoft.NCache.Common.Util.ReaderWriterLock;
import Alachisoft.NCache.Management.Statistics.StatisticsCounter;
import com.alachisoft.ncache.client.EventCacheItemWrapperInternal;
import com.alachisoft.ncache.client.EventUtil;
import com.alachisoft.ncache.client.MessageItem;
import com.alachisoft.ncache.client.internal.caching.CacheHelper;
import com.alachisoft.ncache.client.internal.caching.CacheImplBase;
import com.alachisoft.ncache.client.internal.caching.Shorter;
import com.alachisoft.ncache.client.internal.caching.TopicSubscriptionImpl;
import com.alachisoft.ncache.client.internal.messaging.MessageCollectionEventItem;
import com.alachisoft.ncache.client.internal.messaging.MessageEventItem;
import com.alachisoft.ncache.client.internal.messaging.MessageManager;
import com.alachisoft.ncache.client.util.PayLoadDeserializationJson;
import com.alachisoft.ncache.runtime.caching.DeliveryOption;
import com.alachisoft.ncache.runtime.caching.Message;
import com.alachisoft.ncache.runtime.caching.MessageEventArgs;
import com.alachisoft.ncache.runtime.caching.MessageFailedEventArgs;
import com.alachisoft.ncache.runtime.caching.PayloadDeserializer;
import com.alachisoft.ncache.runtime.caching.SubscriptionPolicy;
import com.alachisoft.ncache.runtime.caching.SubscriptionPolicyType;
import com.alachisoft.ncache.runtime.caching.Topic;
import com.alachisoft.ncache.runtime.caching.TopicDeleteEventArgs;
import com.alachisoft.ncache.runtime.caching.TopicListener;
import com.alachisoft.ncache.runtime.caching.TopicSubscription;
import com.alachisoft.ncache.runtime.caching.messaging.DeliveryMode;
import com.alachisoft.ncache.runtime.caching.messaging.DurableTopicSubscription;
import com.alachisoft.ncache.runtime.caching.messaging.MessageReceivedListener;
import com.alachisoft.ncache.runtime.caching.messaging.TopicPriority;
import com.alachisoft.ncache.runtime.caching.messaging.TopicSearchOptions;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.runtime.OperationFailedRuntimeException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import tangible.RefObject;

public class TopicImpl
implements Topic {
    private final String topicName;
    private TopicPriority _topicPriority;
    private final CacheImplBase cacheImpl;
    private final String publisherId;
    private final Object syncLock = new Object();
    private final MessageManager parent;
    private final ReaderWriterLock readerWriterLock;
    private boolean isDisposed;
    private int refPublisherCount;
    private TimeSpan expiration = new TimeSpan(Long.MAX_VALUE);
    private AtomicInteger refCount = new AtomicInteger(0);
    private HashMap<SubscriptionIdentifier, TopicSubscriptionImpl> subscriptions;
    private TopicListener deleteEventListener;
    private TopicListener messageFailedEventListener;
    private TopicSearchOptions _searchOptions = TopicSearchOptions.ByName;
    private StatisticsCounter _perfStatsCollector;
    private boolean _eventRegistered = false;

    public TopicImpl(String topicName, TopicPriority topicPriority, CacheImplBase cacheImpl, StatisticsCounter perfStatsCollector, MessageManager parent) {
        this.topicName = topicName;
        this.subscriptions = new HashMap();
        this.cacheImpl = cacheImpl;
        this._perfStatsCollector = perfStatsCollector;
        this._topicPriority = topicPriority;
        this.parent = parent;
        this.publisherId = new Shorter().getGuidString();
        this.readerWriterLock = new ReaderWriterLock();
    }

    public final TopicSearchOptions getSearchOptions() {
        return this._searchOptions;
    }

    public final void setSearchOptions(TopicSearchOptions value) {
        this._searchOptions = value;
    }

    public final TopicSubscription createSubscription(MessageReceivedListener messageReceivedListener) throws CacheException {
        return this.createSubscription(messageReceivedListener, DeliveryMode.Sync);
    }

    public final TopicSubscription createSubscription(MessageReceivedListener messageReceivedListener, DeliveryMode deliveryMode) throws CacheException {
        this.ValidateInput(messageReceivedListener);
        String subscriptionName = new Shorter().getGuidString();
        return this.RegisterSubscriptions(subscriptionName, messageReceivedListener, deliveryMode, null, null);
    }

    public TopicSubscription createEventSubscription(MessageReceivedListener messageReceivedListener) throws CacheException {
        this.ValidateInput(messageReceivedListener);
        String subscriptionName = "$EventsSubscription$";
        return this.RegisterSubscriptions(subscriptionName, messageReceivedListener, DeliveryMode.Async, SubscriptionPolicyType.EventSubscription, null);
    }

    public DurableTopicSubscription createDurableSubscription(String subscriptionName, SubscriptionPolicy subscriptionPolicy, MessageReceivedListener messageReceivedListener, TimeSpan timeSpan) throws CacheException {
        return this.createDurableSubscription(subscriptionName, subscriptionPolicy, messageReceivedListener, timeSpan, DeliveryMode.Sync);
    }

    public DurableTopicSubscription createDurableSubscription(String subscriptionName, SubscriptionPolicy subscriptionPolicy, MessageReceivedListener messageReceivedListener, TimeSpan timeSpan, DeliveryMode deliveryMode) throws CacheException {
        this.ValidateInput(messageReceivedListener);
        SubscriptionPolicyType subscriptionPolicyType = subscriptionPolicy == SubscriptionPolicy.Exclusive ? SubscriptionPolicyType.DurableExclusiveSubscription : SubscriptionPolicyType.DurableSharedSubscription;
        return (DurableTopicSubscription)this.RegisterSubscriptions(subscriptionName, messageReceivedListener, deliveryMode, subscriptionPolicyType, timeSpan);
    }

    public final boolean getIsClosed() {
        return this.isDisposed;
    }

    public final String getName() {
        return this.topicName;
    }

    public final TopicPriority getPriority() {
        return this._topicPriority;
    }

    public long getMessageCount() throws Exception {
        if (this.getIsClosed()) {
            throw new OperationFailedRuntimeException(20007, ErrorMessages.getErrorMessage((int)20007, (String[])new String[]{this.getName()}));
        }
        if (this.cacheImpl != null) {
            return this.cacheImpl.getMessageCount(this.topicName);
        }
        return 0L;
    }

    public final void close() {
        this.disposeInternal(false);
        this.parent.topicDisposeItself(this);
        this.parent.stopPollingIfRequired(this);
    }

    public final TimeSpan getExpirationTime() {
        return this.expiration;
    }

    public final void setExpirationTime(TimeSpan value) {
        this.expiration = value;
    }

    public final void publish(Message message, DeliveryOption deliverOption) throws Exception {
        this.publish(message, deliverOption, false);
    }

    public final void publish(Message message, DeliveryOption deliverOption, boolean notifyDeliveryFailure) throws Exception {
        this.publishInternal(message, deliverOption, null, notifyDeliveryFailure);
    }

    public final void publish(Message message, DeliveryOption deliverOption, String sequenceName) throws Exception {
        this.publish(message, deliverOption, sequenceName, false);
    }

    public final void publish(Message message, DeliveryOption deliverOption, String sequenceName, boolean notifyDeliveryFailure) throws Exception {
        if (sequenceName == null || sequenceName.isEmpty()) {
            throw new IllegalArgumentException("sequenceName");
        }
        message.setMessageId("{" + sequenceName + "}" + message.getMessageId());
        this.publishInternal(message, deliverOption, sequenceName, notifyDeliveryFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishInternal(Message message, DeliveryOption deliverOption, String sequenceName, boolean notifyDeliveryFailure) throws Exception {
        if (TopicSearchOptions.ByName != this._searchOptions) {
            throw new OperationFailedException(20006, ErrorMessages.getErrorMessage((int)20006, (String[])new String[0]));
        }
        if (message == null) {
            throw new IllegalArgumentException("message");
        }
        if (this.isDisposed) {
            throw new OperationFailedException(20007, ErrorMessages.getErrorMessage((int)20007, (String[])new String[]{this.getName()}));
        }
        try {
            this.readerWriterLock.AcquireReaderLock();
            if (message == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: message");
            }
            if (this.isDisposed) {
                throw new OperationFailedException(20007, ErrorMessages.getErrorMessage((int)20007, (String[])new String[]{this.getName()}));
            }
            UsageStats stats = new UsageStats();
            stats.BeginSample();
            BitSet flagMap = new BitSet();
            long size = 0L;
            Object value = message.getPayload();
            RefObject tempRef_size = new RefObject((Object)size);
            value = this.cacheImpl.safeSerialize(value, this.cacheImpl.getName(), flagMap, this.cacheImpl, (RefObject<Long>)tempRef_size, UserObjectType.CacheItem);
            size = (Long)tempRef_size.argvalue;
            if (this.cacheImpl.getEncryptionEnabled()) {
                value = CacheHelper.EncryptData((byte[])value, this.cacheImpl.getName());
            }
            if (this._perfStatsCollector != null && value != null && value instanceof byte[]) {
                this._perfStatsCollector.incrementAvgItemSize((long)((byte[])value).length);
            }
            if (this.cacheImpl.getCompressionEnabled()) {
                value = CompressionUtil.Compress((byte[])((byte[])value), (BitSet)flagMap, (long)this.cacheImpl.getCompressionThreshold());
            }
            if (sequenceName == null) {
                sequenceName = "";
            }
            Hashtable<String, Object> metaInfo = new Hashtable<String, Object>();
            metaInfo.put("CHA$#+%*$>", "CHA$#+%*$>" + this.topicName);
            metaInfo.put("DeliveryOption", String.valueOf(deliverOption.getValue()));
            metaInfo.put("NotifyFailure", String.valueOf(notifyDeliveryFailure));
            metaInfo.put("SequenceName", sequenceName);
            long expiration = this.GetExpirationTime(message);
            this.cacheImpl.publishMessage(message.getMessageId(), value, message.getCreationTime().getTime(), expiration, metaInfo, flagMap);
            if (this._perfStatsCollector != null) {
                stats.EndSample();
                this._perfStatsCollector.incrementMsecPerMessagePublish(stats.getCurrent());
                this._perfStatsCollector.incrementMessagePublishedPerSec(1);
            }
        }
        finally {
            this.readerWriterLock.ReleaseReaderLock();
        }
    }

    public FutureTask publishAsync(Message message, DeliveryOption deliverOption) throws Exception {
        return this.publishAsync(message, deliverOption, false);
    }

    public FutureTask publishAsync(Message message, DeliveryOption deliverOption, boolean notifyDeliveryFailure) throws Exception {
        if (TopicSearchOptions.ByName != this._searchOptions) {
            throw new OperationFailedException(20006, ErrorMessages.getErrorMessage((int)20006, (String[])new String[0]));
        }
        if (message == null) {
            throw new IllegalArgumentException("message");
        }
        if (this.isDisposed) {
            throw new OperationFailedException(20007, ErrorMessages.getErrorMessage((int)20007, (String[])new String[]{this.getName()}));
        }
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            this.publish(message, deliverOption, notifyDeliveryFailure);
            return null;
        });
        ThreadPool.getInstance().executeTask(task);
        return task;
    }

    public Map<Message, Exception> publishBulk(Map<Message, DeliveryOption> messages) throws CacheException {
        return this.publishBulk(messages, false);
    }

    public Map<Message, Exception> publishBulk(Map<Message, DeliveryOption> messages, boolean notifyDeliveryFailure) throws CacheException {
        if (this.isDisposed) {
            throw new OperationFailedException(20007, ErrorMessages.getErrorMessage((int)20007, (String[])new String[]{this.topicName}));
        }
        if (TopicSearchOptions.ByName != this._searchOptions) {
            throw new OperationFailedException(20006, ErrorMessages.getErrorMessage((int)20006, (String[])new String[0]));
        }
        if (messages == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: messages");
        }
        return this.publishBulkInternal(messages, notifyDeliveryFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Message, Exception> publishBulkInternal(Map<Message, DeliveryOption> messages, boolean notifyDeliveryFailure) throws CacheException {
        HashMap<Message, Exception> failureResult = null;
        HashMap<String, Alachisoft.NCache.Caching.Messaging.Message> keyMessageBulk = new HashMap<String, Alachisoft.NCache.Caching.Messaging.Message>();
        HashMap<String, Message> clientKeyMessagesList = new HashMap<String, Message>();
        UsageStats stats = new UsageStats();
        stats.BeginSample();
        for (Map.Entry<Message, DeliveryOption> entry : messages.entrySet()) {
            Message message = entry.getKey();
            DeliveryOption deliveryOption = entry.getValue();
            try {
                if (message == null) {
                    throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: message");
                }
                BitSet flagMap = new BitSet();
                long size = 0L;
                Object value = message.getPayload();
                RefObject tempRef_size = new RefObject((Object)size);
                value = this.cacheImpl.safeSerialize(value, this.cacheImpl.getName(), flagMap, this.cacheImpl, (RefObject<Long>)tempRef_size, UserObjectType.CacheItem);
                size = (Long)tempRef_size.argvalue;
                if (this.cacheImpl.getEncryptionEnabled()) {
                    value = CacheHelper.EncryptData((byte[])value, this.cacheImpl.getName());
                }
                if (this.cacheImpl.getCompressionEnabled()) {
                    value = CompressionUtil.Compress((byte[])((byte[])value), (BitSet)flagMap, (long)this.cacheImpl.getCompressionThreshold());
                }
                long expiration = this.GetExpirationTime(message);
                if (this._perfStatsCollector != null && value != null && value instanceof byte[]) {
                    this._perfStatsCollector.incrementAvgItemSize((long)((byte[])value).length);
                }
                clientKeyMessagesList.put(message.getMessageId(), message);
                Alachisoft.NCache.Caching.Messaging.Message serverMessage = new Alachisoft.NCache.Caching.Messaging.Message(message.getMessageId());
                serverMessage.setPayLoad(value);
                serverMessage.setFlagMap(flagMap);
                serverMessage.setCreationTime(NCDateTime.getUTCDate((Date)message.getCreationTime()));
                serverMessage.setMessageMetaData(new MessageMetaData(message.getMessageId()));
                serverMessage.getMessageMetaData().setSubscriptionType(SubscriptionType.Subscriber);
                serverMessage.getMessageMetaData().setTopicName(this.topicName);
                serverMessage.getMessageMetaData().setIsNotify(notifyDeliveryFailure);
                serverMessage.getMessageMetaData().setDeliveryOption(deliveryOption);
                serverMessage.getMessageMetaData().setExpirationTime(expiration);
                serverMessage.getMessageMetaData().setTimeToLive((double)AppUtil.DiffSeconds((Date)new Date()) + new TimeSpan(expiration).getTotalSeconds());
                keyMessageBulk.put(message.getMessageId(), serverMessage);
            }
            catch (IllegalArgumentException ex) {
                throw ex;
            }
            catch (RuntimeException | ParseException e) {
                if (failureResult == null) {
                    failureResult = new HashMap<Message, Exception>();
                }
                failureResult.put(message, e);
            }
        }
        if (keyMessageBulk.size() < 1) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: messages is empty");
        }
        try {
            this.readerWriterLock.AcquireReaderLock();
            Map failedMessagesOnServer = this.cacheImpl.publishMessage(this.topicName, keyMessageBulk, notifyDeliveryFailure);
            if (failedMessagesOnServer != null) {
                if (failureResult == null) {
                    failureResult = new HashMap();
                }
                for (Object messageId : failedMessagesOnServer.keySet()) {
                    failureResult.put((Message)clientKeyMessagesList.get(messageId), (RuntimeException)failedMessagesOnServer.get(messageId));
                }
            }
        }
        finally {
            this.readerWriterLock.ReleaseReaderLock();
        }
        if (this._perfStatsCollector != null) {
            stats.EndSample();
            this._perfStatsCollector.incrementMsecPerMessagePublish(stats.getCurrent());
            this._perfStatsCollector.incrementMessagePublishedPerSec(keyMessageBulk.size() - (failureResult == null ? 0 : failureResult.size()));
        }
        return failureResult != null ? failureResult : new HashMap<Message, Exception>();
    }

    public final void fireDeleteNotification() {
        if (this.deleteEventListener != null) {
            FutureTask<Object> task = new FutureTask<Object>(() -> {
                this.deleteEventListener.onTopicDeleted((Object)this.deleteEventListener, new TopicDeleteEventArgs(this.getName()));
                return null;
            });
            ThreadPool.getInstance().executeTask(task);
        }
    }

    public final int getActiveSubscriptions() {
        return this.subscriptions == null ? 0 : this.subscriptions.size();
    }

    public final void subscribe(TopicSubscriptionImpl subscription) throws Exception {
        this.subscribe(subscription, SubscriptionPolicyType.NonDurableExclusiveSubscription);
    }

    public void subscribe(TopicSubscriptionImpl subscription, SubscriptionPolicyType subscriptionPolicyType) throws CacheException {
        try {
            this.readerWriterLock.AcquireReaderLock();
            if (this.isDisposed) {
                return;
            }
            this.cacheImpl.subscribe(this.getName(), subscription.getSubscriptionName(), this.getSearchOptions() == TopicSearchOptions.ByName ? SubscriptionType.Subscriber : SubscriptionType.PatternSubscription, subscription.getCreationTime(), subscription.getExpiration(), subscriptionPolicyType);
        }
        finally {
            this.readerWriterLock.ReleaseReaderLock();
        }
    }

    public final void unSubscribe(TopicSubscriptionImpl subscription, boolean remove) throws Exception {
        this.unSubscribe(subscription, remove, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSubscribe(TopicSubscriptionImpl subscription, boolean remove, boolean dispose) throws Exception {
        try {
            SubscriptionIdentifier subscriptionIdentifier = new SubscriptionIdentifier(subscription.getSubscriptionName(), subscription.getSubscriptionPolicyType());
            this.readerWriterLock.AcquireReaderLock();
            if (this.isDisposed) {
                return;
            }
            this.cacheImpl.unSubscribe(this.getName(), subscription.getSubscriptionName(), subscription.getSubscriptionPolicyType(), this.getSearchOptions() == TopicSearchOptions.ByName ? SubscriptionType.Subscriber : SubscriptionType.PatternSubscription, dispose);
            if (remove) {
                HashMap<SubscriptionIdentifier, TopicSubscriptionImpl> hashMap = this.subscriptions;
                synchronized (hashMap) {
                    this.subscriptions.remove(subscriptionIdentifier);
                }
            }
            this.parent.stopPollingIfRequired(this);
        }
        finally {
            this.readerWriterLock.ReleaseReaderLock();
        }
    }

    public final boolean getHasFailureDeliveryNotification() {
        return this.messageFailedEventListener != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disposeInternal(boolean removeTopic) {
        block14: {
            try {
                this.readerWriterLock.AcquireWriterLock();
                if (this.isDisposed) {
                    return;
                }
                if (this.refCount.get() > 0) {
                    this.refCount.decrementAndGet();
                }
                if (removeTopic) {
                    this.refCount.set(0);
                }
                if (this.refCount.get() != 0 || this.isDisposed) break block14;
                if (this.subscriptions != null) {
                    HashMap<SubscriptionIdentifier, TopicSubscriptionImpl> hashMap = this.subscriptions;
                    synchronized (hashMap) {
                        for (Map.Entry<SubscriptionIdentifier, TopicSubscriptionImpl> pair : this.subscriptions.entrySet()) {
                            pair.getValue().dispose();
                        }
                        this.subscriptions.clear();
                    }
                }
                if (this.getHasFailureDeliveryNotification()) {
                    this.cacheImpl.unSubscribe(this.topicName, this.publisherId, SubscriptionPolicyType.EventSubscription, SubscriptionType.Publisher, removeTopic);
                }
                this.messageFailedEventListener = null;
                this.subscriptions = null;
                this.isDisposed = true;
            }
            catch (Exception exception) {
            }
            finally {
                this.readerWriterLock.ReleaseWriterLock();
            }
        }
    }

    public final void IncrementRefCount() {
        this.refCount.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reRegisterSubscribers(TopicSearchOptions searchOption) throws CacheException {
        try {
            this.readerWriterLock.AcquireReaderLock();
            if (this.isDisposed) {
                return;
            }
            HashMap<SubscriptionIdentifier, TopicSubscriptionImpl> hashMap = this.subscriptions;
            synchronized (hashMap) {
                switch (searchOption) {
                    case ByPattern: {
                        for (Map.Entry<SubscriptionIdentifier, TopicSubscriptionImpl> subscriptions : this.subscriptions.entrySet()) {
                            this.cacheImpl.subscribe(this.getName(), subscriptions.getValue().getSubscriptionName(), SubscriptionType.PatternSubscription, subscriptions.getValue().getCreationTime(), subscriptions.getValue().getExpiration(), subscriptions.getValue().getSubscriptionPolicyType());
                        }
                        break;
                    }
                    case ByName: {
                        for (Map.Entry<SubscriptionIdentifier, TopicSubscriptionImpl> subscriptions : this.subscriptions.entrySet()) {
                            TopicSubscriptionImpl topicSubscription = subscriptions.getValue();
                            this.cacheImpl.subscribe(this.getName(), topicSubscription.getSubscriptionName(), SubscriptionType.Subscriber, topicSubscription.getCreationTime(), topicSubscription.getExpiration(), topicSubscription.getSubscriptionPolicyType());
                        }
                        break;
                    }
                }
            }
        }
        finally {
            this.readerWriterLock.ReleaseReaderLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSyncData(List<MessageItem> messageList, String topicName) {
        try {
            this.readerWriterLock.AcquireReaderLock();
            if (this.isDisposed) {
                return;
            }
            for (MessageItem messageItem : messageList) {
                try {
                    this.GetMessagePayLoad(messageItem);
                    ArrayList<SubscriptionIdentifier> subscriptionReciepientList = null;
                    if (messageItem.getSubscriptionType() == SubscriptionType.Publisher || messageItem.getDeliveryOption() == DeliveryOption.Any) {
                        subscriptionReciepientList = messageItem.getSubscriptionIdentifierList();
                    } else {
                        HashMap<SubscriptionIdentifier, TopicSubscriptionImpl> hashMap = this.subscriptions;
                        synchronized (hashMap) {
                            subscriptionReciepientList = new ArrayList<SubscriptionIdentifier>(this.subscriptions.keySet());
                        }
                    }
                    for (SubscriptionIdentifier info : subscriptionReciepientList) {
                        switch (messageItem.getSubscriptionType()) {
                            case PatternSubscription: 
                            case Subscriber: {
                                if (!this.subscriptions.containsKey(info)) break;
                                this.subscriptions.get(info).onMessageRecieved(this.GetMessageEventArgs(messageItem, topicName));
                                break;
                            }
                            case PatternPublisher: 
                            case Publisher: {
                                if (!this.publisherId.equals(info.getSubscriptionName())) break;
                                this.OnMessageDeliveryFailure(this.GetMessageFailureEventArgs(messageItem));
                            }
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        finally {
            this.readerWriterLock.ReleaseReaderLock();
        }
    }

    public void unSubscribeEventTopic(TopicSubscriptionImpl subscription, boolean remove) throws Exception {
        try {
            this.readerWriterLock.AcquireReaderLock();
            this.unSubscribe(subscription, remove);
            this._eventRegistered = false;
        }
        finally {
            this.readerWriterLock.ReleaseReaderLock();
        }
    }

    private long GetExpirationTime(Message message) {
        long expiration = 0L;
        if (message.getExpirationTime() != null) {
            expiration = message.getExpirationTime().getTotalTicks();
        } else if (this.getExpirationTime() != null) {
            expiration = this.getExpirationTime().getTotalTicks();
        }
        return expiration;
    }

    private MessageFailedEventArgs GetMessageFailureEventArgs(MessageItem messageItem) {
        Message message = this.GetMessage(messageItem);
        return new MessageFailedEventArgs(message, messageItem.getDeliveryOption(), (Topic)this, messageItem.getMessageFailureReason());
    }

    private MessageEventArgs GetMessageEventArgs(MessageItem messageItem, String topicName) {
        Message message = this.GetMessage(messageItem);
        return new MessageEventArgs(message, messageItem.getDeliveryOption(), (Topic)this, topicName);
    }

    private Message GetMessage(MessageItem messageItem) {
        PayLoadDeserializationJson payLoadDeserializationJson = new PayLoadDeserializationJson();
        Message message = new Message(messageItem.getPayload(), messageItem.getExpirationTime());
        message.setSerializationDataInternal((PayloadDeserializer)payLoadDeserializationJson, messageItem.getSerializedJson());
        message.setCreationTime(messageItem.getCreationTime());
        message.setMessageId(messageItem.getMessageId());
        return message;
    }

    private void GetMessagePayLoad(MessageItem messageItem) throws CacheException, IOException {
        if (messageItem != null && messageItem.getPayload() != null) {
            EventUtil.MessageItemType type = EventUtil.getMessageItemType(messageItem);
            switch (type) {
                case MessageItems: {
                    this.GetMessageItemPayLoad(messageItem);
                    break;
                }
                case MessageEventItem: {
                    messageItem.setPayload(this.GetMessageEventItemPayLoad((MessageEventItem)messageItem.getPayload()));
                    break;
                }
                case MessageEventItems: {
                    MessageEventItem[] items = (MessageEventItem[])messageItem.getPayload();
                    if (items == null) break;
                    MessageEventItem[] payLoads = new MessageEventItem[items.length];
                    for (int count = 0; count < items.length; ++count) {
                        payLoads[count] = this.GetMessageEventItemPayLoad(items[count]);
                    }
                    messageItem.setPayload(payLoads);
                    break;
                }
                case MessageEventCollections: {
                    MessageCollectionEventItem[] citems = (MessageCollectionEventItem[])messageItem.getPayload();
                    if (citems == null) break;
                    for (MessageCollectionEventItem eventItem : citems) {
                        messageItem.setPayload(this.GetMessageEventCollectionPayLoad(eventItem));
                    }
                    break;
                }
                case MessageEventCollection: {
                    messageItem.setPayload(this.GetMessageEventCollectionPayLoad((MessageCollectionEventItem)messageItem.getPayload()));
                }
            }
        }
    }

    private MessageCollectionEventItem GetMessageEventCollectionPayLoad(MessageCollectionEventItem eventItem) throws OperationFailedException {
        if (eventItem != null && eventItem.getCollectionItem() != null) {
            eventItem.setCollectionItem(this.cacheImpl.safeDeserialize(eventItem.getCollectionItem(), this.cacheImpl.getName(), new BitSet(), this.cacheImpl, UserObjectType.CacheItem, null));
        }
        return eventItem;
    }

    private MessageEventItem GetMessageEventItemPayLoad(MessageEventItem eventItem) throws CacheException, IOException {
        if (eventItem != null && eventItem.getItem() != null) {
            if (EventCacheItemWrapperInternal.getFlagMap(eventItem.getItem()) != null) {
                if (EventCacheItemWrapperInternal.getFlagMap(eventItem.getItem()).IsBitSet((byte)2)) {
                    EventCacheItemWrapperInternal.setValue(eventItem.getItem(), CompressionUtil.Decompress((byte[])((byte[])eventItem.getItem().getValue(null))));
                }
                this.IncrementCompressionCounter((byte[])eventItem.getItem().getValue(null));
            }
            if (this.cacheImpl.getEncryptionEnabled()) {
                UsageStats statsEncryption = new UsageStats();
                statsEncryption.BeginSample();
                EventCacheItemWrapperInternal.setValue(eventItem.getItem(), CacheHelper.DecryptData((byte[])eventItem.getItem().getValue(null), this.cacheImpl.getName()));
                EventCacheItemWrapperInternal.setValue(eventItem.getOldItem(), CacheHelper.DecryptData((byte[])eventItem.getOldItem().getValue(null), this.cacheImpl.getName()));
                statsEncryption.EndSample();
                this.IncrementEncryptionCounter(statsEncryption);
            }
            EventCacheItemWrapperInternal.setValue(eventItem.getItem(), this.cacheImpl.safeDeserialize(eventItem.getItem().getValue(null), this.cacheImpl.getName(), EventCacheItemWrapperInternal.getFlagMap(eventItem.getItem()), this.cacheImpl, UserObjectType.CacheItem, null));
            EventCacheItemWrapperInternal.setValue(eventItem.getOldItem(), this.cacheImpl.safeDeserialize(eventItem.getOldItem().getValue(null), this.cacheImpl.getName(), EventCacheItemWrapperInternal.getFlagMap(eventItem.getItem()), this.cacheImpl, UserObjectType.CacheItem, null));
        }
        return eventItem;
    }

    private void GetMessageItemPayLoad(MessageItem messageItem) throws CacheException, IOException {
        if (messageItem != null && !messageItem.getDeserialized()) {
            if (messageItem.getPayload() != null && messageItem.getFlag().IsBitSet((byte)2)) {
                messageItem.setPayload(CompressionUtil.Decompress((byte[])((byte[])messageItem.getPayload())));
            }
            this.IncrementCompressionCounter((byte[])messageItem.getPayload());
            if (this.cacheImpl.getEncryptionEnabled()) {
                UsageStats statsEncryption = new UsageStats();
                statsEncryption.BeginSample();
                messageItem.setPayload(CacheHelper.DecryptData((byte[])messageItem.getPayload(), this.cacheImpl.getName()));
                statsEncryption.EndSample();
                this.IncrementEncryptionCounter(statsEncryption);
            }
            messageItem.setSerializedJson(messageItem.getPayload());
            messageItem.setPayload(this.cacheImpl.safeDeserialize(messageItem.getPayload(), this.cacheImpl.getName(), messageItem.getFlag(), this.cacheImpl, UserObjectType.CacheItem, null));
            messageItem.setDeserialized(true);
        }
    }

    private void IncrementEncryptionCounter(UsageStats statsEncryption) {
        if (this._perfStatsCollector != null) {
            this._perfStatsCollector.incrementMsecPerDecryptionSample(statsEncryption.getCurrent());
        }
    }

    private void IncrementCompressionCounter(byte[] messageItem) {
        if (this._perfStatsCollector != null && messageItem != null) {
            this._perfStatsCollector.incrementAvgItemSize((long)messageItem.length);
        }
    }

    private void UnRegisterPublisher(String publisherId) throws Exception {
        this.cacheImpl.unSubscribe(this.topicName, publisherId, SubscriptionPolicyType.NonDurableExclusiveSubscription, this.getSearchOptions() == TopicSearchOptions.ByName ? SubscriptionType.Publisher : SubscriptionType.PatternPublisher, true);
        this.parent.stopPollingIfRequired(this);
    }

    private void RegisterPublisher(String publisherId) throws Exception {
        long expiration = TimeSpan.MaxValue.getTotalTicks();
        this.cacheImpl.subscribe(this.topicName, publisherId, this.getSearchOptions() == TopicSearchOptions.ByName ? SubscriptionType.Publisher : SubscriptionType.PatternPublisher, HelperFxn.getTicks((Date)new Date()), expiration, SubscriptionPolicyType.NonDurableExclusiveSubscription);
        this.parent.startPolling();
    }

    private void OnMessageDeliveryFailure(final MessageFailedEventArgs args) {
        try {
            if (this.messageFailedEventListener != null) {
                final TopicImpl topicImpl = this;
                Runnable asyncTask = new Runnable(){

                    @Override
                    public void run() {
                        TopicImpl.this.messageFailedEventListener.onMessageDeliveryFailure((Object)topicImpl, args);
                    }
                };
                ThreadPool.getInstance().executeTask(asyncTask);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void addTopicDeletedListener(TopicListener deleteTopicListener) {
        this.deleteEventListener = deleteTopicListener;
    }

    public void removeTopicDeletedListener() {
        this.deleteEventListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageDeliveryFailureListener(TopicListener messageFailedEventListener) throws Exception {
        Object object = this.syncLock;
        synchronized (object) {
            this.messageFailedEventListener = messageFailedEventListener;
            ++this.refPublisherCount;
        }
        if (this.refPublisherCount == 1) {
            this.RegisterPublisher(this.publisherId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageDeliveryFailureListener() throws Exception {
        Object object = this.syncLock;
        synchronized (object) {
            this.messageFailedEventListener = null;
            --this.refPublisherCount;
        }
        if (this.refPublisherCount == 0) {
            this.UnRegisterPublisher(this.publisherId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TopicSubscription RegisterSubscriptions(String subscriptionName, MessageReceivedListener onMessageReceivedListener, DeliveryMode deliveryMode, SubscriptionPolicyType subscriptionPolicy, TimeSpan timeSpan) throws CacheException {
        try {
            SubscriptionIdentifier subscriptionIdentifier;
            TopicSubscriptionImpl topicSubscription;
            this.readerWriterLock.AcquireReaderLock();
            if (deliveryMode == null) {
                deliveryMode = DeliveryMode.Sync;
            }
            if (subscriptionPolicy == null) {
                subscriptionPolicy = SubscriptionPolicyType.NonDurableExclusiveSubscription;
            }
            if ((topicSubscription = this.GetExistingSubscription(subscriptionIdentifier = new SubscriptionIdentifier(subscriptionName, subscriptionPolicy), subscriptionPolicy)) == null) {
                topicSubscription = new TopicSubscriptionImpl(this, subscriptionName, subscriptionPolicy, onMessageReceivedListener, deliveryMode);
                Date creationTime = new Date();
                topicSubscription.setCreationTime(HelperFxn.getTicks((Date)creationTime));
                topicSubscription.setSubscriptionPolicy(subscriptionPolicy);
                if (timeSpan == null) {
                    topicSubscription.setExpiration(TimeSpan.MaxValue.getTotalTicks());
                } else {
                    topicSubscription.setExpiration(timeSpan.getTotalTicks());
                }
                this.subscribe(topicSubscription, subscriptionPolicy);
                HashMap<SubscriptionIdentifier, TopicSubscriptionImpl> hashMap = this.subscriptions;
                synchronized (hashMap) {
                    TopicSubscriptionImpl existingSubscription = this.GetExistingSubscription(subscriptionIdentifier, subscriptionPolicy);
                    if (existingSubscription != null) {
                        TopicSubscriptionImpl topicSubscriptionImpl = existingSubscription;
                        return topicSubscriptionImpl;
                    }
                    this.subscriptions.put(subscriptionIdentifier, topicSubscription);
                }
                this.parent.onSubscriptionCreated(this, topicSubscription);
            }
            TopicSubscriptionImpl topicSubscriptionImpl = topicSubscription;
            return topicSubscriptionImpl;
        }
        finally {
            this.readerWriterLock.ReleaseReaderLock();
        }
    }

    private TopicSubscriptionImpl GetExistingSubscription(SubscriptionIdentifier subscriptionIdentifier, SubscriptionPolicyType subscriptionPolicy) throws CacheException {
        TopicSubscriptionImpl topicSubscription = this.subscriptions.get(subscriptionIdentifier);
        if (topicSubscription != null) {
            if ((topicSubscription.getSubscriptionPolicyType() != SubscriptionPolicyType.DurableSharedSubscription || subscriptionPolicy != SubscriptionPolicyType.DurableSharedSubscription) && subscriptionPolicy != SubscriptionPolicyType.EventSubscription) {
                throw new OperationFailedException(20005, ErrorMessages.getErrorMessage((int)20005, (String[])new String[0]));
            }
            topicSubscription.UpdateCount();
        }
        return topicSubscription;
    }

    private void ValidateInput(MessageReceivedListener messageReceivedListener) throws OperationFailedException {
        if (this.isDisposed) {
            throw new OperationFailedException(20007, ErrorMessages.getErrorMessage((int)20007, (String[])new String[]{this.getName()}));
        }
        if (messageReceivedListener == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: messageReceivedListener");
        }
    }
}

