/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Caching.CacheSynchronization.ISyncCache;
import Alachisoft.NCache.Caching.CacheSynchronization.ISyncCacheEventsListener;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.CompressionUtil;
import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import com.alachisoft.ncache.client.Cache;
import com.alachisoft.ncache.client.CacheClearedListener;
import com.alachisoft.ncache.client.CacheConnectionOptions;
import com.alachisoft.ncache.client.CacheDataModificationListener;
import com.alachisoft.ncache.client.CacheEventArg;
import com.alachisoft.ncache.client.CacheItem;
import com.alachisoft.ncache.client.CacheItemWrapperInternal;
import com.alachisoft.ncache.client.CacheManager;
import com.alachisoft.ncache.client.CacheStatusEventListener;
import com.alachisoft.ncache.client.CacheStatusNotificationType;
import com.alachisoft.ncache.client.CacheStoppedListener;
import com.alachisoft.ncache.client.ClusterEvent;
import com.alachisoft.ncache.client.Credentials;
import com.alachisoft.ncache.client.ServerInfo;
import com.alachisoft.ncache.client.internal.caching.CacheEvent;
import com.alachisoft.ncache.client.internal.caching.CacheHelper;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.PollNotificationListener;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.caching.ReadMode;
import com.alachisoft.ncache.runtime.caching.ReadThruOptions;
import com.alachisoft.ncache.runtime.caching.datasource.ResyncOptions;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.events.ListenerType;
import com.alachisoft.ncache.runtime.exceptions.AggregateException;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.OperationNotSupportedException;
import com.alachisoft.ncache.runtime.exceptions.StreamAlreadyLockedException;
import com.alachisoft.ncache.runtime.exceptions.StreamException;
import com.alachisoft.ncache.runtime.exceptions.StreamNotFoundException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import tangible.DotNetToJavaStringHelper;
import tangible.RefObject;

public class SyncCache
implements ISyncCache,
ICompactSerializable,
Serializable,
CacheStatusEventListener,
CacheDataModificationListener,
CacheClearedListener,
CacheStoppedListener,
PollNotificationListener {
    private CacheImpl _syncCache;
    private String _cacheId;
    private String _server;
    private int _port;
    private ArrayList _synEventListeners = new ArrayList();
    private ArrayList _synPollEventListeners = new ArrayList();
    private boolean _modeInproc = false;
    private CacheDataModificationListener _updateListener;
    private CacheDataModificationListener _removedListener;
    private CacheClearedListener _cacheClearListener;
    private CacheStoppedListener cacheStoppedListener;
    private PollNotificationListener pollNotificationListener;

    public SyncCache(String cacheId, String server, int port, boolean isInproc) {
        this._cacheId = cacheId;
        this._server = server;
        this._port = port;
        this._modeInproc = isInproc;
    }

    @Deprecated
    public SyncCache() {
    }

    public boolean getIsModeInProc() {
        return this._modeInproc;
    }

    public void cacheCleared() {
        if (this._synEventListeners != null) {
            for (Object eventListener : this._synEventListeners) {
                ((ISyncCacheEventsListener)eventListener).CacheCleared();
            }
        }
    }

    public void itemChangedListener(String key, CacheEventArg eventArgs) {
        block2: {
            block3: {
                if (this._synEventListeners == null) break block2;
                if (eventArgs.getEventType() != EventType.ItemUpdated) break block3;
                for (Object eventListener : this._synEventListeners) {
                    ((ISyncCacheEventsListener)eventListener).SyncItemUpdated(key);
                }
                break block2;
            }
            if (eventArgs.getEventType() != EventType.ItemRemoved) break block2;
            for (Object eventListener : this._synEventListeners) {
                ((ISyncCacheEventsListener)eventListener).SyncItemRemoved(key);
            }
        }
    }

    public void itemRemovedListener(String key, CacheEventArg eventArgs) {
        if (this._synEventListeners != null) {
            for (Object eventListener : this._synEventListeners) {
                ((ISyncCacheEventsListener)eventListener).SyncItemRemoved(key);
            }
        }
    }

    public Object Get(String key, RefObject<Long> version, RefObject<BitSet> flag, RefObject<Date> absoluteExpiration, RefObject<TimeSpan> slidingExpiration, RefObject<String> group, RefObject<HashMap> queryInfo, RefObject<CacheDependency> cacheDependency, RefObject<ResyncOptions> resyncOptions, RefObject<CacheItemPriority> priority) throws Exception {
        Object val = null;
        CacheItem item = null;
        if (this._syncCache != null) {
            val = this._syncCache.getSerializedObject(key, new ReadThruOptions(ReadMode.None, ""), version, flag, absoluteExpiration, slidingExpiration, group, queryInfo, cacheDependency, resyncOptions, priority);
            CacheItem cacheItem = item = val instanceof CacheItem ? (CacheItem)val : null;
            if (item == null) {
                return null;
            }
            if (this._modeInproc) {
                if (item.getValue(Object.class) instanceof byte[] && CacheItemWrapperInternal.getFlagValue(item).IsBitSet((byte)2)) {
                    try {
                        item.setValue(CompressionUtil.Decompress((byte[])((byte[])item.getValue(Object.class))));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                item.setValue(CacheHelper.DecryptData((byte[])item.getValue(Object.class), this._syncCache.getSerializationContext()));
                item.setValue(this._syncCache.getDeserializedObject(item.getValue(Object.class), this._syncCache.getSerializationContext(), CacheItemWrapperInternal.getFlagValue(item)));
            }
        }
        return item.getValue(Object.class);
    }

    public void RegisterSyncKeyNotifications(String key, ISyncCacheEventsListener eventListener, ListenerType listenerType) throws GeneralFailureException, OperationFailedException {
        try {
            if (!this._synEventListeners.contains(eventListener)) {
                this._synEventListeners.add(eventListener);
            }
            if (this._syncCache != null && listenerType == ListenerType.PushBasedNotification) {
                this._syncCache.addCacheDataNotificationListener(new String[]{key}, this._updateListener, EnumSet.of(EventType.ItemUpdated, EventType.ItemRemoved), EventDataFilter.None, true);
            }
        }
        catch (Exception e) {
            throw new OperationFailedException(e.getMessage());
        }
    }

    public void UnRegisterSyncKeyNotifications(String key, ISyncCacheEventsListener eventListener) throws GeneralFailureException, OperationFailedException {
        if (!this._synEventListeners.contains(eventListener)) {
            this._synEventListeners.remove(eventListener);
        }
    }

    public String getCacheId() {
        return this._cacheId;
    }

    public void setCacheId(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void Initialize(String userId, String password) throws Exception {
        try {
            CacheConnectionOptions cacheConnectionOptions = new CacheConnectionOptions();
            if (DotNetToJavaStringHelper.isNullOrEmpty((String)this._server) && this._port > 0) {
                cacheConnectionOptions.getServerList().add(new ServerInfo(this._server, this._port));
            }
            cacheConnectionOptions.setLoadBalance(true);
            if (!DotNetToJavaStringHelper.isNullOrEmpty((String)userId) && !DotNetToJavaStringHelper.isNullOrEmpty((String)password)) {
                cacheConnectionOptions.setUserCredentials(new Credentials(userId, password));
            }
            this._syncCache = CacheManager.getCache(this._cacheId, cacheConnectionOptions, false, false);
            this._updateListener = this;
            this._removedListener = this;
            this._cacheClearListener = this;
            this.cacheStoppedListener = cacheName -> this.onCacheStopped(cacheName);
            this.pollNotificationListener = () -> this.onPollNotified();
            this._synEventListeners = new ArrayList();
            if (this._syncCache != null) {
                this._syncCache.setExceptionEnabled(true);
                this._syncCache.getNotificationService().addCacheClearedListener(this._cacheClearListener);
            }
        }
        catch (Exception ex) {
            throw new Exception("Unable to initialize " + this._cacheId + " while creating CacheSyncDependency", ex);
        }
    }

    public void Dispose() {
        if (this._syncCache != null) {
            this.DisposeInternal(this._syncCache);
        }
    }

    public void RegisterBulkSyncKeyNotifications(String[] keys, ISyncCacheEventsListener eventListener, ListenerType listenerType) throws GeneralFailureException, OperationFailedException {
        try {
            if (!this._synEventListeners.contains(eventListener)) {
                this._synEventListeners.add(eventListener);
            }
            if (this._syncCache != null && listenerType == ListenerType.PushBasedNotification) {
                this._syncCache.addCacheDataNotificationListener(keys, this._updateListener, EnumSet.of(EventType.ItemUpdated, EventType.ItemRemoved), EventDataFilter.None, true);
            }
        }
        catch (Exception e) {
            throw new OperationFailedException(e.getMessage());
        }
    }

    public void UnRegisterBulkSyncKeyNotifications(String key, ISyncCacheEventsListener eventListener) throws GeneralFailureException, OperationFailedException {
        if (!this._synEventListeners.contains(eventListener)) {
            this._synEventListeners.remove(eventListener);
        }
    }

    public ListenerType GetNotificationType(String cacheId) {
        return ListenerType.PushBasedNotification;
    }

    public void IsAuthorized(String cacheID, String password, String userId) throws OperationFailedException {
        if (cacheID == null) {
            throw new OperationFailedException(10004, ErrorMessages.getErrorMessage((int)10004, (String[])new String[0]));
        }
        if (!this._syncCache.checkUserAuthorization(cacheID.toLowerCase(), password, userId)) {
            throw new SecurityException("You do not have permissions to initialize this cache");
        }
    }

    public void PerformTouch(ArrayList<String> keys) throws OperationNotSupportedException, CommandException, GeneralFailureException, StreamNotFoundException, ConfigurationException, StreamException, AggregateException, OperationFailedException, StreamAlreadyLockedException, LicensingException, com.alachisoft.ncache.runtime.exceptions.SecurityException {
        this._syncCache.touch(keys);
    }

    private void DisposeInternal(Object param) {
        try {
            ((Cache)param).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void serialize(NCacheObjectOutput writer) throws IOException {
        writer.writeObject((Object)this._cacheId);
        writer.writeObject((Object)this._server);
        writer.writeInt(this._port);
    }

    public void deserialize(NCacheObjectInput reader) throws IOException, ClassNotFoundException {
        Object tempVar = reader.readObject();
        this._cacheId = (String)(tempVar instanceof String ? tempVar : null);
        Object tempVar2 = reader.readObject();
        this._server = (String)(tempVar2 instanceof String ? tempVar2 : null);
        this._port = reader.readInt();
    }

    public void cacheItemAdded(CacheEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void cacheItemRemoved(CacheEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void cacheItemUpdated(CacheEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void onCacheCleared() {
        this.cacheCleared();
    }

    @Override
    public void onCacheStopped(String cacheName) {
        if (this._synEventListeners != null) {
            for (Object eventListener : this._synEventListeners) {
                ((ISyncCacheEventsListener)eventListener).CacheStopped(cacheName);
            }
        }
    }

    @Override
    public void onPollNotified() {
        if (this._synEventListeners != null) {
            for (Object eventListener : this._synPollEventListeners) {
                ((ISyncCacheEventsListener)eventListener).PollEventNotified();
            }
        }
    }

    @Override
    public void onCacheStatusChanged(ClusterEvent event) {
        if (event.getEventType() == CacheStatusNotificationType.CacheStopped && this._synEventListeners != null) {
            for (Object eventListener : this._synEventListeners) {
                ((ISyncCacheEventsListener)eventListener).CacheStopped(event.getCacheId());
            }
        }
        if (event.getEventType() == CacheStatusNotificationType.MemberJoined) {
            // empty if block
        }
        if (event.getEventType() == CacheStatusNotificationType.MemberLeft) {
            // empty if block
        }
    }

    @Override
    public void onCacheDataModified(String key, CacheEventArg eventArgs) {
        if (eventArgs != null) {
            switch (eventArgs.getEventType()) {
                case ItemUpdated: {
                    this.itemChangedListener(key, eventArgs);
                    break;
                }
                case ItemRemoved: {
                    this.itemRemovedListener(key, eventArgs);
                }
            }
        }
    }

    @Override
    public void onCacheCleared(String cacheName) {
        this.cacheCleared();
    }
}

