/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import com.alachisoft.ncache.client.EventUtil;
import com.alachisoft.ncache.client.internal.caching.EventManager;
import com.alachisoft.ncache.client.internal.messaging.MessageCollectionEventItem;
import com.alachisoft.ncache.client.internal.messaging.MessageEventItem;
import com.alachisoft.ncache.runtime.caching.MessageEventArgs;
import com.alachisoft.ncache.runtime.caching.messaging.MessageReceivedListener;

public class SelectiveEventMessageReceivedListener
implements MessageReceivedListener {
    EventManager _eventManager = null;

    public SelectiveEventMessageReceivedListener(EventManager eventManager) {
        this._eventManager = eventManager;
    }

    public void onMessageReceived(Object sender, MessageEventArgs args) {
        EventUtil.MessageItemType type = SelectiveEventMessageReceivedListener.GetMessageItemType(args);
        switch (type) {
            case MessageEventItem: {
                this._eventManager.onSelectiveEventsMessageRecieved((MessageEventItem)args.getMessage().getPayload());
                break;
            }
            case MessageEventItems: {
                MessageEventItem[] messages = (MessageEventItem[])args.getMessage().getPayload();
                if (messages == null) break;
                for (MessageEventItem item : messages) {
                    this._eventManager.onSelectiveEventsMessageRecieved(item);
                }
                break;
            }
        }
    }

    static EventUtil.MessageItemType GetMessageItemType(MessageEventArgs messageEventArgs) {
        if (messageEventArgs != null && messageEventArgs.getMessage() != null && messageEventArgs.getMessage().getPayload() != null) {
            if (messageEventArgs.getMessage().getPayload() instanceof MessageEventItem[]) {
                return EventUtil.MessageItemType.MessageEventItems;
            }
            if (messageEventArgs.getMessage().getPayload() instanceof MessageEventItem) {
                return EventUtil.MessageItemType.MessageEventItem;
            }
            if (messageEventArgs.getMessage().getPayload() instanceof MessageCollectionEventItem) {
                return EventUtil.MessageItemType.MessageEventCollection;
            }
            if (messageEventArgs.getMessage().getPayload() instanceof MessageCollectionEventItem[]) {
                return EventUtil.MessageItemType.MessageEventCollections;
            }
            return EventUtil.MessageItemType.MessageItems;
        }
        return EventUtil.MessageItemType.MessageItems;
    }
}

