/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Caching.TagComparisonType;
import com.alachisoft.ncache.client.CacheReader;
import com.alachisoft.ncache.client.QueryCommand;
import com.alachisoft.ncache.client.TagSearchOptions;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.util.ConversionUtil;
import com.alachisoft.ncache.client.services.SearchService;
import com.alachisoft.ncache.runtime.caching.Tag;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tangible.DotNetToJavaStringHelper;

class SearchServiceImpl
implements SearchService {
    protected CacheImpl cacheContainer;

    SearchServiceImpl(CacheImpl cache) {
        this.cacheContainer = cache;
    }

    CacheImpl getCacheContainer() {
        return this.cacheContainer;
    }

    void setCacheContainer(CacheImpl value) {
        this.cacheContainer = value;
    }

    @Override
    public int executeNonQuery(QueryCommand queryCommand) throws CacheException {
        if (queryCommand == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: queryCommand");
        }
        if (queryCommand.getQuery() == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: query");
        }
        if (queryCommand.getQuery() == "") {
            throw new IllegalArgumentException("Value cannot be empty.\nParameter name: query");
        }
        return this.cacheContainer.executeNonQuery(queryCommand.getQuery(), queryCommand.getParameters());
    }

    @Override
    public CacheReader executeReader(QueryCommand queryCommand) throws CacheException {
        return this.executeReader(queryCommand, true, -1);
    }

    @Override
    public CacheReader executeReader(QueryCommand queryCommand, boolean getData, int chunkSize) throws CacheException {
        if (queryCommand == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: queryCommand");
        }
        if (queryCommand.getQuery() == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: query");
        }
        if (queryCommand.getQuery() == "") {
            throw new IllegalArgumentException("Value cannot be empty.\nParameter name: query");
        }
        return this.cacheContainer.executeReader(queryCommand.getQuery(), queryCommand.getParameters(), getData, chunkSize);
    }

    @Override
    public <T> T executeScalar(QueryCommand queryCommand, Class<?> cls) throws CacheException {
        if (queryCommand == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: queryCommand");
        }
        if (queryCommand.getQuery() == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: query");
        }
        if (queryCommand.getQuery() == "") {
            throw new IllegalArgumentException("Value cannot be empty.\nParameter name: query");
        }
        T scalarValue = null;
        AutoCloseable reader = null;
        try {
            reader = this.cacheContainer.executeReader(queryCommand.getQuery(), queryCommand.getParameters(), true, -1);
            if (reader != null && reader.read()) {
                scalarValue = reader.getFieldCount() > 1 ? (T)reader.getValue(1, cls) : (T)reader.getValue(0, cls);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    throw new CacheException((Throwable)e);
                }
            }
        }
        return scalarValue;
    }

    @Override
    public void removeByTag(Tag tag) throws CacheException {
        if (tag == null || tag.getTagName() == null) {
            throw new IllegalArgumentException("Tag cannot be null.");
        }
        this.cacheContainer.removeByTag(new Tag[]{tag}, TagComparisonType.BY_TAG);
    }

    @Override
    public void removeByTags(List<Tag> tags, TagSearchOptions searchOptions) throws CacheException {
        if (tags == null) {
            throw new IllegalArgumentException("Tags cannot be null.");
        }
        if (searchOptions == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: searchOptions");
        }
        Tag[] tagsList = ConversionUtil.toArray(tags);
        if (tagsList.length == 0) {
            throw new IllegalArgumentException("At least one Tag required.");
        }
        tagsList = this.removeDuplicateTags(tagsList);
        this.cacheContainer.removeByTag(tagsList, this.getTagComparisonType(searchOptions));
    }

    @Override
    public <T> Map<String, T> getByTag(Tag tag) throws CacheException {
        if (tag == null || tag.getTagName() == null) {
            throw new IllegalArgumentException("Tag cannot be null.");
        }
        return this.cacheContainer.getByTagInternal(new Tag[]{tag}, TagComparisonType.BY_TAG);
    }

    @Override
    public <T> Map<String, T> getByTag(String wildCardExpression) throws CacheException {
        if (wildCardExpression == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: wildCardExpression");
        }
        if (wildCardExpression == "") {
            throw new IllegalArgumentException("Value cannot be empty." + System.lineSeparator() + "Parameter name: wildCardExpression");
        }
        return this.cacheContainer.getByTagInternal(new Tag[]{new Tag(wildCardExpression)}, TagComparisonType.BY_WILDCARDTAG);
    }

    @Override
    public <T> Map<String, T> getByTags(List<Tag> tags, TagSearchOptions searchOptions) throws CacheException {
        if (tags == null) {
            throw new IllegalArgumentException("Tags cannot be null.");
        }
        if (searchOptions == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: searchOptions");
        }
        Tag[] tagsList = ConversionUtil.toArray(tags);
        if (tagsList.length == 0) {
            throw new IllegalArgumentException("At least one Tag required.");
        }
        tagsList = this.removeDuplicateTags(tagsList);
        return this.cacheContainer.getByTagInternal(tagsList, this.getTagComparisonType(searchOptions));
    }

    @Override
    public Collection<String> getKeysByTag(Tag tag) throws CacheException {
        if (tag == null || tag.getTagName() == null) {
            throw new IllegalArgumentException("Tag cannot be null.");
        }
        return this.cacheContainer.getKeysByTag(new Tag[]{tag}, TagComparisonType.BY_TAG);
    }

    @Override
    public Collection<String> getKeysByTag(String wildCardExpression) throws CacheException {
        if (wildCardExpression == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: wildCardExpression");
        }
        if (wildCardExpression == "") {
            throw new IllegalArgumentException("Value cannot be empty." + System.lineSeparator() + "Parameter name: wildCardExpression");
        }
        return this.cacheContainer.getKeysByTag(new Tag[]{new Tag(wildCardExpression)}, TagComparisonType.BY_WILDCARDTAG);
    }

    @Override
    public Collection<String> getKeysByTags(List<Tag> tags, TagSearchOptions searchOptions) throws CacheException {
        if (tags == null) {
            throw new IllegalArgumentException("Tag cannot be null." + System.lineSeparator() + "Parameter name: tags");
        }
        if (searchOptions == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: searchOptions");
        }
        Tag[] tagsArray = ConversionUtil.toArray(tags);
        if (tagsArray.length == 0) {
            throw new IllegalArgumentException("At least one Tag required.");
        }
        tagsArray = this.removeDuplicateTags(tagsArray);
        return this.cacheContainer.getKeysByTag(tagsArray, this.getTagComparisonType(searchOptions));
    }

    @Override
    public void removeGroupData(String group) throws CacheException {
        if (DotNetToJavaStringHelper.isNull((String)group)) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: group");
        }
        this.cacheContainer.removeGroupData(group);
    }

    @Override
    public Collection<String> getGroupKeys(String group) throws CacheException {
        if (DotNetToJavaStringHelper.isNull((String)group)) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: group");
        }
        ArrayList groupKeys = this.cacheContainer.getGroupKeys(group);
        return this.getGenericCollection(groupKeys);
    }

    @Override
    public <T> Map<String, T> getGroupData(String group) throws CacheException {
        if (DotNetToJavaStringHelper.isNull((String)group)) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: group");
        }
        return this.cacheContainer.getGroupData(group);
    }

    Tag[] removeDuplicateTags(Tag[] tags) {
        HashMap keysAndItems = new HashMap(tags.length);
        for (int item = 0; item < tags.length; ++item) {
            if (tags[item] == null || tags[item].getTagName() == null) {
                throw new IllegalArgumentException("Tag cannot be null.");
            }
            keysAndItems.put(tags[item], null);
        }
        Object[] objects = keysAndItems.keySet().toArray();
        Tag[] finalTags = new Tag[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            finalTags[i] = (Tag)objects[i];
        }
        return finalTags;
    }

    TagComparisonType getTagComparisonType(TagSearchOptions type) {
        TagComparisonType tagCompareType = TagComparisonType.DEFAULT;
        switch (type) {
            case ByAllTags: {
                tagCompareType = TagComparisonType.ALL_MATCHING_TAGS;
                break;
            }
            case ByAnyTag: {
                tagCompareType = TagComparisonType.ANY_MATCHING_TAG;
            }
        }
        return tagCompareType;
    }

    Collection<String> getGenericCollection(Collection col) {
        ArrayList<String> keyList = new ArrayList<String>();
        for (Object item : col) {
            keyList.add((String)item);
        }
        return keyList;
    }
}

