/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import com.alachisoft.ncache.client.CacheStream;
import com.alachisoft.ncache.client.StreamMode;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.runtime.exceptions.NotSupportedException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class OutputCacheStream
extends OutputStream
implements CacheStream {
    private CacheImpl _cacheHandle;
    private StreamMode _mode;
    private String _key;
    private long _position;
    private String _lockHandle;
    private boolean _closed;
    private long _length;

    OutputCacheStream(String key, StreamMode mode, CacheImpl cacheHandle, String lockHandle, long length) {
        this._cacheHandle = cacheHandle;
        this._mode = mode;
        this._key = key;
        this._length = length;
        this._lockHandle = lockHandle;
        if (this._mode == StreamMode.Write) {
            this._position = this._length;
        }
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buffer = new byte[]{(byte)b};
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this._mode == StreamMode.Read || this._mode == StreamMode.ReadWithoutLock) {
            throw new IOException("Stream does not support writing.");
        }
        if (this._closed) {
            throw new IOException("Methods were called after the stream was closed.");
        }
        if (b == null) {
            throw new IllegalArgumentException("Value cannot be null.\r\nParameter name: buffer");
        }
        if (off + len > b.length) {
            throw new IOException("Sum of offset and count is greater than the buffer length.");
        }
        if (off < 0 || len < 0) {
            throw new IOException("offset or count is negative.");
        }
        byte[] bufferCopy = b;
        if (len != b.length) {
            bufferCopy = new byte[len];
            HelperFxn.BlockCopy((byte[])b, (int)off, (byte[])bufferCopy, (int)0, (int)len);
            off = 0;
        }
        try {
            this._cacheHandle.writeToStream(this._key, this._lockHandle, bufferCopy, off, (int)this._position, len);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        this._position += (long)len;
    }

    @Override
    public void close() throws IOException {
        this._closed = true;
        if (this._mode == StreamMode.Write) {
            try {
                this._cacheHandle.closeStream(this._key, this._lockHandle);
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
    }

    @Override
    public boolean canRead() {
        return this._mode != StreamMode.Write;
    }

    @Override
    public boolean canSeek() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return this._mode == StreamMode.Write;
    }

    @Override
    public boolean closed() {
        return this._closed;
    }

    @Override
    public void flush() {
    }

    @Override
    public long length() throws Exception {
        if (this._closed) {
            throw new IllegalAccessException("Methods were called after the stream was closed.");
        }
        return this._cacheHandle.getStreamLength(this._key, this._lockHandle);
    }

    @Override
    public long position() throws Exception {
        if (!this.canSeek()) {
            throw new NotSupportedException("Operation not supported");
        }
        return 0L;
    }

    @Override
    public long seek(long offset) throws NotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLength(long value) throws NotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BufferedInputStream getBufferedInputStream(int bufferSize) throws Exception {
        return null;
    }

    @Override
    public BufferedInputStream getBufferedInputStream() throws Exception {
        return null;
    }

    @Override
    public BufferedOutputStream getBufferedOutputStream(int bufferSize) throws Exception {
        return null;
    }

    @Override
    public BufferedOutputStream getBufferedOutputStream() throws Exception {
        return null;
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws Exception {
        return 0;
    }
}

