/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Common.Common;
import com.alachisoft.ncache.client.internal.util.ClientConfiguration;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.GetLCCommandProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.licensing.License;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.ncactivate.utils.AppUtil;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.LocalVerificationFailedException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LicenseVerification {
    private static String _verifyLicense = "";
    private String _server;
    private int _port;
    private Socket _socket;
    private int _requestId;
    private int _editionId;

    public static void main(String[] args) throws Exception {
        LicenseVerification v = new LicenseVerification();
        try {
            v.verifyLicense();
        }
        catch (LicensingException licensingException) {
            // empty catch block
        }
    }

    public LicenseManager.LicenseType verifyLicense() throws LicensingException, Exception {
        LicenseManager.LicenseType type = LicenseManager.LicenseType.None;
        try {
            try {
                this.loadEditionInformation();
            }
            catch (Exception ex) {
                this.loadEditionInfoFromServer();
            }
            if (LicenseManager.Edition.enterpriseCacheServer.equals((Object)LicenseManager.getEditionFromID((int)this._editionId))) {
                type = this.getLicenseTypeFromServer();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    private void loadEditionInformation() throws LicensingException {
        int editionId = AppUtil.getEditionID();
        if (editionId == -1) {
            throw new LicensingException("Invalid install code");
        }
        this._editionId = editionId;
    }

    private void loadEditionInfoFromServer() throws LicensingException {
        try {
            this.connectToLocalService();
            if (this._socket != null) {
                byte[] edId = this.executeCommand(this._socket, 7);
                String editionInfo = License.convertToString((byte[])edId);
                LicenseManager.setEditionInfo((String)editionInfo);
                this._editionId = AppUtil.getEditionIDFromServerValue((String)editionInfo);
            }
        }
        catch (Exception ex) {
            throw new LicensingException(ex.getMessage());
        }
        finally {
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(LicenseVerification.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private LicenseManager.LicenseType verifyLicenseInternally() throws LicensingException, LocalVerificationFailedException {
        LicenseManager.LicenseType type = LicenseManager.LicenseType.Expired;
        try {
            type = LicenseManager.LicenseMode((int)this._editionId, (String)AppUtil.getVersion());
        }
        catch (LicensingException licensingException) {
        }
        catch (SecurityException securityException) {
        }
        catch (LocalVerificationFailedException localVerificationFailedException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    private LicenseManager.LicenseType getLicenseTypeFromServer() throws LicensingException {
        LicenseManager.LicenseType type = LicenseManager.LicenseType.None;
        try {
            this.connectToLocalService();
            if (this._socket != null) {
                byte[] typeResponse = this.executeCommand(this._socket, 8);
                int typeValue = License.Decode((byte[])typeResponse);
                type = LicenseManager.LicenseType.forValue((int)typeValue);
            }
        }
        catch (LicensingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new LicensingException(ex.getMessage());
        }
        finally {
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(LicenseVerification.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return type;
    }

    private LicenseManager.LicenseType verifyLicenseExternally() throws LicensingException {
        LicenseManager.LicenseType type = LicenseManager.LicenseType.Expired;
        try {
            this.connectToLocalService();
            if (this._socket != null) {
                byte[] edId = this.executeCommand(this._socket, 7);
                String editionId = License.convertToString((byte[])edId);
                byte[] stubData = this.executeCommand(this._socket, 1);
                byte[] cpuData = this.executeCommand(this._socket, 2);
                byte[] nicData = this.executeCommand(this._socket, 3);
                byte[] phyCoreData = this.executeCommand(this._socket, 4);
                byte[] logCoreData = this.executeCommand(this._socket, 5);
                byte[] socCountData = this.executeCommand(this._socket, 6);
                type = LicenseManager.LicenseMode((int)this._editionId, (String)AppUtil.getVersion(), (byte[])stubData, (byte[])cpuData, (byte[])nicData, (byte[])phyCoreData, (byte[])logCoreData, (byte[])socCountData);
            }
        }
        catch (LicensingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new LicensingException(ex.getMessage());
        }
        finally {
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(LicenseVerification.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return type;
    }

    private void connectToLocalService() throws Exception {
        this.readConfiguration();
        if (this._server == null || this._server.trim().isEmpty()) {
            throw new Exception("Local server ip is not specified in client.ncconf");
        }
        if (this._port <= 0) {
            throw new Exception("Local server port is not specified in client.ncconf");
        }
        try {
            this._socket = new Socket(this._server, this._port);
            this._socket.setTcpNoDelay(false);
        }
        catch (IOException e) {
            throw new Exception("Failed to connect with the local cache host");
        }
    }

    private byte[] executeCommand(Socket socket, int opCode) throws Exception {
        ResponseProtocol.Response response = null;
        if (this._socket != null) {
            byte[] buffer = this.serializeCommand(opCode);
            this.sendToServer(buffer);
            byte[] lengthBuffer = this.receiveFromServer(10);
            String s = new String(lengthBuffer, 0, 10);
            Object resultItem = null;
            int responseSize = 0;
            try {
                responseSize = Integer.parseInt(s.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            buffer = this.receiveFromServer(responseSize);
            response = ResponseProtocol.Response.parseFrom((byte[])buffer);
        }
        if (response != null && response.getLcDataResponse() != null && response.getLcDataResponse().getLcData() != null) {
            return response.getLcDataResponse().getLcData().toByteArray();
        }
        return null;
    }

    private void sendToServer(byte[] buffer) throws IOException {
        int dataTobeSent = buffer.length;
        OutputStream stream = this._socket.getOutputStream();
        stream.write(buffer);
    }

    private byte[] receiveFromServer(int expectedDataLength) throws IOException {
        InputStream stream = this._socket.getInputStream();
        byte[] buffer = new byte[expectedDataLength];
        int offset = 0;
        while (expectedDataLength > 0) {
            int received = stream.read(buffer, offset, expectedDataLength);
            expectedDataLength -= received;
            offset += received;
            if (received > 0) continue;
            throw new IOException();
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeCommand(int opCode) throws Exception {
        byte[] buffer = null;
        int requestId = this._requestId++;
        GetLCCommandProtocol.GetLCCommand.Builder builder = GetLCCommandProtocol.GetLCCommand.newBuilder();
        builder.setOpCode(opCode);
        builder.setRequestId((long)requestId);
        CommandProtocol.Command.Builder commandBuilder = CommandProtocol.Command.newBuilder();
        commandBuilder = commandBuilder.setGetLCCommand(builder).setRequestID((long)this._requestId).setType(CommandProtocol.Command.Type.GET_LC_DATA);
        buffer = commandBuilder.build().toByteArray();
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            byte[] discardingBuffer = new byte[20];
            stream.write(discardingBuffer);
            byte[] size = new byte[10];
            byte[] commandSize = String.valueOf(buffer.length).getBytes("UTF-8");
            System.arraycopy(commandSize, 0, size, 0, commandSize.length);
            stream.write(size);
            stream.write(buffer);
            buffer = stream.toByteArray();
        }
        return buffer;
    }

    private void dispose() {
    }

    private void readConfiguration() throws Exception {
        ClientConfiguration clientConfig = new ClientConfiguration(null);
        clientConfig.setLoadCacheConfiguration(false);
        clientConfig.loadLocalServerIP();
        this._server = clientConfig.getLocalServerIP();
        this._port = clientConfig.getServerPort();
    }

    private byte[] getLCData() {
        byte[] stubdata = null;
        GetLCCommandProtocol.GetLCCommand.Builder builder = GetLCCommandProtocol.GetLCCommand.newBuilder();
        int requestId = this._requestId++;
        builder.setEditionId(this._editionId);
        builder.setOpCode(1);
        builder.setRequestId((long)requestId);
        CommandProtocol.Command.Builder commandBuilder = CommandProtocol.Command.newBuilder();
        commandBuilder = commandBuilder.setGetLCCommand(builder).setRequestID((long)this._requestId).setType(CommandProtocol.Command.Type.GET_LC_DATA);
        return stubdata;
    }

    public void LoadServerConfiguration() throws SAXException, Exception {
        File hfile;
        String directoryValue = Common.getNCHome();
        String separator = File.separator;
        if (directoryValue != null) {
            if (!directoryValue.endsWith(separator)) {
                directoryValue = directoryValue.concat(separator);
            }
            directoryValue.replaceFirst(";", "");
            directoryValue = directoryValue.concat("config" + separator + "client.ncconf");
        }
        if (!(hfile = new File(directoryValue)).exists()) {
            // empty if block
        }
        Document response = null;
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        response = builder.parse(hfile);
        boolean serverPortFound = false;
        NodeList serverPortNL = response.getElementsByTagName("ncache-server");
        if (serverPortNL != null) {
            Node ncacheServerDetails = serverPortNL.item(0);
            if (ncacheServerDetails == null) {
                throw new Exception("ncache-server options not found in client.ncconf.");
            }
            NamedNodeMap attributes = ncacheServerDetails.getAttributes();
            try {
                Node verifyLicense = attributes.getNamedItem("verify-license");
                _verifyLicense = verifyLicense.getTextContent();
            }
            catch (Exception ex) {
                _verifyLicense = "";
            }
        }
    }
}

