/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import com.alachisoft.ncache.client.CacheStream;
import com.alachisoft.ncache.client.StreamMode;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.runtime.exceptions.NotSupportedException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;

class InputCacheStream
extends InputStream
implements CacheStream {
    private CacheImpl _cacheHandle;
    private StreamMode _mode;
    private String _key;
    private long _position;
    private String _lockHandle;
    private boolean _closed;
    private long _length;

    InputCacheStream(String key, StreamMode mode, CacheImpl cacheHandle, String lockHandle, long length) {
        this._cacheHandle = cacheHandle;
        this._mode = mode;
        this._key = key;
        this._length = length;
        this._lockHandle = lockHandle;
        this._position = 0L;
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        this.read(buffer, 0, 1);
        return buffer[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead;
        if (this._mode == StreamMode.Write) {
            throw new IOException("Stream does not support reading.");
        }
        if (this._closed) {
            throw new IOException("Methods were called after the stream was closed.");
        }
        if (b == null) {
            throw new NullPointerException("buffer");
        }
        if (off + len > b.length) {
            throw new IOException("Sum of offset and count is greater than the buffer length.");
        }
        if (off < 0 || len < 0) {
            throw new IOException("offset or count is negative.");
        }
        try {
            bytesRead = this._cacheHandle.readFromStream(b, this._key, this._lockHandle, off, (int)this._position, len);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        this._position += (long)bytesRead;
        return bytesRead;
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws Exception {
    }

    @Override
    public void close() throws IOException {
        this._closed = true;
        if (this._mode == StreamMode.Read) {
            try {
                this._cacheHandle.closeStream(this._key, this._lockHandle);
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean canRead() {
        return this._mode != StreamMode.Write;
    }

    @Override
    public boolean canSeek() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return this._mode == StreamMode.Write;
    }

    @Override
    public boolean closed() {
        return this._closed;
    }

    @Override
    public void flush() {
    }

    @Override
    public long length() throws Exception {
        if (this._closed) {
            throw new IllegalAccessException("Methods were called after the stream was closed.");
        }
        return this._cacheHandle.getStreamLength(this._key, this._lockHandle);
    }

    @Override
    public long position() throws Exception {
        if (!this.canSeek()) {
            throw new NotSupportedException("Operation not supported");
        }
        return 0L;
    }

    @Override
    public long seek(long offset) throws NotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLength(long value) throws NotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BufferedInputStream getBufferedInputStream(int bufferSize) throws Exception {
        return null;
    }

    @Override
    public BufferedInputStream getBufferedInputStream() throws Exception {
        return null;
    }

    @Override
    public BufferedOutputStream getBufferedOutputStream(int bufferSize) throws Exception {
        return null;
    }

    @Override
    public BufferedOutputStream getBufferedOutputStream() throws Exception {
        return null;
    }
}

