/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Common.EncryptionUtil;
import Alachisoft.NCache.Common.Enum.SerializationFormat;
import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import com.alachisoft.ncache.client.CacheDataModificationListener;
import com.alachisoft.ncache.client.CacheItem;
import com.alachisoft.ncache.client.CacheItemVersion;
import com.alachisoft.ncache.client.CacheItemWrapperInternal;
import com.alachisoft.ncache.client.CacheReader;
import com.alachisoft.ncache.client.CacheStream;
import com.alachisoft.ncache.client.CacheStreamAttributes;
import com.alachisoft.ncache.client.CacheSyncDependency;
import com.alachisoft.ncache.client.ClientInfo;
import com.alachisoft.ncache.client.ContinuousQuery;
import com.alachisoft.ncache.client.LockHandle;
import com.alachisoft.ncache.client.datastructures.DataStructureManager;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.CacheItemRemovedListener;
import com.alachisoft.ncache.client.internal.caching.CacheItemUpdatedListener;
import com.alachisoft.ncache.client.internal.caching.ClientCacheSearchService;
import com.alachisoft.ncache.client.internal.caching.EventTypeInternal;
import com.alachisoft.ncache.client.internal.caching.RemoteCache;
import com.alachisoft.ncache.client.internal.util.ConversionUtil;
import com.alachisoft.ncache.client.services.MessagingService;
import com.alachisoft.ncache.client.services.NotificationService;
import com.alachisoft.ncache.client.services.SearchService;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.caching.CacheItemAttributes;
import com.alachisoft.ncache.runtime.caching.DataSourceModifiedListener;
import com.alachisoft.ncache.runtime.caching.NamedTagsDictionary;
import com.alachisoft.ncache.runtime.caching.ReadMode;
import com.alachisoft.ncache.runtime.caching.ReadThruOptions;
import com.alachisoft.ncache.runtime.caching.Tag;
import com.alachisoft.ncache.runtime.caching.WriteMode;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.caching.expiration.Expiration;
import com.alachisoft.ncache.runtime.caching.expiration.ExpirationConstants;
import com.alachisoft.ncache.runtime.caching.expiration.ExpirationType;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.events.ListenerType;
import com.alachisoft.ncache.runtime.exceptions.AggregateException;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.OperationNotSupportedException;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import com.alachisoft.ncache.runtime.exceptions.StreamAlreadyLockedException;
import com.alachisoft.ncache.runtime.exceptions.StreamException;
import com.alachisoft.ncache.runtime.exceptions.StreamNotFoundException;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.security.encryption.EncryptionMgr;
import com.alachisoft.ncache.serialization.standard.CompactBinaryFormatter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import tangible.RefObject;

public class DisconnectedClientCache
extends CacheImpl {
    protected CacheImpl _nearCache;
    protected CacheImpl _farCache;
    private boolean _isPessimistic = false;
    protected boolean _clientCacheUsed;
    private boolean _sldDefaultEnabled;
    private boolean _sldLongerEnabled;
    private boolean _absEnabled;
    private boolean _absLongerEnabled;
    private long _absDefault;
    private long _absLonger;
    private long _sldDeault;
    private long _sldLonger;
    private String _userId;
    private byte[] _password;
    private SearchService privateSearchService;

    protected boolean getThrowError() {
        return this.isExceptionsEnabled();
    }

    @Override
    public boolean isExceptionsEnabled() {
        return this._farCache.isExceptionsEnabled();
    }

    @Override
    public void setExceptionsEnabled(boolean value) {
        this._farCache.setExceptionsEnabled(value);
    }

    public CacheImpl getNearCacheInstance() {
        return this._nearCache;
    }

    public void setNearCacheProperties() throws Exception {
        if (this._nearCache != null) {
            this.InitializeEncryption();
            this._nearCache.setQueryTypeInfoMap(this._farCache.getQueryTypeMap());
            this._nearCache.setSerializationContext(this._farCache.getSerializationContext());
            this._nearCache.setSerializationFormat(this._farCache.getSerializationFormat());
        }
        this.setSearchService(new ClientCacheSearchService(this._farCache, this._nearCache));
    }

    public CacheSyncDependency getCacheSyncDependency(String key) {
        return new CacheSyncDependency(this._farCache._cacheId, key, this._userId, this._password);
    }

    @Override
    public MessagingService getMessagingService() throws CacheException {
        return this._farCache.getMessagingService();
    }

    @Override
    public SearchService getSearchService() {
        return this.privateSearchService;
    }

    @Override
    public void setSearchService(SearchService value) {
        this.privateSearchService = value;
    }

    @Override
    public NotificationService getNotificationService() throws CacheException {
        return this._farCache.getNotificationService();
    }

    @Override
    public List<ClientInfo> getConnectedClientList() throws CacheException {
        return this._farCache.getConnectedClientList();
    }

    @Override
    public DataStructureManager getDataStructuresManager() {
        return this._farCache.getDataStructuresManager();
    }

    @Override
    public SerializationFormat getSerializationFormat() {
        return this._farCache.getSerializationFormat();
    }

    @Override
    public void setSerializationFormat(SerializationFormat value) {
        super.setSerializationFormat(value);
    }

    @Override
    public ClientInfo getClientInfo() throws CacheException {
        return this._farCache.getClientInfo();
    }

    public String getUserId() {
        return this._userId;
    }

    public void setUserId(String value) {
        this._userId = value;
    }

    public byte[] getPassword() {
        return this._password;
    }

    public void setPassword(byte[] value) {
        this._password = value;
    }

    public boolean getSldDefaultEnabled() {
        return this._sldDefaultEnabled;
    }

    public void setSldDefaultEnabled(boolean value) {
        this._sldDefaultEnabled = value;
    }

    public boolean getSldLongerEnabled() {
        return this._sldLongerEnabled;
    }

    public void setSldLongerEnabled(boolean value) {
        this._sldLongerEnabled = value;
    }

    public boolean getAbsDefaultEnabled() {
        return this._absEnabled;
    }

    public void setAbsDefaultEnabled(boolean value) {
        this._absEnabled = value;
    }

    public boolean getAbsLongerEnabled() {
        return this._absLongerEnabled;
    }

    public void setAbsLongerEnabled(boolean value) {
        this._absLongerEnabled = value;
    }

    public long getSldDefault() {
        return this._sldDeault;
    }

    public void setSldDefault(long value) {
        this._sldDeault = value;
    }

    public long getSldLonger() {
        return this._sldLonger;
    }

    public void setSldLonger(long value) {
        this._sldLonger = value;
    }

    public long getAbsDefault() {
        return this._absDefault;
    }

    public void setAbsDefault(long value) {
        this._absDefault = value;
    }

    public long getAbsLonger() {
        return this._absLonger;
    }

    public void setAbsLonger(long value) {
        this._absLonger = value;
    }

    @Override
    public boolean getExceptionEnabled() {
        return this._farCache.getExceptionEnabled();
    }

    @Override
    public void setExceptionEnabled(boolean value) {
        this._farCache.setExceptionsEnabled(value);
    }

    public DisconnectedClientCache(CacheImpl l2, CacheImpl l1, String userid, String pswd, boolean isPessimistic) throws Exception {
        if (l2 == null) {
            throw new OperationFailedException(10008, ErrorMessages.getErrorMessage((int)10008, (String[])new String[0]));
        }
        this._nearCache = l1;
        this._farCache = l2;
        this.GetClientExpiration();
        this._isPessimistic = isPessimistic;
        this.setNearCacheProperties();
        if (userid != null) {
            this._userId = userid;
        }
        if (pswd != null) {
            this._password = EncryptionUtil.Encrypt((String)pswd);
        }
    }

    @Override
    public CacheImpl getCacheInstanceInternal() {
        return this._farCache;
    }

    @Override
    public long getCount() throws CacheException {
        return this._farCache.getCount();
    }

    @Override
    public boolean contains(String key) throws CacheException {
        return this._farCache.contains(key);
    }

    @Override
    public Map<String, Boolean> containsBulk(Iterable<String> keys) throws CacheException {
        return this._farCache.containsBulk(keys);
    }

    @Override
    public void clearClientCache() throws CacheException {
        if (this._nearCache != null) {
            this._nearCache.clear();
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._nearCache.clear();
    }

    @Override
    public void clear() throws CacheException {
        this._farCache.clear();
    }

    @Override
    public CacheItemVersion addOperation(String key, Object value, CacheDependency dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, WriteMode writeOption, DataSourceModifiedListener dataSourceModifiedCallback, EventTypeInternal eventTypeInternal, boolean isResyncExpiredItems, String group, Tag[] tags, String providerName, String resyncProviderName, NamedTagsDictionary namedTags, CacheDataModificationListener cacheItemUdpatedCallback, CacheDataModificationListener cacheItemRemovedCallaback, EventDataFilter itemUpdateDataFilter, EventDataFilter itemRemovedDataFilter, RefObject<Long> size, boolean allowQueryTags, String clientId, short updateCallbackID, short removeCallbackID, short dsItemAddedCallbackID) throws CacheException {
        CacheItemVersion result;
        block3: {
            if (this._farCache.getCacheImpl() == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            result = null;
            try {
                updateCallbackID = this._farCache.registerUpdateSorrogateCallback(null, cacheItemUdpatedCallback, itemUpdateDataFilter);
                removeCallbackID = this._farCache.registerRemoveSorrogateCallback(null, cacheItemRemovedCallaback, itemRemovedDataFilter);
                dsItemAddedCallbackID = this._farCache.GetCallbackId(dataSourceModifiedCallback, 1, eventTypeInternal);
                String clientID = updateCallbackID < 0 && removeCallbackID < 0 && dsItemAddedCallbackID < 0 ? null : this._farCache.getCacheImpl().getClientID();
                result = this.getNearCacheInstance().addOperation(key, value, dependency, new CacheSyncDependency(this._farCache._cacheId, key, this.getUserId(), this.getPassword()), this.GetDefaultAbsoluteExpiration(absoluteExpiration), this.GetDefaultSlidingExpiration(slidingExpiration), priority, writeOption, dataSourceModifiedCallback, eventTypeInternal, isResyncExpiredItems, group, tags, providerName, resyncProviderName, namedTags, cacheItemUdpatedCallback, cacheItemRemovedCallaback, itemUpdateDataFilter, itemRemovedDataFilter, size, allowQueryTags, clientID, updateCallbackID, removeCallbackID, dsItemAddedCallbackID);
            }
            catch (CacheException | RuntimeException e) {
                if (!this.getThrowError()) break block3;
                throw e;
            }
        }
        return result;
    }

    @Override
    public Map<String, Exception> addBulk(Map<String, CacheItem> items, WriteThruOptions writeThruOptions) throws OperationFailedException, StreamNotFoundException, StreamException, ConfigurationException, CommandException, AggregateException, GeneralFailureException, OperationNotSupportedException, StreamAlreadyLockedException, LicensingException, SecurityException {
        if (items == null) {
            throw new IllegalArgumentException("items");
        }
        if (items.isEmpty()) {
            throw new IllegalArgumentException("Adding empty dictionary into cache.");
        }
        if (this._farCache.getCacheImpl() == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        long[] sizes = new long[items.size()];
        String providerName = null;
        WriteMode mode = WriteMode.None;
        DataSourceModifiedListener dataSourceModifiedListener = null;
        short updateCallbackID = -1;
        short removeCallbackID = -1;
        EnumSet eventTypes = EnumSet.of(EventTypeInternal.None);
        RefObject tempRef_mode = new RefObject((Object)mode);
        RefObject tempRef_providerName = new RefObject(providerName);
        RefObject tempRef_dataSourceModifiedCallback = new RefObject(dataSourceModifiedListener);
        RefObject tempRef_eventTypes = new RefObject(eventTypes);
        ConversionUtil.GetWriteOptions(writeThruOptions, (RefObject<WriteMode>)tempRef_mode, (RefObject<String>)tempRef_providerName, (RefObject<DataSourceModifiedListener>)tempRef_dataSourceModifiedCallback, (RefObject<EnumSet<EventTypeInternal>>)tempRef_eventTypes);
        mode = (WriteMode)tempRef_mode.argvalue;
        providerName = (String)tempRef_providerName.argvalue;
        dataSourceModifiedListener = (DataSourceModifiedListener)tempRef_dataSourceModifiedCallback.argvalue;
        eventTypes = (EnumSet)tempRef_eventTypes.argvalue;
        EventTypeInternal eventTypeInternal = (EventTypeInternal)((Object)eventTypes.toArray()[0]);
        CacheItem cacheItemAtFirstIndex = items.entrySet().iterator().next().getValue();
        for (Map.Entry<String, CacheItem> item : items.entrySet()) {
            if (item.getValue() == null) {
                throw new IllegalArgumentException("CacheItem cannot be null");
            }
            CacheItem l2item = item.getValue();
            l2item.setExpiration(l2item.getExpiration());
            l2item.setSyncDependency(this.getCacheSyncDependency(item.getKey()));
        }
        try {
            if (cacheItemAtFirstIndex != null) {
                updateCallbackID = this._farCache.registerUpdateSorrogateCallback(null, CacheItemWrapperInternal.getCacheItemUpdatedListener(cacheItemAtFirstIndex), CacheItemWrapperInternal.getItemUpdatedDataFilter(cacheItemAtFirstIndex));
                removeCallbackID = this._farCache.registerRemoveSorrogateCallback(null, CacheItemWrapperInternal.getCacheItemRemovedListener(cacheItemAtFirstIndex), CacheItemWrapperInternal.getItemRemovedDataFilter(cacheItemAtFirstIndex));
            }
            short dsItemAddedCallbackID = this._farCache.GetCallbackId(dataSourceModifiedListener, items.size(), eventTypeInternal);
            String clientID = updateCallbackID < 0 && removeCallbackID < 0 && dsItemAddedCallbackID < 0 ? null : this._farCache.getCacheImpl().getClientID();
            return this.getNearCacheInstance().AddBulkInternal(items, mode, dataSourceModifiedListener, eventTypeInternal, providerName, true, clientID, updateCallbackID, removeCallbackID, dsItemAddedCallbackID, cacheItemAtFirstIndex != null ? CacheItemWrapperInternal.getItemUpdatedDataFilter(cacheItemAtFirstIndex) : EventDataFilter.None, cacheItemAtFirstIndex != null ? CacheItemWrapperInternal.getItemRemovedDataFilter(cacheItemAtFirstIndex) : EventDataFilter.None, false);
        }
        catch (CacheException e) {
            if (this.getThrowError()) {
                throw e;
            }
            return null;
        }
    }

    @Override
    public CacheItemVersion insertOperation(String key, Object value, CacheDependency dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, WriteMode WriteMode2, DataSourceModifiedListener dataSourceModifiedCallback, EventTypeInternal eventType, boolean isResyncExpiredItems, String group, LockHandle lockHandle, CacheItemVersion version, LockAccessType accessType, Tag[] tags, String providerName, String resyncProviderName, NamedTagsDictionary namedTags, CacheDataModificationListener cacheItemUdpatedCallback, CacheDataModificationListener onRemoveCallback, EventDataFilter itemUpdateDataFilter, EventDataFilter itemRemovedDataFilter, boolean allowQueryTags, String clientId, short updateCallbackId, short removeCallbackId, short dataSourceUpdatedCallbackId) throws CacheException {
        CacheItemVersion newVersion;
        block3: {
            String lockId;
            newVersion = null;
            String string = lockId = lockHandle == null ? null : lockHandle.getLockId();
            if (this._farCache.getCacheImpl() == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            try {
                updateCallbackId = this._farCache.registerUpdateSorrogateCallback(null, cacheItemUdpatedCallback, itemUpdateDataFilter);
                removeCallbackId = this._farCache.registerRemoveSorrogateCallback(null, onRemoveCallback, itemRemovedDataFilter);
                dataSourceUpdatedCallbackId = this._farCache.GetCallbackId(dataSourceModifiedCallback, 1, eventType);
                String clientID = updateCallbackId < 0 && removeCallbackId < 0 && dataSourceUpdatedCallbackId < 0 ? null : this._farCache.getCacheImpl().getClientID();
                newVersion = this.getNearCacheInstance().insertOperation(key, value, dependency, new CacheSyncDependency(this._farCache._cacheId, key, this.getUserId(), this.getPassword()), this.GetDefaultAbsoluteExpiration(absoluteExpiration), this.GetDefaultSlidingExpiration(slidingExpiration), priority, WriteMode2, dataSourceModifiedCallback, eventType, isResyncExpiredItems, group, lockHandle, version, accessType, tags, providerName, resyncProviderName, namedTags, cacheItemUdpatedCallback, onRemoveCallback, itemUpdateDataFilter, itemRemovedDataFilter, allowQueryTags, clientID, updateCallbackId, removeCallbackId, dataSourceUpdatedCallbackId);
            }
            catch (CacheException e) {
                if (!this.getThrowError()) break block3;
                throw e;
            }
        }
        return newVersion;
    }

    @Override
    public Map<String, Exception> insertBulk(Map<String, CacheItem> items, WriteThruOptions writeThruOptions) throws CacheException {
        String providerName = null;
        WriteMode mode = WriteMode.None;
        DataSourceModifiedListener dataSourceModifiedCallback = null;
        EnumSet eventTypes = EnumSet.of(EventTypeInternal.None);
        RefObject tempRef_mode = new RefObject((Object)mode);
        RefObject tempRef_providerName = new RefObject(providerName);
        RefObject tempRef_dataSourceModifiedCallback = new RefObject(dataSourceModifiedCallback);
        RefObject tempRef_eventTypes = new RefObject(eventTypes);
        ConversionUtil.GetWriteOptions(writeThruOptions, (RefObject<WriteMode>)tempRef_mode, (RefObject<String>)tempRef_providerName, (RefObject<DataSourceModifiedListener>)tempRef_dataSourceModifiedCallback, (RefObject<EnumSet<EventTypeInternal>>)tempRef_eventTypes);
        mode = (WriteMode)tempRef_mode.argvalue;
        providerName = (String)tempRef_providerName.argvalue;
        dataSourceModifiedCallback = (DataSourceModifiedListener)tempRef_dataSourceModifiedCallback.argvalue;
        eventTypes = (EnumSet)tempRef_eventTypes.argvalue;
        EventTypeInternal eventTypeInternal = (EventTypeInternal)((Object)eventTypes.toArray()[0]);
        if (items == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: items");
        }
        if (items.isEmpty()) {
            throw new IllegalArgumentException("There is no key present in keys array");
        }
        if (this._farCache.getCacheImpl() == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        try {
            long[] updateSize = new long[items.size()];
            CacheItem cacheItemAtFirstIndex = items.entrySet().iterator().next().getValue();
            short updateCallbackId = -1;
            short removeCallbackId = -1;
            for (Map.Entry<String, CacheItem> item : items.entrySet()) {
                CacheItem l2CacheItem = item.getValue();
                if (l2CacheItem == null) continue;
                l2CacheItem.setExpiration(this.GetExpiration(l2CacheItem.getExpiration()));
                l2CacheItem.setSyncDependency(this.getCacheSyncDependency(item.getKey()));
                l2CacheItem.setGroup(l2CacheItem.getGroup());
                l2CacheItem.setTags(l2CacheItem.getTags());
                l2CacheItem.setNamedTags(l2CacheItem.getNamedTags());
            }
            if (cacheItemAtFirstIndex != null) {
                updateCallbackId = this._farCache.registerUpdateSorrogateCallback(null, CacheItemWrapperInternal.getCacheItemUpdatedListener(cacheItemAtFirstIndex), CacheItemWrapperInternal.getItemUpdatedDataFilter(cacheItemAtFirstIndex));
                removeCallbackId = this._farCache.registerRemoveSorrogateCallback(null, CacheItemWrapperInternal.getCacheItemRemovedListener(cacheItemAtFirstIndex), CacheItemWrapperInternal.getItemRemovedDataFilter(cacheItemAtFirstIndex));
            }
            short dsItemUpdateCallbackID = this._farCache.GetCallbackId(dataSourceModifiedCallback, items.size(), eventTypeInternal);
            String clientID = updateCallbackId < 0 && removeCallbackId < 0 && dsItemUpdateCallbackID < 0 ? null : this._farCache.getCacheImpl().getClientID();
            Object itemVersions = null;
            RefObject tempRef_itemVersions = new RefObject(itemVersions);
            RefObject tempRef_updateSize = new RefObject((Object)updateSize);
            return this.getNearCacheInstance().InsertBulkInternal(items, mode, dataSourceModifiedCallback, eventTypeInternal, providerName, (RefObject<long[]>)tempRef_updateSize, true, clientID, updateCallbackId, removeCallbackId, dsItemUpdateCallbackID, cacheItemAtFirstIndex != null ? CacheItemWrapperInternal.getItemUpdatedDataFilter(cacheItemAtFirstIndex) : EventDataFilter.None, cacheItemAtFirstIndex != null ? CacheItemWrapperInternal.getItemRemovedDataFilter(cacheItemAtFirstIndex) : EventDataFilter.None, false, (RefObject<Map>)tempRef_itemVersions);
        }
        catch (CacheException e) {
            if (this.getThrowError()) {
                throw e;
            }
            return null;
        }
    }

    @Override
    public boolean updateAttributes(String key, CacheItemAttributes attributes) throws CacheException {
        boolean success;
        block6: {
            success = false;
            if (key == null) {
                throw new IllegalArgumentException();
            }
            if (attributes == null) {
                throw new IllegalArgumentException();
            }
            if (this._farCache == null) {
                throw new OperationFailedException(10008, ErrorMessages.getErrorMessage((int)10008, (String[])new String[0]));
            }
            try {
                success = this._farCache.updateAttributes(key, attributes);
                if (success) {
                    success = this.getNearCacheInstance().updateAttributes(key, attributes);
                }
            }
            catch (RuntimeException e) {
                if (!this.getThrowError()) break block6;
                throw e;
            }
        }
        return success;
    }

    @Override
    public <T> T remove(String key, LockHandle lockHandle, CacheItemVersion version, WriteThruOptions writeThruOptions, Class<?> cls) throws CacheException {
        return this.getNearCacheInstance().remove(key, lockHandle, version, writeThruOptions, cls);
    }

    @Override
    public void delete(String key, LockHandle lockHandle, CacheItemVersion version, WriteThruOptions writeThruOptions) throws CacheException {
        this.getNearCacheInstance().delete(key, lockHandle, version, writeThruOptions);
    }

    @Override
    public <T> Map<String, T> removeBulk(Iterable<String> keys, WriteThruOptions writeThruOption, Class<?> cls) throws CacheException {
        return this.getNearCacheInstance().removeBulk(keys, writeThruOption, cls);
    }

    @Override
    public void deleteBulk(Iterable<String> keys, WriteThruOptions writeThruOptions) throws CacheException {
        this.getNearCacheInstance().deleteBulk(keys, writeThruOptions);
    }

    @Override
    public <T> FutureTask<T> removeAsync(String key, WriteThruOptions writeThruOptions, Class<?> cls) {
        return this.getNearCacheInstance().removeAsync(key, writeThruOptions, cls);
    }

    @Override
    public <T> T get(String key, ReadThruOptions readThruOptions, Class<?> cls) throws CacheException {
        T result;
        block8: {
            result = null;
            if (this._isPessimistic) {
                CacheItemVersion version = new CacheItemVersion();
                Object localItem = this.getNearCacheInstance().get(key, version, readThruOptions, cls);
                try {
                    if (localItem != null && (result = (T)this._farCache.getIfNewer(key, version, cls)) == null) {
                        if (version.getVersion() == new CacheItemVersion().getVersion()) {
                            return localItem;
                        }
                        return null;
                    }
                    break block8;
                }
                catch (CacheException e) {
                    if (this.getThrowError()) {
                        throw e;
                    }
                    break block8;
                }
            }
            try {
                CacheItem cacheItem = this.getNearCacheInstance().getCacheItem(key, readThruOptions);
                CacheItemWrapperInternal.setCacheInstance(cacheItem, this);
                return cacheItem != null ? (T)cacheItem.getValue(cls) : null;
            }
            catch (RuntimeException e2) {
                if (!this.getThrowError()) break block8;
                throw e2;
            }
        }
        return result;
    }

    @Override
    public <T> T get(String key, CacheItemVersion version, ReadThruOptions readThruOptions, Class<?> cls) throws CacheException {
        CacheItem cacheItem = this.getNearCacheInstance().getCacheItem(key, version, readThruOptions);
        if (cacheItem != null) {
            if (cacheItem.getCacheItemVersion().getVersion() != version.getVersion()) {
                version = cacheItem.getCacheItemVersion();
                return null;
            }
            version = cacheItem.getCacheItemVersion();
        }
        return cacheItem != null ? (T)cacheItem.getValue(cls) : null;
    }

    @Override
    public <T> T get(String key, boolean acquireLock, TimeSpan lockTimeout, LockHandle lockHandle, Class<?> cls) throws CacheException {
        try {
            return this.getNearCacheInstance().get(key, acquireLock, lockTimeout, lockHandle, cls);
        }
        catch (CacheException | RuntimeException e) {
            if (this.getThrowError()) {
                throw e;
            }
            return null;
        }
    }

    @Override
    public <T> T getInternal(String key, CacheItemVersion version, LockAccessType accessType, TimeSpan lockTimeout, LockHandle lockHandle, ReadThruOptions readOptions, Class<?> cls) throws CacheException {
        T result;
        block9: {
            result = null;
            if (this._isPessimistic) {
                try {
                    CacheItem cItem = this._farCache.getCacheItem(key, version, readOptions);
                    T localItem = null;
                    if (cItem != null) {
                        localItem = cItem.getValue(cls);
                        version = cItem.getCacheItemVersion();
                    }
                    if (localItem == null && (result = (T)this._farCache.getIfNewer(key, version, cls)) == null) {
                        if (version == null) {
                            return localItem;
                        }
                        return null;
                    }
                    break block9;
                }
                catch (CacheException e) {
                    if (this.getThrowError()) {
                        throw e;
                    }
                    break block9;
                }
            }
            try {
                result = this.getNearCacheInstance().getInternal(key, version, accessType, lockTimeout, lockHandle, readOptions, cls);
            }
            catch (RuntimeException e2) {
                if (!this.getThrowError()) break block9;
                throw e2;
            }
        }
        return result;
    }

    @Override
    public <T> Map<String, T> getBulk(Iterable<String> keys, ReadThruOptions readThruOptions, Class<?> cls) throws CacheException {
        Map clientResult;
        block2: {
            clientResult = null;
            try {
                clientResult = this.getNearCacheInstance().getBulk(keys, readThruOptions, cls);
            }
            catch (CacheException | RuntimeException e) {
                if (!this.getThrowError()) break block2;
                throw e;
            }
        }
        return clientResult;
    }

    @Override
    public CacheItem getCacheItem(String key, ReadThruOptions readThruOptions) throws CacheException {
        CacheItem cacheItem;
        block9: {
            block10: {
                cacheItem = null;
                if (this._isPessimistic) {
                    try {
                        Object result;
                        CacheItemVersion version = new CacheItemVersion();
                        cacheItem = this.getNearCacheInstance().getCacheItem(key, version, readThruOptions);
                        if (cacheItem != null && (result = this._farCache.getIfNewer(key, version, Object.class)) == null) {
                            if (version.getVersion() == 0L) {
                                return cacheItem;
                            }
                            return null;
                        }
                        break block9;
                    }
                    catch (CacheException e) {
                        if (this.getThrowError()) {
                            throw e;
                        }
                        break block9;
                    }
                }
                try {
                    cacheItem = this.getNearCacheInstance().getCacheItem(key, readThruOptions);
                    CacheItemWrapperInternal.setCacheInstance(cacheItem, this);
                }
                catch (CacheException e2) {
                    if (!this.getThrowError()) break block10;
                    throw e2;
                }
            }
            if (cacheItem != null) {
                return cacheItem;
            }
        }
        return cacheItem;
    }

    @Override
    public CacheItem getCacheItem(String key, boolean acquireLock, TimeSpan lockTimeout, LockHandle lockHandle) throws CacheException {
        CacheItem cacheItem = this.getNearCacheInstance().getCacheItem(key, acquireLock, lockTimeout, lockHandle);
        CacheItemWrapperInternal.setCacheInstance(cacheItem, this);
        return cacheItem;
    }

    @Override
    public Map<String, CacheItem> getCacheItemBulk(Iterable<String> keys, ReadThruOptions readThruOptions) throws CacheException {
        Map<String, CacheItem> clientResult;
        block3: {
            clientResult = null;
            try {
                clientResult = this.getNearCacheInstance().getCacheItemBulk(keys, readThruOptions);
                for (Map.Entry<String, CacheItem> item : clientResult.entrySet()) {
                    CacheItemWrapperInternal.setCacheInstance(item.getValue(), this);
                }
            }
            catch (CacheException e) {
                if (!this._nearCache._exceptionEnabled) break block3;
                throw e;
            }
        }
        return clientResult;
    }

    @Override
    public CacheItem getCacheItemInternal(String key, CacheItemVersion version, LockAccessType accessType, TimeSpan lockTimeout, LockHandle lockHandle, ReadThruOptions readOptions) throws CacheException {
        return this.getNearCacheInstance().getCacheItemInternal(key, version, accessType, lockTimeout, lockHandle, readOptions);
    }

    @Override
    public boolean lock(String key, TimeSpan lockTimeout, LockHandle lockHandle) throws CacheException {
        return this._farCache.lock(key, lockTimeout, lockHandle);
    }

    @Override
    public void unlock(String key) throws CacheException {
        this._farCache.unlock(key);
    }

    @Override
    public void unlock(String key, LockHandle lockHandle) throws CacheException {
        this._farCache.unlock(key, lockHandle);
    }

    @Override
    public <T> T getIfNewer(String key, CacheItemVersion version, Class<?> cls) throws CacheException {
        T result;
        block7: {
            result = null;
            CacheItem cacheItem = null;
            if (version == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: version");
            }
            cacheItem = this._farCache.getCacheItem(key, new ReadThruOptions(ReadMode.None));
            if (cacheItem != null) {
                result = cacheItem.getValue(cls);
                if (cacheItem.getCacheItemVersion() == null || cacheItem.getCacheItemVersion().getVersion() <= version.getVersion()) {
                    version.setVersion(0L);
                    return null;
                }
                version.setVersion(cacheItem.getCacheItemVersion().getVersion());
                try {
                    if (!this.getNearCacheInstance().contains(key)) {
                        long size;
                        byte[] seralized = CompactBinaryFormatter.toByteBuffer(cacheItem.getValue(cls), (String)this._farCache._cacheId);
                        long l = size = seralized instanceof byte[] ? (long)seralized.length : 0L;
                        if (cacheItem != null) {
                            cacheItem = this.GetCompatibleItem(cacheItem);
                        }
                        RefObject tempRef_size = new RefObject((Object)size);
                        CacheItemVersion itemVersion = this.getNearCacheInstance().insertOperation(key, result, null, new CacheSyncDependency(this._farCache._cacheId, key, this.getUserId(), this.getPassword()), this.GetDefaultAbsoluteExpiration(ConversionUtil.getAbsoluteExpiration(cacheItem.getExpiration())), NoSlidingExpiration, cacheItem.getCacheItemPriority(), WriteMode.None, null, EventTypeInternal.None, false, cacheItem.getGroup(), null, version, LockAccessType.PRESERVE_VERSION, ConversionUtil.toArray(cacheItem.getTags()), null, null, cacheItem.getNamedTags(), null, null, EventDataFilter.None, EventDataFilter.None, false, null, (short)-1, (short)-1, (short)-1);
                        size = (Long)tempRef_size.argvalue;
                    }
                }
                catch (IOException e) {
                    if (!this.getThrowError()) break block7;
                    throw new OperationFailedException((Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public boolean isLocked(String key, LockHandle lockHandle) throws CacheException {
        return this._farCache.isLocked(key, lockHandle);
    }

    @Override
    public CacheStream getCacheStream(String key, CacheStreamAttributes cacheStreamAttributes) throws CacheException {
        return this._farCache.getCacheStream(key, cacheStreamAttributes);
    }

    @Override
    public void registerKeyNotificationCallback(String key, CacheItemUpdatedListener updateCallback, CacheItemRemovedListener removeCallback, boolean notifyOnItemExpiration, ListenerType listenerType) throws CacheException {
        this._farCache.registerKeyNotificationCallback(key, updateCallback, removeCallback, notifyOnItemExpiration, listenerType);
    }

    @Override
    public String toString() {
        return "L1 cache=" + this._nearCache.toString() + ", L2 cache=" + this._farCache.toString();
    }

    @Override
    public void close() {
        this._farCache.close();
        if (this._nearCache != null) {
            this._nearCache.close();
        }
    }

    @Override
    public void touch(ArrayList<String> keys) throws OperationFailedException, OperationNotSupportedException, CommandException, GeneralFailureException, StreamNotFoundException, ConfigurationException, StreamException, AggregateException, StreamAlreadyLockedException, LicensingException, SecurityException {
        this._farCache.touch(keys);
    }

    @Override
    public void InitializeEncryption() throws Exception {
        HashMap encryptionInfo = this._farCache.getCacheImpl().getEncryptionInfo();
        if (encryptionInfo != null && encryptionInfo.size() > 0) {
            boolean enableEncryption = Boolean.parseBoolean((String)encryptionInfo.get("enabled"));
            this._nearCache.setEncryptionEnabled(enableEncryption);
            EncryptionMgr.InitializeEncryption((boolean)enableEncryption, (String)((String)encryptionInfo.get("key")), (String)this._nearCache.getCacheImpl().getName(), (String)((String)encryptionInfo.get("provider")));
        }
    }

    @Override
    public void raiseCustomEvent(Object notifId, Object data) throws CacheException {
        this._farCache.raiseCustomEvent(notifId, data);
    }

    private Expiration GetExpiration(Expiration expiration) {
        Date absoulteExpiration = ConversionUtil.getAbsoluteExpiration(expiration);
        TimeSpan slidingExpiration = ConversionUtil.getSlidingExpiration(expiration);
        if (absoulteExpiration == CacheImpl.defaultAbsolute && this._absEnabled) {
            return new Expiration(ExpirationType.Absolute, TimeSpan.FromSeconds((double)this._absDefault));
        }
        if (absoulteExpiration == CacheImpl.defaultAbsoluteLonger && this._absLongerEnabled) {
            return new Expiration(ExpirationType.Absolute, TimeSpan.FromSeconds((double)this._absLonger));
        }
        if (slidingExpiration == DefaultSliding && this._sldDefaultEnabled) {
            return new Expiration(ExpirationType.Absolute, TimeSpan.FromSeconds((double)this._sldDeault));
        }
        if (slidingExpiration == DefaultSlidingLonger && this._sldLongerEnabled) {
            return new Expiration(ExpirationType.Absolute, TimeSpan.FromSeconds((double)this._sldLonger));
        }
        return expiration;
    }

    public Date GetDefaultAbsoluteExpiration(Date absoluteExpiration) {
        if (absoluteExpiration.equals(ExpirationConstants.AbsoluteDefaultExpiration) && this.getAbsDefaultEnabled()) {
            NCDateTime dateTime = new NCDateTime(new Date());
            dateTime.addTicks(TimeSpan.TimeToTicks((int)0, (int)0, (int)((int)this.getAbsDefault())));
            return dateTime.getDate();
        }
        if (absoluteExpiration.equals(ExpirationConstants.AbsoluteDefaultLongerExpiration) && this.getAbsLongerEnabled()) {
            NCDateTime dateTime = new NCDateTime(new Date());
            dateTime.addTicks(TimeSpan.TimeToTicks((int)0, (int)0, (int)((int)this.getAbsLonger())));
            return dateTime.getDate();
        }
        if (!absoluteExpiration.equals(CacheImpl.NoAbsoluteExpiration)) {
            return absoluteExpiration;
        }
        return absoluteExpiration;
    }

    public TimeSpan GetDefaultSlidingExpiration(TimeSpan slidingExpiration) {
        if (slidingExpiration == CacheImpl.DefaultSliding && this.getSldDefaultEnabled()) {
            return TimeSpan.FromSeconds((double)this.getSldDefault());
        }
        if (slidingExpiration == CacheImpl.DefaultSlidingLonger && this.getSldLongerEnabled()) {
            return TimeSpan.FromSeconds((double)this.getSldLonger());
        }
        return slidingExpiration;
    }

    @Override
    public void makeTargetCacheActivePassive(boolean makeActive) throws Exception {
        block2: {
            try {
                this._farCache.makeTargetCacheActivePassive(makeActive);
            }
            catch (RuntimeException e) {
                if (!this._exceptionEnabled) break block2;
                throw e;
            }
        }
    }

    @Override
    public CacheReader executeReaderCQ(ContinuousQuery query, boolean getData, int chunkSize) throws CacheException {
        return this._farCache.executeReaderCQ(query, getData, chunkSize);
    }

    @Override
    public ArrayList getGroupKeys(String group) throws CacheException {
        return this._farCache.getGroupKeys(group);
    }

    @Override
    public <T> Map<String, T> getGroupData(String group) throws CacheException {
        return this._farCache.getGroupData(group);
    }

    @Override
    public void removeGroupData(String group) throws CacheException {
        this._farCache.removeGroupData(group);
    }

    private void GetClientExpiration() {
        HashMap expirationInfo = ((RemoteCache)this._farCache.getCacheImpl()).GetExpirationInfo();
        if (expirationInfo != null) {
            this.setAbsDefault((Long)expirationInfo.get("absDefault"));
            this.setAbsLonger((Long)expirationInfo.get("absLonger"));
            this.setSldDefault((Long)expirationInfo.get("sldDefault"));
            this.setSldLonger((Long)expirationInfo.get("sldLonger"));
            this.setAbsDefaultEnabled((Boolean)expirationInfo.get("absDefaultEnabled"));
            this.setAbsLongerEnabled((Boolean)expirationInfo.get("absLongerEnabled"));
            this.setSldDefaultEnabled((Boolean)expirationInfo.get("sldDefaultEnabled"));
            this.setSldLongerEnabled((Boolean)expirationInfo.get("sldLongerEnabled"));
        }
    }

    private CacheItem GetCompatibleItem(CacheItem l2CacheItem) {
        if (l2CacheItem == null) {
            return null;
        }
        CacheItem l1CacheItem = l2CacheItem;
        l1CacheItem.setExpiration(this.GetExpiration(l2CacheItem.getExpiration()));
        l1CacheItem.setGroup(l2CacheItem.getGroup());
        l1CacheItem.setTags(l2CacheItem.getTags());
        l1CacheItem.setNamedTags(l2CacheItem.getNamedTags());
        return l1CacheItem;
    }

    public static Date GetCompatibleExpiration(Date absoluteExpiration, TimeSpan slidingExpiration) {
        if (!absoluteExpiration.equals(NoAbsoluteExpiration)) {
            return absoluteExpiration;
        }
        if (slidingExpiration == NoSlidingExpiration) {
            return NoAbsoluteExpiration;
        }
        return absoluteExpiration;
    }

    @Override
    public boolean hasMoreElements() {
        return this._farCache.hasMoreElements();
    }

    @Override
    public Object nextElement() {
        return this._farCache.nextElement();
    }
}

