/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Caching.CompressedValueEntry;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.CompressionUtil;
import com.alachisoft.ncache.client.internal.caching.CacheHelper;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.datastructure.DataTypeCreator;
import com.alachisoft.ncache.runtime.JSON.JsonUtil;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.serialization.JSON.JsonBinaryFormatter;
import com.alachisoft.ncache.serialization.standard.CompactBinaryFormatter;
import java.io.IOException;
import tangible.RefObject;

abstract class DataReaderCommon {
    protected CacheImpl _cache;

    DataReaderCommon() {
    }

    protected <T> T extractObjectFromCompressedValueEntry(CompressedValueEntry cmpEntry, Class<?> cls) throws IOException, ClassNotFoundException, OperationFailedException {
        Object obj = cmpEntry.getValue();
        switch (cmpEntry.getType()) {
            case Set: 
            case List: 
            case Queue: 
            case Counter: 
            case Dictionary: {
                String key = null;
                RefObject tempRef_key = new RefObject(key);
                boolean tempVar = this.tryGetKeyFromCurrentRow((RefObject<String>)tempRef_key) && this._cache != null;
                key = (String)tempRef_key.argvalue;
                if (!tempVar) break;
                obj = DataTypeCreator.createDataTypeHandle(cmpEntry.getType(), key, this._cache, cls);
                break;
            }
            case CacheItem: {
                obj = this.convertToUserObject(cmpEntry, cls);
            }
        }
        return (T)obj;
    }

    protected <T> T extractFromCompressedValueEntry(CompressedValueEntry cmpEntry, Class<?> cls) throws OperationFailedException, IOException, ClassNotFoundException {
        Object obj = cmpEntry.getValue();
        switch (cmpEntry.getType()) {
            case Set: 
            case List: 
            case Queue: 
            case Counter: 
            case Dictionary: {
                String key = null;
                RefObject tempRef_key = new RefObject(key);
                boolean tempVar = this.tryGetKeyFromCurrentRow((RefObject<String>)tempRef_key) && this._cache != null;
                key = (String)tempRef_key.argvalue;
                if (!tempVar) break;
                obj = DataTypeCreator.createDataTypeHandle(cmpEntry.getType(), key, this._cache, cls);
                break;
            }
            case CacheItem: {
                obj = this.convertToUserObject(cmpEntry, cls);
            }
        }
        return (T)JsonUtil.getValueAs((Object)obj, cls);
    }

    protected <T> T convertToUserObject(CompressedValueEntry cmpEntry, Class<?> cls) throws OperationFailedException, IOException, ClassNotFoundException {
        if (cmpEntry == null) {
            return null;
        }
        if (cmpEntry.getValue() == null) {
            return null;
        }
        UserBinaryObject ubObject = (UserBinaryObject)(cmpEntry.getValue() instanceof UserBinaryObject ? cmpEntry.getValue() : null);
        if (ubObject != null) {
            cmpEntry.setValue((Object)ubObject.getFullObject());
        }
        if (cmpEntry.getValue() instanceof byte[]) {
            if (cmpEntry.getFlag().IsBitSet((byte)2)) {
                cmpEntry.setValue((Object)CompressionUtil.Decompress((byte[])((byte[])cmpEntry.getValue())));
            }
            if (this._cache != null && this._cache.getCacheImpl().getEncryptionEnabled()) {
                cmpEntry.setValue((Object)CacheHelper.DecryptData((byte[])cmpEntry.getValue(), this._cache.getCacheImpl().getName()));
            }
            if (cmpEntry.getFlag().IsBitSet((byte)-128)) {
                return (T)cmpEntry.getValue();
            }
            if (cmpEntry.getFlag().IsBitSet((byte)32)) {
                cmpEntry.setValue(JsonBinaryFormatter.fromByteBuffer((byte[])((byte[])cmpEntry.getValue()), cls));
            } else {
                cmpEntry.setValue(CompactBinaryFormatter.fromByteBuffer((byte[])((byte[])cmpEntry.getValue()), (String)this._cache.getCacheImpl().getName()));
            }
        }
        return (T)cmpEntry.getValue();
    }

    protected abstract boolean tryGetKeyFromCurrentRow(RefObject<String> var1);
}

