/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Common.BitSet;
import com.alachisoft.ncache.client.ContinuousQuery;
import com.alachisoft.ncache.client.EventCacheItem;
import com.alachisoft.ncache.client.internal.caching.CQEventMessageReceivedListener;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.CacheImplBase;
import com.alachisoft.ncache.client.internal.caching.EventTypeInternal;
import com.alachisoft.ncache.client.internal.caching.QueryChangeType;
import com.alachisoft.ncache.client.internal.caching.TopicImpl;
import com.alachisoft.ncache.client.internal.caching.TopicSubscriptionImpl;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import java.util.ArrayList;
import java.util.Iterator;

public class ContinuousQueryManager {
    Object sync = new Object();
    private ArrayList<ContinuousQuery> queries = new ArrayList();
    private TopicSubscriptionImpl _cqEventsSubscription;
    private static boolean tracingEnabled;
    CacheImplBase cacheImpl;
    CQEventMessageReceivedListener cQEventMessageReceivedListener = null;

    public ContinuousQueryManager() {
        String eventsTracingEnabled = System.getProperty("EventsTracingEnabled");
        boolean bl = tracingEnabled = eventsTracingEnabled != null && eventsTracingEnabled.toLowerCase().equals("true");
        if (this.cQEventMessageReceivedListener == null) {
            this.cQEventMessageReceivedListener = new CQEventMessageReceivedListener(this);
        }
    }

    public static boolean getTracingEnabled() {
        return tracingEnabled;
    }

    public static void setTracingEnabled(boolean value) {
        tracingEnabled = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ContinuousQuery query, CacheImpl cache) throws CacheException {
        this.cacheImpl = cache.getCacheImpl();
        this.cQEventMessageReceivedListener.setCacheImplBase(this.cacheImpl);
        if (tracingEnabled) {
            System.out.println("CQManager.RegisterQuery() -> query : {query.Command} server id: {query.ServerUniqueID}");
        }
        Object object = this.sync;
        synchronized (object) {
            if (!this.queries.contains(query)) {
                this.queries.add(query);
            } else {
                this.queries.remove(query);
                this.queries.add(query);
            }
        }
        if (this._cqEventsSubscription == null) {
            TopicImpl topic = (TopicImpl)cache._messagingService.getTopic("$ContinuousQueryEvents$", true);
            this._cqEventsSubscription = (TopicSubscriptionImpl)topic.createEventSubscription(this.cQEventMessageReceivedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegister(ContinuousQuery query) throws Exception {
        Object object = this.sync;
        synchronized (object) {
            this.queries.remove(query);
        }
        if (this.queries.size() == 0 && this._cqEventsSubscription != null) {
            this._cqEventsSubscription.unSubscribeEventTopic();
            this._cqEventsSubscription = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(String queryId, QueryChangeType changeType, String key, boolean notifyAsync, EventCacheItem item, EventCacheItem oldItem, BitSet flag, String cacheName, EventDataFilter datafilter) {
        ArrayList<ContinuousQuery> registeredQueries = null;
        Iterator iterator = this.sync;
        synchronized (iterator) {
            if (this.queries.size() == 0) {
                return;
            }
            registeredQueries = new ArrayList<ContinuousQuery>(this.queries);
        }
        if (tracingEnabled) {
            System.out.println("CQManager.Notify() -> queries#  ({queries.Count})  change event :{changeType}");
        }
        for (ContinuousQuery query : registeredQueries) {
            try {
                if (!query.getServerUniqueIDInternal().equals(queryId)) continue;
                if (tracingEnabled) {
                    System.out.println("CQManager.Notify() -> query ({queryId})  change event :{changeType}");
                }
                if (changeType == QueryChangeType.Add) {
                    query.fireCQEventsInternal(key, EventTypeInternal.ItemAdded, item, oldItem, notifyAsync, cacheName, flag, datafilter);
                    continue;
                }
                if (changeType == QueryChangeType.Remove) {
                    query.fireCQEventsInternal(key, EventTypeInternal.ItemRemoved, item, oldItem, notifyAsync, cacheName, flag, datafilter);
                    continue;
                }
                query.fireCQEventsInternal(key, EventTypeInternal.ItemUpdated, item, oldItem, notifyAsync, cacheName, flag, datafilter);
            }
            catch (Throwable throwable) {}
        }
    }
}

