/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import com.alachisoft.ncache.client.EventHandle;
import com.alachisoft.ncache.client.internal.caching.EventManager;
import com.alachisoft.ncache.client.internal.caching.EventTypeInternal;
import com.alachisoft.ncache.client.internal.messaging.MessageCollectionEventItem;
import com.alachisoft.ncache.runtime.caching.MessageEventArgs;
import com.alachisoft.ncache.runtime.caching.messaging.MessageReceivedListener;

public class CollectionEventMessageReceivedListener
implements MessageReceivedListener {
    private EventManager _eventManager;

    CollectionEventMessageReceivedListener(EventManager eventManager) {
        this._eventManager = eventManager;
    }

    public void onMessageReceived(Object sender, MessageEventArgs args) {
        MessageCollectionEventItem[] eventMessages = new MessageCollectionEventItem[1];
        MessageCollectionEventItem eventMsg = (MessageCollectionEventItem)(args.getMessage().getPayload() instanceof MessageCollectionEventItem ? args.getMessage().getPayload() : null);
        if (eventMsg == null) {
            eventMessages = (MessageCollectionEventItem[])args.getMessage().getPayload();
        } else {
            eventMessages[0] = eventMsg;
        }
        for (MessageCollectionEventItem eventMessage : eventMessages) {
            EventHandle handle = null;
            EventTypeInternal eventType = EventTypeInternal.ItemAdded;
            handle = new EventHandle((Short)eventMessage.getCallback());
            switch (eventMessage.getEventType()) {
                case ITEM_ADDED_CALLBACK: {
                    eventType = EventTypeInternal.ItemAdded;
                    break;
                }
                case ITEM_UPDATED_CALLBACK: {
                    eventType = EventTypeInternal.ItemUpdated;
                    break;
                }
                case ITEM_REMOVED_CALLBACK: {
                    eventType = EventTypeInternal.ItemRemoved;
                }
            }
            this._eventManager.raiseCollectionNotification(eventMessage.getKey(), eventType, eventMessage.getDataType(), eventMessage.getDataFilter(), eventMessage.getCollectionItem(), eventMessage.getOldCollectionItem(), false, handle);
        }
    }
}

