/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Caching.TagComparisonType;
import com.alachisoft.ncache.client.TagSearchOptions;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.SearchServiceImpl;
import com.alachisoft.ncache.client.services.SearchService;
import com.alachisoft.ncache.runtime.caching.Tag;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import java.util.ArrayList;
import java.util.List;

public class ClientCacheSearchService
extends SearchServiceImpl
implements SearchService {
    CacheImpl _nearCacheContainer;
    protected boolean _clientCacheUsed;

    CacheImpl getNearCacheContainer() {
        this._clientCacheUsed = true;
        return this._nearCacheContainer;
    }

    void setNearCacheContainer(CacheImpl nearCacheContainer) {
        this._nearCacheContainer = nearCacheContainer;
    }

    public ClientCacheSearchService(CacheImpl farCache, CacheImpl nearCache) {
        super(farCache);
        this._nearCacheContainer = nearCache;
    }

    @Override
    public void removeByTag(Tag tag) throws CacheException {
        if (tag == null || tag.getTagName() == null) {
            throw new IllegalArgumentException("Tag cannot be null.");
        }
        this.getNearCacheContainer().removeByTag(new Tag[]{tag}, TagComparisonType.BY_TAG);
        if (this._clientCacheUsed) {
            this.getCacheContainer().removeByTag(new Tag[]{tag}, TagComparisonType.BY_TAG);
        }
    }

    @Override
    public void removeByTags(List<Tag> tags, TagSearchOptions type) throws CacheException {
        if (tags == null) {
            throw new IllegalArgumentException("Tags cannot be null.\nParameter name: tags");
        }
        Tag[] tagsList = new ArrayList<Tag>(tags).toArray(new Tag[0]);
        if (tagsList.length == 0) {
            throw new IllegalArgumentException("At least one Tag required.");
        }
        this.removeDuplicateTags(tagsList);
        this.getNearCacheContainer().removeByTag(tagsList, this.getTagComparisonType(type));
        if (this._clientCacheUsed) {
            this.getCacheContainer().removeByTag(tagsList, this.getTagComparisonType(type));
        }
    }

    @Override
    public void removeGroupData(String group) throws CacheException {
        this.getNearCacheContainer().removeGroupData(group);
        if (this._clientCacheUsed) {
            this.getCacheContainer().removeGroupData(group);
        }
    }
}

