/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import com.alachisoft.ncache.client.CacheStream;
import com.alachisoft.ncache.client.StreamMode;
import com.alachisoft.ncache.client.internal.caching.InputCacheStream;
import com.alachisoft.ncache.client.internal.caching.OutputCacheStream;
import com.alachisoft.ncache.runtime.exceptions.NotSupportedException;
import com.alachisoft.ncache.runtime.exceptions.StreamException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

final class CacheStreamImpl
implements CacheStream {
    private StreamMode _mode;
    private CacheStream cacheStream;

    CacheStreamImpl() {
    }

    void setCacheStream(CacheStream cacheStream) {
        if (cacheStream != null) {
            this.cacheStream = cacheStream;
            this._mode = cacheStream instanceof OutputCacheStream ? StreamMode.Write : StreamMode.Read;
        }
    }

    void setMode(StreamMode mode) {
        this._mode = mode;
    }

    @Override
    public BufferedInputStream getBufferedInputStream(int bufferSize) throws Exception {
        if (this._mode == StreamMode.Write) {
            throw new NotSupportedException("Stream does not support reading.");
        }
        if (bufferSize > 0) {
            return new BufferedInputStream((InputStream)((Object)this.cacheStream), bufferSize);
        }
        throw new IllegalArgumentException("buffer size should be greater than zero");
    }

    @Override
    public BufferedOutputStream getBufferedOutputStream(int bufferSize) throws Exception {
        if (this._mode != StreamMode.Write) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        if (bufferSize > 0) {
            return new BufferedOutputStream((OutputStream)((Object)this.cacheStream), bufferSize);
        }
        throw new IllegalArgumentException("buffer size should be greater than zero");
    }

    @Override
    public BufferedInputStream getBufferedInputStream() throws Exception {
        if (this._mode == StreamMode.Write) {
            throw new NotSupportedException("Stream does not support reading.");
        }
        return new BufferedInputStream((InputStream)((Object)this.cacheStream), 4096);
    }

    @Override
    public BufferedOutputStream getBufferedOutputStream() throws Exception {
        if (this._mode != StreamMode.Write) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        return new BufferedOutputStream((OutputStream)((Object)this.cacheStream), 4096);
    }

    @Override
    public long length() throws Exception {
        if (this.cacheStream.closed()) {
            throw new IllegalAccessException("Methods were called after the stream was closed.");
        }
        return this.cacheStream.length();
    }

    @Override
    public boolean canRead() {
        return this._mode != StreamMode.Write;
    }

    @Override
    public boolean canSeek() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return this._mode == StreamMode.Write;
    }

    @Override
    public boolean closed() {
        return this.cacheStream.closed();
    }

    @Override
    public void flush() {
    }

    @Override
    public long position() throws Exception {
        if (!this.canSeek()) {
            throw new NotSupportedException("Operation not supported");
        }
        return 0L;
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws Exception {
        if (this._mode == StreamMode.Write) {
            throw new NotSupportedException("Stream does not support reading.");
        }
        int bytesRead = ((InputCacheStream)this.cacheStream).read(buffer, offset, count);
        return bytesRead;
    }

    @Override
    public long seek(long offset) throws NotSupportedException {
        throw new NotSupportedException("Stream does not support seeking.");
    }

    @Override
    public void setLength(long value) throws NotSupportedException {
        throw new NotSupportedException("Stream does not support both writing and seeking");
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws Exception {
        if (this._mode == StreamMode.Read || this._mode == StreamMode.ReadWithoutLock) {
            throw new StreamException("Stream does not support writing.");
        }
        ((OutputCacheStream)this.cacheStream).write(buffer, offset, count);
    }

    @Override
    public void close() throws Exception {
        if (this._mode == StreamMode.Read || this._mode == StreamMode.ReadWithoutLock) {
            ((InputCacheStream)this.cacheStream).close();
        } else {
            ((OutputCacheStream)this.cacheStream).close();
        }
    }
}

