/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Caching.AutoExpiration.DependencyHelper;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.CompressedValueEntry;
import Alachisoft.NCache.Caching.Queries.QueryResultSet;
import Alachisoft.NCache.Caching.TagComparisonType;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.CompressionUtil;
import Alachisoft.NCache.Common.DataReader.RecordSetEnumerator;
import Alachisoft.NCache.Common.DataSource.ClientCacheItem;
import Alachisoft.NCache.Common.DataStructures.EnumerationDataChunk;
import Alachisoft.NCache.Common.DataStructures.EnumerationPointer;
import Alachisoft.NCache.Common.DataStructures.NewHashmap;
import Alachisoft.NCache.Common.DataStructures.VirtualArray;
import Alachisoft.NCache.Common.DataTypes.CollectionCreateOrGetOperation;
import Alachisoft.NCache.Common.DataTypes.CollectionOperation;
import Alachisoft.NCache.Common.DataTypes.Counter.CounterGetOperation;
import Alachisoft.NCache.Common.DataTypes.Counter.CounterOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryAddOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryContainsOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryGetOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryRemoveOperation;
import Alachisoft.NCache.Common.DataTypes.GetCollectionChunkOperation;
import Alachisoft.NCache.Common.DataTypes.GetDictionaryChunkOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetAddOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetContainsOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetGetRandomOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetRemoveOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetRemoveRandomOperation;
import Alachisoft.NCache.Common.DataTypes.KeyValuePairedEnumerationFilter;
import Alachisoft.NCache.Common.DataTypes.List.ListAddWithPivotOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListAddWithoutIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListGetBulkOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListGetItemOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListInsertWithIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListRemoveWithIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListRemoveWithoutIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListSearchOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueueDequeueOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueueEnqueueOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueuePeekOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueueSearchOperation;
import Alachisoft.NCache.Common.DataTypes.Responses.GetCollectionChunkResponse;
import Alachisoft.NCache.Common.DataTypes.Responses.GetCollectionChunkResponseBase;
import Alachisoft.NCache.Common.DataTypes.Responses.GetPairedCollectionChunkResponse;
import Alachisoft.NCache.Common.EncryptionUtil;
import Alachisoft.NCache.Common.Enum.SerializationFormat;
import Alachisoft.NCache.Common.Enum.UserObjectType;
import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Queries.AverageResult;
import Alachisoft.NCache.Common.ResourcePool;
import Alachisoft.NCache.Common.Stats.UsageStats;
import Alachisoft.NCache.Common.Threading.ThreadPool;
import Alachisoft.NCache.Management.CacheConfig;
import Alachisoft.NCache.Management.Statistics.StatisticsCounter;
import com.alachisoft.ncache.client.Cache;
import com.alachisoft.ncache.client.CacheClearedListener;
import com.alachisoft.ncache.client.CacheClientConnectivityChangedListener;
import com.alachisoft.ncache.client.CacheCollection;
import com.alachisoft.ncache.client.CacheDataModificationListener;
import com.alachisoft.ncache.client.CacheEventDescriptor;
import com.alachisoft.ncache.client.CacheItem;
import com.alachisoft.ncache.client.CacheItemVersion;
import com.alachisoft.ncache.client.CacheItemWrapperInternal;
import com.alachisoft.ncache.client.CacheManager;
import com.alachisoft.ncache.client.CacheReader;
import com.alachisoft.ncache.client.CacheStatusEventListener;
import com.alachisoft.ncache.client.CacheStream;
import com.alachisoft.ncache.client.CacheStreamAttributes;
import com.alachisoft.ncache.client.CacheSyncDependency;
import com.alachisoft.ncache.client.ClientInfo;
import com.alachisoft.ncache.client.ContinuousQuery;
import com.alachisoft.ncache.client.Credentials;
import com.alachisoft.ncache.client.EventUtil;
import com.alachisoft.ncache.client.LockHandle;
import com.alachisoft.ncache.client.NonQueryIndexed;
import com.alachisoft.ncache.client.QueryIndexable;
import com.alachisoft.ncache.client.QueryIndexed;
import com.alachisoft.ncache.client.StreamMode;
import com.alachisoft.ncache.client.datastructures.DataStructureAttributes;
import com.alachisoft.ncache.client.datastructures.DataStructureManager;
import com.alachisoft.ncache.client.internal.caching.AggregateFunctionType;
import com.alachisoft.ncache.client.internal.caching.CacheAsyncEventsListener;
import com.alachisoft.ncache.client.internal.caching.CacheDataReader;
import com.alachisoft.ncache.client.internal.caching.CacheEventsListener;
import com.alachisoft.ncache.client.internal.caching.CacheHelper;
import com.alachisoft.ncache.client.internal.caching.CacheImplBase;
import com.alachisoft.ncache.client.internal.caching.CacheItemRemovedListener;
import com.alachisoft.ncache.client.internal.caching.CacheItemUpdatedListener;
import com.alachisoft.ncache.client.internal.caching.CacheStreamImpl;
import com.alachisoft.ncache.client.internal.caching.ClientDataReader;
import com.alachisoft.ncache.client.internal.caching.ClientRecordSetEnumeratorImpl;
import com.alachisoft.ncache.client.internal.caching.ContinuousQueryManager;
import com.alachisoft.ncache.client.internal.caching.CustomEventListener;
import com.alachisoft.ncache.client.internal.caching.DataReaderCommon;
import com.alachisoft.ncache.client.internal.caching.EventManager;
import com.alachisoft.ncache.client.internal.caching.EventTypeInternal;
import com.alachisoft.ncache.client.internal.caching.ExpirationUtil;
import com.alachisoft.ncache.client.internal.caching.IndexableQueryData;
import com.alachisoft.ncache.client.internal.caching.InputCacheStream;
import com.alachisoft.ncache.client.internal.caching.MessagingServiceImpl;
import com.alachisoft.ncache.client.internal.caching.NotificationServiceImpl;
import com.alachisoft.ncache.client.internal.caching.OutputCacheStream;
import com.alachisoft.ncache.client.internal.caching.PollNotificationListener;
import com.alachisoft.ncache.client.internal.caching.RemoteCacheClusterEventsListener;
import com.alachisoft.ncache.client.internal.caching.SearchServiceImpl;
import com.alachisoft.ncache.client.internal.caching.WebCacheEnumerator;
import com.alachisoft.ncache.client.internal.datastructure.DataStructureManagerImpl;
import com.alachisoft.ncache.client.internal.util.ClientConfiguration;
import com.alachisoft.ncache.client.internal.util.ConversionUtil;
import com.alachisoft.ncache.client.internal.util.DictionaryEntry;
import com.alachisoft.ncache.client.internal.util.HelperUtil;
import com.alachisoft.ncache.client.services.MessagingService;
import com.alachisoft.ncache.client.services.NotificationService;
import com.alachisoft.ncache.client.services.SearchService;
import com.alachisoft.ncache.common.caching.EntryType;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.JSON.JsonObject;
import com.alachisoft.ncache.runtime.JSON.JsonValueBase;
import com.alachisoft.ncache.runtime.caching.CacheItemAttributes;
import com.alachisoft.ncache.runtime.caching.DataSourceModifiedListener;
import com.alachisoft.ncache.runtime.caching.DistributedDataStructure;
import com.alachisoft.ncache.runtime.caching.NamedTagsDictionary;
import com.alachisoft.ncache.runtime.caching.ReadMode;
import com.alachisoft.ncache.runtime.caching.ReadThruOptions;
import com.alachisoft.ncache.runtime.caching.Tag;
import com.alachisoft.ncache.runtime.caching.WriteMode;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.caching.datasource.ResyncOptions;
import com.alachisoft.ncache.runtime.caching.expiration.Expiration;
import com.alachisoft.ncache.runtime.caching.expiration.ExpirationConstants;
import com.alachisoft.ncache.runtime.caching.expiration.ExpirationType;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.events.DataTypeEventDataFilter;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.events.ListenerType;
import com.alachisoft.ncache.runtime.exceptions.AggregateException;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.ConnectionException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.OperationNotSupportedException;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import com.alachisoft.ncache.runtime.exceptions.StreamAlreadyLockedException;
import com.alachisoft.ncache.runtime.exceptions.StreamException;
import com.alachisoft.ncache.runtime.exceptions.StreamNotFoundException;
import com.alachisoft.ncache.runtime.exceptions.runtime.GeneralFailureRuntimeException;
import com.alachisoft.ncache.runtime.exceptions.runtime.OperationFailedRuntimeException;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.security.encryption.EncryptionMgr;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheArgumentException;
import com.alachisoft.ncache.serialization.standard.CompactBinaryFormatter;
import com.alachisoft.ncache.serialization.standard.FormatterServices;
import com.alachisoft.ncache.serialization.util.SerializationUtil;
import com.alachisoft.ncache.serialization.util.TypeInfoMap;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import tangible.DotNetToJavaStringHelper;
import tangible.RefObject;

public class CacheImpl
implements Cache {
    public static TimeSpan NoLockingExpiration = TimeSpan.Zero;
    public static Date NoAbsoluteExpiration = ExpirationConstants.AbsoluteNoneExpiration;
    public static Date defaultAbsolute = ExpirationConstants.AbsoluteDefaultExpiration;
    public static final TimeSpan NoSlidingExpiration = ExpirationConstants.SlidingNoneExpiration;
    public static Date defaultAbsoluteLonger = ExpirationConstants.AbsoluteDefaultLongerExpiration;
    public static final TimeSpan DefaultSliding = ExpirationConstants.SlidingDefaultExpiration;
    public static final TimeSpan DefaultSlidingLonger = ExpirationConstants.SlidingDefaultLongerExpiration;
    private static boolean _serializationEnabled = true;
    public String _cacheId;
    public ContinuousQueryManager _cqManager = new ContinuousQueryManager();
    public MessagingServiceImpl _messagingService;
    boolean _clientCacheEnabled = false;
    FormatterServices impl;
    NotificationService _notificationService;
    StatisticsCounter _perfStatsCollector;
    boolean _exceptionEnabled = true;
    ArrayList<CacheStatusEventListener> cacheStoppedListeners = new ArrayList();
    ArrayList<CacheClearedListener> cacheClearedListeners = new ArrayList();
    ArrayList<CacheStatusEventListener> memberJoinedListeners = new ArrayList();
    ArrayList<CacheStatusEventListener> memberLeftListeners = new ArrayList();
    ArrayList<CacheClientConnectivityChangedListener> cacheClientConnectivityChangedListeners = new ArrayList();
    private GeneralDataNotificationWrapper _notificationWrapper = null;
    private CacheClearedListener _cqCacheClearListener;
    private CacheEventsListener _listener = null;
    private AtomicInteger _refCount = new AtomicInteger(0);
    private int _refCacheStoppedCount = 0;
    private int _refClearCount = 0;
    private int _refCustomCount = 0;
    private TimeSpan noLockExpiration = TimeSpan.Zero;
    private ResourcePool _callbackIDsMap = new ResourcePool();
    private ResourcePool _callbacksMap = new ResourcePool();
    private int _refCounter = 0;
    private RemoteCacheClusterEventsListener _clusterListener;
    private ArrayList _secondaryInprocInstances;
    private SearchService _searchService;
    private SerializationFormat _serializationFormat;
    private DataStructureManager _dataTypeManager;
    private Credentials _securityParams;
    private CacheConfig _config;
    private CacheAsyncEventsListener _asyncListener;
    private CacheImplBase _cacheImpl;
    private String _serializationContext;
    private EventManager _eventManager;
    private int _compressed = 2;
    ResourcePool _asyncCallbackIDsMap = new ResourcePool();
    private ResourcePool _asyncCallbacksMap = new ResourcePool();
    private short _dsiacbInitialVal = (short)6000;
    private short _dsiucbInitialVal = (short)7000;
    private short _dsircbInitialVal = (short)8000;
    private long _compressionThresholdSize = 0L;
    private boolean _compressionEnabled = false;
    boolean _encryptionEnabled = false;
    private TypeInfoMap typeMap = null;
    private String _defaultReadThruProvider;
    private String _defaultWriteThruProvider;
    private long size;
    private WebCacheEnumerator enumerator;
    private ConcurrentHashMap _indexableValues = new ConcurrentHashMap();
    private ConcurrentHashMap _nonIndexableValues = new ConcurrentHashMap();

    public CacheImpl() {
        this._notificationWrapper = new GeneralDataNotificationWrapper(this);
        this._eventManager = new EventManager(this._cacheId, null, this);
        this._listener = new CacheEventsListener(this, this._eventManager);
    }

    public CacheImpl(CacheImplBase objectCache, CacheConfig config) throws CacheException {
        this._notificationWrapper = new GeneralDataNotificationWrapper(this);
        this._cacheImpl = objectCache;
        this._config = config;
        this._cacheId = config.getCacheId();
        if (this._cacheImpl != null) {
            this._serializationContext = this._cacheImpl.getName();
            this._cacheId = this._cacheImpl.getName();
        }
        this._eventManager = new EventManager(this._cacheId, null, this);
        this._listener = new CacheEventsListener(this, this._eventManager);
        this._asyncListener = new CacheAsyncEventsListener(this);
        this._clusterListener = new RemoteCacheClusterEventsListener(this);
        this.loadRWTrhuSettings();
        this.addRef();
        this._messagingService = new MessagingServiceImpl(this._eventManager, null, this);
        this._dataTypeManager = new DataStructureManagerImpl(this);
        this._searchService = new SearchServiceImpl(this);
        this._notificationService = new NotificationServiceImpl(this);
    }

    public CacheImpl(CacheImplBase objectCache, String cacheId, StatisticsCounter perfStatsCollector) throws CacheException {
        this._notificationWrapper = new GeneralDataNotificationWrapper(this);
        this._cacheImpl = objectCache;
        this._cacheId = cacheId;
        if (this._cacheImpl != null) {
            this._serializationContext = this._cacheImpl.getName();
        }
        this._eventManager = new EventManager(this._cacheId, null, this);
        this._listener = new CacheEventsListener(this, this._eventManager);
        this._asyncListener = new CacheAsyncEventsListener(this);
        this._clusterListener = new RemoteCacheClusterEventsListener(this);
        this._perfStatsCollector = perfStatsCollector;
        this.loadRWTrhuSettings();
        this.addRef();
        this._messagingService = new MessagingServiceImpl(this._eventManager, perfStatsCollector, this);
        this._dataTypeManager = new DataStructureManagerImpl(this);
        this.setSearchService(new SearchServiceImpl(this));
        this.setNotificationService(new NotificationServiceImpl(this));
    }

    public CacheImpl getCacheInstanceInternal() {
        return this;
    }

    public ArrayList<CacheStatusEventListener> getMemberJoinedListeners() {
        return this.memberJoinedListeners;
    }

    public ArrayList<CacheStatusEventListener> getMemberLeftListeners() {
        return this.memberLeftListeners;
    }

    public ArrayList<CacheClientConnectivityChangedListener> getCacheClientConnectivityChangedListeners() {
        return this.cacheClientConnectivityChangedListeners;
    }

    public boolean getExceptionEnabled() {
        return this._exceptionEnabled;
    }

    public void setExceptionEnabled(boolean exceptionEnabled) {
        this._exceptionEnabled = exceptionEnabled;
    }

    @Override
    public SearchService getSearchService() {
        return this._searchService;
    }

    public void setSearchService(SearchService value) {
        this._searchService = value;
    }

    @Override
    public DataStructureManager getDataStructuresManager() {
        return this._dataTypeManager;
    }

    @Override
    public NotificationService getNotificationService() throws CacheException {
        return this._notificationService;
    }

    private void setNotificationService(NotificationService value) {
        this._notificationService = value;
    }

    @Override
    public ClientInfo getClientInfo() throws CacheException {
        return this._cacheImpl.getLocalClientInfo();
    }

    @Override
    public List<ClientInfo> getConnectedClientList() throws CacheException {
        return this._cacheImpl.getConnectedClientList();
    }

    private static String[] toArray(Iterable<String> values) {
        ArrayList<String> list = new ArrayList<String>();
        for (String item : values) {
            list.add(item);
        }
        String[] array = list.toArray(new String[list.size()]);
        return array;
    }

    SerializationFormat getSerializationFormat() {
        return this._serializationFormat;
    }

    void setSerializationFormat(SerializationFormat _serializationFormat) {
        this._serializationFormat = _serializationFormat;
    }

    public ContinuousQueryManager getCQManager() {
        return this._cqManager;
    }

    public void setMessagingServiceCacheImpl(CacheImplBase cacheImpl) {
        this._messagingService.getPubSubManager().setCacheImpl(cacheImpl);
    }

    public void setDataTypeManagerImpl(CacheImpl cache) throws CacheException {
        this._dataTypeManager.setCache(cache);
    }

    public Credentials getSecurityParameters() {
        return this._securityParams;
    }

    public void setSecurityParameters(Credentials value) {
        this._securityParams = value;
    }

    public RemoteCacheClusterEventsListener getClusterListener() {
        return this._clusterListener;
    }

    public CacheAsyncEventsListener getAsyncListener() {
        return this._asyncListener;
    }

    CacheEventsListener getEventListener() {
        return this._listener;
    }

    public String getSerializationContext() {
        return this._serializationContext;
    }

    void setSerializationContext(String value) {
        this._serializationContext = value;
    }

    public EventManager getEventManager() {
        return this._eventManager;
    }

    public ArrayList<CacheStatusEventListener> getCacheStoppedListeners() {
        return this.cacheStoppedListeners;
    }

    public ArrayList<CacheClearedListener> getCacheClearedListeners() {
        return this.cacheClearedListeners;
    }

    @Override
    public void close() {
        this.dispose(true);
    }

    @Override
    public boolean updateAttributes(String key, CacheItemAttributes attributes) throws CacheException {
        this.validateKey(key);
        if (attributes == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: attribute");
        }
        return this._cacheImpl.setAttributes(key, attributes);
    }

    @Override
    public CacheItemVersion add(String key, Object value) throws CacheException, IllegalArgumentException {
        Expiration expiration = new Expiration(ExpirationType.DefaultAbsolute);
        CacheItem cacheItem = new CacheItem(value);
        cacheItem.setExpiration(expiration);
        return this.add(key, cacheItem);
    }

    @Override
    public CacheItemVersion add(String key, CacheItem item) throws CacheException, IllegalArgumentException {
        return this.add(key, item, null);
    }

    @Override
    public CacheItemVersion add(String key, CacheItem item, WriteThruOptions writeThruOptions) throws CacheException, IllegalArgumentException {
        return this.AddInternal(key, item, writeThruOptions);
    }

    private CacheItemVersion AddInternal(String key, CacheItem item, WriteThruOptions writeThruOptions) throws CacheException, IllegalArgumentException {
        RefObject size = new RefObject((Object)0L);
        if (item == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: CacheItem");
        }
        WriteMode mode = WriteMode.None;
        String providerName = null;
        DataSourceModifiedListener dataSourceModifiedListener = null;
        EnumSet eventTypes = EnumSet.of(EventTypeInternal.None);
        RefObject tempRef_mode = new RefObject((Object)mode);
        RefObject tempRef_providerName = new RefObject(providerName);
        RefObject tempRef_dataSourceModifiedCallback = new RefObject(dataSourceModifiedListener);
        RefObject tempRef_eventTypes = new RefObject(eventTypes);
        ConversionUtil.GetWriteOptions(writeThruOptions, (RefObject<WriteMode>)tempRef_mode, (RefObject<String>)tempRef_providerName, (RefObject<DataSourceModifiedListener>)tempRef_dataSourceModifiedCallback, (RefObject<EnumSet<EventTypeInternal>>)tempRef_eventTypes);
        mode = (WriteMode)tempRef_mode.argvalue;
        providerName = (String)tempRef_providerName.argvalue;
        dataSourceModifiedListener = (DataSourceModifiedListener)tempRef_dataSourceModifiedCallback.argvalue;
        eventTypes = (EnumSet)tempRef_eventTypes.argvalue;
        EventTypeInternal eventTypeInternal = (EventTypeInternal)((Object)eventTypes.toArray()[0]);
        boolean ResyncOnExpirationEnable = false;
        if (item.getResyncOptions() != null) {
            ResyncOnExpirationEnable = item.getResyncOptions().getResyncOnExpiration();
        }
        String ResyncProvider = null;
        if (item.getResyncOptions() != null) {
            ResyncProvider = item.getResyncOptions().getProviderName();
        }
        return this.addOperation(key, item.getValue(Object.class), item.getDependency(), item.getSyncDependency(), ConversionUtil.getAbsoluteExpiration(item.getExpiration()), ConversionUtil.getSlidingExpiration(item.getExpiration()), item.getCacheItemPriority(), mode, dataSourceModifiedListener, eventTypeInternal, ResyncOnExpirationEnable, item.getGroup(), ConversionUtil.toArray(item.getTags()), providerName, ResyncProvider, item.getNamedTags(), CacheItemWrapperInternal.getCacheItemUpdatedListener(item), CacheItemWrapperInternal.getCacheItemRemovedListener(item), CacheItemWrapperInternal.getItemUpdatedDataFilter(item), CacheItemWrapperInternal.getItemRemovedDataFilter(item), (RefObject<Long>)size, true, null, (short)-1, (short)-1, (short)-1);
    }

    @Override
    public FutureTask<CacheItemVersion> addAsync(String key, Object value) {
        Expiration expiration = new Expiration(ExpirationType.DefaultAbsolute);
        CacheItem cacheItem = new CacheItem(value);
        cacheItem.setExpiration(expiration);
        return this.addAsync(key, cacheItem);
    }

    @Override
    public FutureTask<CacheItemVersion> addAsync(String key, CacheItem item) {
        return this.addAsync(key, item, new WriteThruOptions(WriteMode.None, ""));
    }

    @Override
    public FutureTask<CacheItemVersion> addAsync(String key, CacheItem item, WriteThruOptions writeThruOptions) {
        AddAsyncCallable task = new AddAsyncCallable(key, item, writeThruOptions);
        FutureTask<CacheItemVersion> futureTask = new FutureTask<CacheItemVersion>(task);
        ThreadPool.getInstance().executeTask(futureTask);
        return futureTask;
    }

    protected CacheItemVersion addOperation(String key, Object value, CacheDependency dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, WriteMode writeMode, DataSourceModifiedListener onDataSourceModified, EventTypeInternal eventTypeInternal, boolean isResyncExpiredItems, String group, Tag[] tags, String providerName, String resyncProviderName, NamedTagsDictionary namedTags, CacheDataModificationListener cacheItemUpdatedListener, CacheDataModificationListener cacheItemRemovedListener, EventDataFilter itemUpdateDataFilter, EventDataFilter itemRemovedDataFilter, RefObject<Long> size, boolean allowQueryTags, String clientId, short updateCallbackId, short removeCallbackId, short dsItemAddedCallbackId) throws CacheException, IllegalArgumentException {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        this.validateKeyValue(key, value);
        if (value instanceof com.alachisoft.ncache.client.datastructures.DistributedDataStructure) {
            throw new IllegalArgumentException("Value cannot be a distributed data type.");
        }
        String typeName = null;
        HashMap<String, HashMap> queryInfo = null;
        BitSet flagMap = new BitSet();
        if (value instanceof ClientCacheItem) {
            ClientCacheItem clientcacheItem = (ClientCacheItem)(value instanceof ClientCacheItem ? value : null);
            value = clientcacheItem.getValue();
            queryInfo = clientcacheItem.getQueryInfo();
            if (clientcacheItem.getFlags().IsAnyBitSet((byte)-128)) {
                flagMap.SetBit((byte)-128);
            } else if (clientcacheItem.getFlags().IsAnyBitSet((byte)32)) {
                flagMap.SetBit((byte)32);
            }
            typeName = clientcacheItem.getGroupDataType();
        }
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)group) && DotNetToJavaStringHelper.isNullOrEmpty(typeName)) {
            typeName = this.getTypeName(value);
        }
        if ((writeMode == WriteMode.WriteThru || writeMode == WriteMode.WriteBehind) && providerName == null) {
            providerName = this._defaultWriteThruProvider;
        }
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)providerName)) {
            providerName.toLowerCase();
        }
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)resyncProviderName)) {
            resyncProviderName = resyncProviderName.toLowerCase();
        }
        if (itemUpdateDataFilter == null) {
            itemUpdateDataFilter = EventDataFilter.None;
        }
        if (itemRemovedDataFilter == null) {
            itemRemovedDataFilter = EventDataFilter.None;
        }
        UsageStats stats = new UsageStats();
        stats.BeginSample();
        if (queryInfo == null) {
            queryInfo = new HashMap<String, HashMap>();
            if (allowQueryTags) {
                ArrayList<Tag> validTags;
                HashMap htTagInfo;
                HashMap htNamedTagInfo;
                HashMap htQueryInfo = this.getQueryInfo(value);
                if (htQueryInfo != null) {
                    queryInfo.put("query-info", htQueryInfo);
                }
                if ((htNamedTagInfo = this.getNamedTagsInfo(value, namedTags, htQueryInfo == null)) != null) {
                    queryInfo.put("named-tag-info", htNamedTagInfo);
                }
                if ((htTagInfo = this.getTagInfo(value, tags, validTags = new ArrayList<Tag>())) != null) {
                    queryInfo.put("tag-info", htTagInfo);
                }
            }
        }
        value = this.safeSerialize(value, this._serializationContext, flagMap, (Long)size.getValue(), UserObjectType.CacheItem);
        value = this.encryptAndCompress(value, flagMap);
        flagMap = this.setDSUpdateOptBit(flagMap, writeMode);
        if (absoluteExpiration != null && absoluteExpiration != NoAbsoluteExpiration) {
            try {
                absoluteExpiration = NCDateTime.getUTCDate((Date)absoluteExpiration);
            }
            catch (ParseException htQueryInfo) {
                // empty catch block
            }
        }
        if (removeCallbackId == -1 && cacheItemRemovedListener != null) {
            short[] callbackIds = this._eventManager.registerSelectiveEvent(cacheItemRemovedListener, EnumSet.of(EventType.ItemRemoved), itemRemovedDataFilter);
            removeCallbackId = callbackIds[1];
        }
        if (updateCallbackId == -1 && cacheItemUpdatedListener != null) {
            short[] callabackIds = this._eventManager.registerSelectiveEvent(cacheItemUpdatedListener, EnumSet.of(EventType.ItemUpdated), itemUpdateDataFilter);
            updateCallbackId = callabackIds[0];
        }
        if (dsItemAddedCallbackId == -1 && onDataSourceModified != null) {
            dsItemAddedCallbackId = this.GetCallbackId(onDataSourceModified, 1, eventTypeInternal);
        }
        CacheItemVersion cVersion = this._cacheImpl.add(key, value, dependency, syncDependency, absoluteExpiration, slidingExpiration, priority, removeCallbackId, updateCallbackId, dsItemAddedCallbackId, isResyncExpiredItems, group, queryInfo, flagMap, providerName, resyncProviderName, itemUpdateDataFilter, itemRemovedDataFilter, (Long)size.argvalue, this._cacheImpl.getEncryptionEnabled(), clientId, typeName);
        if (this.isPerfStatsCollectorInitialized()) {
            stats.EndSample();
            this._perfStatsCollector.incrementMsecPerAddSample(stats.getCurrent());
            this._perfStatsCollector.incrementAddPerSecStats();
        }
        return cVersion;
    }

    @Override
    public CacheItemVersion insert(String key, Object value) throws CacheException, IllegalArgumentException {
        this.validateKeyValue(key, value);
        Expiration expiration = new Expiration(ExpirationType.DefaultAbsolute);
        CacheItem cacheItem = new CacheItem(value);
        cacheItem.setExpiration(expiration);
        return this.insert(key, cacheItem);
    }

    @Override
    public CacheItemVersion insert(String key, CacheItem item) throws CacheException, IllegalArgumentException {
        if (item == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: CacheItem");
        }
        return this.insert(key, item, null, null, false);
    }

    @Override
    public CacheItemVersion insert(String key, CacheItem item, WriteThruOptions writeThruOptions) throws CacheException, IllegalArgumentException {
        return this.insert(key, item, writeThruOptions, new LockHandle(), false);
    }

    @Override
    public CacheItemVersion insert(String key, CacheItem item, WriteThruOptions writeThruOptions, LockHandle lockHandle, boolean releaseLock) throws CacheException, IllegalArgumentException {
        return this.InsertInternal(key, item, writeThruOptions, lockHandle, releaseLock);
    }

    private CacheItemVersion InsertInternal(String key, CacheItem item, WriteThruOptions writeThruOptions, LockHandle lockHandle, boolean releaseLock) throws CacheException, IllegalArgumentException {
        LockAccessType accessType;
        this.validateKeyValue(key, item);
        WriteMode mode = WriteMode.None;
        String providerName = null;
        DataSourceModifiedListener dataSourceModifiedListener = null;
        EnumSet eventTypes = EnumSet.of(EventTypeInternal.None);
        RefObject tempRef_mode = new RefObject((Object)mode);
        RefObject tempRef_providerName = new RefObject(providerName);
        RefObject tempRef_dataSourceModifiedCallback = new RefObject(dataSourceModifiedListener);
        RefObject tempRef_eventTypes = new RefObject(eventTypes);
        ConversionUtil.GetWriteOptions(writeThruOptions, (RefObject<WriteMode>)tempRef_mode, (RefObject<String>)tempRef_providerName, (RefObject<DataSourceModifiedListener>)tempRef_dataSourceModifiedCallback, (RefObject<EnumSet<EventTypeInternal>>)tempRef_eventTypes);
        mode = (WriteMode)tempRef_mode.argvalue;
        providerName = (String)tempRef_providerName.argvalue;
        dataSourceModifiedListener = (DataSourceModifiedListener)tempRef_dataSourceModifiedCallback.argvalue;
        eventTypes = (EnumSet)tempRef_eventTypes.argvalue;
        EventTypeInternal eventTypeInternal = (EventTypeInternal)((Object)eventTypes.toArray()[0]);
        CacheItemVersion itemVersion = item.getCacheItemVersion();
        LockAccessType lockAccessType = accessType = itemVersion == null ? LockAccessType.IGNORE_LOCK : LockAccessType.COMPARE_VERSION;
        if (lockHandle != null) {
            accessType = releaseLock ? LockAccessType.RELEASE : LockAccessType.DONT_RELEASE;
            itemVersion = null;
        }
        boolean ResyncOnExpirationEnable = false;
        if (item.getResyncOptions() != null) {
            ResyncOnExpirationEnable = item.getResyncOptions().getResyncOnExpiration();
        }
        String ResyncProvider = null;
        if (item.getResyncOptions() != null) {
            ResyncProvider = item.getResyncOptions().getProviderName();
        }
        return this.insertOperation(key, item.getValue(Object.class), item.getDependency(), item.getSyncDependency(), ConversionUtil.getAbsoluteExpiration(item.getExpiration()), ConversionUtil.getSlidingExpiration(item.getExpiration()), item.getCacheItemPriority(), mode, dataSourceModifiedListener, eventTypeInternal, ResyncOnExpirationEnable, item.getGroup(), lockHandle, item.getCacheItemVersion(), accessType, ConversionUtil.toArray(item.getTags()), providerName, ResyncProvider, item.getNamedTags(), CacheItemWrapperInternal.getCacheItemUpdatedListener(item), CacheItemWrapperInternal.getCacheItemRemovedListener(item), CacheItemWrapperInternal.getItemUpdatedDataFilter(item), CacheItemWrapperInternal.getItemRemovedDataFilter(item), true, null, (short)-1, (short)-1, (short)-1);
    }

    @Override
    public FutureTask<CacheItemVersion> insertAsync(String key, Object value) throws OperationFailedException {
        this.validateKeyValue(key, value);
        Expiration expiration = new Expiration(ExpirationType.DefaultAbsolute);
        CacheItem cacheItem = new CacheItem(value);
        cacheItem.setExpiration(expiration);
        if (value instanceof com.alachisoft.ncache.client.datastructures.DistributedDataStructure) {
            throw new IllegalArgumentException("Value cannot be a distributed data type.");
        }
        return this.insertAsync(key, cacheItem);
    }

    @Override
    public FutureTask<CacheItemVersion> insertAsync(String key, CacheItem item) throws OperationFailedException {
        return this.insertAsync(key, item, new WriteThruOptions(WriteMode.None, ""));
    }

    @Override
    public FutureTask<CacheItemVersion> insertAsync(String key, CacheItem item, WriteThruOptions writeThruOptions) throws OperationFailedException {
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)key)) {
            throw new OperationFailedException(17511, ErrorMessages.getErrorMessage((int)17511, (String[])new String[0]));
        }
        if (item == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: CacheItem");
        }
        InsertAsyncCallable task = new InsertAsyncCallable(key, item, writeThruOptions, null, false);
        FutureTask<CacheItemVersion> futureTask = new FutureTask<CacheItemVersion>(task);
        ThreadPool.getInstance().executeTask(futureTask);
        return futureTask;
    }

    CacheItemVersion insertOperation(String key, Object value, CacheDependency dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, WriteMode writeMode, DataSourceModifiedListener onDataSourceModified, EventTypeInternal eventType, boolean isResyncExpiredItems, String group, LockHandle lockHandle, CacheItemVersion version, LockAccessType accessType, Tag[] tags, String providerName, String resyncProviderName, NamedTagsDictionary namedTags, CacheDataModificationListener cacheItemUpdated, CacheDataModificationListener cacheItemRemoved, EventDataFilter itemUpdateDataFilter, EventDataFilter itemRemovedDataFilter, boolean allowQueryTags, String clientId, short updateCallbackId, short removeCallbackId, short dsItemAddedCallbackId) throws CacheException, IllegalArgumentException {
        String lockId;
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        this.validateKeyValue(key, value);
        if (value instanceof com.alachisoft.ncache.client.datastructures.DistributedDataStructure) {
            throw new IllegalArgumentException("Value cannot be a distributed data type.");
        }
        String typeName = null;
        HashMap<String, HashMap> queryInfo = null;
        BitSet flagMap = new BitSet();
        Long size = 0L;
        if (value instanceof ClientCacheItem) {
            ClientCacheItem clientcacheItem = (ClientCacheItem)(value instanceof ClientCacheItem ? value : null);
            value = clientcacheItem.getValue();
            queryInfo = clientcacheItem.getQueryInfo();
            if (clientcacheItem.getFlags().IsAnyBitSet((byte)-128)) {
                flagMap.SetBit((byte)-128);
            } else if (clientcacheItem.getFlags().IsAnyBitSet((byte)32)) {
                flagMap.SetBit((byte)32);
            }
            typeName = clientcacheItem.getGroupDataType();
        }
        if ((writeMode == WriteMode.WriteThru || writeMode == WriteMode.WriteBehind) && providerName == null) {
            providerName = this._defaultWriteThruProvider;
        }
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)providerName)) {
            providerName.toLowerCase();
        }
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)resyncProviderName)) {
            resyncProviderName = resyncProviderName.toLowerCase();
        }
        String string = lockId = lockHandle == null ? null : lockHandle.getLockId();
        if (itemUpdateDataFilter == null) {
            itemUpdateDataFilter = EventDataFilter.None;
        }
        if (itemRemovedDataFilter == null) {
            itemRemovedDataFilter = EventDataFilter.None;
        }
        UsageStats stats = new UsageStats();
        stats.BeginSample();
        if (queryInfo == null) {
            queryInfo = new HashMap<String, HashMap>();
            if (allowQueryTags) {
                ArrayList<Tag> validTags;
                HashMap htTagInfo;
                HashMap staticIndexes = this.getQueryInfo(value);
                queryInfo.put("query-info", staticIndexes);
                HashMap htNamedTagInfo = this.getNamedTagsInfo(value, namedTags, staticIndexes == null);
                if (htNamedTagInfo != null) {
                    queryInfo.put("named-tag-info", htNamedTagInfo);
                }
                if ((htTagInfo = this.getTagInfo(value, tags, validTags = new ArrayList<Tag>())) != null) {
                    queryInfo.put("tag-info", htTagInfo);
                }
            }
        }
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)group) && DotNetToJavaStringHelper.isNullOrEmpty((String)typeName)) {
            typeName = this.getTypeName(value);
        }
        value = this.safeSerialize(value, this._serializationContext, flagMap, size, UserObjectType.CacheItem);
        value = this.encryptAndCompress(value, flagMap);
        flagMap = this.setDSUpdateOptBit(flagMap, writeMode);
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)lockId)) {
            flagMap.SetBit((byte)64);
        } else {
            flagMap.UnsetBit((byte)64);
        }
        if (absoluteExpiration != null && absoluteExpiration.compareTo(NoAbsoluteExpiration) != 0) {
            try {
                absoluteExpiration = NCDateTime.getUTCDate((Date)absoluteExpiration);
            }
            catch (ParseException staticIndexes) {
                // empty catch block
            }
        }
        if (removeCallbackId == -1 && cacheItemRemoved != null) {
            short[] callbackIds = this._eventManager.registerSelectiveEvent(cacheItemRemoved, EnumSet.of(EventType.ItemRemoved), itemRemovedDataFilter);
            removeCallbackId = callbackIds[1];
        }
        if (updateCallbackId == -1 && cacheItemUpdated != null) {
            short[] callabackIds = this._eventManager.registerSelectiveEvent(cacheItemUpdated, EnumSet.of(EventType.ItemUpdated), itemUpdateDataFilter);
            updateCallbackId = callabackIds[0];
        }
        if (dsItemAddedCallbackId == -1 && onDataSourceModified != null) {
            dsItemAddedCallbackId = this.GetCallbackId(onDataSourceModified, 1, eventType);
        }
        CacheItemVersion newVersion = null;
        newVersion = this._cacheImpl.insert(key, value, dependency, syncDependency, absoluteExpiration, slidingExpiration, priority, removeCallbackId, updateCallbackId, dsItemAddedCallbackId, isResyncExpiredItems, group, queryInfo, flagMap, lockId, version, accessType, providerName, resyncProviderName, itemUpdateDataFilter, itemRemovedDataFilter, size, this._cacheImpl.getEncryptionEnabled(), clientId, typeName, ListenerType.PushBasedNotification);
        if (this.isPerfStatsCollectorInitialized()) {
            stats.EndSample();
            this._perfStatsCollector.incrementMsecPerUpdSample(stats.getCurrent());
            this._perfStatsCollector.incrementUpdPerSecStats();
        }
        return newVersion;
    }

    @Override
    public <T> T get(String key, Class<?> cls) throws CacheException {
        return this.get(key, new ReadThruOptions(ReadMode.None), cls);
    }

    @Override
    public <T> T get(String key, ReadThruOptions readThruOptions, Class<?> cls) throws CacheException, IllegalArgumentException, ClassCastException {
        LockAccessType accessType = LockAccessType.IGNORE_LOCK;
        CacheItemVersion version = null;
        LockHandle lockHandle = null;
        if (readThruOptions == null) {
            readThruOptions = new ReadThruOptions(ReadMode.None);
        }
        return this.getInternal(key, version, accessType, this.noLockExpiration, lockHandle, readThruOptions, cls);
    }

    @Override
    public <T> T get(String key, boolean acquireLock, TimeSpan lockTimeout, LockHandle lockHandle, Class<?> cls) throws AggregateException, SecurityException, GeneralFailureException, ConfigurationException, OperationFailedException, CommandException, StreamException, OperationNotSupportedException, LicensingException, StreamNotFoundException, StreamAlreadyLockedException, CacheException {
        if (lockHandle == null) {
            throw new IllegalArgumentException("Value cannot be null.\r\nParameter name: LockHandle");
        }
        LockAccessType accessType = acquireLock ? LockAccessType.ACQUIRE : LockAccessType.DONT_ACQUIRE;
        CacheItemVersion version = null;
        ReadThruOptions readThruOptions = new ReadThruOptions(ReadMode.None);
        return this.getInternal(key, version, accessType, lockTimeout, lockHandle, readThruOptions, cls);
    }

    @Override
    public <T> T get(String key, CacheItemVersion version, ReadThruOptions readThruOptions, Class<?> cls) throws CacheException, IllegalArgumentException, ClassCastException {
        if (version == null) {
            throw new IllegalArgumentException("Value cannot be null.\r\nParameter name: version");
        }
        if (readThruOptions == null) {
            readThruOptions = new ReadThruOptions(ReadMode.None);
        }
        LockHandle lockHandle = null;
        LockAccessType accessType = LockAccessType.DEFAULT;
        accessType = version.getVersion() == 0L ? LockAccessType.GET_VERSION : LockAccessType.MATCH_VERSION;
        return this.getInternal(key, version, accessType, this.noLockExpiration, lockHandle, readThruOptions, cls);
    }

    <T> T getInternal(String key, CacheItemVersion version, LockAccessType accessType, TimeSpan lockTimeout, LockHandle lockHandle, ReadThruOptions readOptions, Class<?> cls) throws CacheException {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        this.validateKey(key);
        if (version == null && accessType == LockAccessType.COMPARE_VERSION) {
            throw new IllegalArgumentException("Value cannot be null \nParameter name: version");
        }
        if (readOptions.getReadMode() != ReadMode.None && DotNetToJavaStringHelper.isNullOrEmpty((String)readOptions.getProviderName())) {
            readOptions.setProviderName(this._defaultReadThruProvider);
        }
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)readOptions.getProviderName())) {
            readOptions.setProviderName(readOptions.getProviderName().toLowerCase());
        }
        if (lockHandle == null) {
            lockHandle = new LockHandle();
        }
        if (version == null) {
            version = new CacheItemVersion();
        }
        CompressedValueEntry result = null;
        BitSet flagMap = new BitSet();
        UsageStats stats = new UsageStats();
        stats.BeginSample();
        result = this._cacheImpl.get(key, flagMap, null, version, lockHandle, lockTimeout, accessType, readOptions);
        if (lockHandle != null && !lockHandle.getLockDate().equals(NCDateTime.MinValue)) {
            lockHandle.setLockDate(new NCDateTime(lockHandle.getLockDate()).getLocalizedDate());
        }
        if (this.isPerfStatsCollectorInitialized()) {
            stats.EndSample();
            this._perfStatsCollector.incrementMsecPerGetSample(stats.getCurrent());
            this._perfStatsCollector.incrementGetPerSecStats();
        }
        if (result != null && result.getValue() != null && result.getType() == EntryType.CacheItem) {
            if (result.getFlag().IsBitSet((byte)this._compressed)) {
                result.setValue((Object)this.Decompress((byte[])result.getValue()));
            }
            if (this.isPerfStatsCollectorInitialized() && result.getValue() != null && result.getValue() instanceof byte[]) {
                this._perfStatsCollector.incrementAvgItemSize((long)((byte[])result.getValue()).length);
            }
            if (this._cacheImpl.getEncryptionEnabled()) {
                UsageStats statsEncryption = new UsageStats();
                statsEncryption.BeginSample();
                result.setValue((Object)CacheHelper.DecryptData((byte[])result.getValue(), this._serializationContext));
                statsEncryption.EndSample();
                if (this.isPerfStatsCollectorInitialized()) {
                    this._perfStatsCollector.incrementMsecPerDecryptionSample(statsEncryption.getCurrent());
                }
            }
            result.setValue(this.safeDeserialize(result.getValue(), this._serializationContext, result.getFlag(), UserObjectType.CacheItem, cls));
            return (T)result.getValue();
        }
        return CacheHelper.getSafeValue(CacheHelper.getObjectOrInitializedCollection(key, result.getType(), result.getValue(), this, cls));
    }

    @Override
    public CacheItem getCacheItem(String key) throws CacheException {
        return this.getCacheItem(key, null);
    }

    @Override
    public CacheItem getCacheItem(String key, ReadThruOptions readThruOptions) throws CacheException, IllegalArgumentException {
        LockAccessType accessType = LockAccessType.IGNORE_LOCK;
        CacheItemVersion version = null;
        LockHandle lockHandle = null;
        if (readThruOptions == null) {
            readThruOptions = new ReadThruOptions(ReadMode.None);
        }
        return this.getCacheItemInternal(key, version, accessType, this.noLockExpiration, lockHandle, readThruOptions);
    }

    @Override
    public CacheItem getCacheItem(String key, CacheItemVersion version, ReadThruOptions readThruOptions) throws CacheException {
        if (version == null) {
            throw new IllegalArgumentException("Value cannot be null.\r\nParameter name: version");
        }
        LockHandle lockHandle = null;
        LockAccessType accessType = LockAccessType.DEFAULT;
        LockAccessType lockAccessType = accessType = version.getVersion() == 0L ? LockAccessType.GET_VERSION : LockAccessType.MATCH_VERSION;
        if (readThruOptions == null) {
            readThruOptions = new ReadThruOptions(ReadMode.None);
        }
        return this.getCacheItemInternal(key, version, accessType, this.noLockExpiration, lockHandle, readThruOptions);
    }

    @Override
    public CacheItem getCacheItem(String key, boolean acquireLock, TimeSpan lockTimeout, LockHandle lockHandle) throws CacheException {
        if (lockHandle == null) {
            throw new IllegalArgumentException("Value cannot be null.\r\nParameter name: LockHandle");
        }
        LockAccessType accessType = acquireLock ? LockAccessType.ACQUIRE : LockAccessType.DONT_ACQUIRE;
        CacheItemVersion version = null;
        ReadThruOptions readThruOptions = new ReadThruOptions(ReadMode.None);
        return this.getCacheItemInternal(key, version, accessType, lockTimeout, lockHandle, readThruOptions);
    }

    CacheItem getCacheItemInternal(String key, CacheItemVersion version, LockAccessType accessType, TimeSpan lockTimeout, LockHandle lockHandle, ReadThruOptions readThruOptions) throws CacheException {
        block14: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            this.validateKey(key);
            if (version == null && accessType == LockAccessType.COMPARE_VERSION) {
                throw new IllegalArgumentException("Value cannot be null or empty.\nParameter name: version");
            }
            if (lockHandle == null) {
                lockHandle = new LockHandle();
            }
            if (version == null) {
                version = new CacheItemVersion();
            }
            try {
                Object entry = null;
                BitSet flagMap = new BitSet();
                CacheItem item = new CacheItem();
                UsageStats stats = new UsageStats();
                if (readThruOptions.getReadMode() != ReadMode.None && DotNetToJavaStringHelper.isNullOrEmpty((String)readThruOptions.getProviderName())) {
                    readThruOptions.setProviderName(this._defaultReadThruProvider);
                }
                if (!DotNetToJavaStringHelper.isNullOrEmpty((String)readThruOptions.getProviderName())) {
                    readThruOptions.setProviderName(readThruOptions.getProviderName().toLowerCase());
                }
                stats.BeginSample();
                Object value = this._cacheImpl.getCacheItem(key, flagMap, null, version, lockHandle, lockTimeout, accessType, readThruOptions);
                if (lockHandle != null && !lockHandle.getLockDate().equals(NCDateTime.MinValue)) {
                    lockHandle.setLockDate(new NCDateTime(lockHandle.getLockDate()).getLocalizedDate());
                }
                if (this.isPerfStatsCollectorInitialized()) {
                    stats.EndSample();
                    this._perfStatsCollector.incrementMsecPerGetSample(stats.getCurrent());
                    this._perfStatsCollector.incrementGetPerSecStats();
                }
                if (value == null) {
                    return null;
                }
                if (value instanceof CacheItem) {
                    return this.getCacheItemFromBinaryCacheItem(key, (CacheItem)(value instanceof CacheItem ? value : null));
                }
                return this.getCacheItemFromEntry(key, (CacheEntry)value);
            }
            catch (CacheException e) {
                if (this.getExceptionEnabled()) {
                    throw e;
                }
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block14;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
        return null;
    }

    CacheItem getCacheItemFromEntry(String key, CacheEntry entry) throws CacheException {
        CacheItem item = new CacheItem();
        if (entry != null) {
            CacheItemWrapperInternal.setEntryType(item, entry.getType());
            CacheItemWrapperInternal.setFlagValue(item, entry.getFlag());
            item.setValue(entry.getValue());
            if (CacheItemWrapperInternal.getFlagValue(item).IsBitSet((byte)this._compressed)) {
                try {
                    item.setValue(this.Decompress((byte[])entry.getValue()));
                }
                catch (Exception e) {
                    throw new CacheException(e.getMessage(), e.getCause());
                }
            }
            if (this.isPerfStatsCollectorInitialized() && item.getValue(Object.class) != null && item.getValue(Object.class) instanceof byte[]) {
                this._perfStatsCollector.incrementAvgItemSize((long)((byte[])item.getValue(Object.class)).length);
            }
            item.setCacheItemPriority(entry.getPriority());
            ExpirationHint hint = entry.getExpirationHint();
            if (hint != null) {
                item.setResyncOptions(new ResyncOptions(hint.getNeedsReSync()));
            }
            Date absoluteExpiration = null;
            absoluteExpiration = NCDateTime.MaxValue;
            TimeSpan slidingExpiration = TimeSpan.Zero;
            try {
                RefObject refAbsoluteExpiration = new RefObject((Object)absoluteExpiration);
                RefObject refSlidingExpiration = new RefObject((Object)slidingExpiration);
                item.setDependency(DependencyHelper.GetCacheDependency((ExpirationHint)hint, (RefObject)refAbsoluteExpiration, (RefObject)refSlidingExpiration));
                absoluteExpiration = (Date)refAbsoluteExpiration.getValue();
                slidingExpiration = (TimeSpan)refSlidingExpiration.getValue();
            }
            catch (Exception e) {
                throw new CacheException(e.getMessage(), e.getCause());
            }
            try {
                Date absExp = absoluteExpiration == NCDateTime.MaxValue ? absoluteExpiration : new NCDateTime(absoluteExpiration).getLocalizedDate();
                item.setExpiration(ExpirationUtil.getExpiration(absExp, slidingExpiration));
            }
            catch (ParseException e) {
                throw new CacheException(e.getMessage(), e.getCause());
            }
            if (entry.getGroupInfo() != null) {
                item.setGroup(entry.getGroupInfo().getGroup());
            }
            item.setCacheItemVersion(new CacheItemVersion(entry.getVersion()));
            CacheItemWrapperInternal.setCreationTime(item, entry.getCreationTime());
            CacheItemWrapperInternal.setLastModifiedTime(item, entry.getLastModifiedTime());
            if (entry.getQueryInfo() != null) {
                Object tag;
                Cloneable tagsList;
                HashMap tagInfo;
                if (entry.getQueryInfo().containsKey("tag-info")) {
                    tagInfo = entry.getQueryInfo().get("tag-info") instanceof Map ? entry.getQueryInfo().get("tag-info") : null;
                    tagsList = tagInfo.get("tags-list") instanceof ArrayList ? tagInfo.get("tags-list") : null;
                    Tag[] tags = new Tag[((ArrayList)tagsList).size()];
                    int i = 0;
                    Iterator iterator = ((ArrayList)tagsList).iterator();
                    while (iterator.hasNext()) {
                        tag = iterator.next();
                        tags[i++] = new Tag((String)tag);
                    }
                    item.setTags(Arrays.asList(tags));
                }
                if (entry.getQueryInfo().containsKey("named-tag-info")) {
                    tagInfo = entry.getQueryInfo().get("named-tag-info") instanceof HashMap ? (HashMap)entry.getQueryInfo().get("named-tag-info") : null;
                    tagsList = tagInfo.get("named-tags-list") instanceof HashMap ? tagInfo.get("named-tags-list") : null;
                    NamedTagsDictionary namedTags = new NamedTagsDictionary();
                    for (Map.Entry object : ((HashMap)tagsList).entrySet()) {
                        tag = object;
                        Class<?> tagType = tag.getValue().getClass();
                        String tagKey = tag.getKey().toString();
                        if (tagType == Integer.class) {
                            namedTags.add(tagKey, ((Integer)tag.getValue()).intValue());
                            continue;
                        }
                        if (tagType == Long.class) {
                            namedTags.add(tagKey, ((Long)tag.getValue()).longValue());
                            continue;
                        }
                        if (tagType == Float.class) {
                            namedTags.add(tagKey, ((Float)tag.getValue()).floatValue());
                            continue;
                        }
                        if (tagType == Double.class) {
                            namedTags.add(tagKey, ((Double)tag.getValue()).doubleValue());
                            continue;
                        }
                        if (tagType == BigDecimal.class) {
                            namedTags.add(tagKey, (BigDecimal)tag.getValue());
                            continue;
                        }
                        if (tagType == Boolean.class) {
                            namedTags.add(tagKey, ((Boolean)tag.getValue()).booleanValue());
                            continue;
                        }
                        if (tagType == Character.class) {
                            namedTags.add(tagKey, ((Character)tag.getValue()).charValue());
                            continue;
                        }
                        if (tagType == String.class) {
                            namedTags.add(tagKey, (String)tag.getValue());
                            continue;
                        }
                        if (tagType != Date.class) continue;
                        namedTags.add(tagKey, (Date)tag.getValue());
                    }
                    item.setNamedTags(namedTags);
                }
            }
            CacheItemWrapperInternal.setCacheInstance(item, this);
            item.setValue(CacheHelper.getObjectOrDataTypeForCacheItem(key, entry.getType(), item.getValue(Object.class)));
            return item;
        }
        return null;
    }

    CacheItem getCacheItemFromBinaryCacheItem(String key, CacheItem binaryCacheItem) throws CacheException {
        if (binaryCacheItem == null) {
            return null;
        }
        if (CacheItemWrapperInternal.getFlagValue(binaryCacheItem).IsBitSet((byte)this._compressed)) {
            try {
                binaryCacheItem.setValue(this.Decompress((byte[])binaryCacheItem.getValue(Object.class)));
            }
            catch (Exception e) {
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
        if (this.isPerfStatsCollectorInitialized() && binaryCacheItem.getValue(Object.class) != null && binaryCacheItem.getValue(Object.class) instanceof byte[]) {
            this._perfStatsCollector.incrementAvgItemSize((long)((byte[])binaryCacheItem.getValue(Object.class)).length);
        }
        if (this._cacheImpl.getEncryptionEnabled()) {
            UsageStats statsEncryption = new UsageStats();
            statsEncryption.BeginSample();
            binaryCacheItem.setValue(CacheHelper.DecryptData((byte[])binaryCacheItem.getValue(Object.class), this._serializationContext));
            statsEncryption.EndSample();
            if (this.isPerfStatsCollectorInitialized()) {
                this._perfStatsCollector.incrementMsecPerDecryptionSample(statsEncryption.getCurrent());
            }
        }
        try {
            binaryCacheItem.setExpiration(ExpirationUtil.getExpiration(ConversionUtil.getAbsoluteExpiration(binaryCacheItem.getExpiration()), ConversionUtil.getSlidingExpiration(binaryCacheItem.getExpiration())));
        }
        catch (ParseException e) {
            throw new CacheException(e.getMessage(), e.getCause());
        }
        CacheItemWrapperInternal.setCacheInstance(binaryCacheItem, this);
        binaryCacheItem.setValue(CacheHelper.getObjectOrDataTypeForCacheItem(key, CacheItemWrapperInternal.GetCacheItemEntryType(binaryCacheItem), binaryCacheItem.getValue(Object.class)));
        return binaryCacheItem;
    }

    @Override
    public Map<String, CacheItem> getCacheItemBulk(Iterable<String> keys) throws CacheException {
        return this.getCacheItemBulk(keys, null);
    }

    @Override
    public Map<String, CacheItem> getCacheItemBulk(Iterable<String> keys, ReadThruOptions readThruOptions) throws CacheException {
        if (keys == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: keys");
        }
        if (readThruOptions == null) {
            readThruOptions = new ReadThruOptions(ReadMode.None);
        }
        Object entry = null;
        BitSet flagMap = new BitSet();
        CacheItem item = new CacheItem();
        UsageStats stats = new UsageStats();
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        String[] keysList = CacheImpl.toArray(keys);
        if (keysList.length == 0) {
            throw new IllegalArgumentException("There is no key present in keys array");
        }
        if (readThruOptions.getReadMode() != ReadMode.None && readThruOptions.getProviderName() == null) {
            readThruOptions.setProviderName(this._defaultReadThruProvider);
        }
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)readThruOptions.getProviderName())) {
            readThruOptions.setProviderName(readThruOptions.getProviderName().toLowerCase());
        }
        try {
            stats.BeginSample();
            HashMap<String, CacheItem> result = new HashMap<String, CacheItem>();
            Map map = this._cacheImpl.getCacheItemBulk(keysList, flagMap, readThruOptions);
            if (this._perfStatsCollector != null) {
                stats.EndSample();
                this._perfStatsCollector.incrementMsecPerGetSample(stats.getCurrent());
                this._perfStatsCollector.incrementGetPerSecStats();
            }
            if (map != null) {
                for (Map.Entry object : map.entrySet()) {
                    Map.Entry iteratorEntry = object;
                    CacheItem binaryCacheItem = iteratorEntry.getValue() instanceof CacheItem ? iteratorEntry.getValue() : null;
                    if (binaryCacheItem != null) {
                        result.put((String)iteratorEntry.getKey(), this.getCacheItemFromBinaryCacheItem((String)iteratorEntry.getKey(), binaryCacheItem));
                        continue;
                    }
                    result.put((String)iteratorEntry.getKey(), this.getCacheItemFromEntry((String)iteratorEntry.getKey(), iteratorEntry.getValue() instanceof CacheEntry ? iteratorEntry.getValue() : null));
                }
            }
            return result;
        }
        catch (Exception e) {
            if (this.getExceptionEnabled()) {
                throw new CacheException(e.getMessage(), e.getCause());
            }
            return null;
        }
    }

    <T> Map<String, T> getByTagInternal(Tag[] tags, TagComparisonType compareType) throws CacheException {
        UsageStats stats = new UsageStats();
        stats.BeginSample();
        try {
            HashMap data = this._cacheImpl.getByTag(tags, compareType);
            HashMap<String, T> tagResult = new HashMap<String, T>();
            if (data != null) {
                for (Map.Entry entry : data.entrySet()) {
                    CompressedValueEntry result = (CompressedValueEntry)entry.getValue();
                    if (result.getFlag().IsBitSet((byte)this._compressed)) {
                        result.setValue((Object)this.Decompress((byte[])result.getValue()));
                    }
                    if (this.isPerfStatsCollectorInitialized() && result.getValue() != null && result.getValue() instanceof byte[]) {
                        this._perfStatsCollector.incrementAvgItemSize((long)((byte[])result.getValue()).length);
                    }
                    if (this._cacheImpl.getEncryptionEnabled() && result.getType() == EntryType.CacheItem) {
                        UsageStats statsEncryption = new UsageStats();
                        statsEncryption.BeginSample();
                        result.setValue((Object)CacheHelper.DecryptData((byte[])result.getValue(), this._serializationContext));
                        statsEncryption.EndSample();
                        if (this.isPerfStatsCollectorInitialized()) {
                            this._perfStatsCollector.incrementMsecPerDecryptionSample(statsEncryption.getCurrent());
                        }
                    }
                    tagResult.put((String)entry.getKey(), this.safeDeserialize(result.getValue(), this._serializationContext, result.getFlag(), UserObjectType.CacheItem, null));
                }
                if (this.isPerfStatsCollectorInitialized()) {
                    stats.EndSample();
                    this._perfStatsCollector.incrementMsecPerGetBulkSample(stats.getCurrent());
                    this._perfStatsCollector.incrementByGetPerSecStats((long)data.size());
                }
            }
            return tagResult;
        }
        catch (Exception e) {
            throw new CacheException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void delete(String key) throws CacheException {
        this.delete(key, null, null, null);
    }

    @Override
    public void delete(String key, WriteThruOptions writeThruOptions) throws CacheException, IllegalArgumentException {
        this.delete(key, null, null, writeThruOptions);
    }

    @Override
    public void delete(String key, LockHandle lockHandle, CacheItemVersion version, WriteThruOptions writeThruOptions) throws CacheException {
        WriteMode mode = WriteMode.None;
        String providerName = null;
        DataSourceModifiedListener dataSourceModifiedListener = null;
        EnumSet eventTypes = EnumSet.of(EventTypeInternal.None);
        RefObject tempRef_mode = new RefObject((Object)mode);
        RefObject tempRef_providerName = new RefObject(providerName);
        RefObject tempRef_dataSourceModifiedCallback = new RefObject(dataSourceModifiedListener);
        RefObject tempRef_eventTypes = new RefObject(eventTypes);
        ConversionUtil.GetWriteOptions(writeThruOptions, (RefObject<WriteMode>)tempRef_mode, (RefObject<String>)tempRef_providerName, (RefObject<DataSourceModifiedListener>)tempRef_dataSourceModifiedCallback, (RefObject<EnumSet<EventTypeInternal>>)tempRef_eventTypes);
        mode = (WriteMode)tempRef_mode.argvalue;
        providerName = (String)tempRef_providerName.argvalue;
        dataSourceModifiedListener = (DataSourceModifiedListener)tempRef_dataSourceModifiedCallback.argvalue;
        eventTypes = (EnumSet)tempRef_eventTypes.argvalue;
        EventTypeInternal eventTypeInternal = (EventTypeInternal)((Object)eventTypes.toArray()[0]);
        LockAccessType accessType = LockAccessType.IGNORE_LOCK;
        if (version != null) {
            accessType = LockAccessType.COMPARE_VERSION;
        }
        if (lockHandle != null) {
            accessType = LockAccessType.DEFAULT;
            version = null;
        }
        this.deleteInternal(key, mode, dataSourceModifiedListener, eventTypeInternal, lockHandle, version, accessType, providerName);
    }

    @Override
    public <T> T remove(String key, Class<?> cls) throws CacheException, IllegalArgumentException, ClassCastException {
        return this.remove(key, null, null, null, cls);
    }

    @Override
    public <T> T remove(String key, WriteThruOptions writeThruOptions, Class<?> cls) throws CacheException, IllegalArgumentException, ClassCastException {
        return this.remove(key, null, null, writeThruOptions, cls);
    }

    @Override
    public <T> T remove(String key, LockHandle lockHandle, CacheItemVersion version, WriteThruOptions writeThruOptions, Class<?> cls) throws CacheException {
        LockAccessType accessType = LockAccessType.IGNORE_LOCK;
        if (version != null) {
            accessType = LockAccessType.COMPARE_VERSION;
        }
        if (lockHandle != null) {
            accessType = LockAccessType.DEFAULT;
            version = null;
        }
        return (T)this.removeInternal(key, writeThruOptions, lockHandle, version, accessType, cls);
    }

    private Object removeInternal(String key, WriteThruOptions writeThruOptions, LockHandle lockHandle, CacheItemVersion itemVersion, LockAccessType accessType, Class<?> cls) throws CacheException {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        this.validateKey(key);
        WriteMode mode = WriteMode.None;
        String providerName = null;
        DataSourceModifiedListener dataSourceModifiedListener = null;
        EnumSet eventTypes = EnumSet.of(EventTypeInternal.None);
        RefObject tempRef_mode = new RefObject((Object)mode);
        RefObject tempRef_providerName = new RefObject(providerName);
        RefObject tempRef_dataSourceModifiedCallback = new RefObject(dataSourceModifiedListener);
        RefObject tempRef_eventTypes = new RefObject(eventTypes);
        ConversionUtil.GetWriteOptions(writeThruOptions, (RefObject<WriteMode>)tempRef_mode, (RefObject<String>)tempRef_providerName, (RefObject<DataSourceModifiedListener>)tempRef_dataSourceModifiedCallback, (RefObject<EnumSet<EventTypeInternal>>)tempRef_eventTypes);
        mode = (WriteMode)tempRef_mode.argvalue;
        providerName = (String)tempRef_providerName.argvalue;
        dataSourceModifiedListener = (DataSourceModifiedListener)tempRef_dataSourceModifiedCallback.argvalue;
        eventTypes = (EnumSet)tempRef_eventTypes.argvalue;
        EventTypeInternal eventTypeInternal = (EventTypeInternal)((Object)eventTypes.toArray()[0]);
        if ((mode == WriteMode.WriteThru || mode == WriteMode.WriteBehind) && DotNetToJavaStringHelper.isNullOrEmpty((String)providerName)) {
            providerName = this._defaultWriteThruProvider;
        }
        UsageStats stats = new UsageStats();
        stats.BeginSample();
        String lockId = null;
        long version = 0L;
        if (lockHandle != null) {
            lockId = lockHandle.getLockId();
        }
        if (itemVersion != null) {
            version = itemVersion.getVersion();
        }
        BitSet flagMap = new BitSet();
        flagMap = this.setDSUpdateOptBit(flagMap, mode);
        short onDSItemRemovedCallbackId = -1;
        if (dataSourceModifiedListener != null) {
            onDSItemRemovedCallbackId = this.GetCallbackId(dataSourceModifiedListener, 1, eventTypeInternal);
        }
        long objectSize = 0L;
        long encryptedObjectSize = 0L;
        long compressedObjectSize = 0L;
        Object obj = null;
        CompressedValueEntry result = this._cacheImpl.remove(key, flagMap, onDSItemRemovedCallbackId, lockId, HelperUtil.createCacheItemVersion(version), accessType, providerName);
        if (result != null && result.getValue() != null) {
            if (result.getFlag().IsBitSet((byte)2)) {
                result.setValue((Object)this.Decompress((byte[])result.getValue()));
            }
            if (this.isPerfStatsCollectorInitialized() && result.getValue() != null && result.getValue() instanceof byte[]) {
                this._perfStatsCollector.incrementAvgItemSize((long)((byte[])result.getValue()).length);
            }
            if (this._cacheImpl.getEncryptionEnabled() && result.getType() == EntryType.CacheItem) {
                if (this.isPerfStatsCollectorInitialized()) {
                    this._perfStatsCollector.mSecPerDecryptionBeginSample();
                }
                result.setValue((Object)CacheHelper.DecryptData((byte[])result.getValue(), this._serializationContext));
                if (this.isPerfStatsCollectorInitialized()) {
                    this._perfStatsCollector.mSecPerDecryptionEndSample();
                }
            }
            obj = this.safeDeserialize(result.value, this._serializationContext, result.getFlag(), UserObjectType.CacheItem, cls);
        }
        if (this.isPerfStatsCollectorInitialized()) {
            stats.EndSample();
            this._perfStatsCollector.incrementMsecPerDelSample(stats.getCurrent());
            this._perfStatsCollector.incrementDelPerSecStats();
        }
        return obj;
    }

    private void deleteInternal(String key, WriteMode writeMode, DataSourceModifiedListener dataSourceModifiedListener, EventTypeInternal eventType, LockHandle lockHandle, CacheItemVersion itemVersion, LockAccessType accessType, String providerName) throws CacheException {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        this.validateKey(key);
        BitSet flagMap = new BitSet();
        if ((writeMode == WriteMode.WriteThru || writeMode == WriteMode.WriteBehind) && providerName == null) {
            providerName = this._defaultWriteThruProvider;
        }
        UsageStats stats = new UsageStats();
        stats.BeginSample();
        String lockId = lockHandle == null ? null : lockHandle.getLockId();
        flagMap = this.setDSUpdateOptBit(flagMap, writeMode);
        short dsItemRemovedCallbackId = -1;
        if (dataSourceModifiedListener != null) {
            dsItemRemovedCallbackId = this.GetCallbackId(dataSourceModifiedListener, 1, eventType);
        }
        this._cacheImpl.delete(key, flagMap, dsItemRemovedCallbackId, lockId, itemVersion, accessType, providerName);
        if (this._perfStatsCollector != null) {
            stats.EndSample();
            this._perfStatsCollector.incrementMsecPerDelSample(stats.getCurrent());
            this._perfStatsCollector.incrementDelPerSecStats();
        }
    }

    @Override
    public <T> FutureTask<T> removeAsync(String key, Class<?> cls) {
        return this.removeAsync(key, null, cls);
    }

    @Override
    public <T> FutureTask<T> removeAsync(String key, WriteThruOptions writeThruOptions, Class<?> cls) {
        RemoveAsyncCallable task = new RemoveAsyncCallable(key, writeThruOptions, cls);
        FutureTask futureTask = new FutureTask(task);
        ThreadPool.getInstance().executeTask(futureTask);
        return futureTask;
    }

    @Override
    public FutureTask<Void> deleteAsync(String key) {
        return this.deleteAsync(key, null);
    }

    @Override
    public FutureTask<Void> deleteAsync(String key, WriteThruOptions writeThruOptions) {
        DeleteAsyncCallable task = new DeleteAsyncCallable(key, writeThruOptions);
        FutureTask<Void> futureTask = new FutureTask<Void>(task);
        ThreadPool.getInstance().executeTask(futureTask);
        return futureTask;
    }

    void addCacheStoppedListener(CacheStatusEventListener cacheStopped) throws CacheException {
        this.cacheStoppedListeners.add(cacheStopped);
        if (this._cacheImpl != null && ++this._refCacheStoppedCount == 1) {
            this._cacheImpl.registerCacheStoppedEvent();
        }
    }

    void removeCacheStoppedListener(CacheStatusEventListener cacheStopped) throws CacheException {
        this.cacheStoppedListeners.add(cacheStopped);
        if (this._cacheImpl != null && ++this._refCacheStoppedCount == 1) {
            this._cacheImpl.unregisterCacheStoppedEvent();
        }
    }

    void addCacheClearedListner(CacheClearedListener cacheClearedListener) throws CacheException {
        this.cacheClearedListeners.add(cacheClearedListener);
        if (this._cacheImpl != null && ++this._refClearCount == 1) {
            this._cacheImpl.registerClearEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCacheClearedListner(CacheClearedListener cacheClearedListener) throws CacheException {
        int afterLength = 0;
        CacheImpl cacheImpl = this;
        synchronized (cacheImpl) {
            if (this.cacheClearedListeners != null) {
                int beforeLength = this.cacheClearedListeners.size();
                this.cacheClearedListeners.remove(cacheClearedListener);
                if (this.cacheClearedListeners != null) {
                    afterLength = this.cacheClearedListeners.size();
                }
                if (beforeLength - afterLength == 1 && this._cacheImpl != null && --this._refClearCount == 0) {
                    this._cacheImpl.unregisterClearEvent();
                }
            }
        }
    }

    void addMemberJoinedListener(CacheStatusEventListener memberJoinedListener) {
        this.memberJoinedListeners.add(memberJoinedListener);
    }

    void removeMemberJoinedListener(CacheStatusEventListener memberJoinedListener) {
        this.memberJoinedListeners.remove(memberJoinedListener);
    }

    void addMemberLeftListener(CacheStatusEventListener memberLeftListener) {
        this.memberLeftListeners.add(memberLeftListener);
    }

    void removeMemberLeftListener(CacheStatusEventListener memberLeftListener) {
        this.memberLeftListeners.remove(memberLeftListener);
    }

    public void registerCQ(ContinuousQuery query) throws CacheException {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        if (query == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: query");
        }
        try {
            query.setServerUniqueIDInternal(this._cacheImpl.registerCQ(query, query.getClientUniqueIDInternal(), query.notifyAddInternal(), query.notifyUpdateInternal(), query.notifyRemoveInternal()));
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage(), ex.getCause());
        }
    }

    public void removeCQ(ContinuousQuery query) throws CacheException {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        if (query == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: query");
        }
        try {
            if (!DotNetToJavaStringHelper.isNullOrEmpty((String)query.getServerUniqueIDInternal()) && !DotNetToJavaStringHelper.isNullOrEmpty((String)query.getClientUniqueIDInternal())) {
                this._cacheImpl.unRegisterCQ(query.getServerUniqueIDInternal(), query.getClientUniqueIDInternal());
            }
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage(), ex.getCause());
        }
    }

    public CacheEventDescriptor registerCacheNotificationInternal(String key, CacheDataModificationListener listener, EnumSet<EventType> eventTypes, EventDataFilter datafilter, boolean notifyOnItemExpiration) throws CacheException {
        return this.registerCacheNotificationInternal(key, listener, eventTypes, datafilter, notifyOnItemExpiration, ListenerType.PushBasedNotification);
    }

    public CacheEventDescriptor registerCacheNotificationInternal(String key, CacheDataModificationListener listener, EnumSet<EventType> eventTypes, EventDataFilter datafilter, boolean notifyOnItemExpiration, ListenerType listenerType) throws CacheException {
        CacheEventDescriptor discriptor;
        block5: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            discriptor = null;
            try {
                if (key != null) {
                    short[] callbackRefs = this._eventManager.registerSelectiveEvent(listener, eventTypes, datafilter, listenerType);
                    this._cacheImpl.registerKeyNotificationListener(key, callbackRefs[0], callbackRefs[1], datafilter, notifyOnItemExpiration, listenerType);
                } else {
                    discriptor = this._eventManager.registerGeneralEvents(listener, eventTypes, datafilter);
                }
            }
            catch (Exception ex) {
                if (!this.getExceptionEnabled()) break block5;
                throw new CacheException(ex.getMessage(), ex.getCause());
            }
        }
        return discriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClientConnectivityChangedListener(CacheClientConnectivityChangedListener clientConnectivityChangedListener) throws CacheException {
        boolean register = false;
        CacheImpl cacheImpl = this;
        synchronized (cacheImpl) {
            this.cacheClientConnectivityChangedListeners.add(clientConnectivityChangedListener);
            register = this.cacheClientConnectivityChangedListeners.size() == 1;
        }
        if (this._cacheImpl != null && register) {
            this._cacheImpl.registerCacheClientConnectivityEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClientConnectivityChangedListener(CacheClientConnectivityChangedListener cacheClientConnectivityChangedListener) throws CacheException {
        boolean unregister = false;
        CacheImpl cacheImpl = this;
        synchronized (cacheImpl) {
            this.cacheClientConnectivityChangedListeners.remove(cacheClientConnectivityChangedListener);
            unregister = this.cacheClientConnectivityChangedListeners == null || this.cacheClientConnectivityChangedListeners.size() == 0;
        }
        if (this._cacheImpl != null && unregister) {
            this._cacheImpl.unregisterCacheClientConnectivityEvent();
        }
    }

    private BitSet setDSUpdateOptBit(BitSet flagMap, WriteMode dsWriteOption) {
        if (flagMap == null) {
            flagMap = new BitSet();
        }
        switch (dsWriteOption) {
            case WriteBehind: {
                flagMap.SetBit((byte)8);
                break;
            }
            case WriteThru: {
                flagMap.SetBit((byte)4);
            }
        }
        return flagMap;
    }

    private String[] removeDuplicateKeys(Iterable<String> keys) {
        HashSet<String> keysSet = new HashSet<String>();
        for (String key : keys) {
            if (key != null) {
                keysSet.add(key);
                continue;
            }
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        String[] array = keysSet.toArray(new String[keysSet.size()]);
        return array;
    }

    private void loadRWTrhuSettings() throws CacheException {
        ClientConfiguration config = new ClientConfiguration(this._cacheId);
        config.loadConfiguration();
        this._defaultWriteThruProvider = config.getDefaultWriteThru();
        this._defaultReadThruProvider = config.getDefaultReadThru();
    }

    void removeGroupData(String group) throws CacheException {
        block4: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            if (group == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: group");
            }
            try {
                this._cacheImpl.remove(group);
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block4;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
    }

    ArrayList getGroupKeys(String group) throws CacheException {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        if (group == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: group");
        }
        try {
            return (ArrayList)this._cacheImpl.getGroupKeys(group);
        }
        catch (Exception e) {
            if (this.getExceptionEnabled()) {
                throw new CacheException(e.getMessage(), e.getCause());
            }
            return null;
        }
    }

    <T> Map<String, T> getGroupData(String group) throws CacheException {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        if (group == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: group");
        }
        try {
            UsageStats stats = new UsageStats();
            stats.BeginSample();
            HashMap<String, T> groupResult = new HashMap<String, T>();
            HashMap data = this._cacheImpl.getGroupData(group);
            if (data != null) {
                for (Map.Entry entry : data.entrySet()) {
                    CompressedValueEntry result = (CompressedValueEntry)entry.getValue();
                    if (result.getFlag().IsBitSet((byte)this._compressed)) {
                        result.setValue((Object)this.Decompress((byte[])result.getValue()));
                    }
                    if (this.isPerfStatsCollectorInitialized() && result.getValue() != null && result.getValue() instanceof byte[]) {
                        this._perfStatsCollector.incrementAvgItemSize((long)((byte[])result.getValue()).length);
                    }
                    if (this._cacheImpl.getEncryptionEnabled() && result.getType() == EntryType.CacheItem) {
                        UsageStats statsEncryption = new UsageStats();
                        statsEncryption.BeginSample();
                        result.setValue((Object)CacheHelper.DecryptData((byte[])result.getValue(), this._serializationContext));
                        statsEncryption.EndSample();
                        if (this.isPerfStatsCollectorInitialized()) {
                            this._perfStatsCollector.incrementMsecPerDecryptionSample(statsEncryption.getCurrent());
                        }
                    }
                    groupResult.put((String)entry.getKey(), this.safeDeserialize(result.getValue(), this._serializationContext, result.getFlag(), UserObjectType.CacheItem, null));
                }
                if (this.isPerfStatsCollectorInitialized()) {
                    stats.EndSample();
                    this._perfStatsCollector.incrementMsecPerGetBulkSample(stats.getCurrent());
                    this._perfStatsCollector.incrementByGetPerSecStats((long)data.size());
                }
            }
            return groupResult;
        }
        catch (Exception e) {
            if (this.getExceptionEnabled()) {
                throw new CacheException(e.getMessage(), e.getCause());
            }
            return null;
        }
    }

    private void validateKey(String key) throws OperationFailedException {
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (key.isEmpty()) {
            throw new OperationFailedException(17511, ErrorMessages.getErrorMessage((int)17511, (String[])new String[0]));
        }
    }

    private void validateKeyValue(String key, Object value) throws OperationFailedException {
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (key.isEmpty()) {
            throw new OperationFailedException(17511, ErrorMessages.getErrorMessage((int)17511, (String[])new String[0]));
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
        }
    }

    public ArrayList<CustomEventListener> getCustomEventList() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRef() {
        CacheImpl cacheImpl = this;
        synchronized (cacheImpl) {
            this._refCount.incrementAndGet();
        }
    }

    public boolean isInProc() {
        return this._cacheImpl.isInproc();
    }

    protected void SetMessagingServiceCacheImpl(CacheImplBase cacheImpl) {
        this._messagingService.getPubSubManager().setCacheImpl(cacheImpl);
    }

    public void InitializeEncryption() throws Exception {
        HashMap encryptionInfo = this._cacheImpl.getEncryptionInfo();
        if (encryptionInfo != null && encryptionInfo.size() > 0) {
            try {
                this._encryptionEnabled = Boolean.parseBoolean(encryptionInfo.get("enabled").toString());
                this.setEncryptionEnabled(this._encryptionEnabled);
                EncryptionMgr.InitializeEncryption((boolean)this._encryptionEnabled, (String)((String)encryptionInfo.get("key")), (String)this._cacheImpl.getName(), (String)((String)encryptionInfo.get("provider")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private HashMap getPortability() {
        return SerializationUtil.getPortability((String)this._cacheId.toLowerCase());
    }

    private HashMap getAttributeOrder() {
        return SerializationUtil.getAttributeOrder((String)this._cacheId.toLowerCase());
    }

    public void initializeCompactFramework() throws NCacheArgumentException, OperationFailedException {
        this.impl = FormatterServices.getDefault();
        HashMap type = this._cacheImpl.getCompactTypes();
        if (type != null && !type.isEmpty()) {
            this.impl.register((Map)type, this.getAttributeOrder(), this._cacheId.toLowerCase(), this.getPortability());
        }
        this.impl.registerKnownTypes(VirtualArray.class, (short)149);
        this.impl.registerKnownTypes(NewHashmap.class, (short)346);
        this._compressionEnabled = this._cacheImpl.getCompressionEnabled();
        this._compressionThresholdSize = this._cacheImpl.getCompressionThreshold();
    }

    public void addSecondaryInprocInstance(Cache secondaryInstance) {
        if (this._secondaryInprocInstances == null) {
            this._secondaryInprocInstances = new ArrayList();
        }
        this._secondaryInprocInstances.add(secondaryInstance);
    }

    Object getSerializedObject(String key, ReadThruOptions readOption, RefObject<Long> v, RefObject<BitSet> flag, RefObject<Date> absoluteExpiration, RefObject<TimeSpan> slidingExpiration, RefObject<String> group, RefObject<HashMap> queryInfo, RefObject<CacheDependency> cacheDependency, RefObject<ResyncOptions> resyncOptions, RefObject<CacheItemPriority> priority) throws Exception {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (key.isEmpty()) {
            throw new OperationFailedException(17511, ErrorMessages.getErrorMessage((int)17511, (String[])new String[0]));
        }
        CacheItem result = null;
        try {
            BitSet flagMap = new BitSet();
            group.argvalue = null;
            queryInfo.argvalue = null;
            cacheDependency.argvalue = null;
            resyncOptions.argvalue = null;
            flagMap = this.setDSReadOptBit(flagMap, readOption.getReadMode());
            LockHandle lockHandle = new LockHandle();
            CacheItemVersion version = HelperUtil.createCacheItemVersion(0L);
            RefObject tempRef_version = new RefObject((Object)version);
            result = (CacheItem)this._cacheImpl.getCacheItem(key, flagMap, null, version, lockHandle, TimeSpan.Zero, LockAccessType.GET_VERSION, readOption);
            if (version != null) {
                v.argvalue = version.getVersion();
            }
            if (result == null) {
                return null;
            }
            ((BitSet)flag.argvalue).setData(result.getFlagMapInternal().getData());
            if (result != null && result.getValue(null) != null) {
                Object value = result.getValue(null);
                if (value instanceof CallbackEntry) {
                    CallbackEntry e = value instanceof CallbackEntry ? (CallbackEntry)value : null;
                    result.setValue((byte[])e.getValue());
                }
                if (result.getFlagMapInternal().IsBitSet((byte)this._compressed)) {
                    result.setValue(this.Decompress((byte[])value));
                }
                if (result.getTags() != null || result.getNamedTags() != null) {
                    queryInfo.argvalue = new HashMap();
                    HashMap htNamedTagInfo = this.getNamedTagsInfo(value, result.getNamedTags(), true);
                    if (htNamedTagInfo != null) {
                        ((HashMap)queryInfo.argvalue).put("named-tag-info", htNamedTagInfo);
                    }
                    ArrayList<Tag> validTags = new ArrayList<Tag>();
                    HashMap htTagInfo = this.getTagInfo(value, ConversionUtil.toArray(result.getTags()), validTags);
                    if (htTagInfo != null) {
                        ((HashMap)queryInfo.argvalue).put("tag-info", htTagInfo);
                    }
                }
                if (result.getExpiration() != null) {
                    absoluteExpiration.argvalue = ConversionUtil.getAbsoluteExpiration(result.getExpiration());
                    slidingExpiration.argvalue = ConversionUtil.getSlidingExpiration(result.getExpiration());
                }
                cacheDependency.argvalue = result.getDependency();
                resyncOptions.argvalue = result.getResyncOptions();
                priority.argvalue = result.getCacheItemPriority();
                v.argvalue = result.getCacheItemVersion().getVersion();
                if (this.isPerfStatsCollectorInitialized() && value != null && value instanceof byte[]) {
                    this._perfStatsCollector.incrementAvgItemSize((long)((byte[])value).length);
                }
                return result;
            }
        }
        catch (Exception e) {
            if (this.isExceptionsEnabled()) {
                throw e;
            }
            return null;
        }
        return null;
    }

    public boolean isExceptionsEnabled() {
        return this._exceptionEnabled;
    }

    public void setExceptionsEnabled(boolean exceptionsEnabled) {
        this._exceptionEnabled = exceptionsEnabled;
    }

    boolean setAttributes(String key, CacheItemAttributes attributes) throws Exception {
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: attributes");
        }
        return this._cacheImpl.setAttributes(key, attributes);
    }

    void makeTargetCacheActivePassive(boolean makeActive) throws Exception {
        block2: {
            try {
                this._cacheImpl.makeTargetCacheActivePassive(makeActive);
            }
            catch (CacheException e) {
                if (!this._exceptionEnabled) break block2;
                throw e;
            }
        }
    }

    @Override
    public MessagingService getMessagingService() throws CacheException {
        return this._messagingService;
    }

    String getTargetCacheUniqueID() {
        return this._cacheImpl.getBridgeTargetCacheUniqueID();
    }

    void setQueryTypeInfoMap(TypeInfoMap typeMap) {
        this.typeMap = typeMap;
    }

    TypeInfoMap getQueryTypeMap() {
        return this._cacheImpl != null ? this._cacheImpl.getTypeMap() : null;
    }

    public CacheImplBase getCacheImpl() {
        return this._cacheImpl;
    }

    public void setCacheImpl(CacheImplBase value) {
        this._cacheImpl = value;
        if (this._cacheImpl != null) {
            this._serializationContext = this._cacheImpl.getName();
            this._cacheId = this._serializationContext.toLowerCase();
        }
    }

    void setEncryptionEnabled(boolean _encryptionEnabled) {
        this._cacheImpl.setEncryptionEnabled(_encryptionEnabled);
    }

    private void dispose() {
        this.dispose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(boolean disposing) {
        CacheImpl cacheImpl = this;
        synchronized (cacheImpl) {
            this._refCount.decrementAndGet();
            if (this._refCount.get() > 0) {
                return;
            }
            if (this._refCount.get() < 0) {
                this._refCount.set(0);
            }
            if (this._messagingService != null) {
                this._messagingService.dispose();
            }
            CacheCollection cacheCollection = CacheManager.getCaches();
            synchronized (cacheCollection) {
                if (this._cacheId != null) {
                    CacheManager.getCaches().removeCache(this._cacheId);
                    SerializationUtil.unRegisterCache((String)this._cacheId);
                    this._cacheId = null;
                }
            }
            if (this._cacheImpl != null) {
                try {
                    this._cacheImpl.dispose(disposing);
                }
                catch (ConfigurationException | GeneralFailureException | OperationFailedException throwable) {
                    // empty catch block
                }
            }
            if (this._secondaryInprocInstances != null) {
                for (Object cache : this._secondaryInprocInstances) {
                    ((CacheImpl)cache).dispose();
                }
            }
            if (this._clusterListener != null) {
                this._clusterListener.dispose();
            }
            if (this.isPerfStatsCollectorInitialized()) {
                this._perfStatsCollector.dispose();
            }
            this._cacheImpl = null;
            this._messagingService = null;
            ThreadPool.getInstance().Stop(true);
        }
    }

    public boolean checkUserAuthorization(String cacheId, String password, String userId) {
        try {
            return this._cacheImpl.checkSecurityAuthorization(cacheId.toLowerCase(), EncryptionUtil.Encrypt((String)password), userId);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void findNull(String[] keys) throws OperationFailedException {
        try {
            for (String item : keys) {
                if (item != null) continue;
                throw new IllegalArgumentException("keys cannot contain null values");
            }
        }
        catch (IllegalArgumentException e) {
            throw new OperationFailedException(e.getMessage());
        }
    }

    private BitSet setDSReadOptBit(BitSet flagMap, ReadMode readMode) {
        if (flagMap == null) {
            flagMap = new BitSet();
        }
        if (readMode == ReadMode.ReadThru) {
            flagMap.SetBit((byte)16);
        }
        return flagMap;
    }

    private String[] RemoveDuplicateKeys(String[] keys) {
        HashSet<String> keysAndItems = new HashSet<String>();
        for (int item = 0; item < keys.length; ++item) {
            if (keys[item] == null) {
                throw new IllegalArgumentException("Value cannot be null.\r\nParameter name: key");
            }
            keysAndItems.add(keys[item]);
        }
        return CacheImpl.toArray(keysAndItems);
    }

    Object getDeserializedObject(Object value, String serializationContext, BitSet flag) throws GeneralFailureException {
        if (value instanceof byte[] && this._cacheImpl.getSerializationEnabled()) {
            try {
                if (flag != null && flag.IsBitSet((byte)-128)) {
                    return value;
                }
                UsageStats statsSerialization = new UsageStats();
                statsSerialization.BeginSample();
                value = this._cacheImpl.safeDeserialize(value, serializationContext.toLowerCase(), flag, this._cacheImpl, null, null);
                statsSerialization.EndSample();
                if (this.isPerfStatsCollectorInitialized()) {
                    this._perfStatsCollector.incrementMsecPerDeserialization(statsSerialization.getCurrent());
                }
                return value;
            }
            catch (Exception iOException) {
                return value;
            }
        }
        return value;
    }

    public Object safeSerialize(Object serializableObject, String serializationContext, BitSet flag, Long size, UserObjectType userObjectType) throws OperationFailedException, GeneralFailureException {
        return this.safeSerialize(serializableObject, serializationContext, flag, size, userObjectType, false);
    }

    public Object safeDataStructuresSerialize(Object serializableObject, String serializationContext, BitSet flag, Long size, UserObjectType userObjectType, boolean isCustomAttributeBaseSerialzed) {
        try {
            return this.safeSerialize(serializableObject, serializationContext, flag, size, userObjectType, isCustomAttributeBaseSerialzed);
        }
        catch (OperationFailedException e) {
            throw new OperationFailedRuntimeException((Throwable)e);
        }
        catch (GeneralFailureException e) {
            throw new GeneralFailureRuntimeException((Throwable)e);
        }
    }

    public Object safeSerialize(Object serializableObject, String serializationContext, BitSet flag, Long size, UserObjectType userObjectType, boolean isCustomAttributeBaseSerialzed) throws OperationFailedException, GeneralFailureException {
        if (!_serializationEnabled) {
            return serializableObject;
        }
        Object serializedObject = null;
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        if (serializableObject != null) {
            UsageStats statsSerialization = new UsageStats();
            statsSerialization.BeginSample();
            RefObject temp_size = new RefObject((Object)size);
            serializedObject = this._cacheImpl.safeSerialize(serializableObject, serializationContext, flag, this._cacheImpl, (RefObject<Long>)temp_size, userObjectType, isCustomAttributeBaseSerialzed);
            statsSerialization.EndSample();
            if (this.isPerfStatsCollectorInitialized()) {
                this._perfStatsCollector.incrementMsecPerSerialization(statsSerialization.getCurrent());
            }
        }
        return serializedObject;
    }

    public <T> T safeDataStructuresDeserialize(Object serializedObject, String serializationContext, BitSet flag, UserObjectType userObjectType, Class<?> cls) {
        try {
            return this.safeDeserialize(serializedObject, serializationContext, flag, userObjectType, cls);
        }
        catch (OperationFailedException e) {
            throw new OperationFailedRuntimeException((Throwable)e);
        }
    }

    public <T> T safeDeserialize(Object serializedObject, String serializationContext, BitSet flag, UserObjectType userObjectType, Class<?> cls) throws OperationFailedException {
        if (!this.getSerializationEnabled()) {
            return (T)serializedObject;
        }
        T deSerializedObject = null;
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        if (serializedObject != null) {
            UsageStats statsDeserialization = new UsageStats();
            statsDeserialization.BeginSample();
            deSerializedObject = this._cacheImpl.safeDeserialize(serializedObject, serializationContext, flag, this._cacheImpl, userObjectType, cls);
            statsDeserialization.EndSample();
            if (this.isPerfStatsCollectorInitialized()) {
                this._perfStatsCollector.incrementMsecPerDeserialization(statsDeserialization.getCurrent());
            }
        }
        return deSerializedObject;
    }

    private Object encryptAndCompress(Object value, BitSet flagMap) {
        if (this._cacheImpl.getEncryptionEnabled()) {
            UsageStats statsEncryption = new UsageStats();
            statsEncryption.BeginSample();
            value = CacheHelper.EncryptData((byte[])value, this._serializationContext);
            statsEncryption.EndSample();
            if (this.isPerfStatsCollectorInitialized()) {
                this._perfStatsCollector.incrementMsecPerEncryptionSample(statsEncryption.getCurrent());
            }
        }
        if (this.isPerfStatsCollectorInitialized() && value != null && value instanceof byte[]) {
            this._perfStatsCollector.incrementAvgItemSize((long)((byte[])value).length);
        }
        if (this.getCompressionEnabled()) {
            value = this.Compress((byte[])value, flagMap, this.getCompressionThreshold());
        }
        return value;
    }

    private void setExpirationTimeInUtc(RefObject<Date> absoluteExpiration) {
        if (absoluteExpiration.getValue() != null && absoluteExpiration.getValue() != NoAbsoluteExpiration) {
            try {
                absoluteExpiration.setValue((Object)NCDateTime.getUTCDate((Date)((Date)absoluteExpiration.getValue())));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private void setDefaults(WriteMode writeMode, RefObject<String> refproviderName, RefObject<String> refresyncProviderName) {
        if ((writeMode == WriteMode.WriteThru || writeMode == WriteMode.WriteBehind) && refproviderName.getValue() == null) {
            refproviderName.setValue((Object)this._defaultWriteThruProvider);
        }
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)((String)refproviderName.getValue()))) {
            refproviderName.setValue((Object)((String)refproviderName.getValue()).toLowerCase());
        }
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)((String)refresyncProviderName.getValue()))) {
            refresyncProviderName.setValue((Object)((String)refresyncProviderName.getValue()).toLowerCase());
        }
    }

    private boolean populateFromClientCacheItem(RefObject<String> typeName, RefObject<HashMap> htQueryInfo, RefObject<BitSet> flagMap, RefObject<Object> valueWrapper) {
        if (valueWrapper.getValue() instanceof ClientCacheItem) {
            ClientCacheItem clientcacheItem = (ClientCacheItem)(valueWrapper.getValue() instanceof ClientCacheItem ? valueWrapper.getValue() : null);
            valueWrapper.setValue(clientcacheItem.getValue());
            htQueryInfo.setValue((Object)clientcacheItem.getQueryInfo());
            if (clientcacheItem.getFlags().IsAnyBitSet((byte)-128)) {
                ((BitSet)flagMap.getValue()).SetBit((byte)-128);
            } else if (clientcacheItem.getFlags().IsAnyBitSet((byte)32)) {
                ((BitSet)flagMap.getValue()).SetBit((byte)32);
            }
            typeName.setValue((Object)clientcacheItem.getGroupDataType());
            return true;
        }
        return false;
    }

    short GetCallbackId(DataSourceModifiedListener dsItemModified) {
        if (dsItemModified == null) {
            return -1;
        }
        if (this._asyncCallbackIDsMap == null) {
            this._asyncCallbackIDsMap = new ResourcePool();
        }
        if (this._asyncCallbacksMap == null) {
            this._asyncCallbacksMap = new ResourcePool();
        }
        while (true) {
            if (this._asyncCallbacksMap.GetResource((Object)dsItemModified) == null) {
                this._dsiucbInitialVal = (short)(this._dsiucbInitialVal + 1);
                this._asyncCallbacksMap.AddResource((Object)dsItemModified, (Object)this._dsiucbInitialVal);
                this._asyncCallbackIDsMap.AddResource((Object)this._dsiucbInitialVal, (Object)dsItemModified);
                return this._dsiucbInitialVal;
            }
            try {
                short dsiacb = (Short)this._asyncCallbacksMap.GetResource((Object)dsItemModified);
                this._asyncCallbacksMap.AddResource((Object)dsItemModified, (Object)dsiacb);
                this._asyncCallbackIDsMap.AddResource((Object)dsiacb, (Object)dsItemModified);
                return dsiacb;
            }
            catch (NullPointerException ex) {
                continue;
            }
            break;
        }
    }

    private short GetCallbackId(DataSourceModifiedListener dsItemUpdatedCallback, int numberOfCallbacks) {
        if (dsItemUpdatedCallback == null) {
            return -1;
        }
        if (this._asyncCallbackIDsMap == null) {
            this._asyncCallbackIDsMap = new ResourcePool();
        }
        if (this._asyncCallbacksMap == null) {
            this._asyncCallbacksMap = new ResourcePool();
        }
        while (true) {
            if (this._asyncCallbacksMap.GetResource((Object)dsItemUpdatedCallback) == null) {
                this._dsiucbInitialVal = (short)(this._dsiucbInitialVal + 1);
                this._asyncCallbacksMap.AddResource((Object)dsItemUpdatedCallback, (Object)this._dsiucbInitialVal, numberOfCallbacks);
                this._asyncCallbackIDsMap.AddResource((Object)this._dsiucbInitialVal, (Object)dsItemUpdatedCallback, numberOfCallbacks);
                return this._dsiucbInitialVal;
            }
            try {
                short dsiacb = (Short)this._asyncCallbacksMap.GetResource((Object)dsItemUpdatedCallback);
                this._asyncCallbacksMap.AddResource((Object)dsItemUpdatedCallback, (Object)dsiacb, numberOfCallbacks);
                this._asyncCallbackIDsMap.AddResource((Object)dsiacb, (Object)dsItemUpdatedCallback, numberOfCallbacks);
                return dsiacb;
            }
            catch (NullPointerException ex) {
                continue;
            }
            break;
        }
    }

    public short GetCallbackId(DataSourceModifiedListener dataSourceModifiedCallback, int numberOfCallbacks, EventTypeInternal eventType) {
        if (dataSourceModifiedCallback == null) {
            return -1;
        }
        if (this._asyncCallbackIDsMap == null) {
            this._asyncCallbackIDsMap = new ResourcePool();
        }
        if (this._asyncCallbacksMap == null) {
            this._asyncCallbacksMap = new ResourcePool();
        }
        short dsIdIncrementalValue = 0;
        switch (eventType) {
            case ItemAdded: {
                dsIdIncrementalValue = this._dsiacbInitialVal;
                break;
            }
            case ItemUpdated: {
                dsIdIncrementalValue = this._dsiucbInitialVal;
                break;
            }
            case ItemRemoved: {
                dsIdIncrementalValue = this._dsircbInitialVal;
            }
        }
        while (true) {
            if (this._asyncCallbacksMap.GetResource((Object)dataSourceModifiedCallback) == null) {
                dsIdIncrementalValue = (short)(dsIdIncrementalValue + 1);
                this._asyncCallbacksMap.AddResource((Object)dataSourceModifiedCallback, (Object)dsIdIncrementalValue, numberOfCallbacks);
                this._asyncCallbackIDsMap.AddResource((Object)dsIdIncrementalValue, (Object)dataSourceModifiedCallback, numberOfCallbacks);
                switch (eventType) {
                    case ItemAdded: {
                        this._dsiacbInitialVal = dsIdIncrementalValue;
                        break;
                    }
                    case ItemUpdated: {
                        this._dsiucbInitialVal = dsIdIncrementalValue;
                        break;
                    }
                    case ItemRemoved: {
                        this._dsircbInitialVal = dsIdIncrementalValue;
                    }
                }
                return dsIdIncrementalValue;
            }
            try {
                short dsiacb = (Short)this._asyncCallbacksMap.GetResource((Object)dataSourceModifiedCallback);
                this._asyncCallbacksMap.AddResource((Object)dataSourceModifiedCallback, (Object)dsiacb, numberOfCallbacks);
                this._asyncCallbackIDsMap.AddResource((Object)dsiacb, (Object)dataSourceModifiedCallback, numberOfCallbacks);
                return dsiacb;
            }
            catch (NullPointerException e) {
                continue;
            }
            break;
        }
    }

    private void CheckDuplicateIndexName(Object value, NamedTagsDictionary namedTags) throws IllegalArgumentException {
        if (namedTags == null || value == null || this.typeMap == null) {
            return;
        }
        int handleId = this.typeMap.getHandleId(value.getClass().getCanonicalName());
        if (handleId != -1) {
            ArrayList attributes = this.typeMap.getAttribList(handleId);
            for (int i = 0; i < attributes.size(); ++i) {
                if (!namedTags.contains(attributes.get(i).toString())) continue;
                throw new IllegalArgumentException("Key in named tags conflicts with the indexed attribute name of the specified object.");
            }
        }
    }

    protected long getCompressionThreshold() {
        return this._compressionThresholdSize;
    }

    private byte[] Compress(byte[] value, BitSet flag, long threshold) {
        UsageStats statsCompression = new UsageStats();
        statsCompression.BeginSample();
        byte[] result = CompressionUtil.Compress((byte[])value, (BitSet)flag, (long)threshold);
        statsCompression.EndSample();
        if (this.isPerfStatsCollectorInitialized()) {
            this._perfStatsCollector.incrementMsecPerCompression(statsCompression.getCurrent());
            this._perfStatsCollector.incrementAvgCompressedItemSize(result != null ? (long)result.length : 0L);
            if (flag != null && flag.IsAnyBitSet((byte)2)) {
                this._perfStatsCollector.incrementCompressionPerSec();
            }
        }
        return result;
    }

    private byte[] Decompress(byte[] value) {
        if (this.isPerfStatsCollectorInitialized() && value != null) {
            this._perfStatsCollector.incrementAvgCompressedItemSize((long)value.length);
        }
        UsageStats statsCompression = new UsageStats();
        statsCompression.BeginSample();
        byte[] decompressedValue = new byte[]{};
        try {
            decompressedValue = CompressionUtil.Decompress((byte[])value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        statsCompression.EndSample();
        if (this.isPerfStatsCollectorInitialized()) {
            this._perfStatsCollector.incrementMsecPerDecompression(statsCompression.getCurrent());
            this._perfStatsCollector.incrementCompressionPerSec();
        }
        return decompressedValue;
    }

    protected boolean getCompressionEnabled() {
        return this._compressionEnabled;
    }

    protected boolean getSerializationEnabled() {
        return true;
    }

    boolean isPerfStatsCollectorInitialized() {
        return this._perfStatsCollector != null;
    }

    private boolean equalsIgnoreCase(ArrayList<String> tagsList, String tag) {
        for (String tagg : tagsList) {
            if (!tagg.equalsIgnoreCase(tag)) continue;
            return true;
        }
        return false;
    }

    private HashMap getTagInfo(Object value, Tag[] tags, ArrayList<Tag> validTags) throws IllegalArgumentException {
        if (tags == null || tags.length <= 0) {
            return null;
        }
        HashMap<String, Object> tagInfo = new HashMap<String, Object>();
        ArrayList<String> tagsList = new ArrayList<String>();
        for (Tag tag : tags) {
            if (tag == null || tag.getTagName() == null) {
                throw new IllegalArgumentException("Value cannot be null.\r\nParameter name: Tag");
            }
            if (this.equalsIgnoreCase(tagsList, tag.getTagName())) continue;
            tagsList.add(tag.getTagName());
            validTags.add(tag);
        }
        tagInfo.put("type", this.getTypeName(value));
        tagInfo.put("tags-list", tagsList);
        return tagInfo;
    }

    private HashMap getNamedTagsInfo(Object value, NamedTagsDictionary namedTags, boolean extractDynamicIndices) throws OperationFailedException {
        if (extractDynamicIndices) {
            namedTags = this.extractDynamicQueryIndexingInfo(value, namedTags);
        }
        this.CheckDuplicateIndexName(value, namedTags);
        if (value == null || namedTags == null || namedTags.getCount() == 0) {
            return null;
        }
        HashMap<String, Object> tagInfo = new HashMap<String, Object>();
        HashMap<String, Object> tagsList = new HashMap<String, Object>();
        HashMap<String, Object> tagsTypeList = new HashMap<String, Object>();
        Iterator iterator = namedTags.getKeysIterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            Object val = namedTags.getValue(key);
            if (key == null || key.isEmpty() || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Named Tag key cannot be null or empty");
            }
            tagsList.put(key, val);
            tagsTypeList.put(key, namedTags.getType((Object)key));
        }
        tagInfo.put("type", this.getTypeName(value));
        tagInfo.put("named-tags-list", tagsList);
        tagInfo.put("named-tags-types-list", tagsTypeList);
        return tagInfo;
    }

    private String getTypeName(Object value) {
        String typeName = value.getClass().getCanonicalName();
        if (JsonObject.class.isAssignableFrom(value.getClass()) && !DotNetToJavaStringHelper.isNullOrEmpty((String)((JsonObject)value).getType())) {
            typeName = ((JsonObject)value).getType();
        }
        typeName = typeName.replace("+", ".");
        return typeName;
    }

    HashMap getQueryInfo(Object value) throws GeneralFailureException {
        TypeInfoMap map;
        HashMap queryInfo = null;
        TypeInfoMap typeInfoMap = map = this.typeMap != null ? this.typeMap : this._cacheImpl.getTypeMap();
        if (map == null) {
            return null;
        }
        this.typeMap = map;
        try {
            int handleId;
            String typeName = value.getClass().getCanonicalName();
            boolean isJson = false;
            if (JsonObject.class.isAssignableFrom(value.getClass()) && !DotNetToJavaStringHelper.isNullOrEmpty((String)((JsonObject)value).getType())) {
                typeName = ((JsonObject)value).getType();
                isJson = true;
            }
            if ((handleId = this.typeMap.getHandleId(typeName)) != -1) {
                queryInfo = new HashMap();
                ArrayList<Object> attribValues = new ArrayList<Object>();
                ArrayList attributes = this.typeMap.getAttribList(handleId);
                for (int i = 0; i < attributes.size(); ++i) {
                    if (!isJson) {
                        Field fieldAttrib = value.getClass().getDeclaredField((String)attributes.get(i));
                        if (fieldAttrib != null) {
                            fieldAttrib.setAccessible(true);
                            Object attribValue = fieldAttrib.get(value);
                            attribValues.add(attribValue);
                            continue;
                        }
                        throw new Exception("Unable to extract query information from user object.");
                    }
                    JsonObject jsonObject = (JsonObject)value;
                    JsonValueBase jsonValue = jsonObject.getAttributeValue((String)attributes.get(i));
                    if (jsonValue != null) {
                        attribValues.add(jsonValue.getValue());
                        continue;
                    }
                    throw new Exception("Unable to extract query information from user object for attribute \"" + (String)attributes.get(i) + "\"");
                }
                queryInfo.put(handleId, attribValues);
            }
        }
        catch (Exception e) {
            throw new GeneralFailureException(e.getMessage());
        }
        return queryInfo;
    }

    @Override
    public <T> Map<String, T> getBulk(Iterable<String> keys, Class<?> cls) throws CacheException {
        return this.getBulk(keys, new ReadThruOptions(ReadMode.None, this._defaultReadThruProvider), cls);
    }

    @Override
    public <T> Map<String, T> getBulk(Iterable<String> keys, ReadThruOptions readThruOptions, Class<?> cls) throws CacheException, IllegalArgumentException, ClassCastException {
        return this.getBulkInternal(keys, readThruOptions, cls);
    }

    private <T> Map<String, T> getBulkInternal(Iterable<String> keys, ReadThruOptions readOption, Class<?> cls) throws OperationFailedException, AggregateException, SecurityException, GeneralFailureException, ConfigurationException, CacheException {
        UsageStats stats = new UsageStats();
        if (this._cacheImpl == null) {
            throw new OperationFailedException("Cache is not initialized");
        }
        if (keys == null) {
            throw new IllegalArgumentException("keys");
        }
        String[] keysArr = CacheImpl.toArray(keys);
        if (keysArr.length == 0) {
            throw new IllegalArgumentException("There is no key present in keys array");
        }
        keysArr = this.RemoveDuplicateKeys(keysArr);
        if (readOption == null) {
            readOption = new ReadThruOptions(ReadMode.None, this._defaultReadThruProvider);
        }
        BitSet flagMap = new BitSet();
        String providerName = readOption.getProviderName();
        if (readOption.getReadMode() != ReadMode.None && providerName == null) {
            providerName = this._defaultWriteThruProvider;
        }
        HashMap resultMap = null;
        flagMap = this.setDSReadOptBit(flagMap, readOption.getReadMode());
        try {
            resultMap = (HashMap)this._cacheImpl.get(keysArr, flagMap, readOption);
            if (resultMap == null) {
                return null;
            }
            long sumObjectSize = 0L;
            long sumCompressedObjectSize = 0L;
            long sumEncryptedObjectSize = 0L;
            HashMap<String, T> deflatMap = new HashMap<String, T>(resultMap.size());
            for (Map.Entry entry : resultMap.entrySet()) {
                Map.Entry pair;
                CompressedValueEntry result;
                if (!Common.is(entry.getValue(), CompressedValueEntry.class) || (result = (CompressedValueEntry)(pair = entry).getValue()) == null || result.getType() != EntryType.CacheItem) continue;
                if (result.getValue() instanceof byte[]) {
                    if (result.getFlag().IsBitSet((byte)2)) {
                        try {
                            result.setValue((Object)this.Decompress((byte[])result.getValue()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.isPerfStatsCollectorInitialized() && result.getValue() != null) {
                        this._perfStatsCollector.incrementAvgItemSize((long)((byte[])result.getValue()).length);
                    }
                    if (this._cacheImpl.getEncryptionEnabled()) {
                        if (this.isPerfStatsCollectorInitialized()) {
                            this._perfStatsCollector.mSecPerDecryptionBeginSample();
                        }
                        result.setValue((Object)CacheHelper.DecryptData((byte[])result.getValue(), this._serializationContext));
                        if (this.isPerfStatsCollectorInitialized()) {
                            this._perfStatsCollector.mSecPerDecryptionEndSample();
                        }
                    }
                    deflatMap.put((String)pair.getKey(), this.safeDeserialize(result.getValue(), this._serializationContext, result.getFlag(), UserObjectType.CacheItem, cls));
                    continue;
                }
                deflatMap.put((String)pair.getKey(), this.safeDeserialize(result.getValue(), this._serializationContext, result.getFlag(), UserObjectType.CacheItem, cls));
            }
            if (this._perfStatsCollector != null) {
                stats.EndSample();
                this._perfStatsCollector.incrementMsecPerGetSample(stats.getCurrent());
                this._perfStatsCollector.incrementByGetPerSecStats((long)keysArr.length);
            }
            return deflatMap;
        }
        catch (CacheException e) {
            if (this._exceptionEnabled) {
                throw e;
            }
            return null;
        }
    }

    @Override
    public Map<String, Exception> addBulk(Map<String, CacheItem> items) throws GeneralFailureException, OperationFailedException, IllegalArgumentException, SecurityException, AggregateException, ConfigurationException, StreamNotFoundException, OperationNotSupportedException, StreamException, CommandException, LicensingException, StreamAlreadyLockedException {
        return this.addBulk(items, null);
    }

    @Override
    public Map<String, Exception> addBulk(Map<String, CacheItem> items, WriteThruOptions writeThruOptions) throws GeneralFailureException, OperationFailedException, SecurityException, IllegalArgumentException, ConfigurationException, AggregateException, OperationNotSupportedException, StreamException, LicensingException, CommandException, StreamNotFoundException, StreamAlreadyLockedException {
        String providerName = null;
        Object itemVersions = null;
        WriteMode mode = WriteMode.None;
        long[] sizes = new long[items.size()];
        DataSourceModifiedListener dataSourceModifiedCallback = null;
        EnumSet eventTypes = EnumSet.of(EventTypeInternal.None);
        RefObject tempRef_mode = new RefObject((Object)mode);
        RefObject tempRef_providerName = new RefObject(providerName);
        RefObject tempRef_dataSourceModifiedCallback = new RefObject(dataSourceModifiedCallback);
        RefObject tempRef_eventTypes = new RefObject(eventTypes);
        ConversionUtil.GetWriteOptions(writeThruOptions, (RefObject<WriteMode>)tempRef_mode, (RefObject<String>)tempRef_providerName, (RefObject<DataSourceModifiedListener>)tempRef_dataSourceModifiedCallback, (RefObject<EnumSet<EventTypeInternal>>)tempRef_eventTypes);
        mode = (WriteMode)tempRef_mode.argvalue;
        providerName = (String)tempRef_providerName.argvalue;
        dataSourceModifiedCallback = (DataSourceModifiedListener)tempRef_dataSourceModifiedCallback.argvalue;
        eventTypes = (EnumSet)tempRef_eventTypes.argvalue;
        EventTypeInternal eventTypeInternal = (EventTypeInternal)((Object)eventTypes.toArray()[0]);
        RefObject tempRef_sizes = new RefObject((Object)sizes);
        RefObject tempRef_itemVersions = new RefObject(itemVersions);
        return this.AddBulkInternal(items, mode, dataSourceModifiedCallback, eventTypeInternal, providerName, true, null, (short)-1, (short)-1, (short)-1, EventDataFilter.None, EventDataFilter.None, false);
    }

    public Map<String, Exception> AddBulkInternal(Map<String, CacheItem> items, WriteMode writeMode, DataSourceModifiedListener dataSourceModifiedListener, EventTypeInternal eventType, String providerName, boolean allowQueryTags, String clientId, short updateCallbackId, short removeCallbackId, short dsItemAddedCallbackID, EventDataFilter updateCallbackFilter, EventDataFilter removeCallabackFilter, boolean returnVersions) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, StreamNotFoundException, OperationNotSupportedException, StreamException, CommandException, LicensingException, StreamAlreadyLockedException {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        if (items == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: items");
        }
        if (items.isEmpty()) {
            throw new IllegalArgumentException("Adding empty dictionary into cache.");
        }
        if ((writeMode == WriteMode.WriteThru || writeMode == WriteMode.WriteBehind) && providerName == null) {
            providerName = this._defaultWriteThruProvider;
        }
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)providerName)) {
            providerName.toLowerCase();
        }
        Map itemVersions = null;
        long[] sizes = new long[items.size()];
        CacheItem[] clonedItems = new CacheItem[items.size()];
        String[] keys = new String[items.size()];
        String[] dataTypes = new String[items.size()];
        UsageStats stats = new UsageStats();
        stats.BeginSample();
        int count = 0;
        for (Map.Entry<String, CacheItem> pair : items.entrySet()) {
            String key = pair.getKey();
            CacheItem cacheitem = pair.getValue();
            if (cacheitem == null) {
                throw new IllegalArgumentException("CacheItem cannot be null");
            }
            if (key == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
            }
            if (cacheitem instanceof com.alachisoft.ncache.client.datastructures.DistributedDataStructure) {
                throw new IllegalArgumentException("Value cannot be a distributed data type.");
            }
            Object tempVar = cacheitem.clone();
            CacheItem cloned = (CacheItem)(tempVar instanceof CacheItem ? tempVar : null);
            if (cloned == null) {
                throw new IllegalArgumentException("items[" + count + "]");
            }
            if (cloned.getGroup() != null) {
                CacheItemWrapperInternal.setTypeName(cloned, this.getTypeName(cloned.getValue(Object.class)));
            }
            BitSet flagMap = new BitSet();
            long size = 0L;
            if (sizes[count] > 0L) {
                size = sizes[count];
            }
            HashMap queryInfo = null;
            if (cloned.getValue(Object.class) instanceof ClientCacheItem) {
                Object tempVar2 = cloned.getValue(Object.class);
                ClientCacheItem clientcacheItem = (ClientCacheItem)(tempVar2 instanceof ClientCacheItem ? tempVar2 : null);
                cloned.setValue(clientcacheItem.getValue());
                queryInfo = clientcacheItem.getQueryInfo();
                if (clientcacheItem.getFlags().IsAnyBitSet((byte)-128)) {
                    flagMap.SetBit((byte)-128);
                } else if (clientcacheItem.getFlags().IsAnyBitSet((byte)32)) {
                    flagMap.SetBit((byte)32);
                }
            }
            if (queryInfo == null) {
                queryInfo = new HashMap();
                HashMap staticIndexes = this.getQueryInfo(cloned.getValue(Object.class));
                if (allowQueryTags) {
                    queryInfo.put("query-info", staticIndexes);
                    HashMap htNamedTagInfo = this.getNamedTagsInfo(cloned.getValue(Object.class), cloned.getNamedTags(), staticIndexes == null);
                    if (htNamedTagInfo != null) {
                        queryInfo.put("named-tag-info", htNamedTagInfo);
                    }
                    ArrayList<Tag> validTags = new ArrayList<Tag>();
                    HashMap htTagInfo = this.getTagInfo(cloned.getValue(Object.class), ConversionUtil.toArray(cloned.getTags()), validTags);
                    if (htTagInfo != null) {
                        queryInfo.put("tag-info", htTagInfo);
                    }
                }
            }
            CacheItemWrapperInternal.setQueryInfo(cloned, queryInfo);
            cloned.setValue(this.safeSerialize(cloned.getValue(Object.class), this._serializationContext, flagMap, size, UserObjectType.CacheItem, false));
            sizes[count] = size;
            if (this._cacheImpl.getEncryptionEnabled()) {
                UsageStats statsEncryption = new UsageStats();
                statsEncryption.BeginSample();
                cloned.setValue(CacheHelper.EncryptData((byte[])cloned.getValue(Object.class), this._serializationContext));
                statsEncryption.EndSample();
                if (this.isPerfStatsCollectorInitialized()) {
                    this._perfStatsCollector.incrementMsecPerEncryptionSample(statsEncryption.getCurrent());
                }
            }
            if (this.isPerfStatsCollectorInitialized() && cloned.getValue(Object.class) != null && cloned.getValue(Object.class) instanceof byte[]) {
                this._perfStatsCollector.incrementAvgItemSize((long)((byte[])cloned.getValue(Object.class)).length);
            }
            if (this._compressionEnabled) {
                RefObject tempRef_flagMap2 = new RefObject((Object)flagMap);
                cloned.setValue(this.Compress((byte[])cloned.getValue(Object.class), (BitSet)tempRef_flagMap2.getValue(), this._compressionThresholdSize));
                flagMap = (BitSet)tempRef_flagMap2.argvalue;
            }
            flagMap = this.setDSUpdateOptBit(flagMap, writeMode);
            CacheItemWrapperInternal.setFlagValue(cloned, flagMap);
            if (ConversionUtil.getAbsoluteExpiration(cloned.getExpiration()) != null && ConversionUtil.getAbsoluteExpiration(cloned.getExpiration()) != NoAbsoluteExpiration) {
                Date expirationTime = null;
                Date nowTme = null;
                try {
                    expirationTime = NCDateTime.getUTCDate((Date)ConversionUtil.getAbsoluteExpiration(cloned.getExpiration()));
                    nowTme = NCDateTime.getUTCDate((Date)new Date());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                Expiration tempVar3 = new Expiration(ExpirationType.Absolute, TimeSpan.subtract((Date)expirationTime, (Date)nowTme));
                cloned.setExpiration(tempVar3);
            }
            clonedItems[count] = cloned;
            keys[count] = key;
            ++count;
        }
        if (dsItemAddedCallbackID == -1 && dataSourceModifiedListener != null) {
            dsItemAddedCallbackID = this.GetCallbackId(dataSourceModifiedListener, keys.length, eventType);
        }
        try {
            HashMap result = this._cacheImpl.add(keys, clonedItems, dsItemAddedCallbackID, providerName, sizes, this._cacheImpl.getEncryptionEnabled(), clientId, updateCallbackId, removeCallbackId, updateCallbackFilter, removeCallabackFilter, returnVersions, itemVersions, ListenerType.PushBasedNotification);
            if (this.isPerfStatsCollectorInitialized()) {
                stats.EndSample();
                this._perfStatsCollector.incrementMsecPerAddBulkSample(stats.getCurrent());
                this._perfStatsCollector.incrementByAddPerSecStats((long)keys.length);
            }
            return result;
        }
        catch (RuntimeException e) {
            if (this._exceptionEnabled) {
                throw e;
            }
            return null;
        }
    }

    @Override
    public Map<String, Exception> insertBulk(Map<String, CacheItem> items) throws CacheException {
        return this.insertBulk(items, null);
    }

    @Override
    public Map<String, Exception> insertBulk(Map<String, CacheItem> items, WriteThruOptions writeThruOptions) throws CacheException {
        String providerName = null;
        Object itemVersions = null;
        WriteMode mode = WriteMode.None;
        long[] sizes = new long[items.size()];
        DataSourceModifiedListener dataSourceModifiedCallback = null;
        EnumSet eventTypes = EnumSet.of(EventTypeInternal.None);
        RefObject tempRef_mode = new RefObject((Object)mode);
        RefObject tempRef_providerName = new RefObject(providerName);
        RefObject tempRef_dataSourceModifiedCallback = new RefObject(dataSourceModifiedCallback);
        RefObject tempRef_eventTypes = new RefObject(eventTypes);
        ConversionUtil.GetWriteOptions(writeThruOptions, (RefObject<WriteMode>)tempRef_mode, (RefObject<String>)tempRef_providerName, (RefObject<DataSourceModifiedListener>)tempRef_dataSourceModifiedCallback, (RefObject<EnumSet<EventTypeInternal>>)tempRef_eventTypes);
        mode = (WriteMode)tempRef_mode.argvalue;
        providerName = (String)tempRef_providerName.argvalue;
        dataSourceModifiedCallback = (DataSourceModifiedListener)tempRef_dataSourceModifiedCallback.argvalue;
        eventTypes = (EnumSet)tempRef_eventTypes.argvalue;
        EventTypeInternal eventTypeInternal = (EventTypeInternal)((Object)eventTypes.toArray()[0]);
        RefObject tempRef_sizes = new RefObject((Object)sizes);
        RefObject tempRef_itemVersions = new RefObject(itemVersions);
        return this.InsertBulkInternal(items, mode, dataSourceModifiedCallback, eventTypeInternal, providerName, (RefObject<long[]>)tempRef_sizes, true, "", (short)-1, (short)-1, (short)-1, EventDataFilter.None, EventDataFilter.None, false, (RefObject<Map>)tempRef_itemVersions);
    }

    public Map<String, Exception> InsertBulkInternal(Map<String, CacheItem> items, WriteMode writeMode, DataSourceModifiedListener dataSourceModifiedCallback, EventTypeInternal eventType, String providerName, RefObject<long[]> sizes, boolean allowQueryTags, String clientId, short updateCallbackId, short removeCallbackId, short dsItemUpdatedCallbackID, EventDataFilter updateCallbackFilter, EventDataFilter removeCallbackFilter, boolean returnVersions, RefObject<Map> itemVersions) throws CacheException {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        if (items == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: items");
        }
        if (items.isEmpty()) {
            throw new IllegalArgumentException("Adding empty dictionary into cache.");
        }
        itemVersions.argvalue = null;
        if ((writeMode == WriteMode.WriteThru || writeMode == WriteMode.WriteBehind) && providerName == null) {
            providerName = this._defaultWriteThruProvider;
        }
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)providerName)) {
            providerName = providerName.toLowerCase();
        }
        CacheItem[] clonedItems = new CacheItem[items.size()];
        String[] keys = new String[items.size()];
        UsageStats stats = new UsageStats();
        stats.BeginSample();
        int count = 0;
        for (Map.Entry<String, CacheItem> pair : items.entrySet()) {
            CacheItem cacheItem = pair.getValue();
            String key = pair.getKey();
            if (cacheItem == null) {
                throw new IllegalArgumentException("CacheItem cannot be null");
            }
            if (cacheItem instanceof com.alachisoft.ncache.client.datastructures.DistributedDataStructure) {
                throw new IllegalArgumentException("Value cannot be a distributed data type.");
            }
            CacheItem cloned = (CacheItem)cacheItem.clone();
            this.validateKeyValue(key, cloned.getValue(Object.class));
            BitSet flagMap = new BitSet();
            if (cloned.getGroup() != null) {
                CacheItemWrapperInternal.setTypeName(cloned, this.getTypeName(cloned.getValue(Object.class)));
            }
            long size = 0L;
            if (((long[])sizes.argvalue)[count] > 0L) {
                size = ((long[])sizes.argvalue)[count];
            }
            HashMap queryInfo = null;
            if (cloned.getValue(Object.class) instanceof ClientCacheItem) {
                Object tempVar2 = cloned.getValue(Object.class);
                ClientCacheItem clientcacheItem = (ClientCacheItem)(tempVar2 instanceof ClientCacheItem ? tempVar2 : null);
                cloned.setValue(clientcacheItem.getValue());
                queryInfo = clientcacheItem.getQueryInfo();
                if (clientcacheItem.getFlags().IsAnyBitSet((byte)-128)) {
                    flagMap.SetBit((byte)-128);
                } else if (clientcacheItem.getFlags().IsAnyBitSet((byte)32)) {
                    flagMap.SetBit((byte)32);
                }
                CacheItemWrapperInternal.setTypeName(cloned, clientcacheItem.getGroupDataType());
            }
            if (queryInfo == null) {
                queryInfo = new HashMap();
                HashMap staticIndexes = this.getQueryInfo(cloned.getValue(Object.class));
                if (allowQueryTags) {
                    queryInfo.put("query-info", staticIndexes);
                    HashMap htNamedTagInfo = this.getNamedTagsInfo(cloned.getValue(Object.class), cloned.getNamedTags(), staticIndexes == null);
                    if (htNamedTagInfo != null) {
                        queryInfo.put("named-tag-info", htNamedTagInfo);
                    }
                    ArrayList<Tag> validTags = new ArrayList<Tag>();
                    HashMap htTagInfo = this.getTagInfo(cloned.getValue(Object.class), ConversionUtil.toArray(cloned.getTags()), validTags);
                    if (htTagInfo != null) {
                        queryInfo.put("tag-info", htTagInfo);
                    }
                }
            }
            CacheItemWrapperInternal.setQueryInfo(cloned, queryInfo);
            cloned.setValue(this.safeSerialize(cloned.getValue(Object.class), this._serializationContext, flagMap, size, UserObjectType.CacheItem, false));
            ((long[])sizes.argvalue)[count] = size;
            if (this._cacheImpl.getEncryptionEnabled()) {
                UsageStats statsEncryption = new UsageStats();
                statsEncryption.BeginSample();
                cloned.setValue(CacheHelper.EncryptData((byte[])cloned.getValue(Object.class), this._serializationContext));
                statsEncryption.EndSample();
                if (this.isPerfStatsCollectorInitialized()) {
                    this._perfStatsCollector.incrementMsecPerEncryptionSample(statsEncryption.getCurrent());
                }
            }
            if (this.isPerfStatsCollectorInitialized() && cloned.getValue(Object.class) != null) {
                this._perfStatsCollector.incrementAvgItemSize((long)((byte[])cloned.getValue(Object.class)).length);
            }
            if (this._compressionEnabled) {
                RefObject tempRef_flagMap2 = new RefObject((Object)flagMap);
                cloned.setValue(this.Compress((byte[])cloned.getValue(Object.class), (BitSet)tempRef_flagMap2.getValue(), this._compressionThresholdSize));
                flagMap = (BitSet)tempRef_flagMap2.argvalue;
            }
            flagMap = this.setDSUpdateOptBit(flagMap, writeMode);
            CacheItemWrapperInternal.setFlagValue(cloned, flagMap);
            if (ConversionUtil.getAbsoluteExpiration(cloned.getExpiration()) != null && ConversionUtil.getAbsoluteExpiration(cloned.getExpiration()) != NoAbsoluteExpiration) {
                Date expirationTime = null;
                Date nowTme = null;
                try {
                    expirationTime = NCDateTime.getUTCDate((Date)ConversionUtil.getAbsoluteExpiration(cloned.getExpiration()));
                    nowTme = NCDateTime.getUTCDate((Date)new Date());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                Expiration tempVar3 = new Expiration(ExpirationType.Absolute, TimeSpan.subtract((Date)expirationTime, (Date)nowTme));
                cloned.setExpiration(tempVar3);
            }
            clonedItems[count] = cloned;
            keys[count] = key;
            ++count;
        }
        if (dsItemUpdatedCallbackID == -1 && dataSourceModifiedCallback != null) {
            dsItemUpdatedCallbackID = this.GetCallbackId(dataSourceModifiedCallback, keys.length, eventType);
        }
        try {
            HashMap result = this._cacheImpl.insert(keys, clonedItems, dsItemUpdatedCallbackID, providerName, (long[])sizes.argvalue, this._cacheImpl.getEncryptionEnabled(), clientId, updateCallbackId, removeCallbackId, updateCallbackFilter, removeCallbackFilter, returnVersions, (Map)itemVersions.argvalue, ListenerType.PushBasedNotification);
            if (this.isPerfStatsCollectorInitialized()) {
                stats.EndSample();
                this._perfStatsCollector.incrementMsecPerUpdBulkSample(stats.getCurrent());
                this._perfStatsCollector.incrementByUpdPerSecStats((long)keys.length);
            }
            return result;
        }
        catch (CacheException e) {
            if (this._exceptionEnabled) {
                throw e;
            }
            return null;
        }
    }

    @Override
    public void deleteBulk(Iterable<String> keys) throws CacheException {
        this.deleteBulk(keys, null);
    }

    @Override
    public void deleteBulk(Iterable<String> keys, WriteThruOptions writeThruOptions) throws CacheException {
        block10: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException(ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            if (keys == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: keys");
            }
            for (String key : keys) {
                if (!key.isEmpty()) continue;
                throw new IllegalArgumentException("key cannot be empty string");
            }
            String[] keysArr = this.removeDuplicateKeys(keys);
            if (keysArr.length == 0) {
                throw new IllegalArgumentException("There is no key present in keys array");
            }
            String providerName = null;
            BitSet flagMap = new BitSet();
            WriteMode mode = WriteMode.None;
            short dsItemsRemovedCallbackId = -1;
            UsageStats stats = new UsageStats();
            DataSourceModifiedListener dataSourceModifiedListener = null;
            EnumSet eventTypes = EnumSet.of(EventTypeInternal.None);
            RefObject tempRef_mode = new RefObject((Object)mode);
            RefObject tempRef_providerName = new RefObject(providerName);
            RefObject tempRef_dataSourceModifiedCallback = new RefObject(dataSourceModifiedListener);
            RefObject tempRef_eventTypes = new RefObject(eventTypes);
            ConversionUtil.GetWriteOptions(writeThruOptions, (RefObject<WriteMode>)tempRef_mode, (RefObject<String>)tempRef_providerName, (RefObject<DataSourceModifiedListener>)tempRef_dataSourceModifiedCallback, (RefObject<EnumSet<EventTypeInternal>>)tempRef_eventTypes);
            mode = (WriteMode)tempRef_mode.argvalue;
            providerName = (String)tempRef_providerName.argvalue;
            dataSourceModifiedListener = (DataSourceModifiedListener)tempRef_dataSourceModifiedCallback.argvalue;
            eventTypes = (EnumSet)tempRef_eventTypes.argvalue;
            EventTypeInternal eventTypeInternal = (EventTypeInternal)((Object)eventTypes.toArray()[0]);
            try {
                flagMap = this.setDSUpdateOptBit(flagMap, mode);
                stats.BeginSample();
                if (dataSourceModifiedListener != null) {
                    dsItemsRemovedCallbackId = this.GetCallbackId(dataSourceModifiedListener, keysArr.length, eventTypeInternal);
                }
                if ((mode == WriteMode.WriteThru || mode == WriteMode.WriteBehind) && providerName == null) {
                    providerName = this._defaultWriteThruProvider;
                }
                if (!DotNetToJavaStringHelper.isNullOrEmpty((String)providerName)) {
                    providerName.toLowerCase();
                }
                this._cacheImpl.delete(keysArr, flagMap, providerName, dsItemsRemovedCallbackId);
                if (this.isPerfStatsCollectorInitialized()) {
                    stats.EndSample();
                    this._perfStatsCollector.incrementMsecPerDelBulkSample(stats.getCurrent());
                    this._perfStatsCollector.incrementByDelPerSecStats((long)keysArr.length);
                }
            }
            catch (Exception e) {
                if (!this._exceptionEnabled) break block10;
                throw new CacheException((Throwable)e);
            }
        }
    }

    @Override
    public <T> Map<String, T> removeBulk(Iterable<String> keys, Class<?> cls) throws CacheException, IllegalArgumentException, ClassCastException {
        return this.removeBulk(keys, null, cls);
    }

    @Override
    public <T> Map<String, T> removeBulk(Iterable<String> keys, WriteThruOptions writeThruOptions, Class<?> cls) throws CacheException, IllegalArgumentException, ClassCastException {
        HashMap<String, T> removedItems;
        block16: {
            removedItems = new HashMap<String, T>();
            if (this._cacheImpl == null) {
                throw new OperationFailedException(ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            if (keys == null) {
                throw new IllegalArgumentException("keys");
            }
            String[] keysArr = this.removeDuplicateKeys(keys);
            if (keysArr.length == 0) {
                throw new IllegalArgumentException("There is no key present in keys array");
            }
            String providerName = null;
            BitSet flagMap = new BitSet();
            WriteMode mode = WriteMode.None;
            short dsItemsRemovedCallbackId = -1;
            UsageStats stats = new UsageStats();
            DataSourceModifiedListener dataSourceModifiedListener = null;
            EnumSet eventTypes = EnumSet.of(EventTypeInternal.None);
            RefObject tempRef_mode = new RefObject((Object)mode);
            RefObject tempRef_providerName = new RefObject(providerName);
            RefObject tempRef_dataSourceModifiedCallback = new RefObject(dataSourceModifiedListener);
            RefObject tempRef_eventTypes = new RefObject(eventTypes);
            ConversionUtil.GetWriteOptions(writeThruOptions, (RefObject<WriteMode>)tempRef_mode, (RefObject<String>)tempRef_providerName, (RefObject<DataSourceModifiedListener>)tempRef_dataSourceModifiedCallback, (RefObject<EnumSet<EventTypeInternal>>)tempRef_eventTypes);
            mode = (WriteMode)tempRef_mode.argvalue;
            providerName = (String)tempRef_providerName.argvalue;
            dataSourceModifiedListener = (DataSourceModifiedListener)tempRef_dataSourceModifiedCallback.argvalue;
            eventTypes = (EnumSet)tempRef_eventTypes.argvalue;
            EventTypeInternal eventTypeInternal = (EventTypeInternal)((Object)eventTypes.toArray()[0]);
            try {
                HashMap map;
                flagMap = this.setDSUpdateOptBit(flagMap, mode);
                stats.BeginSample();
                if (dataSourceModifiedListener != null) {
                    dsItemsRemovedCallbackId = this.GetCallbackId(dataSourceModifiedListener, keysArr.length, eventTypeInternal);
                }
                if ((mode == WriteMode.WriteThru || mode == WriteMode.WriteBehind) && providerName == null) {
                    providerName = this._defaultWriteThruProvider;
                }
                if (!DotNetToJavaStringHelper.isNullOrEmpty((String)providerName)) {
                    providerName.toLowerCase();
                }
                if ((map = this._cacheImpl.remove(keysArr, flagMap, providerName, dsItemsRemovedCallbackId)) != null) {
                    Iterator ie = map.keySet().iterator();
                    while (ie.hasNext()) {
                        String key = ie.next().toString();
                        CompressedValueEntry result = map.get(key) instanceof CompressedValueEntry ? map.get(key) : null;
                        if (result == null) continue;
                        if (result.getType() != EntryType.CacheItem) {
                            map.put(key, null);
                            continue;
                        }
                        if (result.getFlag().IsBitSet((byte)this._compressed)) {
                            result.setValue((Object)this.Decompress((byte[])result.getValue()));
                        }
                        if (this._perfStatsCollector != null && result.getValue() != null && result.getValue() instanceof byte[]) {
                            this._perfStatsCollector.incrementAvgItemSize((long)((byte[])result.getValue()).length);
                        }
                        if (this._cacheImpl.getEncryptionEnabled()) {
                            UsageStats statsEncryption = new UsageStats();
                            statsEncryption.BeginSample();
                            result.setValue((Object)CacheHelper.DecryptData((byte[])result.getValue(), this._serializationContext));
                            statsEncryption.EndSample();
                            if (this._perfStatsCollector != null) {
                                this._perfStatsCollector.incrementMsecPerDecryptionSample(statsEncryption.getCurrent());
                            }
                        }
                        removedItems.put(key, this.safeDeserialize(result.getValue(), this._serializationContext, result.getFlag(), UserObjectType.CacheItem, cls));
                    }
                }
                if (this.isPerfStatsCollectorInitialized()) {
                    stats.EndSample();
                    this._perfStatsCollector.incrementMsecPerDelBulkSample(stats.getCurrent());
                    this._perfStatsCollector.incrementByDelPerSecStats((long)keysArr.length);
                }
            }
            catch (Exception e) {
                if (!this._exceptionEnabled) break block16;
                throw new CacheException((Throwable)e);
            }
        }
        return removedItems;
    }

    private EventTypeInternal convertToEventType(EventType type) {
        EventTypeInternal eventType = EventTypeInternal.None;
        switch (type) {
            case ItemAdded: {
                eventType = EventTypeInternal.ItemAdded;
                break;
            }
            case ItemRemoved: {
                eventType = EventTypeInternal.ItemRemoved;
                break;
            }
            case ItemUpdated: {
                eventType = EventTypeInternal.ItemUpdated;
            }
        }
        return eventType;
    }

    public void createDataType(CollectionCreateOrGetOperation operation, DataStructureAttributes properties) throws CacheException {
        if (operation.getWriteThruOptions() != null && operation.getWriteThruOptions().getDataSourceModificationListener() != null) {
            EnumSet<EventTypeInternal> eventTypes = EventUtil.getEventTypeInternalEnumSet(operation.getWriteThruOptions().getEventTypes());
            operation.setDataSourceModifiedListenerIdInternal((short)-1);
            if (eventTypes.contains((Object)EventTypeInternal.ItemAdded) && operation.getWriteThruOptions().getMode().equals((Object)WriteMode.WriteBehind)) {
                operation.setDataSourceModifiedListenerIdInternal(this.GetCallbackId(operation.getWriteThruOptions().getDataSourceModificationListener(), 1, EventTypeInternal.ItemAdded));
            }
        }
        this._cacheImpl.createDataType(operation, properties);
    }

    public boolean getDataType(CollectionCreateOrGetOperation operation) throws CacheException {
        return this._cacheImpl.getDataType(operation);
    }

    public void addCollectionNotificationListener(String collectionName, short addCallbackId, short updateCallbackId, short removeCallbackId, DataTypeEventDataFilter dataFilter, DistributedDataStructure dataType, boolean notifyOnItemExpiration) throws OperationFailedException, CommandException, LicensingException {
        this._cacheImpl.addCollectionNotificationListener(collectionName, addCallbackId, updateCallbackId, removeCallbackId, dataFilter, dataType, notifyOnItemExpiration);
    }

    public void removeCollectionNotificationListener(String collectionName, short addCallbackId, short updateCallbackId, short removeCallbackId, EventTypeInternal eventType, DistributedDataStructure dataType) throws OperationFailedException, CommandException, LicensingException {
        this._cacheImpl.removeCollectionNotificationListener(collectionName, addCallbackId, updateCallbackId, removeCallbackId, eventType, dataType);
    }

    public void clearCollection(String key, DistributedDataStructure dataType, String lockId, TimeSpan lockTimeout) throws ConnectionException, OperationFailedException {
        CollectionOperation operation = new CollectionOperation(key, dataType, lockId, lockTimeout);
        operation.setOperationType(CollectionOperation.OpType.Clear);
        this._cacheImpl.CollectionClearOperation(operation);
    }

    public Object getNamedTagsInfoForCollection(Object value, NamedTagsDictionary namedTags) {
        this.CheckDuplicateIndexName(value, namedTags);
        if (namedTags == null || namedTags.getCount() == 0) {
            return null;
        }
        HashMap namedTagsMap = new HashMap();
        HashMap<String, Object> namedTagsInfo = new HashMap<String, Object>();
        Iterator it = namedTags.getIterator();
        while (it.hasNext()) {
            Map.Entry nameValue = (Map.Entry)it.next();
            if (nameValue.getKey() != null && DotNetToJavaStringHelper.isNullOrEmpty((String)nameValue.getKey().toString().trim())) {
                throw new IllegalArgumentException("Named Tag key cannot be null or empty");
            }
            if (nameValue.getValue() == null) {
                throw new IllegalArgumentException("Named Tag value cannot be null");
            }
            namedTagsMap.put(nameValue.getKey(), nameValue.getValue());
        }
        namedTagsInfo.put("type", "$DataType$");
        namedTagsInfo.put("named-tags-list", namedTagsMap);
        return namedTagsInfo;
    }

    public final HashMap getTagInfoForCollection(Tag[] tags) {
        if (tags == null || tags.length == 0) {
            return null;
        }
        ArrayList<String> tagsList = new ArrayList<String>();
        HashMap<String, Object> tagsInfo = new HashMap<String, Object>();
        for (Tag tag : tags) {
            if (tag == null) {
                throw new IllegalArgumentException("Tag cannot be null.");
            }
            if (tag.getTagName() == null) {
                throw new IllegalArgumentException("Tag cannot be null.");
            }
            if (tagsList.contains(tag.getTagName())) continue;
            tagsList.add(tag.getTagName());
        }
        tagsInfo.put("type", "$DataType$");
        tagsInfo.put("tags-list", tagsList);
        return tagsInfo;
    }

    public int collectionCount(String key, DistributedDataStructure dataType, String lockId, TimeSpan lockTimeout) {
        CollectionOperation tempVar = new CollectionOperation(key, dataType, lockId, lockTimeout);
        tempVar.setOperationType(CollectionOperation.OpType.Count);
        CollectionOperation operation = tempVar;
        return this._cacheImpl.CollectionCountOperation(operation);
    }

    public GetCollectionChunkResponse getCollectionChunkResponse(String key, DistributedDataStructure collectionType, int version, int nextIndex) {
        GetCollectionChunkOperation operation = new GetCollectionChunkOperation(key, collectionType, null, TimeSpan.MaxValue);
        operation.setIndex(nextIndex);
        operation.setVersion(version);
        return (GetCollectionChunkResponse)this._cacheImpl.GetCollectionChunk(operation);
    }

    public GetCollectionChunkResponseBase getPairedCollectionChunkResponse(String key, DistributedDataStructure collectionType, int collectionVersion, int nextIndex, KeyValuePairedEnumerationFilter filter) {
        GetDictionaryChunkOperation tempVar = new GetDictionaryChunkOperation(key, collectionType, null, TimeSpan.MaxValue);
        tempVar.setFilter(filter);
        tempVar.setIndex(nextIndex);
        tempVar.setVersion(collectionVersion);
        GetDictionaryChunkOperation operation = tempVar;
        return (GetPairedCollectionChunkResponse)this._cacheImpl.GetCollectionChunk((GetCollectionChunkOperation)operation);
    }

    public long counterOperations(String key, String lockId, TimeSpan lockTimeout, long value, CounterOperation.OpType counterOpType, WriteThruOptions writeThruOptions) {
        CounterOperation operation = new CounterOperation(key, lockId, lockTimeout);
        operation.setValue(value);
        operation.setOperationType(counterOpType);
        operation.setWriteThruOptions(writeThruOptions);
        return this._cacheImpl.counterOperations(operation);
    }

    public long counterGetOperation(String key, String lockId, TimeSpan lockTimeout) {
        return this._cacheImpl.counterGetOperation(new CounterGetOperation(key, lockId, lockTimeout));
    }

    public void listRemoveWithIndex(String key, String lockId, TimeSpan lockTimeout, int arg1, int arg2, ListRemoveWithIndexOperation.OpType removeType, WriteThruOptions writeThruOptions) {
        ListRemoveWithIndexOperation operation = new ListRemoveWithIndexOperation(key, lockId, lockTimeout);
        operation.setArg1(arg1);
        operation.setArg2(arg2);
        operation.setOperationType(removeType);
        operation.setWriteThruOptions(writeThruOptions);
        this._cacheImpl.listRemoveWithIndex(operation);
    }

    public <T> List<T> listGetBulk(String key, String lockId, TimeSpan lockTimeout, int start, int count, Class<?> cls) {
        ListGetBulkOperation tempVar = new ListGetBulkOperation(key, lockId, lockTimeout);
        tempVar.setIndex(start);
        tempVar.setCount(count);
        ListGetBulkOperation operation = tempVar;
        ArrayList<T> response = new ArrayList<T>();
        List<ExtendedJsonValueBase> operationResponse = this._cacheImpl.listGetBulk(operation);
        for (ExtendedJsonValueBase item : operationResponse) {
            response.add(this.safeDataStructuresDeserialize(item, this._serializationContext, new BitSet(32), UserObjectType.DistributedDataType, cls));
        }
        return response;
    }

    public <T> void listAddWithoutIndex(String key, String lockId, TimeSpan lockTimeout, Iterable<T> collection, ListAddWithoutIndexOperation.OpType addType, WriteThruOptions writeThruOptions) {
        ArrayList<ExtendedJsonValueBase> serializedData = new ArrayList<ExtendedJsonValueBase>();
        for (T item : collection) {
            BitSet bitSet = new BitSet(32);
            RefObject tempRef_size = new RefObject((Object)this.size);
            serializedData.add((ExtendedJsonValueBase)this.safeDataStructuresSerialize(item, this._serializationContext, bitSet, -1L, UserObjectType.DistributedDataType, false));
        }
        ListAddWithoutIndexOperation operation = new ListAddWithoutIndexOperation(key, lockId, lockTimeout);
        operation.setOperationType(addType);
        operation.setCollection(serializedData);
        operation.setWriteThruOptions(writeThruOptions);
        this._cacheImpl.listAddWithoutIndex(operation);
    }

    public int listRemoveWithoutIndex(String key, String lockId, TimeSpan lockTimeout, Iterable<?> collection, WriteThruOptions writeThruOptions) {
        ArrayList<ExtendedJsonValueBase> serializedData = new ArrayList<ExtendedJsonValueBase>();
        for (Object item : collection) {
            BitSet bitSet = new BitSet(32);
            serializedData.add((ExtendedJsonValueBase)this.safeDataStructuresSerialize(item, this._serializationContext, bitSet, -1L, UserObjectType.DistributedDataType, true));
        }
        ListRemoveWithoutIndexOperation tempVar = new ListRemoveWithoutIndexOperation(key, lockId, lockTimeout);
        tempVar.setCollection(serializedData);
        tempVar.setWriteThruOptions(writeThruOptions);
        ListRemoveWithoutIndexOperation operation = tempVar;
        return this._cacheImpl.listRemoveWithoutIndex(operation);
    }

    public <T> boolean listAddWithPivot(String key, String lockId, TimeSpan lockTimeout, T pivot, T value, ListAddWithPivotOperation.OpType addType, WriteThruOptions writeThruOptions) {
        long sizePivot = -1L;
        long sizeValue = -1L;
        BitSet bitSetPivot = new BitSet(32);
        BitSet bitSetValue = new BitSet(32);
        ListAddWithPivotOperation operation = new ListAddWithPivotOperation(key, lockId, lockTimeout);
        operation.setOperationType(addType);
        operation.setWriteThruOptions(writeThruOptions);
        operation.setPivot((ExtendedJsonValueBase)this.safeDataStructuresSerialize(pivot, this._serializationContext, bitSetPivot, -1L, UserObjectType.DistributedDataType, true));
        operation.setValue((ExtendedJsonValueBase)this.safeDataStructuresSerialize(value, this._serializationContext, bitSetValue, -1L, UserObjectType.DistributedDataType, false));
        return this._cacheImpl.listAddWithPivot(operation);
    }

    public <T> T listGetItem(String key, String lockId, TimeSpan lockTimeout, int index, ListGetItemOperation.OpType getOpType, Class<?> cls) {
        BitSet bitSet = new BitSet(32);
        ListGetItemOperation operation = new ListGetItemOperation(key, lockId, lockTimeout);
        operation.setIndex(index);
        operation.setOperationType(getOpType);
        return this.safeDataStructuresDeserialize(this._cacheImpl.listGetItem(operation), this._serializationContext, bitSet, UserObjectType.DistributedDataType, cls);
    }

    public <T> void listInsertWithIndex(String key, String lockId, TimeSpan lockTimeout, int index, T element, ListInsertWithIndexOperation.OpType insertType, WriteThruOptions writeThruOptions) {
        long size = -1L;
        BitSet bitSet = new BitSet(32);
        ListInsertWithIndexOperation operation = new ListInsertWithIndexOperation(key, lockId, lockTimeout);
        operation.setIndex(index);
        operation.setOperationType(insertType);
        operation.setWriteThruOptions(writeThruOptions);
        operation.setItem((ExtendedJsonValueBase)this.safeDataStructuresSerialize(element, this._serializationContext, bitSet, -1L, UserObjectType.DistributedDataType, false));
        this._cacheImpl.listInsertWithIndex(operation);
    }

    public int listSearch(String key, String lockId, TimeSpan lockTimeout, Object o) {
        BitSet bitSet = new BitSet(32);
        ListSearchOperation tempVar = new ListSearchOperation(key, lockId, lockTimeout);
        tempVar.setItem((ExtendedJsonValueBase)this.safeDataStructuresSerialize(o, this._serializationContext, bitSet, -1L, UserObjectType.DistributedDataType, true));
        ListSearchOperation operation = tempVar;
        return this._cacheImpl.listSearch(operation);
    }

    public <V> List<V> dictionaryGet(String key, String lockId, TimeSpan lockTimeout, Iterable<String> keys, Class<?> cls) {
        DictionaryGetOperation tempVar = new DictionaryGetOperation(key, lockId, lockTimeout);
        tempVar.setCollection((List)keys);
        Collection<ExtendedJsonValueBase> jsonValues = this._cacheImpl.dictionaryGet(tempVar);
        BitSet bitSet = new BitSet(32);
        ArrayList response = new ArrayList();
        for (ExtendedJsonValueBase jsonValue : jsonValues) {
            response.add(this.safeDataStructuresDeserialize(jsonValue, this._serializationContext, bitSet, UserObjectType.DistributedDataType, cls));
        }
        return response;
    }

    public <V> void dictionaryAdd(String key, Map<? extends String, ? extends V> collection, String lockId, TimeSpan lockTimeout, WriteThruOptions writeThruOptions, DictionaryAddOperation.OpType operationType) {
        HashMap<String, ExtendedJsonValueBase> data = new HashMap<String, ExtendedJsonValueBase>();
        for (Map.Entry<String, V> item : collection.entrySet()) {
            long size = -1L;
            BitSet bitSet = new BitSet(32);
            data.put(item.getKey(), (ExtendedJsonValueBase)this.safeDataStructuresSerialize(item.getValue(), this._serializationContext, bitSet, size, UserObjectType.DistributedDataType, false));
        }
        DictionaryAddOperation tempVar = new DictionaryAddOperation(key, lockId, lockTimeout);
        tempVar.setCollection(data);
        tempVar.setOperationType(operationType);
        tempVar.setWriteThruOptions(writeThruOptions);
        this._cacheImpl.dictionaryAdd(tempVar);
    }

    public <V> int dictionaryRemove(String key, Iterable<String> keys, String lockId, TimeSpan lockTimeout, WriteThruOptions writeThruOptions) {
        DictionaryRemoveOperation tempVar = new DictionaryRemoveOperation(key, lockId, lockTimeout);
        tempVar.setCollection((List)keys);
        tempVar.setWriteThruOptions(writeThruOptions);
        tempVar.setOperationType(DictionaryRemoveOperation.OpType.Remove);
        return this._cacheImpl.dictionaryRemove(tempVar);
    }

    public <V> boolean dictionaryContains(String key, String lockId, TimeSpan lockTimeout, String key1, V value, DictionaryContainsOperation.OpType operationType) {
        long size = -1L;
        BitSet bitSet = new BitSet(32);
        RefObject tempRef_bitSet = new RefObject((Object)bitSet);
        RefObject tempRef_size = new RefObject((Object)size);
        DictionaryContainsOperation tempVar = new DictionaryContainsOperation(key, lockId, lockTimeout);
        tempVar.setKey(key1);
        tempVar.setOperationType(operationType);
        tempVar.setValue((ExtendedJsonValueBase)this.safeDataStructuresSerialize(value, this._serializationContext, bitSet, size, UserObjectType.DistributedDataType, false));
        return this._cacheImpl.dictionaryContains(tempVar);
    }

    public <T> void hashSetAdd(String key, String lockId, TimeSpan lockTimeout, Iterable<T> collection, WriteThruOptions writeThruOptions) {
        HashSet<ExtendedJsonValueBase> serializedData = new HashSet<ExtendedJsonValueBase>();
        for (T item : collection) {
            BitSet bitSet = new BitSet(32);
            serializedData.add((ExtendedJsonValueBase)this.safeDataStructuresSerialize(item, this._serializationContext, bitSet, -1L, UserObjectType.DistributedDataType, false));
        }
        HashSetAddOperation tempVar = new HashSetAddOperation(key, lockId, lockTimeout);
        tempVar.setCollection(serializedData);
        tempVar.setWriteThruOptions(writeThruOptions);
        this._cacheImpl.hashSetAdd(tempVar);
    }

    public <T> int hashSetRemove(String key, String lockId, TimeSpan lockTimeout, Iterable<T> collection, WriteThruOptions writeThruOptions) {
        HashSet<ExtendedJsonValueBase> serializedData = new HashSet<ExtendedJsonValueBase>();
        for (T item : collection) {
            BitSet bitSet = new BitSet(32);
            serializedData.add((ExtendedJsonValueBase)this.safeDataStructuresSerialize(item, this._serializationContext, bitSet, -1L, UserObjectType.DistributedDataType, false));
        }
        HashSetRemoveOperation tempVar = new HashSetRemoveOperation(key, lockId, lockTimeout);
        tempVar.setCollection(serializedData);
        tempVar.setWriteThruOptions(writeThruOptions);
        return this._cacheImpl.hashSetRemove(tempVar);
    }

    public <T> T hashSetRemoveRandom(String key, String lockId, TimeSpan lockTimeout, WriteThruOptions writeThruOptions, Class<?> cls) {
        HashSetRemoveRandomOperation tempVar = new HashSetRemoveRandomOperation(key, lockId, lockTimeout);
        tempVar.setWriteThruOptions(writeThruOptions);
        List<ExtendedJsonValueBase> operationResponse = this._cacheImpl.hashSetRemoveRandom(tempVar);
        if (operationResponse.size() == 0) {
            return null;
        }
        return this.safeDataStructuresDeserialize(operationResponse.get(0), this._serializationContext, new BitSet(32), UserObjectType.DistributedDataType, cls);
    }

    public <T> boolean hashSetContains(String key, String lockId, TimeSpan lockTimeout, T value) {
        BitSet bitSet = new BitSet(32);
        HashSetContainsOperation tempVar = new HashSetContainsOperation(key, lockId, lockTimeout);
        tempVar.setItem((ExtendedJsonValueBase)this.safeDataStructuresSerialize(value, this._serializationContext, bitSet, -1L, UserObjectType.DistributedDataType, false));
        HashSetContainsOperation operation = tempVar;
        return this._cacheImpl.hashSetContains(operation);
    }

    public <T> T[] hashSetGetRandom(String key, String lockId, TimeSpan lockTimeout, int count, Class<?> cls) {
        HashSetGetRandomOperation tempVar = new HashSetGetRandomOperation(key, lockId, lockTimeout);
        tempVar.setCount(count);
        HashSetGetRandomOperation operation = tempVar;
        List<ExtendedJsonValueBase> operationResponse = this._cacheImpl.hashSetGetRandom(operation);
        Iterator serializedEnumerator = operationResponse.iterator();
        Object[] response = new Object[operationResponse.size()];
        int i = 0;
        while (serializedEnumerator.hasNext()) {
            Object item = serializedEnumerator.next();
            response[i++] = this.safeDataStructuresDeserialize(item, this._serializationContext, new BitSet(32), UserObjectType.DistributedDataType, cls);
        }
        return response;
    }

    public <T> T queueDequeue(String key, String lockId, TimeSpan lockTimeout, QueueDequeueOperation.OpType dequeueType, WriteThruOptions writeThruOptions, Class<?> cls) {
        QueueDequeueOperation operation = new QueueDequeueOperation(key, lockId, lockTimeout);
        operation.setOperationType(dequeueType);
        operation.setWriteThruOptions(writeThruOptions);
        BitSet bitSet = new BitSet(32);
        ExtendedJsonValueBase operationResponse = this._cacheImpl.queueDequeue(operation);
        return this.safeDataStructuresDeserialize(operationResponse, this._serializationContext, bitSet, UserObjectType.DistributedDataType, cls);
    }

    public <T> T queuePeek(String key, String lockId, TimeSpan lockTimeout, Class<?> cls) {
        ExtendedJsonValueBase operationResponse = this._cacheImpl.queuePeek(new QueuePeekOperation(key, lockId, lockTimeout));
        return this.safeDataStructuresDeserialize(operationResponse, this._serializationContext, new BitSet(32), UserObjectType.DistributedDataType, cls);
    }

    public boolean queueSearch(String key, String lockId, TimeSpan lockTimeout, Object o) {
        BitSet bitSet = new BitSet(32);
        QueueSearchOperation operation = new QueueSearchOperation(key, lockId, lockTimeout);
        operation.setItem((ExtendedJsonValueBase)this.safeDataStructuresSerialize(o, this._serializationContext, bitSet, -1L, UserObjectType.DistributedDataType, true));
        return this._cacheImpl.queueSearch(operation);
    }

    public <T> boolean queueEnqueue(String key, String lockId, TimeSpan lockTimeout, T t, QueueEnqueueOperation.OpType enqueueType, WriteThruOptions writeThruOptions) {
        BitSet tempRef_bitSet = new BitSet(32);
        QueueEnqueueOperation operation = new QueueEnqueueOperation(key, lockId, lockTimeout);
        ArrayList<ExtendedJsonValueBase> items = new ArrayList<ExtendedJsonValueBase>();
        items.add((ExtendedJsonValueBase)this.safeDataStructuresSerialize(t, this._serializationContext, tempRef_bitSet, -1L, UserObjectType.DistributedDataType, false));
        operation.setCollection(items);
        operation.setOperationType(enqueueType);
        operation.setWriteThruOptions(writeThruOptions);
        return this._cacheImpl.queueEnqueue(operation);
    }

    public short getCallbackId(CacheItemRemovedListener removedCallback, ListenerType listenerType) throws CacheException {
        if (removedCallback == null) {
            return -1;
        }
        return this._eventManager.registerSelectiveCallback(removedCallback, listenerType);
    }

    public short getCallbackId(CacheItemRemovedListener removedCallback) throws CacheException {
        return this.getCallbackId(removedCallback, ListenerType.PushBasedNotification);
    }

    public short getCallbackId(CacheItemUpdatedListener updateCallback) throws CacheException {
        return this.getCallbackId(updateCallback, ListenerType.PushBasedNotification);
    }

    public short getCallbackId(CacheItemUpdatedListener updateCallback, ListenerType listenerType) throws CacheException {
        if (updateCallback == null) {
            return -1;
        }
        return this._eventManager.registerSelectiveCallback(updateCallback, listenerType);
    }

    @Override
    public long getCount() throws CacheException {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        return this._cacheImpl.getCount();
    }

    FutureTask clearAsync() {
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            this.clearInternal();
            return null;
        });
        return (FutureTask)ThreadPool.getInstance().submitTask(task);
    }

    FutureTask clearClientCacheAsync() {
        return null;
    }

    @Override
    public void clearClientCache() throws CacheException {
    }

    @Override
    public void clear() throws CacheException {
        this.clearInternal();
    }

    private void clearInternal() throws CacheException {
        block5: {
            if (this._cacheImpl == null) {
                return;
            }
            try {
                String providerName = "";
                BitSet flagMap = new BitSet();
                short dsClearedCallbackId = -1;
                flagMap = this.setDSUpdateOptBit(flagMap, WriteMode.None);
                this._cacheImpl.clear(flagMap, dsClearedCallbackId, providerName);
                if (this._callbackIDsMap != null) {
                    this._callbackIDsMap.removeAllResources();
                }
                if (this._callbacksMap != null) {
                    this._callbacksMap.removeAllResources();
                }
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block5;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
    }

    @Override
    public boolean contains(String key) throws CacheException {
        this.validateKey(key);
        if (!(key.getClass() instanceof Serializable)) {
            throw new IllegalArgumentException("key is not serializable");
        }
        if (this._cacheImpl == null) {
            return false;
        }
        try {
            return this._cacheImpl.contains(key);
        }
        catch (Exception e) {
            if (this.getExceptionEnabled()) {
                throw new CacheException(e.getMessage(), e.getCause());
            }
            return false;
        }
    }

    @Override
    public Map<String, Boolean> containsBulk(Iterable<String> keys) throws CacheException {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        if (keys == null) {
            throw new IllegalArgumentException("keys is null");
        }
        String[] keysArr = this.removeDuplicateKeys(keys);
        if (keysArr.length == 0) {
            throw new IllegalArgumentException("There is no key present in keys array");
        }
        try {
            return this._cacheImpl.containsBulk(keysArr);
        }
        catch (Exception e) {
            if (this.getExceptionEnabled()) {
                throw new CacheException(e.getMessage(), e.getCause());
            }
            return null;
        }
    }

    @Override
    public void unlock(String key) throws CacheException {
        block3: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            this.validateKey(key);
            try {
                this._cacheImpl.unlock(key);
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block3;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
    }

    @Override
    public void unlock(String key, LockHandle lockHandle) throws CacheException {
        block4: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            this.validateKey(key);
            if (lockHandle == null) {
                throw new IllegalArgumentException("Value cannot be null.\r\nParameter name: LockHandle");
            }
            String lockId = lockHandle.getLockId();
            try {
                this._cacheImpl.unlock(key, lockId);
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block4;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
    }

    @Override
    public boolean lock(String key, TimeSpan lockTimeout, LockHandle lockHandle) throws CacheException {
        boolean lockAcquired;
        block5: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            this.validateKey(key);
            if (lockHandle == null) {
                throw new IllegalArgumentException("Value cannot be null.\r\nParameter name: LockHandle");
            }
            lockAcquired = false;
            try {
                lockAcquired = this._cacheImpl.lock(key, lockTimeout, lockHandle);
                if (lockHandle != null && !lockHandle.getLockDate().equals(NCDateTime.MinValue)) {
                    lockHandle.setLockDate(new NCDateTime(lockHandle.getLockDate()).getLocalizedDate());
                }
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block5;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
        return lockAcquired;
    }

    boolean isLocked(String key, LockHandle lockHandle) throws CacheException {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        this.validateKey(key);
        if (lockHandle == null) {
            throw new IllegalArgumentException("Value cannot be null.\r\nParameter name: LockHandle");
        }
        try {
            boolean result = this._cacheImpl.isLocked(key, lockHandle);
            if (lockHandle != null && !lockHandle.getLockDate().equals(NCDateTime.MinValue)) {
                lockHandle.setLockDate(new NCDateTime(lockHandle.getLockDate()).getLocalizedDate());
            }
            return result;
        }
        catch (Exception e) {
            if (this.getExceptionEnabled()) {
                throw new CacheException(e.getMessage(), e.getCause());
            }
            return false;
        }
    }

    @Override
    public <T> T getIfNewer(String key, CacheItemVersion version, Class<?> cls) throws CacheException {
        try {
            if (version == null) {
                throw new IllegalArgumentException("Value cannot be null.\r\nParameter name: version");
            }
            LockHandle lockHandle = null;
            ReadThruOptions readThruOptions = new ReadThruOptions(ReadMode.None);
            return this.getInternal(key, version, LockAccessType.COMPARE_VERSION, this.noLockExpiration, lockHandle, readThruOptions, cls);
        }
        catch (Exception e) {
            if (this.getExceptionEnabled()) {
                throw new CacheException(e.getMessage(), e.getCause());
            }
            return null;
        }
    }

    public CacheItem getIfNewerCacheItem(String key, CacheItemVersion version) throws CacheException {
        if (version == null) {
            throw new IllegalArgumentException("Value cannot be null.\r\nParameter name: version");
        }
        LockHandle lockHandle = null;
        ReadThruOptions readOptions = new ReadThruOptions(ReadMode.None);
        return this.getCacheItemInternal(key, version, LockAccessType.COMPARE_VERSION, this.noLockExpiration, lockHandle, new ReadThruOptions(ReadMode.None));
    }

    @Override
    public boolean hasMoreElements() {
        boolean hasMore;
        if (this.enumerator == null) {
            this.enumerator = new WebCacheEnumerator(this._serializationContext, null, null, this.getCacheInstanceInternal(), Object.class);
        }
        if (!(hasMore = this.enumerator.hasMoreElements())) {
            this.enumerator = null;
        }
        return hasMore;
    }

    public Object nextElement() {
        if (this.enumerator == null) {
            this.enumerator = new WebCacheEnumerator(this._serializationContext, null, null, this.getCacheInstanceInternal(), Object.class);
        }
        return this.enumerator.nextElement();
    }

    @Override
    public Iterator asJsonIterator() {
        return new WebCacheEnumerator(this._serializationContext, null, null, this.getCacheInstanceInternal(), JsonValueBase.class).asIterator();
    }

    ArrayList<EnumerationDataChunk> getNextChunk(ArrayList<EnumerationPointer> pointer) {
        ArrayList<EnumerationDataChunk> chunks;
        block5: {
            chunks = null;
            try {
                chunks = this._cacheImpl.getNextChunk(pointer);
            }
            catch (Exception ex) {
                for (int i = 0; i < pointer.size(); ++i) {
                    pointer.get(i).setDisposable(true);
                }
                try {
                    this._cacheImpl.getNextChunk(pointer);
                }
                catch (Exception exc) {
                    if (!this.getExceptionEnabled()) break block5;
                    throw new ConcurrentModificationException(ex.getMessage());
                }
            }
        }
        return chunks;
    }

    @Override
    public CacheStream getCacheStream(String key, CacheStreamAttributes cacheStreamAttributes) throws CacheException {
        Date absTime = NoAbsoluteExpiration;
        TimeSpan defaultSldTime = NoSlidingExpiration;
        if (cacheStreamAttributes == null) {
            throw new IllegalArgumentException("CacheStreamAttributes");
        }
        if (cacheStreamAttributes.getExpiration() != null) {
            absTime = ConversionUtil.getExpirationAbsoluteInternal(cacheStreamAttributes.getExpiration());
            defaultSldTime = ConversionUtil.getExpirationSlidingInternal(cacheStreamAttributes.getExpiration());
        }
        return this.getCacheStreamInternal(key, cacheStreamAttributes.getStreamMode(), cacheStreamAttributes.getGroup(), null, cacheStreamAttributes.getCacheDependency(), absTime, defaultSldTime, cacheStreamAttributes.getCacheItemPriority());
    }

    CacheStream getCacheStreamInternal(String key, StreamMode streamMode, String group, String subGroup, CacheDependency dependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority) throws CacheException {
        this.validateKey(key);
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        CacheStreamImpl stream = new CacheStreamImpl();
        stream.setCacheStream(this.createStream(key, streamMode, group, dependency, absoluteExpiration, slidingExpiration, priority));
        return stream;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CacheStream createStream(String key, StreamMode streamMode, String group, CacheDependency dependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority) throws CacheException {
        void var9_12;
        Object var9_8 = null;
        if (streamMode == StreamMode.Read) {
            String _lockHandle = this.openStream(key, StreamMode.Read, group, absoluteExpiration, slidingExpiration, dependency, priority);
            if (_lockHandle == null) {
                throw new StreamException("An error occured while opening stream");
            }
            long length = this.getStreamLength(key, _lockHandle);
            InputCacheStream inputCacheStream = new InputCacheStream(key, streamMode, this, _lockHandle, length);
            return var9_12;
        } else if (streamMode == StreamMode.ReadWithoutLock) {
            String lockHandle = this.openStream(key, StreamMode.ReadWithoutLock, group, absoluteExpiration, slidingExpiration, dependency, priority);
            if (lockHandle == null) throw new StreamNotFoundException();
            String _lockHandle = "";
            InputCacheStream inputCacheStream = new InputCacheStream(key, streamMode, this, _lockHandle, 0L);
            return var9_12;
        } else {
            String _lockHandle = this.openStream(key, StreamMode.Write, group, absoluteExpiration, slidingExpiration, dependency, priority);
            if (_lockHandle == null) {
                throw new StreamException("An error occured while opening stream");
            }
            long length = this.getStreamLength(key, _lockHandle);
            OutputCacheStream outputCacheStream = new OutputCacheStream(key, streamMode, this, _lockHandle, length);
        }
        return var9_12;
    }

    String openStream(String key, StreamMode mode, String group, Date absExpiration, TimeSpan slidingExpiration, CacheDependency dependency, CacheItemPriority priority) throws CacheException {
        try {
            return this._cacheImpl.openStream(key, mode, group, absExpiration, slidingExpiration, dependency, priority);
        }
        catch (Exception e) {
            if (this.getExceptionEnabled()) {
                throw new CacheException(e.getMessage(), e.getCause());
            }
            return null;
        }
    }

    void closeStream(String key, String lockHandle) throws CacheException {
        block2: {
            try {
                this._cacheImpl.closeStream(key, lockHandle);
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block2;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
    }

    int readFromStream(byte[] buffer, String key, String lockHandle, int offset, int streamOffset, int length) throws CacheException {
        try {
            RefObject temp_buffer = new RefObject((Object)buffer);
            return this._cacheImpl.readFromStream((RefObject<byte[]>)temp_buffer, key, lockHandle, offset, streamOffset, length);
        }
        catch (Exception e) {
            if (this.getExceptionEnabled()) {
                throw new CacheException(e.getMessage(), e.getCause());
            }
            return 0;
        }
    }

    void writeToStream(String key, String lockHandle, byte[] buffer, int srcOffset, int dstOffset, int length) throws CacheException {
        block2: {
            try {
                this._cacheImpl.writeToStream(key, lockHandle, buffer, srcOffset, dstOffset, length);
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block2;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
    }

    long getStreamLength(String key, String lockHandle) throws CacheException {
        try {
            return this._cacheImpl.getStreamLength(key, lockHandle);
        }
        catch (Exception e) {
            if (this.getExceptionEnabled()) {
                throw new CacheException(e.getMessage(), e.getCause());
            }
            return 0L;
        }
    }

    public String toString() {
        return this._cacheId;
    }

    void removeByTag(Tag[] tags, TagComparisonType tagCompareType) throws CacheException {
        block3: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            try {
                this._cacheImpl.removeByTag(tags, tagCompareType);
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block3;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
    }

    Collection<String> getKeysByTag(Tag[] tags, TagComparisonType tagCompareType) throws CacheException {
        ArrayList<String> keyList;
        block4: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            keyList = new ArrayList<String>();
            try {
                Collection col = this._cacheImpl.getKeysByTag(tags, tagCompareType);
                for (Object item : col) {
                    keyList.add((String)item);
                }
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block4;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
        return keyList;
    }

    int executeNonQuery(String query, Map values) throws CacheException {
        int effectedKeys;
        block3: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            effectedKeys = 0;
            try {
                effectedKeys = this._cacheImpl.executeNonQuery(query, (HashMap)values);
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block3;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
        return effectedKeys;
    }

    CacheReader executeReaderCQ(ContinuousQuery query, boolean getData, int chunkSize) throws CacheException {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)query.getQueryInternal())) {
            throw new IllegalArgumentException("query cannot be null.");
        }
        if (!(query.notifyAddInternal() || query.notifyUpdateInternal() || query.notifyRemoveInternal())) {
            throw new IllegalArgumentException("There is no event registered for this query. Please register at least one event (add/update/remove) before activating continuous query.");
        }
        try {
            this._cqManager.register(query, this);
            return new CacheDataReader(this, (RecordSetEnumerator)this._cacheImpl.executeReaderCQ(query, getData, chunkSize, query.getClientUniqueIDInternal(), query.notifyAddInternal(), query.notifyUpdateInternal(), query.notifyRemoveInternal()));
        }
        catch (Exception e) {
            throw new CacheException(e.getMessage(), e.getCause());
        }
    }

    CacheReader executeReader(String query, Map values, boolean getData, int chunkSize) throws CacheException {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        DataReaderCommon reader = null;
        try {
            boolean isClientReader = false;
            String value = System.getProperty("UseClientSideReader");
            if (!DotNetToJavaStringHelper.isNullOrEmpty((String)value)) {
                isClientReader = Boolean.parseBoolean(value);
            }
            if (isClientReader) {
                boolean bl = isClientReader = !query.toLowerCase().contains("group by") && !query.toLowerCase().contains("order by");
            }
            if (isClientReader) {
                ClientRecordSetEnumeratorImpl clientRecordSet = null;
                QueryResultSet resultSet = this._cacheImpl.search(query, (HashMap)values);
                switch (resultSet.getType()) {
                    case AggregateFunction: {
                        ArrayList resultAggregate = new ArrayList();
                        if (resultSet.getAggregateFunctionResult().getValue() != null) {
                            if (resultSet.getAggregateFunctionResult().getKey().toString().toUpperCase().equals(AggregateFunctionType.AVG.toString().toUpperCase())) {
                                resultSet.setAggregateFunctionResult(new DictionaryEntry<String, BigDecimal>("AVG", ((AverageResult)resultSet.getAggregateFunctionResult().getValue()).getAverage()));
                            }
                            resultAggregate.add(resultSet.getAggregateFunctionResult().getValue());
                        }
                        clientRecordSet = new ClientRecordSetEnumeratorImpl(resultAggregate, this, false);
                        break;
                    }
                    case SearchKeys: {
                        clientRecordSet = new ClientRecordSetEnumeratorImpl(resultSet.getSearchKeysResult(), this, getData);
                    }
                }
                reader = new ClientDataReader(this, clientRecordSet);
            } else {
                reader = new CacheDataReader(this, this._cacheImpl.executeReader(query, values, getData, chunkSize));
            }
        }
        catch (Exception e) {
            throw new CacheException(e.getMessage(), e.getCause());
        }
        return reader;
    }

    protected CacheEventDescriptor addCacheDataModificationListener(String key, CacheDataModificationListener listener, EventType eventType, EventDataFilter dataFilter, boolean notifyOnItemExpiration) throws CacheException {
        CacheEventDescriptor discriptor;
        block5: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException("Cache is not initialized");
            }
            discriptor = null;
            try {
                if (key != null) {
                    short[] callbackRefs = this._eventManager.registerSelectiveEvent(listener, EnumSet.of(eventType), dataFilter);
                    this._cacheImpl.registerKeyNotificationListener(key, callbackRefs[0], callbackRefs[1], dataFilter, notifyOnItemExpiration);
                } else {
                    discriptor = this._eventManager.registerGeneralEvents(listener, EnumSet.of(eventType), dataFilter);
                }
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block5;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
        return discriptor;
    }

    public void addCacheDataModificationListener(String key, CacheDataModificationListener listener, EventType eventType) throws CacheException {
        this.addCacheDataModificationListener(key, listener, eventType, EventDataFilter.None);
    }

    public void addCacheDataModificationListener(String key, CacheDataModificationListener listener, EventType eventType, EventDataFilter dataFilter) throws CacheException {
        this.validateKey(key);
        if (listener == null) {
            throw new IllegalArgumentException("selectiveCacheDataNotificationCallback");
        }
        if (eventType == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: eventType");
        }
        this.addCacheDataModificationListener(key, listener, eventType, dataFilter, true);
    }

    public void addCacheDataNotificationListener(String[] keys, CacheDataModificationListener listener, EnumSet<EventType> eventTypes, EventDataFilter datafilter, boolean notifyOnItemExpiration) throws CacheException {
        this.addCacheDataNotificationListener(keys, listener, eventTypes, datafilter, notifyOnItemExpiration, ListenerType.PushBasedNotification);
    }

    public void addCacheDataNotificationListener(String[] keys, CacheDataModificationListener listener, EnumSet<EventType> eventTypes, EventDataFilter datafilter, boolean notifyOnItemExpiration, ListenerType listenerType) throws CacheException {
        block4: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            try {
                if (keys != null) {
                    short[] callbackRefs = this._eventManager.registerSelectiveEvent(listener, eventTypes, datafilter, listenerType);
                    this._cacheImpl.registerKeyNotificationListener(keys, callbackRefs[0], callbackRefs[1], datafilter, notifyOnItemExpiration, listenerType);
                }
            }
            catch (RuntimeException ex) {
                if (!this.getExceptionEnabled()) break block4;
                throw new CacheException(ex.getMessage(), ex.getCause());
            }
        }
    }

    public void removeCacheNotification(CacheEventDescriptor discriptor) throws Exception {
        if (this._cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        if (discriptor == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: discriptor");
        }
        if (!discriptor.getIsRegistered()) {
            return;
        }
        this._eventManager.unRegisterDiscriptor(discriptor);
    }

    public void removeCacheNotification(String key, CacheDataModificationListener callback, EnumSet<EventType> eventTypes) throws CacheException {
        block3: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            try {
                short[] value = this._eventManager.unRegisterSelectiveNotification(callback, eventTypes);
                short update = value[0];
                short remove = value[1];
                this._cacheImpl.unRegisterKeyNotificationListener(key, update, remove);
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block3;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
    }

    public void removeCacheNotification(String[] key, CacheDataModificationListener listener, EnumSet<EventType> eventTypes) throws CacheException {
        block3: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            try {
                short[] value = this._eventManager.unRegisterSelectiveNotification(listener, eventTypes);
                short update = value[0];
                short remove = value[1];
                this._cacheImpl.unRegisterKeyNotificationListener(key, update, remove);
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block3;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
    }

    public void addCacheNotification(String key, CacheDataModificationListener cacheDataModificationListener, EnumSet<EventType> eventTypes, EventDataFilter datafilter, ListenerType listenerType) throws CacheException {
        this.validateKey(key);
        if (cacheDataModificationListener == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: selectiveCacheDataNotificationlistener");
        }
        this.registerCacheNotificationInternal(key, cacheDataModificationListener, eventTypes, datafilter, true, listenerType);
    }

    public void removeGeneralCacheNotification(EventTypeInternal eventType) throws CacheException {
        if (this._cacheImpl != null) {
            this._cacheImpl.unRegisterGeneralNotificationListener(eventType, (short)-1);
        }
    }

    public void addCacheNotificationDataFilter(EventTypeInternal eventType, EventDataFilter datafilter, short eventSequenceId) throws CacheException {
        if (this._cacheImpl != null) {
            this._cacheImpl.registerGeneralNotification(eventType, datafilter, eventSequenceId);
        }
    }

    public void registerSurrogateKeyNotificationCallback(String[] keys, short update, short remove, String clientId, ListenerType listenerType) throws CacheException {
        block4: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            try {
                if (keys != null) {
                    this._cacheImpl.registerKeyNotificationListener(keys, update, remove, clientId, listenerType);
                }
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block4;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
    }

    public void raiseCustomEvent(Object notifId, Object data) throws CacheException {
        block2: {
            Object flag = null;
            long size = 0L;
            this.validateKeyValue((String)notifId, data);
            try {
                byte[] serializeNotifId = CompactBinaryFormatter.toByteBuffer((Object)notifId, (String)this._serializationContext);
                byte[] serializeData = CompactBinaryFormatter.toByteBuffer((Object)data, (String)this._serializationContext);
                this._cacheImpl.raiseCustomEvent(serializeNotifId, serializeData);
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block2;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
    }

    public void registerKeyNotificationCallback(String key, CacheItemUpdatedListener updateCallback, CacheItemRemovedListener removeCallback, boolean notifyOnItemExpiration, ListenerType listenerType) throws CacheException {
        block6: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            this.validateKey(key);
            if (updateCallback == null && removeCallback == null) {
                throw new IllegalArgumentException();
            }
            try {
                short updateCallbackid = -1;
                short removeCallbackid = -1;
                if (updateCallback != null) {
                    updateCallbackid = this.getCallbackId(updateCallback, listenerType);
                }
                if (removeCallback != null) {
                    removeCallbackid = this.getCallbackId(removeCallback, listenerType);
                }
                this._cacheImpl.registerKeyNotificationListener(key, updateCallbackid, removeCallbackid, EventDataFilter.None, notifyOnItemExpiration, listenerType);
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block6;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
    }

    public short registerUpdateSorrogateCallback(CacheItemUpdatedListener onUpdateCallback, CacheDataModificationListener cacheItemUpdatedCallback, EventDataFilter eventDataFilter) {
        short updateCallbackId = -1;
        try {
            if (cacheItemUpdatedCallback != null) {
                short[] callabackIds = this._eventManager.registerSelectiveEvent(cacheItemUpdatedCallback, EnumSet.of(EventType.ItemUpdated), eventDataFilter);
                updateCallbackId = callabackIds[0];
            } else if (onUpdateCallback != null) {
                updateCallbackId = this.getCallbackId(onUpdateCallback);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return updateCallbackId;
    }

    public short registerRemoveSorrogateCallback(CacheItemRemovedListener onRemovedCallback, CacheDataModificationListener cacheItemRemovedCallback, EventDataFilter eventDataFilter) {
        short removeCallbackId = -1;
        try {
            if (cacheItemRemovedCallback != null) {
                short[] callabackIds = this._eventManager.registerSelectiveEvent(cacheItemRemovedCallback, EnumSet.of(EventType.ItemRemoved), eventDataFilter);
                removeCallbackId = callabackIds[1];
            } else if (onRemovedCallback != null) {
                removeCallbackId = this.getCallbackId(onRemovedCallback);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return removeCallbackId;
    }

    public void registerKeyNotificationCallback(String key, CacheItemUpdatedListener updateCallback, CacheItemRemovedListener removeCallback, boolean notifyOnItemExpiration) throws CacheException {
        block6: {
            if (this._cacheImpl == null) {
                throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
            }
            this.validateKey(key);
            if (updateCallback == null && removeCallback == null) {
                throw new IllegalArgumentException();
            }
            try {
                short updateCallbackid = -1;
                short removeCallbackid = -1;
                if (updateCallback != null) {
                    updateCallbackid = this.getCallbackId(updateCallback);
                }
                if (removeCallback != null) {
                    removeCallbackid = this.getCallbackId(removeCallback);
                }
                this._cacheImpl.registerKeyNotificationListener(key, updateCallbackid, removeCallbackid, notifyOnItemExpiration);
            }
            catch (Exception e) {
                if (!this.getExceptionEnabled()) break block6;
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
    }

    protected void registerPollingNotification(PollNotificationListener listener, EventTypeInternal eventType) {
        if (listener != null) {
            short s = this.getEventManager().registerPollingEvent(listener, eventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void touch(ArrayList<String> keys) throws OperationFailedException, StreamNotFoundException, StreamException, SecurityException, CommandException, OperationNotSupportedException, AggregateException, StreamAlreadyLockedException, ConfigurationException, LicensingException, GeneralFailureException {
        if (this.getCacheImpl() == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        if (keys == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: keys");
        }
        HashMap<String, Object> newKeys = new HashMap<String, Object>();
        for (int i = 0; i < keys.size(); ++i) {
            if (DotNetToJavaStringHelper.isNullOrEmpty((String)keys.get(i))) continue;
            newKeys.put(keys.get(i), null);
        }
        try {
            this.getCacheImpl().touch(keys);
        }
        catch (CacheException e) {
            if (this._exceptionEnabled) {
                throw e;
            }
        }
    }

    private NamedTagsDictionary extractDynamicQueryIndexingInfo(Object value, NamedTagsDictionary namedTags) throws OperationFailedException {
        String className = value.getClass().getCanonicalName();
        IndexableQueryData indexableQueryData = this._indexableValues.getOrDefault(className, null);
        if (indexableQueryData == null && !this._nonIndexableValues.containsKey(className)) {
            Field[] properties = this.getAnnotatedPropertyInfos(value);
            if (properties != null) {
                indexableQueryData = this.getIndexedPropertiesInfo(properties);
                if (!this._indexableValues.containsKey(className)) {
                    this._indexableValues.put(className, indexableQueryData);
                }
            } else {
                this._nonIndexableValues.put(className, value);
            }
        }
        namedTags = this.addPropertiesToNamedTagDictionary(indexableQueryData, namedTags, value);
        return namedTags;
    }

    private NamedTagsDictionary addPropertiesToNamedTagDictionary(IndexableQueryData queryData, NamedTagsDictionary namedTags, Object value) throws OperationFailedException {
        HashMap<String, Field> indexedInfo = queryData.get_indexInfo();
        if (namedTags == null && indexedInfo.size() != 0) {
            namedTags = new NamedTagsDictionary();
        }
        Set<String> indexedInfoKeys = indexedInfo.keySet();
        try {
            for (String key : indexedInfoKeys) {
                String prefixedKey = "$StaticNamedTagAttribute$" + key;
                Object fieldInfo = indexedInfo.get(key).get(value);
                Class<?> valueType = indexedInfo.get(key).getType();
                if (namedTags.contains(key)) continue;
                if (valueType.equals(Integer.TYPE)) {
                    namedTags.add(key, ((Integer)fieldInfo).intValue());
                }
                if (valueType.equals(Float.TYPE)) {
                    namedTags.add(key, ((Float)fieldInfo).floatValue());
                }
                if (valueType.equals(Double.TYPE)) {
                    namedTags.add(key, ((Double)fieldInfo).doubleValue());
                }
                if (valueType.equals(Long.TYPE)) {
                    namedTags.add(key, ((Long)fieldInfo).longValue());
                }
                if (valueType.equals(Short.TYPE)) {
                    namedTags.add(key, (int)((Short)fieldInfo).shortValue());
                }
                if (valueType.equals(Byte.TYPE)) {
                    namedTags.add(key, (int)((Byte)fieldInfo).byteValue());
                }
                if (valueType.equals(Boolean.TYPE)) {
                    namedTags.add(key, ((Boolean)fieldInfo).booleanValue());
                }
                if (valueType.equals(Character.TYPE)) {
                    namedTags.add(key, ((Character)fieldInfo).charValue());
                }
                if (valueType.equals(String.class)) {
                    namedTags.add(key, (String)fieldInfo);
                }
                if (!valueType.equals(Date.class)) continue;
                namedTags.add(key, (Date)fieldInfo);
            }
        }
        catch (IllegalAccessException e) {
            throw new OperationFailedException("The field to be stored is static.");
        }
        return namedTags;
    }

    private IndexableQueryData getIndexedPropertiesInfo(Field[] fields) throws OperationFailedException {
        IndexableQueryData queryData = new IndexableQueryData();
        for (Field property : fields) {
            String propertyName;
            String attributeAnnotation = this.extractPropertyAttribute(property);
            String string = propertyName = attributeAnnotation == null || attributeAnnotation.isEmpty() ? property.getName() : attributeAnnotation;
            if (queryData.get_indexInfo().containsKey(propertyName)) {
                throw new OperationFailedException("A query index with name '" + propertyName + "' is already defined on type '" + property.getDeclaringClass().getCanonicalName() + "'.");
            }
            queryData.get_indexInfo().put(propertyName, property);
        }
        return queryData;
    }

    private Field[] getAnnotatedPropertyInfos(Object value) throws OperationFailedException {
        Field[] fields = null;
        boolean isClassIndexable = value.getClass().getAnnotation(QueryIndexable.class) != null;
        Field[] indexedRefTypeArray = (Field[])Arrays.stream(value.getClass().getDeclaredFields()).map(field -> {
            field.setAccessible(true);
            return field;
        }).filter(field -> !this.isPrimitiveType(field.getType()) && field.getAnnotation(QueryIndexed.class) != null).toArray(Field[]::new);
        if (indexedRefTypeArray.length > 0) {
            throw new OperationFailedException(String.format("Indexes are only supported on value types. %s is a reference type", indexedRefTypeArray[0].getType().toString()));
        }
        if (isClassIndexable) {
            fields = (Field[])Arrays.stream(value.getClass().getFields()).filter(field -> this.isPrimitiveType(field.getType())).toArray(Field[]::new);
        }
        Field[] selectedFields = (Field[])Arrays.stream(value.getClass().getDeclaredFields()).filter(field -> {
            int modifier = field.getModifiers();
            return !isClassIndexable || !Modifier.isPublic(modifier);
        }).map(field -> {
            field.setAccessible(true);
            return field;
        }).filter(field -> this.isPrimitiveType(field.getType())).filter(field -> field.isAnnotationPresent(QueryIndexed.class)).filter(field -> !field.isAnnotationPresent(NonQueryIndexed.class)).toArray(Field[]::new);
        int lenAllFields = fields == null ? 0 : fields.length;
        int lenSelectiveFields = selectedFields.length;
        ArrayList fieldList = new ArrayList(lenAllFields + lenSelectiveFields);
        if (fields != null) {
            Collections.addAll(fieldList, fields);
        }
        Collections.addAll(fieldList, selectedFields);
        fields = (Field[])Array.newInstance(Field.class, 0);
        fields = fieldList.toArray(fields);
        return fields;
    }

    private boolean isPrimitiveType(Class type) {
        return type.isPrimitive() || type.equals(String.class) || type.equals(Date.class);
    }

    private String extractPropertyAttribute(Field prop) {
        if (prop.isAnnotationPresent(QueryIndexed.class)) {
            QueryIndexed annotation = prop.getAnnotation(QueryIndexed.class);
            return annotation.value();
        }
        return null;
    }

    class GeneralDataNotificationWrapper {
        private Cache _parentCache;

        public GeneralDataNotificationWrapper(Cache parentCache) {
            this._parentCache = parentCache;
        }
    }

    class DeleteAsyncCallable
    implements Callable {
        String _key;
        WriteThruOptions _writeThru = null;

        DeleteAsyncCallable(String key, WriteThruOptions writeThruOptions) {
            this._key = key;
            this._writeThru = writeThruOptions;
        }

        public Void call() throws CacheException {
            CacheImpl.this.delete(this._key, this._writeThru);
            return null;
        }
    }

    class RemoveAsyncCallable<T>
    implements Callable<T> {
        String _key;
        WriteThruOptions _writeThru;
        Class<?> _class;

        RemoveAsyncCallable(String key, WriteThruOptions writeThru, Class<?> cls) {
            this._key = key;
            this._writeThru = writeThru;
            this._class = cls;
        }

        @Override
        public T call() throws CacheException {
            return CacheImpl.this.remove(this._key, this._writeThru, this._class);
        }
    }

    class InsertAsyncCallable
    implements Callable<CacheItemVersion> {
        String _key;
        CacheItem _item;
        WriteThruOptions _writeThruOptions;
        private CacheItemVersion waitTime;

        InsertAsyncCallable(String key, CacheItem item, WriteThruOptions writeThruOptions, LockHandle lockhandle, boolean releaseLock) {
            this._key = key;
            this._item = item;
            this._writeThruOptions = writeThruOptions;
        }

        @Override
        public CacheItemVersion call() throws CacheException, IllegalArgumentException {
            return CacheImpl.this.InsertInternal(this._key, this._item, this._writeThruOptions, null, false);
        }
    }

    class AddAsyncCallable
    implements Callable<CacheItemVersion> {
        String _key;
        CacheItem _item;
        WriteThruOptions _writeThruOptions;
        private CacheItemVersion waitTime;

        AddAsyncCallable(String key, CacheItem item, WriteThruOptions writeThruOptions) {
            this._key = key;
            this._item = item;
            this._writeThruOptions = writeThruOptions;
        }

        @Override
        public CacheItemVersion call() throws CacheException, IllegalArgumentException {
            return CacheImpl.this.AddInternal(this._key, this._item, this._writeThruOptions);
        }
    }
}

