/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client;

import Alachisoft.NCache.Common.Net.DnsCache;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ServerInfo
implements Comparable {
    private int _port = 9800;
    private String _name = null;
    private InetAddress _ipAddress;
    private short _portRange = 1;
    private short _priority = 0;
    private boolean _userProvided;

    public ServerInfo(String name) {
        this(name, 9800);
    }

    public ServerInfo(String name, int port) {
        this.setName(name);
        this._port = port;
    }

    public ServerInfo(InetAddress ip) {
        this(ip, 9800);
    }

    public ServerInfo(InetAddress ip, int port) {
        this.setIP(ip);
        this._port = port;
    }

    public ServerInfo() {
    }

    public final int getPort() {
        return this._port;
    }

    public final void setPort(int value) {
        this._port = value;
    }

    public final String getName() {
        if (this._name != null) {
            return this._name;
        }
        if (this._ipAddress != null) {
            return this._ipAddress.getHostAddress();
        }
        return "";
    }

    public final void setName(String value) {
        if (value.isEmpty()) {
            return;
        }
        if (value != null && value.toLowerCase().equals("localhost")) {
            try {
                this._name = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {}
        } else {
            this._name = value;
        }
    }

    public final InetAddress getIP() {
        if (this._ipAddress == null) {
            try {
                if (this._name != null) {
                    try {
                        this._ipAddress = InetAddress.getByName(this._name);
                        return this._ipAddress;
                    }
                    catch (UnknownHostException e) {
                        this._ipAddress = DnsCache.ResolveName((String)this._name);
                        this._ipAddress = DnsCache.ResolveName((String)this._name);
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this._ipAddress;
    }

    public final void setIP(InetAddress value) {
        this._ipAddress = value;
    }

    public final void setIP(String value) {
        try {
            this._ipAddress = InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public final short getPortRangeInternal() {
        return this._portRange;
    }

    public final void setPortRangeInternal(short value) {
        if (this._portRange > 0) {
            this._portRange = value;
        }
    }

    private final short getPriorityInternal() {
        return this._priority;
    }

    public final void setPriorityInternal(short value) {
        if (value > 0) {
            this._priority = value;
        }
    }

    public final boolean getIsUserProvidedInternal() {
        return this._userProvided;
    }

    public final void setIsUserProvidedInternal(boolean value) {
        this._userProvided = value;
    }

    public final String getIpStringInternal() {
        if (this._ipAddress == null) {
            return "";
        }
        return this._ipAddress.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.compareReal(obj) == 0;
    }

    public String toString() {
        String ip = "";
        ip = this._ipAddress != null ? this._ipAddress.toString() : this._name;
        return ip + ":" + this._port;
    }

    public final int compareReal(Object o) {
        ServerInfo other;
        int h1 = 0;
        int h2 = 0;
        if (o == null) {
            return 1;
        }
        ServerInfo serverInfo = other = o instanceof ServerInfo ? (ServerInfo)o : null;
        if (other == null) {
            return 1;
        }
        if (this._ipAddress != null) {
            int rc;
            h1 = this._ipAddress.hashCode();
            if (other._ipAddress != null) {
                h2 = other._ipAddress.hashCode();
            }
            int n = h1 < h2 ? -1 : (rc = h1 > h2 ? 1 : 0);
            return rc != 0 ? rc : (this._port < other.getPort() ? -1 : (this._port > other.getPort() ? 1 : 0));
        }
        if (this._name != null) {
            try {
                int rc;
                InetAddress nameAddress = InetAddress.getByName(this._name);
                h1 = nameAddress.hashCode();
                if (other._name != null) {
                    InetAddress otherAddress = InetAddress.getByName(other._name);
                    h2 = otherAddress.hashCode();
                }
                int n = h1 < h2 ? -1 : (rc = h1 > h2 ? 1 : 0);
                return rc != 0 ? rc : (this._port < other.getPort() ? -1 : (this._port > other.getPort() ? 1 : 0));
            }
            catch (UnknownHostException e) {
                return -1;
            }
        }
        return this._port < other.getPort() ? -1 : (this._port > other.getPort() ? 1 : 0);
    }

    public final int compareTo(Object obj) {
        int result = 0;
        if (obj != null && obj instanceof ServerInfo) {
            ServerInfo other = (ServerInfo)obj;
            if (other.getPriorityInternal() > this._priority) {
                result = -1;
            } else if (other.getPriorityInternal() < this._priority) {
                result = 1;
            }
        }
        return result;
    }
}

