/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.ResourcePool;
import Alachisoft.NCache.Common.Threading.ThreadPool;
import com.alachisoft.ncache.client.CQEventArg;
import com.alachisoft.ncache.client.CacheEventDescriptor;
import com.alachisoft.ncache.client.EventCacheItem;
import com.alachisoft.ncache.client.QueryCommand;
import com.alachisoft.ncache.client.QueryDataModificationListener;
import com.alachisoft.ncache.client.internal.caching.EventTypeInternal;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;

public class ContinuousQuery {
    public short CQREFSTARTAdd = (short)2000;
    public short CQREFSTARTRemove = (short)3000;
    public short CQREFSTARTUpdate = (short)4000;
    String query;
    HashMap values;
    String serverUniqueId;
    String clientUniqueId;
    private QueryCommand _command;
    private QueryDataModificationListener queryNotificationCallback;
    private Object syncLock = new Object();
    private CacheEventDescriptor _descriptor;
    private int refadd = 0;
    private ResourcePool _cqAddEventPool = null;
    private ResourcePool _cqAddEventDataFilter = null;
    private short _cqAddCallbackRef = this.CQREFSTARTAdd;
    private EventDataFilter _cqAddDF = EventDataFilter.None;
    private int refremove = 0;
    private ResourcePool _cqRemoveEventPool = null;
    private ResourcePool _cqRemoveEventDataFilter = null;
    private short _cqRemoveCallbackRef = this.CQREFSTARTRemove;
    private EventDataFilter _cqRemoveDF = EventDataFilter.None;
    private int refupdate = 0;
    private ResourcePool _cqUpdateEventPool = null;
    private ResourcePool _cqUpdateEventDataFilter = null;
    private short _cqUpdateCallbackRef = this.CQREFSTARTUpdate;
    private EventDataFilter _cqUpdateDF = EventDataFilter.None;

    public ContinuousQuery(QueryCommand command) {
        this._command = command;
        this.query = command.getQuery();
        this.values = command.getParameters();
        this.clientUniqueId = UUID.randomUUID().toString();
    }

    public QueryCommand getQueryCommand() {
        return this._command;
    }

    public void setQueryCommand(QueryCommand value) {
        this._command = value;
    }

    public String getQueryInternal() {
        return this.query;
    }

    private void setQuery(String query) {
        this.query = query;
    }

    public HashMap getValuesInternal() {
        return this.values;
    }

    private void setValues(HashMap values) {
        this.values = values;
    }

    public String getServerUniqueIDInternal() {
        return this.serverUniqueId;
    }

    public void setServerUniqueIDInternal(String serverUniqueId) throws OperationFailedException {
        if (serverUniqueId == null) {
            throw new OperationFailedException("serverUniqueId is null");
        }
        this.serverUniqueId = serverUniqueId;
    }

    public String getClientUniqueIDInternal() {
        return this.clientUniqueId;
    }

    public EventDataFilter maxFilterInternal(EventType eventype) {
        switch (eventype) {
            case ItemAdded: {
                return this._cqAddDF;
            }
            case ItemRemoved: {
                return this._cqRemoveDF;
            }
            case ItemUpdated: {
                return this._cqUpdateDF;
            }
        }
        return EventDataFilter.None;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCQ(QueryDataModificationListener listener, EnumSet<EventType> eventEnumSet, EventDataFilter datafilter) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: listener");
        }
        for (EventType type : EventType.values()) {
            Object object = this.syncLock;
            synchronized (object) {
                ResourcePool pool = null;
                ResourcePool poolDF = null;
                if (type.equals((Object)EventType.ItemAdded) && eventEnumSet.contains(EventType.ItemAdded)) {
                    pool = this._cqAddEventPool;
                    poolDF = this._cqAddEventDataFilter;
                } else if (type.equals((Object)EventType.ItemRemoved) && eventEnumSet.contains(EventType.ItemRemoved)) {
                    pool = this._cqRemoveEventPool;
                    poolDF = this._cqRemoveEventDataFilter;
                } else if (type.equals((Object)EventType.ItemUpdated) && eventEnumSet.contains(EventType.ItemUpdated)) {
                    pool = this._cqUpdateEventPool;
                    poolDF = this._cqUpdateEventDataFilter;
                }
                if (pool == null) {
                    continue;
                }
                while (true) {
                    if (pool.GetResource((Object)listener) == null) {
                        short refcallback = -1;
                        if (type == EventType.ItemAdded) {
                            this._cqAddCallbackRef = (short)(this._cqAddCallbackRef + 1);
                            refcallback = this._cqAddCallbackRef;
                            this._cqAddDF = this._cqAddDF.getValue() < datafilter.getValue() ? datafilter : this._cqAddDF;
                        } else if (type == EventType.ItemRemoved) {
                            this._cqRemoveCallbackRef = (short)(this._cqRemoveCallbackRef + 1);
                            refcallback = this._cqRemoveCallbackRef;
                            this._cqRemoveDF = this._cqRemoveDF.getValue() < datafilter.getValue() ? datafilter : this._cqRemoveDF;
                        } else {
                            this._cqUpdateCallbackRef = (short)(this._cqUpdateCallbackRef + 1);
                            refcallback = this._cqUpdateCallbackRef;
                            this._cqUpdateDF = this._cqUpdateDF.getValue() < datafilter.getValue() ? datafilter : this._cqUpdateDF;
                        }
                        pool.AddResource((Object)listener, (Object)refcallback);
                        poolDF.AddResource((Object)refcallback, (Object)datafilter);
                        break;
                    }
                    try {
                        short cref;
                        Object value = pool.GetResource((Object)listener);
                        short s = cref = value != null ? (short)Short.parseShort(value.toString()) : (short)-100;
                        if (cref < 0) break;
                        poolDF.RemoveResource((Object)cref);
                        pool.RemoveResource((Object)listener);
                        pool.AddResource((Object)listener, (Object)cref);
                        poolDF.AddResource((Object)cref, (Object)datafilter);
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    public void fireCQEventsInternal(final String key, EventTypeInternal eventType, EventCacheItem item, EventCacheItem oldItem, boolean notifyAsync, String cacheName, BitSet flag, EventDataFilter datafilter) {
        try {
            CQEventArg arg = null;
            int collectionCount = 0;
            Iterator collection = null;
            ResourcePool pool = null;
            ResourcePool filterPool = null;
            Set keySet = null;
            if (eventType == EventTypeInternal.ItemAdded && this._cqAddEventPool != null) {
                pool = this._cqAddEventPool;
                keySet = (Set)this._cqAddEventPool.getKeys();
                if (keySet != null && keySet.size() > 0) {
                    collection = keySet.iterator();
                    collectionCount = keySet.size();
                    filterPool = this._cqAddEventDataFilter;
                }
            } else if (eventType == EventTypeInternal.ItemUpdated && this._cqUpdateEventPool != null) {
                pool = this._cqUpdateEventPool;
                keySet = (Set)this._cqUpdateEventPool.getKeys();
                if (keySet != null && keySet.size() > 0) {
                    collection = keySet.iterator();
                    collectionCount = keySet.size();
                    filterPool = this._cqUpdateEventDataFilter;
                }
            } else if (eventType == EventTypeInternal.ItemRemoved && this._cqRemoveEventPool != null) {
                pool = this._cqRemoveEventPool;
                keySet = (Set)this._cqRemoveEventPool.getKeys();
                if (keySet != null && keySet.size() > 0) {
                    collection = keySet.iterator();
                    collectionCount = this._cqRemoveEventPool.getKeys().size();
                    filterPool = this._cqRemoveEventDataFilter;
                }
            } else {
                return;
            }
            if (collection != null && collectionCount > 0) {
                for (final QueryDataModificationListener listener : keySet) {
                    short index = -1;
                    Object obj = pool.GetResource((Object)listener);
                    if (obj != null) {
                        index = Short.parseShort(obj.toString());
                    }
                    if (index <= -1) continue;
                    EventDataFilter queryDataFilter = (EventDataFilter)filterPool.GetResource((Object)index);
                    if (eventType == EventTypeInternal.ItemAdded) {
                        arg = this.createCQEventArgument(queryDataFilter, key, cacheName, EventType.ItemAdded, item, oldItem);
                    } else if (eventType == EventTypeInternal.ItemRemoved) {
                        arg = this.createCQEventArgument(queryDataFilter, key, cacheName, EventType.ItemRemoved, item, oldItem);
                    } else if (eventType == EventTypeInternal.ItemUpdated) {
                        arg = this.createCQEventArgument(queryDataFilter, key, cacheName, EventType.ItemUpdated, item, oldItem);
                    } else {
                        return;
                    }
                    arg.setContinuousQuery(this);
                    final CQEventArg finalArg = arg;
                    if (notifyAsync) {
                        Runnable runable = new Runnable(){

                            @Override
                            public void run() {
                                listener.onQueryDataModified(key, finalArg);
                            }
                        };
                        ThreadPool.getInstance().executeTask(runable);
                        continue;
                    }
                    listener.onQueryDataModified(key, arg);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private CQEventArg createCQEventArgument(EventDataFilter dataFilter, String key, String cacheName, EventType eventType, EventCacheItem item, EventCacheItem oldItem) {
        Object temp;
        EventCacheItem cloneItem = null;
        EventCacheItem cloneOldItem = null;
        if (dataFilter != EventDataFilter.None && item != null) {
            temp = item.clone();
            EventCacheItem eventCacheItem = cloneItem = temp instanceof EventCacheItem ? (EventCacheItem)temp : null;
            if (cloneItem != null && dataFilter == EventDataFilter.Metadata) {
                cloneItem.setValue(null);
            }
        }
        if (oldItem != null && dataFilter != EventDataFilter.None) {
            temp = oldItem.clone();
            EventCacheItem eventCacheItem = cloneOldItem = temp instanceof EventCacheItem ? (EventCacheItem)temp : null;
            if (dataFilter == EventDataFilter.Metadata && cloneOldItem != null) {
                cloneOldItem.setValue(null);
            }
        }
        CQEventArg eventArg = new CQEventArg(cacheName, eventType, cloneItem, null);
        if (eventType == EventType.ItemUpdated) {
            eventArg.setOldItem(cloneOldItem);
        }
        return eventArg;
    }

    public void addDataModificationListener(QueryDataModificationListener listener, EnumSet<EventType> eventEnumSet, EventDataFilter datafilter) throws IllegalArgumentException {
        if (listener != null) {
            if (this._cqAddEventPool == null && eventEnumSet.contains(EventType.ItemAdded)) {
                this._cqAddEventPool = new ResourcePool();
                this._cqAddEventDataFilter = new ResourcePool();
            }
            if (this._cqRemoveEventPool == null && eventEnumSet.contains(EventType.ItemRemoved)) {
                this._cqRemoveEventPool = new ResourcePool();
                this._cqRemoveEventDataFilter = new ResourcePool();
            }
            if (this._cqUpdateEventPool == null && eventEnumSet.contains(EventType.ItemUpdated)) {
                this._cqUpdateEventPool = new ResourcePool();
                this._cqUpdateEventDataFilter = new ResourcePool();
            }
            this.registerCQ(listener, eventEnumSet, datafilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataModificationListener(QueryDataModificationListener listener, EnumSet<EventType> eventEnumSet) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("callback");
        }
        Integer id = -1;
        for (EventType type : EventType.values()) {
            Object object = this.syncLock;
            synchronized (object) {
                ResourcePool pool = null;
                ResourcePool poolDF = null;
                if (type.equals((Object)EventType.ItemAdded) && eventEnumSet.contains(EventType.ItemAdded)) {
                    pool = this._cqAddEventPool;
                    poolDF = this._cqAddEventDataFilter;
                } else if (type.equals((Object)EventType.ItemRemoved) && eventEnumSet.contains(EventType.ItemRemoved)) {
                    pool = this._cqRemoveEventPool;
                    poolDF = this._cqRemoveEventDataFilter;
                } else if (type.equals((Object)EventType.ItemUpdated) && eventEnumSet.contains(EventType.ItemUpdated)) {
                    pool = this._cqUpdateEventPool;
                    poolDF = this._cqUpdateEventDataFilter;
                }
                if (pool == null) {
                    continue;
                }
                Object temp = pool.GetResource((Object)listener);
                short index = -1;
                if (temp != null) {
                    index = Short.parseShort(temp.toString());
                }
                if (index > -1) {
                    Object[] callbackRefs;
                    Object retVal = poolDF.RemoveResource((Object)index);
                    pool.RemoveResource((Object)listener);
                    if (retVal == null) {
                        continue;
                    }
                    boolean unregisterNotification = poolDF.getCount() == 0;
                    EventDataFilter maxDataFilter = EventDataFilter.None;
                    if (!unregisterNotification && (callbackRefs = poolDF.GetAllResourceKeys()) != null) {
                        for (int i = 0; i < callbackRefs.length; ++i) {
                            EventDataFilter df = (EventDataFilter)callbackRefs[i];
                            if (df.getValue() > maxDataFilter.getValue()) {
                                maxDataFilter = df;
                            }
                            if (maxDataFilter.equals((Object)EventDataFilter.DataWithMetadata)) break;
                        }
                    }
                    if (type == EventType.ItemAdded) {
                        this._cqAddDF = maxDataFilter;
                    } else if (type == EventType.ItemRemoved) {
                        this._cqRemoveDF = maxDataFilter;
                    } else {
                        this._cqUpdateDF = maxDataFilter;
                    }
                }
            }
        }
    }

    public boolean notifyAddInternal() {
        return this._cqAddEventPool != null && this._cqAddEventPool.getCount() > 0;
    }

    public boolean notifyUpdateInternal() {
        return this._cqUpdateEventPool != null && this._cqUpdateEventPool.getCount() > 0;
    }

    public boolean notifyRemoveInternal() {
        return this._cqRemoveEventPool != null && this._cqRemoveEventPool.getCount() > 0;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ContinuousQuery) {
            ContinuousQuery other = (ContinuousQuery)obj;
            if (this.clientUniqueId.equals(other.clientUniqueId)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.clientUniqueId != null) {
            return this.clientUniqueId.hashCode();
        }
        return super.hashCode();
    }
}

