/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client;

import com.alachisoft.ncache.client.ConnectivityStatus;
import java.net.InetAddress;

public class ClientInfo
implements Cloneable {
    private String appName = "JavaApp";
    private String clientID;
    private InetAddress iPAddress;
    private String macAddress;
    private int cores = 0;
    private int processID;
    private String machineName;
    private ConnectivityStatus status;
    private int clientVersion;

    public static String getLegacyClientID(ClientInfo info) {
        return (info.clientID != null ? info.clientID : "") + ":" + (info.machineName != null ? info.machineName : "") + ":" + info.processID;
    }

    public static ClientInfo tryParseLegacyClientID(String clientId) {
        String[] parameters = clientId.split("[:]", -1);
        if (parameters.length < 3) {
            return null;
        }
        ClientInfo info = new ClientInfo();
        info.clientID = parameters[0];
        info.machineName = parameters[1];
        info.processID = Integer.getInteger(parameters[2]);
        return info;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public InetAddress getiPAddress() {
        return this.iPAddress;
    }

    public void setiPAddress(InetAddress iPAddress) {
        this.iPAddress = iPAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public int getCores() {
        return this.cores;
    }

    public void setCores(int cores) {
        this.cores = cores;
    }

    public int getProcessID() {
        return this.processID;
    }

    public void setProcessID(int processID) {
        this.processID = processID;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public ConnectivityStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConnectivityStatus status) {
        this.status = status;
    }

    public int getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(int clientVersion) {
        this.clientVersion = clientVersion;
    }

    public String toString() {
        return "Client ID: " + this.clientID + System.lineSeparator() + "Application Name: " + this.appName + System.lineSeparator() + "Process ID: " + this.processID + System.lineSeparator() + "Machine Name: " + this.machineName + System.lineSeparator() + "Status: " + this.status + System.lineSeparator() + "Address: " + this.iPAddress + System.lineSeparator() + "Client Version: " + this.clientVersion;
    }

    public final Object clone() {
        ClientInfo info = new ClientInfo();
        info.setiPAddress(this.iPAddress);
        info.setAppName(this.appName);
        info.setClientID(this.clientID);
        info.setMachineName(this.machineName);
        info.setProcessID(this.processID);
        info.setStatus(this.status);
        info.setClientVersion(this.clientVersion);
        return info;
    }
}

