/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client;

import com.alachisoft.ncache.client.ClientCacheSyncMode;
import com.alachisoft.ncache.client.Credentials;
import com.alachisoft.ncache.client.IsolationLevel;
import com.alachisoft.ncache.client.LogLevel;
import com.alachisoft.ncache.client.ServerInfo;
import com.alachisoft.ncache.client.internal.caching.CacheHelper;
import com.alachisoft.ncache.client.internal.util.ClientConfiguration;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import tangible.DotNetToJavaStringHelper;

public class CacheConnectionOptions {
    private Boolean _loadBalance = true;
    private Boolean _enabeKeepAlive = false;
    private Boolean _enableClientLogs = false;
    private int _port = 9800;
    private Integer _commandRetries = 3;
    private Integer _connectionRetries = 5;
    private TimeSpan _commandRetryInterval = TimeSpan.Zero;
    public TimeSpan _clientRequestTimeout = TimeSpan.FromSeconds((double)90.0);
    private TimeSpan _keepAliveInterval = TimeSpan.FromSeconds((double)30.0);
    private TimeSpan _retryInterval = TimeSpan.FromSeconds((double)1.0);
    private TimeSpan _connectionTimeout = TimeSpan.FromSeconds((double)5.0);
    private TimeSpan _retryConnectionDelay = TimeSpan.FromMinutes((double)10.0);
    private String _appName;
    private String _serverName;
    private String _clientBindIP = "";
    private String _defaultReadThruProvider = "";
    private String _defaultWriteThruProvider = "";
    private LogLevel _logLevel = LogLevel.Info;
    private IsolationLevel _mode = IsolationLevel.Default;
    private ClientCacheSyncMode _clientCacheSyncMode = ClientCacheSyncMode.Optimistic;
    private List<ServerInfo> _serverList = new ArrayList<ServerInfo>();
    private HashMap _dirtyFlags = new HashMap();
    private Credentials userCredentials;
    private Credentials secondaryUserCredentials;
    private String serverName;
    private boolean haveBridgeCacheAlias;
    private String bridgeCacheAlias;
    private boolean fromClientCache;
    private boolean isBridgeClient;
    private boolean _skipUnAvailableClientCache = true;
    private int _retryL1ConnectionInterval = 10;

    public boolean isSkipUnAvailableClientCache() {
        return this._skipUnAvailableClientCache;
    }

    public void setSkipUnAvailableClientCache(boolean skipUnAvailableClientCache) {
        this._dirtyFlags.put("skipUnAvailableClientCache", true);
        this._skipUnAvailableClientCache = skipUnAvailableClientCache;
    }

    public int getRetryL1ConnectionInterval() {
        return this._retryL1ConnectionInterval;
    }

    public void setRetryL1ConnectionInterval(int retryL1ConnectionInterval) {
        this._dirtyFlags.put("retryL1ConnectionInterval", true);
        this._retryL1ConnectionInterval = this._retryL1ConnectionInterval;
    }

    public List<ServerInfo> getServerList() {
        return this._serverList;
    }

    public void setServerList(List<ServerInfo> value) {
        if (value == null) {
            return;
        }
        if (this._serverList.size() > 0) {
            this._serverList.clear();
        }
        for (ServerInfo temp : value) {
            if (this._serverList.contains(temp)) continue;
            this._serverList.add(temp);
        }
        this._dirtyFlags.put("serverlist", true);
    }

    public IsolationLevel getIsolationMode() {
        return this._mode;
    }

    public void setIsolationLevel(IsolationLevel value) {
        this._mode = value;
    }

    public String getDefaultReadThruProvider() {
        return this._defaultReadThruProvider;
    }

    public void setDefaultReadThruProvider(String value) {
        this._dirtyFlags.put("defaultReadThruProvider", true);
        this._defaultReadThruProvider = value;
    }

    public String getDefaultWriteThruProvider() {
        return this._defaultWriteThruProvider;
    }

    public void setDefaultWriteThruProvider(String value) {
        this._dirtyFlags.put("defaultWriteThruProvider", true);
        this._defaultWriteThruProvider = value;
    }

    public String getClientBindIP() {
        return this._clientBindIP;
    }

    public void setClientBindIP(String value) {
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)value)) {
            this._dirtyFlags.put("bindIP", true);
            this._clientBindIP = value;
        }
    }

    public String getAppName() {
        return this._appName;
    }

    public void setAppName(String value) {
        this._appName = value;
    }

    public Boolean getLoadBalance() {
        return this._loadBalance;
    }

    public void setLoadBalance(Boolean value) {
        this._dirtyFlags.put("balanceNodes", true);
        this._loadBalance = value;
    }

    public TimeSpan getClientRequestTimeOut() {
        return this._clientRequestTimeout;
    }

    public void setClientRequestTimeOut(TimeSpan value) {
        if (value.compareTo(TimeSpan.Zero) >= 0) {
            this._dirtyFlags.put("opTimeOut", true);
            this._clientRequestTimeout = value;
        }
    }

    public TimeSpan getConnectionTimeout() {
        return this._connectionTimeout;
    }

    public void setConnectionTimeout(TimeSpan value) {
        if (value.compareTo(TimeSpan.Zero) >= 0) {
            this._dirtyFlags.put("connectionTimeOut", true);
            this._connectionTimeout = value;
        }
    }

    public Integer getConnectionRetries() {
        return this._connectionRetries;
    }

    public void setConnectionRetries(Integer value) {
        if (value > 0) {
            this._dirtyFlags.put("connectionRetries", true);
            this._connectionRetries = value;
        }
    }

    public TimeSpan getRetryInterval() {
        return this._retryInterval;
    }

    public void setRetryInterval(TimeSpan value) {
        this._dirtyFlags.put("retryInterval", true);
        this._retryInterval = value;
    }

    public TimeSpan getRetryConnectionDelay() {
        return this._retryConnectionDelay;
    }

    public void setRetryConnectionDelay(TimeSpan value) {
        if (value.compareTo(TimeSpan.Zero) >= 0) {
            this._dirtyFlags.put("retryConnectionDelay", true);
            this._retryConnectionDelay = value;
        }
    }

    public ClientCacheSyncMode getClientCacheMode() {
        return this._clientCacheSyncMode;
    }

    public void setClientCacheMode(ClientCacheSyncMode value) {
        this._dirtyFlags.put("cacheSyncMode", true);
        this._clientCacheSyncMode = value;
    }

    public Integer getCommandRetries() {
        return this._commandRetries;
    }

    public void setCommandRetries(Integer value) {
        if (value > 0) {
            this._dirtyFlags.put("commandRetries", true);
            this._commandRetries = value;
        }
    }

    public TimeSpan getCommandRetryInterval() {
        return this._commandRetryInterval;
    }

    public void setCommandRetryInterval(TimeSpan value) {
        if (value.compareTo(TimeSpan.Zero) > 0) {
            this._dirtyFlags.put("commandRetryInterval", true);
            this._commandRetryInterval = value;
        }
    }

    public Boolean getEnableKeepAlive() {
        return this._enabeKeepAlive;
    }

    public void setEnableKeepAlive(Boolean value) {
        this._dirtyFlags.put("enableKeepAlive", true);
        this._enabeKeepAlive = value;
    }

    public TimeSpan getKeepAliveInterval() {
        return this._keepAliveInterval;
    }

    public void setKeepAliveInterval(TimeSpan value) {
        this._keepAliveInterval = value.compareTo(TimeSpan.FromSeconds((double)1.0)) == -1 || value.compareTo(TimeSpan.FromSeconds((double)7200.0)) == 1 ? TimeSpan.FromSeconds((double)30.0) : value;
        this._dirtyFlags.put("keepAliveInterval", true);
    }

    public boolean IsSet(String paramId) {
        if (this._dirtyFlags == null || this._dirtyFlags.isEmpty()) {
            return false;
        }
        if (this._dirtyFlags.containsKey(paramId)) {
            return (Boolean)this._dirtyFlags.get(paramId);
        }
        return false;
    }

    public Credentials getUserCredentials() {
        return this.userCredentials;
    }

    public void setUserCredentials(Credentials value) {
        this.userCredentials = value;
    }

    public LogLevel getLogLevel() {
        return this._logLevel;
    }

    public void setLogLevel(LogLevel value) {
        this._logLevel = value;
        this._dirtyFlags.put("logLevel", true);
    }

    public Boolean getEnableClientLogs() {
        return this._enableClientLogs;
    }

    public void setEnableClientLogs(Boolean value) {
        this._enableClientLogs = value;
        this._dirtyFlags.put("enableClientLogs", true);
    }

    public Credentials getSecondaryUserCredentials() {
        return this.secondaryUserCredentials;
    }

    public void setSecondaryUserCredentials(Credentials value) {
        this.secondaryUserCredentials = value;
    }

    public Integer getPort() {
        if (this._serverList.size() > 0) {
            return this._serverList.get(0).getPort();
        }
        return this._port;
    }

    void setPort(Integer value) {
        this._dirtyFlags.put("port", true);
        this._port = value;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean getHaveBridgeCacheAlias() {
        return this.haveBridgeCacheAlias;
    }

    public void setHaveBridgeCacheAlias(boolean value) {
        this.haveBridgeCacheAlias = value;
    }

    public String getBridgeCacheAlias() {
        return this.bridgeCacheAlias;
    }

    public void setBridgeCacheAlias(String value) {
        this.bridgeCacheAlias = value;
    }

    public boolean getFromClientCache() {
        return this.fromClientCache;
    }

    public void setFromClientCache(boolean value) {
        this.fromClientCache = value;
    }

    public boolean getIsBridgeClient() {
        return this.isBridgeClient;
    }

    public void setIsBridgeClient(boolean value) {
        this.isBridgeClient = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        CacheConnectionOptions _cloneParam = new CacheConnectionOptions();
        CacheConnectionOptions cacheConnectionOptions = this;
        synchronized (cacheConnectionOptions) {
            _cloneParam.setAppName(this.getAppName());
            _cloneParam.setClientBindIP(this.getClientBindIP());
            _cloneParam.setHaveBridgeCacheAlias(this.getHaveBridgeCacheAlias());
            _cloneParam.setClientCacheMode(this.getClientCacheMode());
            _cloneParam.setClientRequestTimeOut(this.getClientRequestTimeOut());
            _cloneParam.setCommandRetries(this.getCommandRetries());
            _cloneParam.setCommandRetryInterval(this.getCommandRetryInterval());
            _cloneParam.setConnectionRetries(this.getConnectionRetries());
            _cloneParam.setConnectionTimeout(this.getConnectionTimeout());
            _cloneParam.setDefaultReadThruProvider(this.getDefaultReadThruProvider());
            _cloneParam.setDefaultWriteThruProvider(this.getDefaultWriteThruProvider());
            _cloneParam.setEnableKeepAlive(this.getEnableKeepAlive());
            _cloneParam.setFromClientCache(this.getFromClientCache());
            _cloneParam.setHaveBridgeCacheAlias(this.getHaveBridgeCacheAlias());
            _cloneParam.setIsBridgeClient(this.getIsBridgeClient());
            _cloneParam.setKeepAliveInterval(this.getKeepAliveInterval());
            _cloneParam.setLoadBalance(this.getLoadBalance());
            _cloneParam.setIsolationLevel(this.getIsolationMode());
            _cloneParam.setPort(this.getPort());
            _cloneParam.setRetryConnectionDelay(this.getRetryConnectionDelay());
            _cloneParam.setRetryInterval(this.getRetryInterval());
            _cloneParam.setSecondaryUserCredentials(this.getSecondaryUserCredentials());
            _cloneParam.setServerList(this.getServerList());
            _cloneParam.serverName = this.getServerName();
            _cloneParam.setUserCredentials(this.getUserCredentials());
            _cloneParam.setEnableClientLogs(this.getEnableClientLogs());
            _cloneParam.setLogLevel(this.getLogLevel());
            _cloneParam.setSkipUnAvailableClientCache(this.isSkipUnAvailableClientCache());
            _cloneParam.setRetryL1ConnectionInterval(this.getRetryL1ConnectionInterval());
        }
        return _cloneParam;
    }

    void initialize(String cacheId) throws ConfigurationException {
        boolean useDefault = false;
        ClientConfiguration config = new ClientConfiguration(cacheId);
        int retries = 3;
        while (true) {
            try {
                config.loadConfiguration();
            }
            catch (Exception ie) {
                if (--retries == 0) {
                    useDefault = true;
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        if (!useDefault) {
            if (!this.IsSet("opTimeOut")) {
                this._clientRequestTimeout = TimeSpan.FromMilliseconds((double)config.getClientRequestTimeout());
            }
            if (!this.IsSet("connectionTimeOut")) {
                this._connectionTimeout = TimeSpan.FromMilliseconds((double)config.getConnectionTimeout());
            }
            if (!this.IsSet("connectionRetries")) {
                this._connectionRetries = config.getConnectionRetries();
            }
            if (!this.IsSet("retryInterval")) {
                this._retryInterval = TimeSpan.FromMilliseconds((double)config.getRetryInterval());
            }
            if (!this.IsSet("retryConnectionDelay")) {
                this._retryConnectionDelay = TimeSpan.FromMinutes((double)config.getRetryConnectionDelay());
            }
            if (!this.IsSet("bindIP")) {
                this._clientBindIP = config.getBindIP();
            }
            if (!this.IsSet("defaultReadThruProvider")) {
                this._defaultReadThruProvider = config.getDefaultReadThru();
            }
            if (!this.IsSet("defaultWriteThruProvider")) {
                this._defaultWriteThruProvider = config.getDefaultWriteThru();
            }
            if (!this.IsSet("port")) {
                this._port = config.getServerPort();
            }
            if (!this.IsSet("cacheSyncMode")) {
                this._clientCacheSyncMode = config.getCacheSyncMode();
            }
            if (!this.IsSet("enableClientLogs")) {
                this._enableClientLogs = config.getEnableClientLogs();
            }
            if (!this.IsSet("logLevel")) {
                this._logLevel = config.getLogLevels();
            }
            if (!this.IsSet("balanceNodes")) {
                this._loadBalance = config.getBalanceNodes();
            }
            if (!this.IsSet("enableKeepAlive")) {
                this._enabeKeepAlive = config.getEnableKeepAlive();
            }
            if (!this.IsSet("keepAliveInterval")) {
                this._keepAliveInterval = new TimeSpan(0, 0, config.getKeepAliveInterval());
            }
            if (!this.IsSet("skipUnAvailableClientCache")) {
                this._skipUnAvailableClientCache = config.isSkipUnAvailableClientCache();
            }
            if (!this.IsSet("retryL1ConnectionInterval")) {
                this._retryL1ConnectionInterval = config.getRetryL1ConnectionInterval();
            }
            if (this.getUserCredentials() == null) {
                ArrayList<Credentials> list = CacheHelper.LoadCredentialsFromConfig(cacheId);
                if (this.getUserCredentials() == null) {
                    this.setUserCredentials(list.get(0));
                }
            }
        }
    }
}

