/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Management;

import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Management.APISecConfig;
import Alachisoft.NCache.Management.ManagmentSecConfig;
import Alachisoft.NCache.Management.SecurityConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityConfigManager {
    public static HashMap securityMap = new HashMap();
    public static boolean _securityEnabled = false;
    public static String _ldapPath = "";
    public static String _ldapPort = "";

    public static void LoadSecurity() {
        try {
            String filePath = SecurityConfiguration.getConfigurationPath();
            String enabled = "";
            File fXmlFile = new File(filePath);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document document = dBuilder.parse(fXmlFile);
            document.getDocumentElement().normalize();
            NodeList enable = document.getElementsByTagName("enabled");
            NodeList ldap = document.getElementsByTagName("ldap");
            NodeList ldapPort = document.getElementsByTagName("port");
            if (enable != null) {
                Element enableElement = (Element)enable.item(0);
                enabled = enableElement.getFirstChild().getNodeValue().toLowerCase();
            }
            if (ldap != null) {
                Element ldapElement = (Element)ldap.item(0);
                _ldapPath = ldapElement.getFirstChild().getNodeValue();
            }
            if (ldapPort != null) {
                Element ldapPortElement = (Element)ldapPort.item(0);
                _ldapPort = ldapPortElement.getFirstChild().getNodeValue();
            }
            if (_securityEnabled = Boolean.parseBoolean(enabled = enabled.toLowerCase())) {
                securityMap = SecurityConfigManager.LoadSecurityXML(document);
            }
        }
        catch (Exception e) {
            _securityEnabled = false;
        }
    }

    private static HashMap LoadSecurityXML(Document document) {
        HashMap<String, ArrayList> cacheSecurity = new HashMap<String, ArrayList>();
        NodeList nodeSec = document.getElementsByTagName("administrators");
        ArrayList cacheAdministrators = SecurityConfigManager.LoadNCacheAdministrators(nodeSec.item(0));
        cacheSecurity.put("administrators", cacheAdministrators);
        return cacheSecurity;
    }

    private static ArrayList LoadNCacheAdministrators(Node node) {
        ArrayList<String> uids = new ArrayList<String>();
        if (node != null) {
            NodeList uidList = ((Element)node).getElementsByTagName("uid");
            if (uidList != null && uidList != null && uidList.getLength() > 0) {
                for (int usersItem = 0; usersItem < uidList.getLength(); ++usersItem) {
                    Node userNode = uidList.item(usersItem);
                    if (userNode.getNodeType() != 1) continue;
                    Element userElement = (Element)userNode;
                    uids.add(userElement.getFirstChild().getNodeValue());
                }
            }
            ManagmentSecConfig.NCacheAdministrators = uids;
        }
        return uids;
    }

    private static HashMap LoadNCacheUsers(Node node) {
        Node cacheIdNodes = (Node)((Object)((Element)node).getElementsByTagName("cache"));
        HashMap<String, ArrayList> caches = new HashMap<String, ArrayList>();
        while (cacheIdNodes.hasChildNodes()) {
            Element cacheId;
            if (cacheIdNodes.getClass() != Element.class || !(cacheId = (Element)cacheIdNodes).hasAttribute("id")) continue;
            String cacheName = cacheId.getAttribute("id").toLowerCase();
            ArrayList cacheData = SecurityConfigManager.LoadUsers(cacheId);
            caches.put(cacheName, cacheData);
        }
        APISecConfig.oldCacheUsers = caches;
        APISecConfig.fillCacheList();
        return caches;
    }

    private static ArrayList LoadUsers(Element credentials) {
        NodeList uidList;
        ArrayList<String> uids = new ArrayList<String>();
        if (credentials != null && (uidList = credentials.getElementsByTagName("uid")) != null && uidList.getLength() > 0) {
            for (int usersItem = 0; usersItem < uidList.getLength(); ++usersItem) {
                Node userNode = uidList.item(usersItem);
                if (userNode.getNodeType() != 1) continue;
                Element userElement = (Element)userNode;
                uids.add(userElement.getFirstChild().getNodeValue());
            }
        }
        return uids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void UpdateSecurity(boolean enabled, HashMap newSecurityMap, String ldap, String ldapPort) {
        securityMap = new HashMap();
        try {
            HashMap hashMap = securityMap;
            synchronized (hashMap) {
                SecurityConfigManager.LoadSecurity();
                _securityEnabled = enabled;
                if (ldap != null) {
                    _ldapPath = "LDAP://" + ldap;
                }
                _ldapPort = ldapPort == null || ldapPort.isEmpty() ? "389" : ldapPort;
                ArrayList newAdminsList = (ArrayList)newSecurityMap.get("administrators");
                securityMap.put("administrators", ManagmentSecConfig.UpdateAdminsList(newAdminsList));
                SecurityConfigManager.SaveConfiguration();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void SaveConfiguration() throws ManagementException, FileNotFoundException, UnsupportedEncodingException, IOException {
        String filePath = SecurityConfiguration.getConfigurationPath();
        if (filePath.length() == 0) {
            throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt.");
        }
        FileOutputStream os = null;
        Writer writer = null;
        try {
            os = new FileOutputStream(filePath);
            writer = new OutputStreamWriter(os);
            writer.write(SecurityConfigManager.ToXml());
            writer.flush();
        }
        catch (RuntimeException e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (RuntimeException runtimeException) {}
                writer = null;
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (RuntimeException runtimeException) {}
                os = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String ToXml() {
        StringBuilder sb = new StringBuilder();
        HashMap hashMap = securityMap;
        synchronized (hashMap) {
            sb.append("<!-- Security Configuration file for NCache 4.1 and later versions -->");
            sb.append("\n\n<cache-security>");
            String secEnabled = _securityEnabled ? "true" : "false";
            sb.append("\n\n\t<enabled>" + secEnabled + "</enabled>");
            sb.append(" <!-- This value shows whether security feature in NCache is enable or disable   -->");
            sb.append("\n\n<!-- LDAP path is required to log-on to domain. -->");
            sb.append("\n\t<ldap>" + _ldapPath + "</ldap>");
            sb.append("\n\t<port>" + _ldapPort + "</port>");
            sb.append("\n\n<!-- Following users are Administrators and are allowed to add 'this' node into their clusters and \n also allowed to perform Cache operations at API level for all Caches.-->");
            sb.append("\n\n\t<administrators>");
            if (ManagmentSecConfig.NCacheAdministrators != null && ManagmentSecConfig.NCacheAdministrators.size() > 0) {
                for (int i = 0; i < ManagmentSecConfig.NCacheAdministrators.size(); ++i) {
                    sb.append("\n\t      <uid>" + ManagmentSecConfig.NCacheAdministrators.get(i) + "</uid>");
                }
            }
            sb.append("\n\t</administrators>");
            sb.append("\n\n</cache-security>");
        }
        return sb.toString();
    }

    private static String cachesInfoToXml() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry current : APISecConfig.oldCacheUsers.entrySet()) {
            String cacheName = current.getKey().toString();
            sb.append("\n\n\t   <cache id =\"" + cacheName + "\">");
            ArrayList userIds = (ArrayList)current.getValue();
            if (userIds != null && userIds.size() > 0) {
                for (int i = 0; i < userIds.size(); ++i) {
                    sb.append("\n\t      <uid>" + userIds.get(i) + "</uid>");
                }
            }
            sb.append("\n\t   </cache>");
        }
        return sb.toString();
    }
}

