/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Management.ClientConfiguration.Dom;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Configuration.ConfigurationRootAnnotation;
import Alachisoft.NCache.Common.Configuration.ConfigurationSectionAnnotation;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheConfiguration;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.NodeConfiguration;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@ConfigurationRootAnnotation(value="configuration")
public class ClientConfiguration
implements Cloneable,
InternalCompactSerializable {
    private NodeConfiguration _nodeConfig;
    private HashMap<String, CacheConfiguration> _cacheConfigsMap;
    private String _bindIp;

    @ConfigurationSectionAnnotation(value="ncache-server")
    public final NodeConfiguration getNodeConfiguration() {
        return this._nodeConfig;
    }

    @ConfigurationSectionAnnotation(value="ncache-server")
    public final void setNodeConfiguration(Object value) {
        this._nodeConfig = (NodeConfiguration)value;
    }

    @ConfigurationSectionAnnotation(value="cache")
    public final CacheConfiguration[] getCacheConfigurations() {
        CacheConfiguration[] configs = null;
        if (this._cacheConfigsMap != null) {
            configs = new CacheConfiguration[this._cacheConfigsMap.size()];
            if (this._cacheConfigsMap.size() > 0) {
                Iterator<CacheConfiguration> iterator = this._cacheConfigsMap.values().iterator();
                int index = 0;
                while (iterator.hasNext()) {
                    configs[index] = iterator.next();
                    ++index;
                }
            }
        }
        return configs;
    }

    @ConfigurationSectionAnnotation(value="cache")
    public final void setCacheConfigurations(Object[] value) {
        if (this._cacheConfigsMap != null && this._cacheConfigsMap.size() > 0) {
            this._cacheConfigsMap.clear();
        } else {
            this._cacheConfigsMap = new HashMap();
        }
        for (Object temp : value) {
            CacheConfiguration config = (CacheConfiguration)temp;
            this._cacheConfigsMap.put(config.getCacheId().toLowerCase(), config);
        }
    }

    public final String getBindIp() {
        return this._bindIp;
    }

    public final void setBindIp(String value) {
        this._bindIp = value;
        if (this._cacheConfigsMap != null) {
            for (CacheConfiguration config : this._cacheConfigsMap.values()) {
                if (config == null) continue;
                config.setBindIp(value);
            }
        }
    }

    public final HashMap<String, CacheConfiguration> getCacheConfigurationsMap() {
        return this._cacheConfigsMap;
    }

    public final void setCacheConfigurationsMap(HashMap<String, CacheConfiguration> value) {
        this._cacheConfigsMap = value;
    }

    public final Object clone() {
        ClientConfiguration configuration = new ClientConfiguration();
        Object tempVar = this.getCacheConfigurations().clone();
        configuration.setCacheConfigurations(this.getCacheConfigurations() != null ? (CacheConfiguration[])(tempVar instanceof CacheConfiguration[] ? tempVar : null) : null);
        Object tempVar2 = this._nodeConfig.clone();
        configuration._nodeConfig = this._nodeConfig != null ? (NodeConfiguration)(tempVar2 instanceof NodeConfiguration ? tempVar2 : null) : null;
        configuration.setBindIp(this._bindIp);
        return configuration;
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this._nodeConfig = (NodeConfiguration)Common.as((Object)reader.ReadObject(), NodeConfiguration.class);
        this._cacheConfigsMap = new HashMap();
        int length = reader.ReadInt32();
        for (int i = 0; i < length; ++i) {
            this._cacheConfigsMap.put((String)Common.as((Object)reader.ReadObject(), String.class), (CacheConfiguration)Common.as((Object)reader.ReadObject(), CacheConfiguration.class));
        }
        this._bindIp = (String)Common.as((Object)reader.ReadObject(), String.class);
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject((Object)this._nodeConfig);
        writer.Write(this._cacheConfigsMap.size());
        Map.Entry<String, CacheConfiguration> current2 = null;
        for (Map.Entry<String, CacheConfiguration> current2 : this._cacheConfigsMap.entrySet()) {
            writer.WriteObject((Object)current2.getKey().toString());
            writer.WriteObject((Object)current2.getValue());
        }
        writer.WriteObject((Object)this._bindIp);
    }
}

