/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Management.ClientConfiguration.Dom;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Configuration.ConfigurationAttributeAnnotation;
import Alachisoft.NCache.Common.Configuration.ConfigurationSectionAnnotation;
import Alachisoft.NCache.Common.Enum.RtContextValue;
import Alachisoft.NCache.Config.NewDom.Encryption;
import Alachisoft.NCache.Management.ClientConfiguration.CacheServerList;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.SecurityConfiguration;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tangible.DotNetToJavaStringHelper;

public class CacheConfiguration
implements Cloneable,
InternalCompactSerializable {
    private static String _serverName;
    private static String _bindIp;
    private String _cacheId;
    private String _clientCacheId = "";
    private String _clientCacheSyncMode = "optimistic";
    private String _defaultReadThruProvider = "";
    private String _defaultWriteThruProvider = "";
    private boolean _loadBalance = true;
    private boolean _isRegisteredLocal;
    private SecurityConfiguration _securityConfig;
    private CacheServerList _serversPriorityList = new CacheServerList();
    private RtContextValue _serverRuntimeContext;
    private boolean _enableClientLogs = false;
    private String _logLevel = "error";
    private boolean _skipUnavailableClientCache = true;
    private int _retryL1ConnectionInterval = 10;
    private Encryption _encryption;

    public final boolean getIsRegisteredLocal() {
        return this._isRegisteredLocal;
    }

    public final void setIsRegisteredLocal(boolean value) {
        this._isRegisteredLocal = value;
    }

    @ConfigurationAttributeAnnotation(value="id", appendText="")
    public final String getCacheId() {
        return this._cacheId;
    }

    @ConfigurationAttributeAnnotation(value="id", appendText="")
    public final void setCacheId(String value) {
        this._cacheId = value;
    }

    @ConfigurationAttributeAnnotation(value="client-cache-id", appendText="")
    public final String getClientCacheId() {
        return this._clientCacheId;
    }

    @ConfigurationAttributeAnnotation(value="client-cache-id", appendText="")
    public final void setClientCacheId(String value) {
        this._clientCacheId = value;
    }

    @ConfigurationAttributeAnnotation(value="client-cache-syncmode", appendText="")
    public final String getClientCacheSyncMode() {
        return this._clientCacheSyncMode;
    }

    @ConfigurationAttributeAnnotation(value="client-cache-syncmode", appendText="")
    public final void setClientCacheSyncMode(String value) {
        this._clientCacheSyncMode = value;
    }

    @ConfigurationAttributeAnnotation(value="default-readthru-provider", appendText="")
    public final String getDefaultReadThruProvider() {
        return this._defaultReadThruProvider;
    }

    @ConfigurationAttributeAnnotation(value="default-readthru-provider", appendText="")
    public final void setDefaultReadThruProvider(String value) {
        this._defaultReadThruProvider = value;
    }

    @ConfigurationAttributeAnnotation(value="default-writethru-provider", appendText="")
    public final String getDefaultWriteThruProvider() {
        return this._defaultWriteThruProvider;
    }

    @ConfigurationAttributeAnnotation(value="default-writethru-provider", appendText="")
    public final void setDefaultWriteThruProvider(String value) {
        this._defaultWriteThruProvider = value;
    }

    @ConfigurationAttributeAnnotation(value="load-balance", appendText="")
    public final boolean getLoadBalance() {
        return this._loadBalance;
    }

    @ConfigurationAttributeAnnotation(value="load-balance", appendText="")
    public final void setLoadBalance(boolean value) {
        this._loadBalance = value;
    }

    @ConfigurationAttributeAnnotation(value="enable-client-logs", appendText="")
    public final boolean getEnableClientLogs() {
        return this._enableClientLogs;
    }

    @ConfigurationAttributeAnnotation(value="enable-client-logs", appendText="")
    public final void setEnableClientLogs(boolean value) {
        this._enableClientLogs = value;
    }

    @ConfigurationAttributeAnnotation(value="log-level", appendText="")
    public final String getLogLevel() {
        return this._logLevel;
    }

    @ConfigurationAttributeAnnotation(value="log-level", appendText="")
    public final void setLogLevel(String value) {
        this._logLevel = value;
    }

    @ConfigurationAttributeAnnotation(value="skip-client-cache-if-unavailable", appendText="")
    public boolean isSkipUnAvailableClientCache() {
        return this._skipUnavailableClientCache;
    }

    @ConfigurationAttributeAnnotation(value="skip-client-cache-if-unavailable", appendText="")
    public void setSkipUnAvailableClientCache(boolean skipUnAvailableClientCache) {
        this._skipUnavailableClientCache = skipUnAvailableClientCache;
    }

    @ConfigurationAttributeAnnotation(value="reconnect-client-cache-interval", appendText="")
    public int getRetryL1ConnectionInterval() {
        return this._retryL1ConnectionInterval;
    }

    @ConfigurationAttributeAnnotation(value="reconnect-client-cache-interval", appendText="")
    public void setRetryL1ConnectionInterval(int retryL1ConnectionInterval) {
        this._retryL1ConnectionInterval = this._retryL1ConnectionInterval;
    }

    public final RtContextValue getServerRuntimeContext() {
        return this._serverRuntimeContext;
    }

    public final void setServerRuntimeContext(RtContextValue serverRtContext) {
        this._serverRuntimeContext = serverRtContext;
    }

    public final String getServerRuntimeContextString() {
        if (this._serverRuntimeContext == RtContextValue.JVCACHE) {
            return "JVCACHE";
        }
        return "NCACHE";
    }

    public final void setServerRuntimeContextString(String value) {
        if ("JVCACHE".equals(value)) {
            this._serverRuntimeContext = RtContextValue.JVCACHE;
        } else if ("NCACHE".equals(value)) {
            this._serverRuntimeContext = RtContextValue.NCACHE;
        }
    }

    @ConfigurationSectionAnnotation(value="server")
    public final CacheServer[] getServers() {
        CacheServer[] servers = new CacheServer[this._serversPriorityList.getServersList().size()];
        for (Map.Entry<Integer, CacheServer> pair : this._serversPriorityList.getServersList().entrySet()) {
            int priority = pair.getKey();
            CacheServer server = pair.getValue();
            server.setPriority(priority);
            servers[priority] = server;
        }
        return servers;
    }

    @ConfigurationSectionAnnotation(value="server")
    public final void setServers(Object[] value) {
        for (int i = 0; i < value.length; ++i) {
            this._serversPriorityList.getServersList().put(i, (CacheServer)value[i]);
        }
    }

    @ConfigurationSectionAnnotation(value="security")
    public final SecurityConfiguration getSecurityConfiguration() {
        return this._securityConfig;
    }

    @ConfigurationSectionAnnotation(value="security")
    public final void setSecurityConfiguration(SecurityConfiguration value) {
        this._securityConfig = value;
    }

    public final CacheServerList getServersPriorityList() {
        return this._serversPriorityList;
    }

    public final void setServersPriorityList(CacheServerList value) {
        this._serversPriorityList = value;
    }

    public final String getBindIp() {
        return _bindIp;
    }

    public final void setBindIp(String value) {
        _bindIp = value;
    }

    public final boolean getClientCacheIsOptimistic() {
        return this.getClientCacheSyncMode().toLowerCase().compareTo("optimistic") == 0;
    }

    public final void setClientCacheIsOptimistic(boolean value) {
        if (value) {
            this.setClientCacheSyncMode("optimistic");
        } else {
            this.setClientCacheSyncMode("pessimistic");
        }
    }

    public final boolean RemoveServer(String serverName) {
        int serverPriority = 0;
        boolean found = false;
        if (this._serversPriorityList != null) {
            for (CacheServer server : this._serversPriorityList.getServersList().values()) {
                if (!server.getServerName().toLowerCase().equals(serverName.toLowerCase())) continue;
                serverPriority = server.getPriority();
                found = true;
                break;
            }
            if (found) {
                this._serversPriorityList.getServersList().remove(serverPriority);
                return true;
            }
        }
        return false;
    }

    public final boolean AddServer(String serverName, int priority) {
        CacheServer server = new CacheServer();
        server.setServerName(serverName);
        server.setPriority(priority);
        this._serversPriorityList.getServersList().put(priority, server);
        return true;
    }

    public final boolean AddLocalServer(String bindedIp) {
        return this.AddServer(!DotNetToJavaStringHelper.isNullOrEmpty((String)this.getBindIp()) ? this.getBindIp() : bindedIp, 0);
    }

    private void BringLocalServerToFirstPriority() {
        HashMap<Integer, CacheServer> tempList = new HashMap<Integer, CacheServer>();
        int localServerPriority = 0;
        boolean localServerFound = false;
        for (Map.Entry<Integer, CacheServer> pair : this._serversPriorityList.getServersList().entrySet()) {
            String serverName = pair.getValue().getServerName().toLowerCase();
            if (serverName.compareTo(_serverName.toLowerCase()) != 0 && serverName.compareTo(_bindIp.toLowerCase()) != 0) continue;
            localServerFound = true;
            localServerPriority = pair.getKey();
            break;
        }
        if (localServerFound) {
            tempList.put(0, this._serversPriorityList.getServersList().get(localServerPriority));
            int priority = 1;
            for (Map.Entry<Integer, CacheServer> pair : this._serversPriorityList.getServersList().entrySet()) {
                if (pair.getKey() == localServerPriority) continue;
                tempList.put(priority++, pair.getValue());
            }
            this._serversPriorityList.setServersList(tempList);
        }
    }

    public final Encryption getEncryptionConfiguration() {
        return this._encryption;
    }

    public final void setEncryptionConfiguration(Encryption value) {
        this._encryption = value;
    }

    public final Object clone() {
        CacheConfiguration configuration = new CacheConfiguration();
        configuration.setBindIp(_bindIp);
        configuration._cacheId = this._cacheId;
        configuration._clientCacheId = this._clientCacheId;
        configuration._clientCacheSyncMode = this._clientCacheSyncMode;
        configuration._defaultReadThruProvider = this._defaultReadThruProvider;
        configuration._defaultWriteThruProvider = this._defaultWriteThruProvider;
        configuration._loadBalance = this._loadBalance;
        SecurityConfiguration securityConfiguration = this._securityConfig != null ? (SecurityConfiguration)(this._securityConfig.clone() instanceof SecurityConfiguration ? this._securityConfig.clone() : null) : (configuration._securityConfig = null);
        configuration.setServers(this.getServers() != null ? (this.getServers().clone() instanceof CacheServer[] ? (CacheServer[])this.getServers().clone() : null) : null);
        configuration._serverRuntimeContext = this._serverRuntimeContext;
        configuration._enableClientLogs = this._enableClientLogs;
        configuration._logLevel = this._logLevel;
        configuration._retryL1ConnectionInterval = this._retryL1ConnectionInterval;
        configuration._skipUnavailableClientCache = this._skipUnavailableClientCache;
        return configuration;
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this._cacheId = (String)Common.readAs((Object)reader.ReadObject(), String.class);
        this._clientCacheId = (String)Common.readAs((Object)reader.ReadObject(), String.class);
        this._clientCacheSyncMode = (String)Common.readAs((Object)reader.ReadObject(), String.class);
        this._defaultReadThruProvider = (String)Common.readAs((Object)reader.ReadObject(), String.class);
        this._defaultWriteThruProvider = (String)Common.readAs((Object)reader.ReadObject(), String.class);
        this._loadBalance = reader.ReadBoolean();
        this._isRegisteredLocal = reader.ReadBoolean();
        this._securityConfig = (SecurityConfiguration)Common.readAs((Object)reader.ReadObject(), SecurityConfiguration.class);
        int length = reader.ReadInt32();
        for (int i = 0; i < length; ++i) {
            this._serversPriorityList.setServersList(reader.ReadInt32(), (CacheServer)Common.readAs((Object)reader.ReadObject(), CacheServer.class));
        }
        _serverName = (String)Common.readAs((Object)reader.ReadObject(), String.class);
        _bindIp = (String)Common.readAs((Object)reader.ReadObject(), String.class);
        this._serverRuntimeContext = "1".equals(Common.as((Object)reader.ReadObject(), String.class)) ? RtContextValue.JVCACHE : RtContextValue.NCACHE;
        reader.ReadBoolean();
        this._enableClientLogs = reader.ReadBoolean();
        this._logLevel = (String)Common.readAs((Object)reader.ReadObject(), String.class);
        this._skipUnavailableClientCache = reader.ReadBoolean();
        this._retryL1ConnectionInterval = reader.ReadInt32();
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject((Object)this._cacheId);
        writer.WriteObject((Object)this._clientCacheId);
        writer.WriteObject((Object)this._clientCacheSyncMode);
        writer.WriteObject((Object)this._defaultReadThruProvider);
        writer.WriteObject((Object)this._defaultWriteThruProvider);
        writer.Write(this._loadBalance);
        writer.Write(this._isRegisteredLocal);
        writer.WriteObject((Object)this._securityConfig);
        writer.Write(this._serversPriorityList.getServersList().size());
        Map.Entry<Integer, CacheServer> current2 = null;
        for (Map.Entry<Integer, CacheServer> current2 : this._serversPriorityList.getServersList().entrySet()) {
            writer.Write(current2.getKey().intValue());
            writer.WriteObject((Object)current2.getValue());
        }
        writer.WriteObject((Object)_serverName);
        writer.WriteObject((Object)_bindIp);
        writer.WriteObject((Object)(this._serverRuntimeContext == RtContextValue.JVCACHE ? "1" : "0"));
        writer.Write(false);
        writer.Write(this._enableClientLogs);
        writer.WriteObject((Object)this._logLevel);
        writer.Write(this._skipUnavailableClientCache);
        writer.Write(this._retryL1ConnectionInterval);
    }

    static {
        try {
            try {
                _serverName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                Logger.getLogger(CacheConfiguration.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

