/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Management;

import Alachisoft.NCache.Caching.Statistics.CacheStatistics;
import Alachisoft.NCache.Caching.Statistics.ClusterCacheStatistics;
import Alachisoft.NCache.Caching.Statistics.NodeInfo;
import Alachisoft.NCache.Common.EncryptionUtil;
import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Common.Monitoring.ClientProcessStats;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Management.ClientConfiguration.ClientConfigManager;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheConfiguration;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.ClientConfiguration;
import Alachisoft.NCache.Management.ICacheServer;
import Alachisoft.NCache.Management.NCacheRPCService;
import Alachisoft.NCache.ServiceControl.NCacheService;
import com.alachisoft.ncache.ncactivate.utils.EnvironmentUtil;
import com.alachisoft.ncache.runtime.cachemanagement.CacheContext;
import com.alachisoft.ncache.runtime.cachemanagement.CacheHealth;
import com.alachisoft.ncache.runtime.cachemanagement.CacheStatus;
import com.alachisoft.ncache.runtime.cachemanagement.CacheTopology;
import com.alachisoft.ncache.runtime.cachemanagement.ConnectivityStatus;
import com.alachisoft.ncache.runtime.cachemanagement.NodeStatus;
import com.alachisoft.ncache.runtime.cachemanagement.ServerNode;
import com.alachisoft.ncache.runtime.caching.ClientInfo;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CacheServerModerator {
    private static final int _port = 8250;
    private static final int JvCacheManagementPort = 8270;
    private static final int NCacheManagementPort = 8250;
    private static String config = "client.ncconf";
    private static String LOCALCACHE = "local-cache";
    private static String CLUSTEREDCACHE = "clustered-cache";
    private static NCacheRPCService _ncacheService;

    public static void StartCache(String cacheId, String serverName, int port, String userId, String password) throws UnknownHostException, ManagementException {
        ICacheServer cs = null;
        NCacheRPCService cacheService = new NCacheRPCService(null);
        Object config = null;
        try {
            cacheService.setServerName(serverName);
            cacheService.setPort(port);
            cs = ((NCacheService)cacheService).GetCacheServer(new TimeSpan(0, 0, 0, 30));
            cs.StartCache(cacheId, EncryptionUtil.Encrypt((String)userId), EncryptionUtil.Encrypt((String)password));
            if (cs != null) {
                cs.StartCache(cacheId, EncryptionUtil.Encrypt((String)userId), EncryptionUtil.Encrypt((String)password));
            }
        }
        catch (Exception ex) {
            if (cs != null) {
                cs.dispose();
                cs = null;
            }
            throw new ManagementException(ex.getMessage());
        }
        finally {
            if (cs != null) {
                cs.dispose();
            }
            cacheService.dispose();
        }
    }

    public static void StopCache(String cacheId, String serverName, int port, String userId, String password, boolean isGracefulShutdown) throws UnknownHostException, ManagementException {
        ICacheServer cs = null;
        NCacheRPCService cacheService = new NCacheRPCService(null);
        try {
            cacheService.setServerName(serverName);
            cacheService.setPort(port);
            cs = ((NCacheService)cacheService).GetCacheServer(new TimeSpan(0, 0, 0, 30));
            if (cs != null) {
                cs.StopCache(cacheId, EncryptionUtil.Encrypt((String)userId), EncryptionUtil.Encrypt((String)password), isGracefulShutdown);
            }
        }
        catch (Exception ex) {
            if (cs != null) {
                cs.dispose();
                cs = null;
            }
            throw new ManagementException(ex.getMessage());
        }
        finally {
            if (cs != null) {
                cs.dispose();
            }
            cacheService.dispose();
        }
    }

    public static Map<ServerNode, List<ClientInfo>> getCacheClients(String cacheName, String initialNodeName, CacheContext context, int port) throws ManagementException {
        NCacheRPCService cacheService = CacheServerModerator.GetCacheService(context);
        if (port != 0) {
            cacheService.setPort(port);
        }
        String startingNode = initialNodeName;
        CacheServerConfig cacheServerConfig = null;
        ICacheServer cacheServer = null;
        ServerNode clientList = new HashMap();
        try {
            if (initialNodeName.equals("")) {
                cacheServerConfig = CacheServerModerator.getCacheConfigThroughClientConfig(cacheName, port, context);
                if (cacheServerConfig == null) {
                    throw new ManagementException("cache with name " + cacheName + " not found in " + config);
                }
            } else {
                cacheService.setServerName(initialNodeName);
                cacheServer = ((NCacheService)cacheService).GetCacheServer(new TimeSpan(0, 0, 0, 30));
                if (cacheServer == null) {
                    throw new ManagementException("provided initial node not available");
                }
                cacheServerConfig = cacheServer.GetCacheConfiguration(cacheName);
                if (cacheServerConfig == null) {
                    throw new ManagementException(10011, ErrorMessages.getErrorMessage((int)10011, (String[])new String[]{cacheName}));
                }
            }
            if (cacheServerConfig.getCacheType().equalsIgnoreCase(LOCALCACHE)) {
                ServerNode serverNode;
                if (cacheServerConfig.getInProc()) {
                    throw new IllegalArgumentException("API is not supported for Local Inproc Cache");
                }
                cacheService.setServerName(EnvironmentUtil.getComputerName());
                cacheServer = ((NCacheService)cacheService).GetCacheServer(new TimeSpan(0, 0, 0, 30));
                if (cacheServer != null && cacheServer.IsRunning(cacheName)) {
                    serverNode = new ServerNode();
                    serverNode.setServerIP(EnvironmentUtil.getComputerName());
                    ArrayList<ClientProcessStats> clients = cacheServer.GetClientProcessStats(cacheServerConfig.getName());
                    ArrayList<ClientInfo> list = new ArrayList<ClientInfo>();
                    for (ClientProcessStats clientNode : clients) {
                        ClientInfo clientInfo = new ClientInfo();
                        clientInfo.setIPAddress(clientNode.getAddress().getIpAddress());
                        clientInfo.setProcessID(Integer.parseInt(clientNode.getProcessID()));
                        list.add(clientInfo);
                    }
                    clientList.put(serverNode, list);
                }
                serverNode = clientList;
                return serverNode;
            }
            ArrayList initialHost = CacheServerModerator.InitialHostList(cacheServerConfig.getCluster().getChannel().getInitialHosts());
            for (Object host : initialHost) {
                try {
                    cacheService.setServerName((String)host);
                    cacheServer = ((NCacheService)cacheService).GetCacheServer(new TimeSpan(0, 0, 0, 30));
                    if (!cacheServer.IsRunning(cacheName)) continue;
                    ServerNode serverNode = new ServerNode();
                    serverNode.setServerIP((String)(host instanceof String ? host : null));
                    serverNode.setPort(cacheServerConfig.getCluster().getChannel().getTcpPort());
                    ArrayList<ClientProcessStats> clients = cacheServer.GetClientProcessStats(cacheServerConfig.getName());
                    ArrayList<ClientInfo> list = new ArrayList<ClientInfo>();
                    for (ClientProcessStats clientNode : clients) {
                        ClientInfo clientInfo = new ClientInfo();
                        clientInfo.setIPAddress(clientNode.getAddress().getIpAddress());
                        clientInfo.setProcessID(Integer.parseInt(clientNode.getProcessID()));
                        list.add(clientInfo);
                    }
                    clientList.put(serverNode, list);
                }
                catch (Exception exception) {}
            }
            ServerNode serverNode = clientList;
            return serverNode;
        }
        catch (Exception ex) {
            throw new ManagementException(ex.getMessage());
        }
        finally {
            if (cacheServer != null) {
                cacheServer.dispose();
            }
            cacheService.dispose();
        }
    }

    public static CacheHealth getCacheHealth(String cacheName, String initialNodeName, CacheContext context, int port) throws ManagementException {
        _ncacheService = CacheServerModerator.GetCacheService(context);
        if (port != 0) {
            _ncacheService.setPort(port);
        }
        String startingNode = initialNodeName;
        int _runningNodes = 0;
        CacheServerConfig cacheServerConfig = null;
        ICacheServer cacheServer = null;
        CacheHealth cacheHealth = new CacheHealth();
        try {
            if (initialNodeName.equals("")) {
                cacheServerConfig = CacheServerModerator.getCacheConfigThroughClientConfig(cacheName, port, context);
                if (cacheServerConfig == null) {
                    CacheHealth cacheHealth2 = cacheHealth;
                    return cacheHealth2;
                }
            } else {
                _ncacheService.setServerName(initialNodeName);
                cacheServer = _ncacheService.GetCacheServer(new TimeSpan(0, 0, 30));
                if (cacheServer == null) {
                    throw new ManagementException("provided initial node not available");
                }
                cacheServerConfig = cacheServer.GetCacheConfiguration(cacheName);
                if (cacheServerConfig == null) {
                    throw new ManagementException("cache with name " + cacheName + " not registered on specified node");
                }
            }
            if (cacheServerConfig.getCacheType().equalsIgnoreCase(LOCALCACHE)) {
                if (cacheServerConfig.getInProc()) {
                    throw new IllegalArgumentException("API is not supported for Local Inproc Cache");
                }
                _ncacheService.setServerName(InetAddress.getLocalHost().getHostName());
                cacheServer = _ncacheService.GetCacheServer(new TimeSpan(0, 0, 30));
                if (cacheServer != null) {
                    cacheHealth.setCacheName(cacheServerConfig.getName());
                    cacheHealth.setTopology(CacheTopology.LocalOutproc);
                    cacheHealth.setStatus(CacheStatus.Stopped);
                    if (cacheServer.IsRunning(cacheHealth.getCacheName())) {
                        cacheHealth.setStatus(CacheStatus.Running);
                    }
                }
                CacheHealth cacheHealth3 = cacheHealth;
                return cacheHealth3;
            }
            cacheHealth.setCacheName(cacheServerConfig.getName());
            cacheHealth.setTopology(CacheServerModerator.GetCacheTopology(cacheServerConfig.getCluster().getCacheType()));
            cacheHealth.setStatus(CacheStatus.Stopped);
            ArrayList<NodeStatus> serverNodesList = new ArrayList<NodeStatus>();
            ArrayList initialHost = CacheServerModerator.InitialHostList(cacheServerConfig.getCluster().getChannel().getInitialHosts());
            for (Object host : initialHost) {
                NodeStatus nodeStats = new NodeStatus();
                try {
                    nodeStats.setNodeInfo(new ServerNode());
                    nodeStats.getNodeInfo().setServerIP((String)host);
                    nodeStats.getNodeInfo().setPort(cacheServerConfig.getCluster().getChannel().getTcpPort());
                    nodeStats.setConnectivityStatus(ConnectivityStatus.CacheStoped);
                    _ncacheService.setServerName((String)host);
                    cacheServer = _ncacheService.GetCacheServer(new TimeSpan(0, 0, 30));
                    if (cacheServer.IsRunning(cacheName)) {
                        cacheHealth.setStatus(CacheStatus.Running);
                        nodeStats.setConnectivityStatus(ConnectivityStatus.Running);
                        CacheStatistics cacheStats = cacheServer.GetStatistics(cacheName);
                        ClusterCacheStatistics clusterCacheStats = (ClusterCacheStatistics)(cacheStats instanceof ClusterCacheStatistics ? cacheStats : null);
                        ArrayList<ServerNode> connectedNodesList = new ArrayList<ServerNode>();
                        nodeStats.getNodeInfo().setServerIP(clusterCacheStats.getLocalNode().getAddress().getIpAddress().toString());
                        nodeStats.getNodeInfo().setPort(clusterCacheStats.getLocalNode().getAddress().getPort());
                        if (clusterCacheStats.getLocalNode().getIsStartedAsMirror()) {
                            nodeStats.getNodeInfo().setIsReplica(true);
                        }
                        for (Object node : clusterCacheStats.getNodes()) {
                            NodeInfo connectedNode = (NodeInfo)node;
                            ServerNode tempNode = new ServerNode();
                            if (clusterCacheStats.getLocalNode().getAddress().equals((Object)connectedNode.getAddress())) continue;
                            tempNode.setServerIP(connectedNode.getAddress().getIpAddress().toString());
                            tempNode.setPort(connectedNode.getAddress().getPort());
                            if (connectedNode.getIsStartedAsMirror()) {
                                tempNode.setIsReplica(true);
                            }
                            connectedNodesList.add(tempNode);
                        }
                        nodeStats.setConnectedNodes(connectedNodesList.toArray(new ServerNode[0]));
                        _runningNodes = clusterCacheStats.getClassName().equals("partitioned-replicas-server") ? (_runningNodes += 2) : ++_runningNodes;
                    } else {
                        nodeStats.setConnectedNodes(null);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                serverNodesList.add(nodeStats);
            }
            for (int i = 0; i < serverNodesList.size(); ++i) {
                NodeStatus node = (NodeStatus)serverNodesList.get(i);
                if (node.getConnectedNodes() == null) continue;
                if (node.getConnectedNodes().length == _runningNodes - 1) {
                    node.setConnectivityStatus(ConnectivityStatus.FullyConnected);
                    continue;
                }
                if (node.getConnectedNodes().length >= _runningNodes - 1) continue;
                node.setConnectivityStatus(ConnectivityStatus.PartialConnected);
            }
            cacheHealth.setServerNodesStatus(serverNodesList.toArray(new NodeStatus[0]));
        }
        catch (Exception ex) {
            throw new ManagementException(ex.getMessage());
        }
        finally {
            _ncacheService.dispose();
            _ncacheService = null;
        }
        return cacheHealth;
    }

    private static NCacheRPCService GetCacheService(CacheContext context) {
        try {
            switch (context) {
                case TayzGrid: {
                    return new NCacheRPCService("", 8270);
                }
                case NCache: {
                    return new NCacheRPCService("", 8250);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static ArrayList InitialHostList(String initialHostsColl) {
        String[] commaSplit;
        ArrayList<String> list = new ArrayList<String>(5);
        for (String initialHost : commaSplit = initialHostsColl.split("[,]", -1)) {
            String[] split = initialHost.split("\\[");
            list.add(split[0]);
        }
        return list;
    }

    private static CacheTopology GetCacheTopology(String topologyType) {
        if (topologyType.equals("replicated") || topologyType.equals("replicated-server")) {
            return CacheTopology.Replicated;
        }
        if (topologyType.equals("partitioned") || topologyType.equals("partitioned-server")) {
            return CacheTopology.Partitioned;
        }
        if (topologyType.equals("partition-replica") || topologyType.equals("partitioned-replicas-server")) {
            return CacheTopology.PartitionReplica;
        }
        if (topologyType.equals("mirror") || topologyType.equals("mirror-server")) {
            return CacheTopology.Mirrored;
        }
        return CacheTopology.None;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CacheServerConfig getCacheConfigThroughClientConfig(String cacheName, int port, CacheContext context) throws ManagementException {
        CacheServerConfig cacheServerConfig;
        block13: {
            cacheServerConfig = null;
            CacheServer[] serverNodes = null;
            ICacheServer cacheServer = null;
            NCacheRPCService cacheService = CacheServerModerator.GetCacheService(context);
            if (port != 0) {
                cacheService.setPort(port);
            }
            try {
                ClientConfiguration clientConfiguration = ClientConfigManager.GetClientConfiguration(cacheName);
                if (clientConfiguration != null) {
                    HashMap<String, CacheConfiguration> cacheConfigurationMap = clientConfiguration.getCacheConfigurationsMap();
                    CacheConfiguration cacheClientConfiguration = null;
                    cacheClientConfiguration = cacheConfigurationMap.get(cacheName);
                    if (cacheClientConfiguration == null) {
                        throw new ManagementException("cache not found in " + config);
                    }
                    for (CacheServer node : serverNodes = cacheClientConfiguration.getServers()) {
                        try {
                            cacheService.setServerName(node.getServerName());
                            cacheServer = ((NCacheService)cacheService).GetCacheServer(new TimeSpan(0, 0, 0, 30));
                            if (cacheServer == null) continue;
                            cacheServerConfig = cacheServer.GetCacheConfiguration(cacheName);
                            cacheServer.dispose();
                            cacheServer = null;
                            if (cacheServerConfig == null) continue;
                            break block13;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    break block13;
                }
                throw new ManagementException("error while fetching info from " + config);
            }
            catch (Exception exception) {
            }
            finally {
                if (cacheServer != null) {
                    cacheServer.dispose();
                }
                if (cacheService != null) {
                    cacheService.dispose();
                }
            }
        }
        return cacheServerConfig;
    }
}

