/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Management;

import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Caching.CacheClearedCallback;
import Alachisoft.NCache.Caching.CacheRenderer;
import Alachisoft.NCache.Caching.CustomRemoveCallback;
import Alachisoft.NCache.Caching.CustomUpdateCallback;
import Alachisoft.NCache.Caching.EventContext;
import Alachisoft.NCache.Caching.GracefulTimeout;
import Alachisoft.NCache.Caching.ItemAddedCallback;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.ItemRemovedCallback;
import Alachisoft.NCache.Caching.ItemUpdatedListener;
import Alachisoft.NCache.Caching.LeasedCache;
import Alachisoft.NCache.Caching.Statistics.CacheStatistics;
import Alachisoft.NCache.Caching.Statistics.ClusterCacheStatistics;
import Alachisoft.NCache.Caching.Statistics.NodeInfo;
import Alachisoft.NCache.Caching.Util.HotConfig;
import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.DataStructures.NewHashmap;
import Alachisoft.NCache.Common.DirectoryUtil;
import Alachisoft.NCache.Common.EncryptionUtil;
import Alachisoft.NCache.Common.Enum.CacheStatus;
import Alachisoft.NCache.Common.Enum.CacheStatusOnServer;
import Alachisoft.NCache.Common.Enum.CacheStatusOnServerContainer;
import Alachisoft.NCache.Common.Enum.ClientNodeStatus;
import Alachisoft.NCache.Common.Enum.EventType;
import Alachisoft.NCache.Common.Enum.RtContextValue;
import Alachisoft.NCache.Common.Event.ILicenseExpiration;
import Alachisoft.NCache.Common.Event.NEventStart;
import Alachisoft.NCache.Common.EventArgs;
import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Common.Exceptions.SuspectedException;
import Alachisoft.NCache.Common.Exceptions.TimeoutException;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Logger.EventLogger;
import Alachisoft.NCache.Common.LoggingInfo;
import Alachisoft.NCache.Common.Monitoring.CacheNodeStatistics;
import Alachisoft.NCache.Common.Monitoring.ClientProcessStats;
import Alachisoft.NCache.Common.Monitoring.ConfiguredCacheInfo;
import Alachisoft.NCache.Common.Monitoring.EventViewerEvent;
import Alachisoft.NCache.Common.Monitoring.Node;
import Alachisoft.NCache.Common.Monitoring.ServerMonitor;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.Net.NetworkData;
import Alachisoft.NCache.Common.PortPool;
import Alachisoft.NCache.Common.ProductVersion;
import Alachisoft.NCache.Common.RPCFramework.TargetMethodAttribute;
import Alachisoft.NCache.Common.RPCFramework.TargetMethodParameter;
import Alachisoft.NCache.Common.ServiceConfiguration;
import Alachisoft.NCache.Common.ServicePropValues;
import Alachisoft.NCache.Common.StatusInfo;
import Alachisoft.NCache.Common.Threading.TimeScheduler;
import Alachisoft.NCache.Common.Util.ReaderWriterLock;
import Alachisoft.NCache.Config.ConfigReader;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Config.Dom.Cluster;
import Alachisoft.NCache.Config.Dom.ConfigConverter;
import Alachisoft.NCache.Config.NewDom.AbsoluteExpiration;
import Alachisoft.NCache.Config.NewDom.AlertsNotifications;
import Alachisoft.NCache.Config.NewDom.AlertsTypes;
import Alachisoft.NCache.Config.NewDom.Analyzers;
import Alachisoft.NCache.Config.NewDom.Attrib;
import Alachisoft.NCache.Config.NewDom.AttributeListUnion;
import Alachisoft.NCache.Config.NewDom.AutoLoadBalancing;
import Alachisoft.NCache.Config.NewDom.BackingSource;
import Alachisoft.NCache.Config.NewDom.BatchConfig;
import Alachisoft.NCache.Config.NewDom.BridgeConfig;
import Alachisoft.NCache.Config.NewDom.BridgeConflictResolver;
import Alachisoft.NCache.Config.NewDom.CacheDeployment;
import Alachisoft.NCache.Config.NewDom.CacheLoader;
import Alachisoft.NCache.Config.NewDom.CacheServerConfigSetting;
import Alachisoft.NCache.Config.NewDom.CacheTopology;
import Alachisoft.NCache.Config.NewDom.Cleanup;
import Alachisoft.NCache.Config.NewDom.ClientActivityNotification;
import Alachisoft.NCache.Config.NewDom.ClientCacheSettings;
import Alachisoft.NCache.Config.NewDom.ClientDeathDetection;
import Alachisoft.NCache.Config.NewDom.ClientNode;
import Alachisoft.NCache.Config.NewDom.ClientNodeStatusWrapper;
import Alachisoft.NCache.Config.NewDom.ClientNodes;
import Alachisoft.NCache.Config.NewDom.CompactClass;
import Alachisoft.NCache.Config.NewDom.CompactSerialization;
import Alachisoft.NCache.Config.NewDom.Compression;
import Alachisoft.NCache.Config.NewDom.DataSharing;
import Alachisoft.NCache.Config.NewDom.DomHelper;
import Alachisoft.NCache.Config.NewDom.EmailNotifications;
import Alachisoft.NCache.Config.NewDom.Encryption;
import Alachisoft.NCache.Config.NewDom.EvictionPolicy;
import Alachisoft.NCache.Config.NewDom.ExpirationPolicy;
import Alachisoft.NCache.Config.NewDom.LoaderTag;
import Alachisoft.NCache.Config.NewDom.Log;
import Alachisoft.NCache.Config.NewDom.LuceneDepType;
import Alachisoft.NCache.Config.NewDom.LuceneDeployment;
import Alachisoft.NCache.Config.NewDom.LuceneSettings;
import Alachisoft.NCache.Config.NewDom.NodeIdentity;
import Alachisoft.NCache.Config.NewDom.NotificationRecipient;
import Alachisoft.NCache.Config.NewDom.Notifications;
import Alachisoft.NCache.Config.NewDom.Parameter;
import Alachisoft.NCache.Config.NewDom.Patterns;
import Alachisoft.NCache.Config.NewDom.PerfCounters;
import Alachisoft.NCache.Config.NewDom.PortableAttribute;
import Alachisoft.NCache.Config.NewDom.PortableClass;
import Alachisoft.NCache.Config.NewDom.Provider;
import Alachisoft.NCache.Config.NewDom.ProviderAssembly;
import Alachisoft.NCache.Config.NewDom.QueryIndex;
import Alachisoft.NCache.Config.NewDom.Readthru;
import Alachisoft.NCache.Config.NewDom.ReplicationStrategy;
import Alachisoft.NCache.Config.NewDom.SQLDependencyConfig;
import Alachisoft.NCache.Config.NewDom.Security;
import Alachisoft.NCache.Config.NewDom.ServerNode;
import Alachisoft.NCache.Config.NewDom.ServersNodes;
import Alachisoft.NCache.Config.NewDom.SlidingExpiration;
import Alachisoft.NCache.Config.NewDom.StopWords;
import Alachisoft.NCache.Config.NewDom.Storage;
import Alachisoft.NCache.Config.NewDom.SynchronizationStrategy;
import Alachisoft.NCache.Config.NewDom.TagList;
import Alachisoft.NCache.Config.NewDom.TaskConfiguration;
import Alachisoft.NCache.Config.NewDom.Type;
import Alachisoft.NCache.Config.NewDom.User;
import Alachisoft.NCache.Config.NewDom.WriteBehind;
import Alachisoft.NCache.Config.NewDom.Writethru;
import Alachisoft.NCache.Config.PropsConfigReader;
import Alachisoft.NCache.Management.BindedIpMap;
import Alachisoft.NCache.Management.CacheConfig;
import Alachisoft.NCache.Management.CacheConfigManager;
import Alachisoft.NCache.Management.CacheInfo;
import Alachisoft.NCache.Management.CacheRegisterationInfo;
import Alachisoft.NCache.Management.ClientCacheStatus;
import Alachisoft.NCache.Management.ClientConfiguration.CacheServerList;
import Alachisoft.NCache.Management.ClientConfiguration.ClientConfigManager;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheConfiguration;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.ClientConfiguration;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.NodeConfiguration;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.SecurityConfiguration;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.UserCredentials;
import Alachisoft.NCache.Management.ICacheServer;
import Alachisoft.NCache.Management.NewCacheRegisterationInfo;
import Alachisoft.NCache.Management.NodeInfoMap;
import Alachisoft.NCache.Management.SecurityConfigManager;
import Alachisoft.NCache.Management.ServerLicenseInfo;
import com.alachisoft.ncache.common.monitoring.ClientCustomCounters;
import com.alachisoft.ncache.common.monitoring.ClientMetaData;
import com.alachisoft.ncache.common.monitoring.CounterDataCollection;
import com.alachisoft.ncache.common.monitoring.CounterMetadata;
import com.alachisoft.ncache.common.monitoring.CounterMetadataCollection;
import com.alachisoft.ncache.common.monitoring.IntervalCounterDataCollection;
import com.alachisoft.ncache.licensing.LicenseInfo;
import com.alachisoft.ncache.licensing.LicenseLogger;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.licensing.LicenseMonitor;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.security.CacheXMLAuthorizationProvider;
import com.alachisoft.ncache.security.NodeSecurityProvider;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheArgumentException;
import com.alachisoft.ncache.serialization.standard.FormatterServices;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import tangible.DotNetToJavaStringHelper;
import tangible.RefObject;

public class CacheServer
implements ICacheServer,
IDisposable,
ILicenseExpiration {
    private static CacheServer s_instance;
    private static Object serviceObject;
    private static HashMap s_caches;
    private static HashMap s_partitionedCaches;
    private static int _socketServerPort;
    private static String _clusterIp;
    private static String _clientserverip;
    private static String _localCacheIp;
    private static Thread _evalWarningTask;
    private static boolean stopEvalWarning;
    private static LicenseLogger licenseLogger;
    private Exception e2;
    private ReaderWriterLock _rwLock = new ReaderWriterLock();
    private CacheRenderer _renderer;
    private TimeScheduler _gcScheduler;

    public CacheServer() {
        if (this._gcScheduler == null) {
            this._gcScheduler = new TimeScheduler();
        }
        this._gcScheduler.Start();
        NetworkData.registerIPToMonitor((String)ServicePropValues.BIND_ToCLUSTER_IP);
        NetworkData.registerIPToMonitor((String)ServicePropValues.BIND_toClient_IP);
        this.StartGCTask();
    }

    public static String getObjectUri() {
        return CacheServer.class.getName();
    }

    public static String getClientserverIp() {
        return _clientserverip;
    }

    public static void setClientserverIp(String value) {
        _clientserverip = value;
    }

    public static CacheServer getInstance() {
        return s_instance;
    }

    public static void setInstance(CacheServer value) {
        s_instance = value;
        LicenseManager.registerLicenseExpirationCallBack((ILicenseExpiration)s_instance);
    }

    private static void NotifyEvalLicense(Object source, EventArgs e) {
        try {
            LicenseManager.LicenseType mode = LicenseManager.LicenseType.Expired;
            try {
                mode = LicenseManager.LicenseMode(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mode == LicenseManager.LicenseType.ActivePerNode || mode == LicenseManager.LicenseType.ActivePerProcessor) {
                if (_evalWarningTask != null) {
                    stopEvalWarning = true;
                    _evalWarningTask = null;
                }
            } else if (mode == LicenseManager.LicenseType.InEvaluation) {
                TimeSpan tSpan = TimeSpan.subtract((Date)new Date(), (Date)LicenseManager.getEvaluationDt().getTime());
                double daysRemaining = (double)LicenseManager.getEvaluationPeriod() - tSpan.getTotalMinutes() / 3600.0;
                boolean writeEntry = true;
                if (writeEntry) {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, (int)daysRemaining);
                    Date dT = cal.getTime();
                    if (daysRemaining <= 10.0 && daysRemaining > 1.0) {
                        String msg = String.format("N evaluation of %1$s days expires on %2$s. Please purchase license keys or extend evaluation period by contacting support@alachisoft.com ", LicenseManager.getEvaluationPeriod(), dT.toString());
                        EventLogger.LogEvent((String)"NCache", (String)msg, (EventType)EventType.WARNING, (short)2, (int)1020);
                    } else if (daysRemaining == 1.0 || daysRemaining == 0.0) {
                        String msg = String.format("NCache evaluation of %1$s days expires on %2$s. It cannot be extended any more. Therefore, please purchase NCache license from sales@alachisoft.com and activate before expiration.", LicenseManager.getEvaluationPeriod(), dT.toString());
                        EventLogger.LogEvent((String)"NCache", (String)msg, (EventType)EventType.WARNING, (short)2, (int)1020);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void RegisterCompactTypes() throws NCacheArgumentException {
        FormatterServices.getDefault().registerKnownTypes(TargetMethodParameter.class, Integer.valueOf(165).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ProductVersion.class, Integer.valueOf(302).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheServerConfig.class, Integer.valueOf(177).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Log.class, Integer.valueOf(178).shortValue());
        FormatterServices.getDefault().registerKnownTypes(PerfCounters.class, Integer.valueOf(179).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Compression.class, Integer.valueOf(180).shortValue());
        FormatterServices.getDefault().registerKnownTypes(QueryIndex.class, Integer.valueOf(181).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Class.class, Integer.valueOf(182).shortValue());
        FormatterServices.getDefault().registerKnownTypes(DataSharing.class, Integer.valueOf(183).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Type.class, Integer.valueOf(184).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CompactSerialization.class, Integer.valueOf(185).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CompactClass.class, Integer.valueOf(186).shortValue());
        FormatterServices.getDefault().registerKnownTypes(BackingSource.class, Integer.valueOf(187).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Readthru.class, Integer.valueOf(188).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Writethru.class, Integer.valueOf(189).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Provider.class, Integer.valueOf(190).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheLoader.class, Integer.valueOf(191).shortValue());
        FormatterServices.getDefault().registerKnownTypes(BridgeConflictResolver.class, Integer.valueOf(171).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Notifications.class, Integer.valueOf(192).shortValue());
        FormatterServices.getDefault().registerKnownTypes(BridgeConfig.class, Integer.valueOf(193).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Cleanup.class, Integer.valueOf(194).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Storage.class, Integer.valueOf(195).shortValue());
        FormatterServices.getDefault().registerKnownTypes(EvictionPolicy.class, Integer.valueOf(196).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Cluster.class, Integer.valueOf(197).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.Dom.Channel.class, Integer.valueOf(198).shortValue());
        FormatterServices.getDefault().registerKnownTypes(NodeIdentity.class, Integer.valueOf(199).shortValue());
        FormatterServices.getDefault().registerKnownTypes(StatusInfo.class, Integer.valueOf(200).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ReplicationStrategy.class, Integer.valueOf(201).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Security.class, Integer.valueOf(202).shortValue());
        FormatterServices.getDefault().registerKnownTypes(AutoLoadBalancing.class, Integer.valueOf(203).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClientNodes.class, Integer.valueOf(204).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClientNode.class, Integer.valueOf(205).shortValue());
        FormatterServices.getDefault().registerKnownTypes(AlertsNotifications.class, Integer.valueOf(206).shortValue());
        FormatterServices.getDefault().registerKnownTypes(EmailNotifications.class, Integer.valueOf(207).shortValue());
        FormatterServices.getDefault().registerKnownTypes(AlertsTypes.class, Integer.valueOf(208).shortValue());
        FormatterServices.getDefault().registerKnownTypes(NotificationRecipient.class, Integer.valueOf(209).shortValue());
        FormatterServices.getDefault().registerKnownTypes(SQLDependencyConfig.class, Integer.valueOf(210).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Encryption.class, Integer.valueOf(211).shortValue());
        FormatterServices.getDefault().registerKnownTypes(TaskConfiguration.class, Integer.valueOf(369).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheRegisterationInfo.class, Integer.valueOf(212).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheStatusOnServerContainer.class, Integer.valueOf(213).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheStatistics.class, Integer.valueOf(65).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClusterCacheStatistics.class, Integer.valueOf(66).shortValue());
        FormatterServices.getDefault().registerKnownTypes(NodeInfo.class, Integer.valueOf(67).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClientConfiguration.class, Integer.valueOf(214).shortValue());
        FormatterServices.getDefault().registerKnownTypes(NodeConfiguration.class, Integer.valueOf(215).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheConfiguration.class, Integer.valueOf(216).shortValue());
        FormatterServices.getDefault().registerKnownTypes(SecurityConfiguration.class, Integer.valueOf(217).shortValue());
        FormatterServices.getDefault().registerKnownTypes(UserCredentials.class, Integer.valueOf(218).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer.class, Integer.valueOf(219).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheInfo.class, Integer.valueOf(220).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Class[].class, Integer.valueOf(249).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClientNodeStatusWrapper.class, Integer.valueOf(250).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Attrib.class, Integer.valueOf(251).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Type[].class, Integer.valueOf(252).shortValue());
        FormatterServices.getDefault().registerKnownTypes(PortableClass.class, Integer.valueOf(253).shortValue());
        FormatterServices.getDefault().registerKnownTypes(PortableClass[].class, Integer.valueOf(254).shortValue());
        FormatterServices.getDefault().registerKnownTypes(AttributeListUnion.class, Integer.valueOf(255).shortValue());
        FormatterServices.getDefault().registerKnownTypes(PortableAttribute.class, Integer.valueOf(256).shortValue());
        FormatterServices.getDefault().registerKnownTypes(PortableAttribute[].class, Integer.valueOf(257).shortValue());
        FormatterServices.getDefault().registerKnownTypes(NewCacheRegisterationInfo.class, Integer.valueOf(541).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClientCacheStatus.class, Integer.valueOf(259).shortValue());
        FormatterServices.getDefault().registerKnownTypes(RtContextValue.class, Integer.valueOf(300).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheDeployment.class, Integer.valueOf(264).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.CacheServerConfig.class, Integer.valueOf(393).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Cluster.class, Integer.valueOf(266).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheServerConfigSetting.class, Integer.valueOf(540).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheTopology.class, Integer.valueOf(268).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Config.NewDom.Channel.class, Integer.valueOf(269).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ServerNode.class, Integer.valueOf(270).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ServersNodes.class, Integer.valueOf(271).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ServerLicenseInfo.class, Integer.valueOf(301).shortValue());
        FormatterServices.getDefault().registerKnownTypes(WriteBehind.class, Integer.valueOf(276).shortValue());
        FormatterServices.getDefault().registerKnownTypes(BatchConfig.class, Integer.valueOf(277).shortValue());
        FormatterServices.getDefault().registerKnownTypes(NewHashmap.class, Integer.valueOf(346).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ExpirationPolicy.class, Integer.valueOf(278).shortValue());
        FormatterServices.getDefault().registerKnownTypes(AbsoluteExpiration.class, Integer.valueOf(279).shortValue());
        FormatterServices.getDefault().registerKnownTypes(SlidingExpiration.class, Integer.valueOf(280).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClientDeathDetection.class, Integer.valueOf(355).shortValue());
        FormatterServices.getDefault().registerKnownTypes(SynchronizationStrategy.class, Integer.valueOf(378).shortValue());
        FormatterServices.getDefault().registerKnownTypes(TagList.class, Integer.valueOf(371).shortValue());
        FormatterServices.getDefault().registerKnownTypes(LoaderTag.class, Integer.valueOf(282).shortValue());
        FormatterServices.getDefault().registerKnownTypes(LoaderTag[].class, Integer.valueOf(373).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClientCacheSettings.class, Integer.valueOf(372).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClientActivityNotification.class, Integer.valueOf(376).shortValue());
        FormatterServices.getDefault().registerKnownTypes(HotConfig.class, Integer.valueOf(347).shortValue());
        FormatterServices.getDefault().registerKnownTypes(LuceneDeployment.class, Integer.valueOf(494).shortValue());
        FormatterServices.getDefault().registerKnownTypes(LuceneDeployment[].class, Integer.valueOf(495).shortValue());
        FormatterServices.getDefault().registerKnownTypes(LuceneDepType.class, Integer.valueOf(496).shortValue());
        FormatterServices.getDefault().registerKnownTypes(LuceneDepType[].class, Integer.valueOf(497).shortValue());
        FormatterServices.getDefault().registerKnownTypes(LuceneSettings.class, Integer.valueOf(498).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Analyzers.class, Integer.valueOf(499).shortValue());
        FormatterServices.getDefault().registerKnownTypes(StopWords.class, Integer.valueOf(500).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Patterns.class, Integer.valueOf(501).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClientMetaData.class, Integer.valueOf(611).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CounterDataCollection.class, Integer.valueOf(604).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CounterMetadata.class, Integer.valueOf(605).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CounterMetadataCollection.class, Integer.valueOf(606).shortValue());
        FormatterServices.getDefault().registerKnownTypes(IntervalCounterDataCollection.class, Integer.valueOf(609).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClientCustomCounters.class, Integer.valueOf(514).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheNodeStatistics.class, Integer.valueOf(221).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Common.Monitoring.ServerNode.class, Integer.valueOf(222).shortValue());
        FormatterServices.getDefault().registerKnownTypes(EventViewerEvent.class, Integer.valueOf(223).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Node.class, Integer.valueOf(224).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Address.class, Integer.valueOf(110).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Common.Monitoring.ClientNode.class, Integer.valueOf(226).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ConfiguredCacheInfo.class, Integer.valueOf(227).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClientProcessStats.class, Integer.valueOf(228).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheNodeStatistics[].class, Integer.valueOf(229).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Common.Monitoring.ServerNode[].class, Integer.valueOf(230).shortValue());
        FormatterServices.getDefault().registerKnownTypes(EventViewerEvent[].class, Integer.valueOf(231).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Node[].class, Integer.valueOf(232).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Address[].class, Integer.valueOf(233).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Alachisoft.NCache.Common.Monitoring.ClientNode[].class, Integer.valueOf(234).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ConfiguredCacheInfo[].class, Integer.valueOf(235).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClientProcessStats[].class, Integer.valueOf(236).shortValue());
        FormatterServices.getDefault().registerKnownTypes(BindedIpMap.class, Integer.valueOf(237).shortValue());
        FormatterServices.getDefault().registerKnownTypes(NodeInfoMap.class, Integer.valueOf(238).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CacheServerList.class, Integer.valueOf(239).shortValue());
        FormatterServices.getDefault().registerKnownTypes(User.class, Integer.valueOf(240).shortValue());
        FormatterServices.getDefault().registerKnownTypes(User[].class, Integer.valueOf(241).shortValue());
        FormatterServices.getDefault().registerKnownTypes(NotificationRecipient[].class, Integer.valueOf(242).shortValue());
        FormatterServices.getDefault().registerKnownTypes(CompactClass[].class, Integer.valueOf(243).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Parameter.class, Integer.valueOf(244).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Parameter[].class, Integer.valueOf(245).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ProviderAssembly.class, Integer.valueOf(246).shortValue());
        FormatterServices.getDefault().registerKnownTypes(ClientNode[].class, Integer.valueOf(247).shortValue());
        FormatterServices.getDefault().registerKnownTypes(Provider[].class, Integer.valueOf(248).shortValue());
        FormatterServices.getDefault().registerKnownTypes(BitSet.class, Integer.valueOf(621).shortValue());
    }

    private static boolean GetLicenseLoggingStatus() {
        String val = ServicePropValues.CacheServer_LicenseLogging;
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)val)) {
            return false;
        }
        boolean result = false;
        RefObject tempRef_result = new RefObject((Object)result);
        boolean tempVar = Boolean.getBoolean(val) ? result : false;
        result = (Boolean)tempRef_result.argvalue;
        return tempVar;
    }

    public static int getSocketServerPort() {
        return _socketServerPort;
    }

    public static void setSocketServerPort(int value) {
        _socketServerPort = value;
    }

    private static void LoadConfiguration() throws ConfigurationException, ManagementException {
        CacheInfo cacheInfo = null;
        try {
            CacheServerConfig[] configs = CacheConfigManager.GetConfiguredCaches();
            for (int i = 0; i < configs.length; ++i) {
                CacheServerConfig config = configs[i];
                String props = CacheServer.GetProps(config);
                cacheInfo = new CacheInfo();
                cacheInfo.setCache(new LeasedCache(props));
                cacheInfo.setCacheProps(config);
                if (cacheInfo.getCache().getStatistics().getClassName().equals("replicated-client") || cacheInfo.getCache().getStatistics().getClassName().equals("partitioned-replicas-client") || cacheInfo.getCache().getStatistics().getClassName().equals("partitioned-client")) continue;
                String cacheId = config.getName().toLowerCase();
                if (!s_caches.containsKey(cacheId)) {
                    s_caches.put(cacheId, cacheInfo);
                    continue;
                }
                cacheInfo = s_caches.get(cacheId) instanceof CacheInfo ? s_caches.get(cacheId) : null;
                cacheInfo.setCacheProps(config);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String GetProps(CacheServerConfig config) {
        HashMap table = ConfigConverter.ToHashMap((CacheServerConfig)config);
        String props = ConfigReader.ToPropertiesString((Map)table);
        return props;
    }

    private static String GetProps(CacheServerConfig[] configs) {
        HashMap table = ConfigConverter.ToHashMap((CacheServerConfig[])configs);
        String props = ConfigReader.ToPropertiesString((Map)table);
        return props;
    }

    private static void SaveConfiguration(CacheServerConfig cacheConfig) throws ManagementException, IllegalArgumentException, IllegalAccessException, Exception {
        try {
            if (s_caches.containsKey(cacheConfig.getName()) || s_caches.containsKey(cacheConfig.getName().toLowerCase())) {
                throw new Exception("Cache with the same name is already registered on the server.");
            }
            CacheConfigManager.SaveConfiguration(s_caches, s_partitionedCaches);
        }
        catch (Exception e) {
            String msg = String.format("Error: %1$s", e.getMessage());
            throw new Exception(msg);
        }
    }

    private static void SaveConfiguration() throws ManagementException, IllegalArgumentException, IllegalAccessException {
        try {
            CacheConfigManager.SaveConfiguration(s_caches, s_partitionedCaches);
        }
        catch (Exception e) {
            String msg = String.format("CacheServer failed to save configuration information, Error %1$s", e.getMessage() + e.getStackTrace());
            EventLogger.LogEvent((String)msg, (EventType)EventType.WARNING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SetWaitOnServiceObject() {
        try {
            Object object = serviceObject;
            synchronized (object) {
                serviceObject.wait();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ReleaseServiceObject() {
        try {
            Object object = serviceObject;
            synchronized (object) {
                serviceObject.notifyAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void callStaticBlock() {
    }

    public static void disposedStaticCall() {
        if (_evalWarningTask != null) {
            try {
                stopEvalWarning = true;
                _evalWarningTask.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (LicenseMonitor.getInstance() != null) {
            LicenseMonitor.getInstance().dispose();
        }
    }

    public void onLicenseExpiration() {
        try {
            this.StopAllCaches(CacheStopReason.Expired);
        }
        catch (Exception ex) {
            Logger.getLogger(CacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public final String getClusterIP() {
        return _clusterIp;
    }

    public final void setClusterIP(String value) {
        _clusterIp = value;
    }

    public final String getLocalCacheIP() {
        return _localCacheIp;
    }

    public final void setLocalCacheIP(String value) {
        _localCacheIp = value;
    }

    protected void finalize() throws Throwable {
        this.dispose(false);
    }

    public Object InitializeLifetimeService() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetMethodAttribute(privateMethod="CopyAssemblies", privateOverload=1)
    public final void CopyAssemblies(String cacheName, String assemblyFileName, byte[] buffer) {
        if (AppUtil.getInstallDir() != null) {
            FileOutputStream fs = null;
            try {
                String path = DirectoryUtil.getDeployedAssemblyFolder();
                new File(path).mkdir();
                String currentCacheFolderPath = Common.combinePath((String)path, (String[])new String[]{cacheName.toLowerCase()});
                new File(currentCacheFolderPath.trim()).mkdir();
                fs = new FileOutputStream(Common.combinePath((String)currentCacheFolderPath, (String[])new String[]{assemblyFileName}));
                fs.write(buffer, 0, buffer.length);
                fs.flush();
            }
            catch (Exception exception) {
            }
            finally {
                if (fs != null) {
                    fs = null;
                }
            }
        }
    }

    @Override
    @TargetMethodAttribute(privateMethod="CopyBridgeAssemblies", privateOverload=1)
    public final void CopyBridgeAssemblies(String bridgeName, String assemblyFileName, byte[] buffer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetMethodAttribute(privateMethod="GetAssembly", privateOverload=1)
    public final byte[] GetAssembly(String cacheName, String fileName) throws IOException {
        byte[] asmData = null;
        if (AppUtil.getInstallDir() != null) {
            InputStream fs = null;
            try {
                String path = AppUtil.DeployedAssemblyDir + cacheName.toLowerCase() + "\\" + fileName;
                fs = new FileInputStream(path);
                asmData = new byte[fs.available()];
                fs.read(asmData, 0, asmData.length);
            }
            catch (Exception e) {
                byte[] byArray = asmData;
                return byArray;
            }
            finally {
                if (fs != null) {
                    fs.close();
                    fs = null;
                }
            }
        }
        return asmData;
    }

    private void StartGCTask() {
        boolean enabled = true;
        RefObject tempRef_enabled = new RefObject((Object)enabled);
        tempRef_enabled.argvalue = Boolean.getBoolean(ServicePropValues.CacheServer_EnableForcedGC);
        enabled = (Boolean)tempRef_enabled.argvalue;
        if (enabled) {
            int threshold = 0;
            RefObject tempRef_threshold = new RefObject((Object)threshold);
            boolean tempVar = Boolean.getBoolean(ServicePropValues.CacheServer_ForcedGCThreshold);
            threshold = (Integer)tempRef_threshold.argvalue;
            if (tempVar) {
                this._gcScheduler.AddTask(new TimeScheduler.Task(){

                    public boolean IsCancelled() {
                        return false;
                    }

                    public long GetNextInterval() {
                        return 43200000L;
                    }

                    public void Run() {
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(boolean disposing) {
        this._rwLock.AcquireWriterLock();
        try {
            for (CacheInfo cacheInfo : s_caches.values()) {
                try {
                    if (cacheInfo == null || cacheInfo.getCache() == null) continue;
                    cacheInfo.getCache().StopInstance(false);
                }
                catch (Exception exception) {}
            }
            Iterator it = s_partitionedCaches.values().iterator();
            while (it.hasNext()) {
                HashMap partitionedTable = (HashMap)it.next();
                Iterator its = partitionedTable.values().iterator();
                while (it.hasNext()) {
                    CacheInfo cacheInfo = (CacheInfo)its.next();
                    try {
                        if (cacheInfo == null || cacheInfo.getCache() == null) continue;
                        cacheInfo.getCache().StopInstance(false);
                    }
                    catch (Exception exception) {}
                }
            }
            if (_evalWarningTask != null) {
                try {
                    stopEvalWarning = true;
                    _evalWarningTask.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this._gcScheduler != null) {
                TimeScheduler timeScheduler = this._gcScheduler;
                synchronized (timeScheduler) {
                    if (this._gcScheduler != null) {
                        try {
                            this._gcScheduler.Stop();
                            this._gcScheduler.dispose();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (LicenseMonitor.getInstance() != null) {
                LicenseMonitor.getInstance().dispose();
            }
        }
        finally {
            this._rwLock.ReleaseWriterLock();
        }
        if (disposing) {
            System.gc();
        }
    }

    public final void dispose() {
        this.dispose(true);
    }

    @Override
    @TargetMethodAttribute(privateMethod="ClearCache", privateOverload=1)
    public final void ClearCache(String cacheId) throws OperationFailedException {
        this.ClearCacheContent(cacheId);
    }

    public final LicenseLogger getLicenseLogger() {
        return licenseLogger;
    }

    @TargetMethodAttribute(privateMethod="GetLicenseLogger", privateOverload=1)
    public final LicenseLogger GetLicenseLogger() {
        return licenseLogger;
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetLicenses", privateOverload=1)
    public final LicenseInfo[] GetLicenses() {
        return licenseLogger.getLicenses();
    }

    public final String getLicenseKey() {
        return new String();
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetLicenseKey", privateOverload=1)
    public final String GetLicenseKey() {
        return new String();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Cache getItem(String cacheId) {
        if (cacheId == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cacheId");
        }
        this._rwLock.AcquireReaderLock();
        try {
            if (s_caches.containsKey(cacheId.toLowerCase())) {
                CacheInfo cacheInfo = (CacheInfo)s_caches.get(cacheId.toLowerCase());
                if (cacheInfo != null) {
                    LeasedCache leasedCache = cacheInfo.getCache();
                    return leasedCache;
                }
            } else if (s_partitionedCaches.containsKey(cacheId.toLowerCase())) {
                HashMap partitionedTable = s_partitionedCaches.get(cacheId.toLowerCase()) instanceof HashMap ? s_partitionedCaches.get(cacheId.toLowerCase()) : null;
                Iterator ide = partitionedTable.entrySet().iterator();
                LeasedCache stoppedCache = null;
                while (ide.hasNext()) {
                    Map.Entry current = ide.next();
                    CacheInfo cacheInfo = current.getValue() instanceof CacheInfo ? current.getValue() : null;
                    if (cacheInfo == null) continue;
                    LeasedCache cache = cacheInfo.getCache();
                    if (cache.getIsRunning()) {
                        LeasedCache leasedCache = cacheInfo.getCache();
                        return leasedCache;
                    }
                    if (stoppedCache != null) continue;
                    stoppedCache = cacheInfo.getCache();
                }
                LeasedCache leasedCache = stoppedCache;
                return leasedCache;
            }
            Cache cache = null;
            return cache;
        }
        finally {
            this._rwLock.ReleaseReaderLock();
        }
    }

    @Override
    @TargetMethodAttribute(privateMethod="Authorize", privateOverload=1)
    public final boolean Authorize(byte[] userId, byte[] password) {
        return NodeSecurityProvider.getNodeSecurity().Authorize(this.Decrypt(userId), this.Decrypt(password), null) || this.VerifySystemAdministrator(this.Decrypt(userId), this.Decrypt(password));
    }

    @TargetMethodAttribute(privateMethod="GetTayzGridServer", privateOverload=1)
    public final boolean IsTayzGridServer() {
        return true;
    }

    @Override
    @TargetMethodAttribute(privateMethod="IsSecurityEnabled", privateOverload=1)
    public final boolean IsSecurityEnabled() {
        return CacheXMLAuthorizationProvider.isSecurityEnabled();
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetSecurityMap", privateOverload=1)
    public final HashMap GetSecurityMap() {
        return CacheXMLAuthorizationProvider.getSecurityMap();
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetRunningCaches", privateOverload=2)
    public final ArrayList GetRunningCaches(String userId, String password) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        return this.GetRunningCaches(EncryptionUtil.Encrypt((String)userId), EncryptionUtil.Encrypt((String)password));
    }

    @TargetMethodAttribute(privateMethod="GetRunningCaches", privateOverload=3)
    private ArrayList GetRunningCaches(byte[] userId, byte[] password) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException {
        ArrayList runningCache = new ArrayList(5);
        Map coll = this.GetCacheProps(userId, password);
        for (Map.Entry entry : coll.entrySet()) {
            Cache instance;
            Cache instance2;
            CacheServerConfig config;
            if (entry.getValue() instanceof CacheServerConfig && ((config = (CacheServerConfig)entry.getValue()).getCacheType().equals("local-cache") || config.getCacheType().equals("clustered-cache")) && (instance2 = this.GetCacheInstance((String)entry.getKey(), userId, password)) != null && instance2.getIsRunning()) {
                runningCache.add(entry.getKey());
            }
            if (!(entry.getValue() instanceof String) || ((String)entry.getValue()).indexOf("local-cache", 0) == -1 && ((String)entry.getValue()).indexOf("clustered-cache", 0) == -1 || (instance = this.GetCacheInstance((String)entry.getKey(), userId, password)) == null || !instance.getIsRunning()) continue;
            runningCache.add(entry.getKey());
        }
        return runningCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetMethodAttribute(privateMethod="GetCacheInstance", privateOverload=1)
    public final Cache GetCacheInstance(String cacheId, String partitionId) {
        if (partitionId == null || partitionId.equals("")) {
            return this.getItem(cacheId);
        }
        if (cacheId == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cacheId");
        }
        this._rwLock.AcquireReaderLock();
        try {
            HashMap partitionTable = s_partitionedCaches.get(cacheId.toLowerCase()) instanceof HashMap ? s_partitionedCaches.get(cacheId.toLowerCase()) : null;
            if (partitionTable != null) {
                CacheInfo cacheInfo = (CacheInfo)partitionTable.get(partitionId.toLowerCase());
                if (cacheInfo != null) {
                    LeasedCache leasedCache = cacheInfo.getCache();
                    return leasedCache;
                }
                Cache cache = null;
                return cache;
            }
        }
        finally {
            this._rwLock.ReleaseReaderLock();
        }
        return null;
    }

    @TargetMethodAttribute(privateMethod="GetCacheInstance", privateOverload=2)
    public final Cache GetCacheInstance(String cacheId, byte[] userId, byte[] password) {
        return this.getItem(cacheId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetMethodAttribute(privateMethod="GetCacheInstance", privateOverload=3)
    public final Cache GetCacheInstance(String cacheId, String partitionId, byte[] userId, byte[] password) throws SecurityException {
        boolean isAuthorized;
        Cache returnCache = null;
        if (partitionId == null || partitionId.equals("")) {
            returnCache = this.getItem(cacheId);
        } else {
            if (cacheId == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cacheId");
            }
            this._rwLock.AcquireReaderLock();
            try {
                CacheInfo cacheInfo;
                HashMap partitionTable = s_partitionedCaches.get(cacheId.toLowerCase()) instanceof HashMap ? s_partitionedCaches.get(cacheId.toLowerCase()) : null;
                if (partitionTable != null && (cacheInfo = (CacheInfo)partitionTable.get(partitionId.toLowerCase())) != null) {
                    returnCache = cacheInfo.getCache();
                }
            }
            finally {
                this._rwLock.ReleaseReaderLock();
            }
        }
        if (LicenseManager.isEnterprise() && returnCache != null && returnCache.getIsRunning() && !(isAuthorized = returnCache.CacheSecurityProvider.Authorize(this.Decrypt(userId), this.Decrypt(password), cacheId))) {
            throw new SecurityException("You do not have permissions to perform this operation");
        }
        return returnCache;
    }

    @TargetMethodAttribute(privateMethod="GetCacheInstanceIgnoreReplica", privateOverload=1)
    public final Cache GetCacheInstanceIgnoreReplica(String cacheId, byte[] userId, byte[] password) throws IllegalArgumentException, SecurityException {
        return this.GetCacheInstanceIgnoreReplica(cacheId, this.Decrypt(userId), this.Decrypt(password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetMethodAttribute(privateMethod="GetCacheInstanceIgnoreReplica", privateOverload=2)
    public final Cache GetCacheInstanceIgnoreReplica(String cacheId, String userId, String password) throws IllegalArgumentException, SecurityException {
        LeasedCache cache;
        block16: {
            if (userId != null && userId.equals("")) {
                userId = null;
            }
            if (password != null && password.equals("")) {
                password = null;
            }
            if (cacheId == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cacheId");
            }
            cacheId = cacheId.toLowerCase();
            Boolean isLockAcquired = false;
            if (!this._rwLock.IsWriterLockHeld()) {
                this._rwLock.AcquireReaderLock();
                isLockAcquired = true;
            }
            cache = null;
            try {
                HashMap partitionedTable;
                if (s_caches.containsKey(cacheId)) {
                    CacheInfo cacheInfo = (CacheInfo)s_caches.get(cacheId);
                    if (cacheInfo != null) {
                        cache = cacheInfo.getCache();
                    }
                    if (cache != null && cache.getIsRunning()) {
                        LeasedCache leasedCache = cache;
                        return leasedCache;
                    }
                    break block16;
                }
                if (!s_partitionedCaches.containsKey(cacheId) || (partitionedTable = (HashMap)(s_partitionedCaches.get(cacheId) instanceof HashMap ? s_partitionedCaches.get(cacheId) : null)) == null) break block16;
                for (Map.Entry current : partitionedTable.entrySet()) {
                    CacheInfo cacheInfo = current.getValue() instanceof CacheInfo ? current.getValue() : null;
                    if (cacheInfo != null) {
                        cache = cacheInfo.getCache();
                    }
                    if (cache == null || !cache.getIsRunning()) continue;
                    LeasedCache leasedCache = cache;
                    return leasedCache;
                }
            }
            finally {
                boolean isAuthorized;
                if (isLockAcquired.booleanValue()) {
                    this._rwLock.ReleaseReaderLock();
                }
                if (LicenseManager.isEnterprise() && cache != null && cache.getIsRunning() && !(isAuthorized = cache.CacheSecurityProvider.Authorize(userId, password, cacheId))) {
                    throw new SecurityException("You do not have permissions to perform this operation");
                }
            }
        }
        return cache;
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetCacheProps", privateOverload=1)
    public final Map GetCacheProps(byte[] userId, byte[] password) throws SecurityException {
        if (!NodeSecurityProvider.getNodeSecurity().Authorize(this.Decrypt(userId), this.Decrypt(password), null) && !this.VerifySystemAdministrator(this.Decrypt(userId), this.Decrypt(password))) {
            throw new SecurityException("You do not have permissions to perform this operation");
        }
        return this.getCacheProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map getCacheProps() {
        HashMap<String, Object> cacheProps = new HashMap<String, Object>();
        this._rwLock.AcquireReaderLock();
        try {
            for (Map.Entry current : s_caches.entrySet()) {
                CacheInfo cacheInfo = (CacheInfo)current.getValue();
                cacheProps.put(cacheInfo.getCache().getName(), cacheInfo.getCacheProps());
            }
            for (Map.Entry current : s_partitionedCaches.entrySet()) {
                String cacheName = current.getKey() instanceof String ? current.getKey() : null;
                HashMap tbl = new HashMap();
                HashMap partitionedTable = current.getValue() instanceof HashMap ? current.getValue() : null;
                cacheProps.put(cacheName, tbl);
                for (Map.Entry subCurrent : partitionedTable.entrySet()) {
                    CacheInfo cacheInfo = (CacheInfo)Common.readAs(subCurrent.getValue(), CacheInfo.class);
                    tbl.put(subCurrent.getKey(), cacheInfo.getCacheProps());
                }
            }
            HashMap<String, Object> hashMap = cacheProps;
            return hashMap;
        }
        finally {
            this._rwLock.ReleaseReaderLock();
        }
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetCacheConfiguration", privateOverload=1)
    public final CacheServerConfig GetCacheConfiguration(String cacheId) {
        CacheInfo cacheInfo = this.GetCacheInfo(cacheId);
        CacheServerConfig config = null;
        if (cacheInfo != null) {
            config = cacheInfo.getCacheProps();
        }
        return config;
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetNewConfiguration", privateOverload=1)
    public final Alachisoft.NCache.Config.NewDom.CacheServerConfig GetNewConfiguration(String cacheId) throws Exception {
        CacheInfo cacheInfo = this.GetCacheInfo(cacheId);
        CacheServerConfig config = null;
        if (cacheInfo != null) {
            config = cacheInfo.getCacheProps();
            return DomHelper.convertToNewDom((CacheServerConfig)config);
        }
        return null;
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetCacheInfo", privateOverload=1)
    public final CacheInfo GetCacheInfo(String cacheId) {
        CacheInfo cacheInfo;
        block2: {
            Map.Entry de;
            HashMap partitionedTable;
            block1: {
                cacheInfo = null;
                if (!s_caches.containsKey(cacheId.toLowerCase())) break block1;
                cacheInfo = s_caches.get(cacheId.toLowerCase()) instanceof CacheInfo ? s_caches.get(cacheId.toLowerCase()) : null;
                break block2;
            }
            if (!s_partitionedCaches.containsKey(cacheId.toLowerCase()) || (partitionedTable = (HashMap)(s_partitionedCaches.get(cacheId.toLowerCase()) instanceof HashMap ? s_partitionedCaches.get(cacheId.toLowerCase()) : null)) == null) break block2;
            Iterator it = partitionedTable.entrySet().iterator();
            while (it.hasNext() && (cacheInfo = (CacheInfo)((de = it.next()).getValue() instanceof CacheInfo ? de.getValue() : null)) == null) {
            }
        }
        return cacheInfo;
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetHostName", privateOverload=1)
    public final String GetHostName() throws UnknownHostException {
        String localhost = InetAddress.getLocalHost().getHostName();
        return localhost;
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetUpdatedCacheConfiguration", privateOverload=1)
    public final CacheRegisterationInfo GetUpdatedCacheConfiguration(String cacheId, String partId, String newNode, boolean isJoining) throws ManagementException, Exception {
        CacheServerConfig config = null;
        ArrayList affectedNodes = new ArrayList();
        ArrayList affectedPartitions = new ArrayList();
        RefObject tempRef_affectedNodes = new RefObject(affectedNodes);
        config = CacheConfigManager.GetUpdatedCacheConfig(cacheId, partId, newNode, (RefObject<ArrayList>)tempRef_affectedNodes, isJoining);
        affectedNodes = (ArrayList)tempRef_affectedNodes.argvalue;
        return new CacheRegisterationInfo(config, affectedNodes, affectedPartitions);
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetNewUpdatedCacheConfiguration", privateOverload=1)
    public NewCacheRegisterationInfo GetNewUpdatedCacheConfiguration(String cacheId, String partId, String newNode, boolean isJoining) throws ManagementException, Exception {
        CacheRegisterationInfo oldCacheInfo = this.GetUpdatedCacheConfiguration(cacheId, partId, newNode, isJoining);
        Alachisoft.NCache.Config.NewDom.CacheServerConfig newDom = DomHelper.convertToNewDom((CacheServerConfig)oldCacheInfo.getUpdatedCacheConfig());
        NewCacheRegisterationInfo newCacheInfo = new NewCacheRegisterationInfo(newDom, oldCacheInfo.getAffectedNodes(), oldCacheInfo.getAffectedPartitions());
        return newCacheInfo;
    }

    public final CacheRenderer getRenderer() {
        return this._renderer;
    }

    public final void setRenderer(CacheRenderer value) {
        this._renderer = value;
    }

    @TargetMethodAttribute(privateMethod="GetCacheRenderer", privateOverload=1)
    public final CacheRenderer GetCacheRenderer() {
        return this._renderer;
    }

    @Override
    @TargetMethodAttribute(privateMethod="RegisterCache", privateOverload=1)
    public final boolean RegisterCache(String cacheId, CacheServerConfig config, String partId, boolean overwrite, byte[] userId, byte[] password, boolean hotApply) throws ConfigurationException, UnknownHostException, ManagementException, Exception, SecurityException {
        if (cacheId == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cacheId");
        }
        if (!NodeSecurityProvider.getNodeSecurity().Authorize(this.Decrypt(userId), this.Decrypt(password), null) && !this.VerifySystemAdministrator(this.Decrypt(userId), this.Decrypt(password))) {
            throw new SecurityException("You do not have permissions to perform this operation");
        }
        cacheId = cacheId.toLowerCase();
        CacheInfo cacheInfo = null;
        this._rwLock.AcquireWriterLock();
        try {
            if (s_partitionedCaches.containsKey(cacheId.toLowerCase())) {
                throw new ManagementException("A cache with same cacheId already exists");
            }
            if (s_caches.containsKey(cacheId.toLowerCase())) {
                if (!overwrite) {
                    boolean bl = false;
                    return bl;
                }
                cacheInfo = (CacheInfo)s_caches.get(cacheId.toLowerCase());
            } else {
                String props = CacheServer.GetProps(config);
                ClientConfigManager.setLocalCacheId(this.getLocalCacheIP());
                ClientConfigManager.AddCache(cacheId, config.getRuntimeContext());
                cacheInfo = new CacheInfo();
                cacheInfo.setCache(new LeasedCache(props));
                s_caches.put(cacheId.toLowerCase(), cacheInfo);
            }
            cacheInfo.setCacheProps(config);
            if (hotApply && cacheInfo != null && cacheInfo.getCache() != null && cacheInfo.getCache().getIsRunning()) {
                CacheConfig cc = CacheConfig.FromConfiguration(config);
                HotConfig hotConfig = new HotConfig();
                hotConfig.set_isErrorLogsEnabled(cc.getIsErrorLogsEnabled());
                hotConfig.set_isDetailedLogsEnabled(cc.getIsDetailedLogsEnabled());
                hotConfig.set_cacheMaxSize(cc.getCacheMaxSize());
                hotConfig.set_cleanInterval(cc.getCleanInterval());
                hotConfig.set_evictRatio(cc.getEvictRatio());
                cacheInfo.getCache().ApplyHotConfiguration(hotConfig);
            }
            CacheServer.SaveConfiguration();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this._rwLock.ReleaseWriterLock();
        }
        return true;
    }

    @Override
    @TargetMethodAttribute(privateMethod="RegisterCache", privateOverload=2)
    public final boolean RegisterCache(String cacheId, Alachisoft.NCache.Config.NewDom.CacheServerConfig config, String partId, boolean overwrite, byte[] userId, byte[] password, boolean hotApply) throws ConfigurationException, UnknownHostException, ManagementException, Exception, SecurityException {
        CacheServerConfig oldDom = DomHelper.convertToOldDom((Alachisoft.NCache.Config.NewDom.CacheServerConfig)config);
        return this.RegisterCache(cacheId, oldDom, partId, overwrite, userId, password, hotApply);
    }

    private String GetChangedConfigForTemp(String cacheId, String oldProps, String updatedProps) {
        PropsConfigReader pcr;
        HashMap cacheConfig;
        if (oldProps != null && (cacheConfig = (pcr = new PropsConfigReader(oldProps)).getProperties()) != null) {
            HashMap<String, HashMap> configTable = new HashMap<String, HashMap>();
            cacheConfig.put("id", cacheId);
            configTable.put("configuration", cacheConfig);
            CacheServerConfig[] configDomList = ConfigConverter.ToDom(configTable);
            if (configDomList != null && configDomList.length > 0) {
                CacheServerConfig oldConfig;
                CacheServerConfig tempVar = configDomList[0];
                Object object = oldConfig = tempVar instanceof CacheServerConfig ? tempVar : null;
                if (oldConfig != null && oldConfig.getCluster() != null && oldConfig.getCluster().getChannel() != null && oldConfig.getCluster().getChannel() != null) {
                    int retries = oldConfig.getCluster().getChannel().getConnectionRetries();
                    int retryInterval = oldConfig.getCluster().getChannel().getConnectionRetryInterval();
                    int indexOfTcpConfig = updatedProps.toLowerCase().indexOf("tcp(");
                    if (indexOfTcpConfig > -1) {
                        String str = "connection_retries=" + retries + ";connection_retry_interval=" + retryInterval + ";";
                        updatedProps = new StringBuffer(updatedProps).insert(indexOfTcpConfig + 4, str).toString();
                    }
                }
            }
        }
        return updatedProps;
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetNodeInfo", privateOverload=1)
    public final NodeInfoMap GetNodeInfo() {
        HashMap<Channel, String> nodeInfo = new HashMap<Channel, String>();
        nodeInfo.put(Channel.Cluster, this.getClusterIP());
        nodeInfo.put(Channel.SocketServer, ClientConfigManager.getBindIP());
        return new NodeInfoMap(nodeInfo);
    }

    @Override
    @TargetMethodAttribute(privateMethod="CanApplyHotConfig", privateOverload=1)
    public final String CanApplyHotConfiguration(String cacheId, CacheServerConfig config) {
        Exception e = this.CanApplyHotConfig(cacheId, config);
        if (e != null) {
            return e.getMessage();
        }
        return null;
    }

    public final Exception CanApplyHotConfig(String cacheId, CacheServerConfig config) {
        CacheInfo cacheInfo = null;
        cacheId = cacheId.toLowerCase();
        HashMap result = new HashMap();
        HotConfig hotConfig = new HotConfig();
        if (s_caches.containsKey(cacheId)) {
            cacheInfo = (CacheInfo)s_caches.get(cacheId);
            return cacheInfo.getCache().CanApplyHotConfig(hotConfig);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection getCaches() {
        ArrayList<LeasedCache> caches = new ArrayList<LeasedCache>();
        this._rwLock.AcquireReaderLock();
        try {
            for (Map.Entry current : s_caches.entrySet()) {
                CacheInfo cacheInfo = (CacheInfo)current.getValue();
                caches.add(cacheInfo.getCache());
            }
            ArrayList<LeasedCache> arrayList = caches;
            return arrayList;
        }
        finally {
            this._rwLock.ReleaseReaderLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map getPartitionedReplicaCaches() {
        HashMap caches = new HashMap();
        HashMap<String, LeasedCache> tmp = null;
        this._rwLock.AcquireReaderLock();
        try {
            for (Map.Entry current : s_partitionedCaches.entrySet()) {
                HashMap partitionedCaches;
                String cacheId = current.getKey() instanceof String ? current.getKey() : null;
                if (!caches.containsKey(cacheId.toLowerCase())) {
                    tmp = new HashMap<String, LeasedCache>();
                    caches.put(cacheId.toLowerCase(), tmp);
                }
                if ((partitionedCaches = (HashMap)(current.getValue() instanceof HashMap ? current.getValue() : null)) == null) continue;
                for (Map.Entry de : partitionedCaches.entrySet()) {
                    String partId = de.getKey() instanceof String ? de.getKey() : null;
                    CacheInfo cacheInfo = (CacheInfo)de.getValue();
                    if (tmp == null) continue;
                    tmp.put(partId, cacheInfo.getCache());
                }
            }
            HashMap hashMap = caches;
            return hashMap;
        }
        finally {
            this._rwLock.ReleaseReaderLock();
        }
    }

    @Override
    @TargetMethodAttribute(privateMethod="RemoveCacheServerFromClientConfig", privateOverload=1)
    public final void RemoveCacheServerFromClientConfig(String cacheId, String serverName) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.RemoveCacheServer(cacheId, serverName);
    }

    @Override
    @TargetMethodAttribute(privateMethod="RemoveCacheFromClientConfig", privateOverload=1)
    public final void RemoveCacheFromClientConfig(String cacheId) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.RemoveCache(cacheId);
    }

    @Override
    @TargetMethodAttribute(privateMethod="UpdateClientServersList", privateOverload=1)
    public final void UpdateClientServersList(String cacheId, CacheServerList serversPriorityList, String serverRuntimeContext) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.UpdateServerNodes(cacheId, serversPriorityList, serverRuntimeContext.equals("1") ? RtContextValue.JVCACHE : RtContextValue.NCACHE);
    }

    @Override
    @TargetMethodAttribute(privateMethod="UpdateClientServersList", privateOverload=2)
    public final void UpdateClientServersList(String cacheId, String[] servers, RefObject<String> xml, String clientCacheId, boolean loadBalance) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.UpdateServerNodes(cacheId, servers, xml, clientCacheId, loadBalance);
    }

    @Override
    @TargetMethodAttribute(privateMethod="UpdateSecurity", privateOverload=1)
    public final void UpdateSecurity(boolean enabled, HashMap newSecurityMap, String ldap, String ldapPort) {
        SecurityConfigManager.UpdateSecurity(enabled, newSecurityMap, ldap, ldapPort);
    }

    @Override
    @TargetMethodAttribute(privateMethod="UpdateUserSecurityCredentials", privateOverload=1)
    public final void UpdateUserSecurityCredentials(String cacheId, String[] users, String[] passwords) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.UpdateUserSecurityCredentials(cacheId, users, passwords);
    }

    @Override
    public final void GetUserSecurityCredentials(String cacheId, RefObject<String[]> users, RefObject<String[]> passwords) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.GetUserSecurityCredentials(cacheId, users, passwords);
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetUserSecurityCredentials", privateOverload=1)
    public final Object[] GetUserSecurityCredentials(String cacheId) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        Object[] credenials = new Object[2];
        String[] users = null;
        String[] password = null;
        RefObject tempRef_users = new RefObject(users);
        RefObject tempRef_password = new RefObject(password);
        this.GetUserSecurityCredentials(cacheId, (RefObject<String[]>)tempRef_users, (RefObject<String[]>)tempRef_password);
        users = (String[])tempRef_users.argvalue;
        password = (String[])tempRef_password.argvalue;
        credenials[0] = users;
        credenials[1] = password;
        return credenials;
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetClientConfiguration", privateOverload=1)
    public final ClientConfiguration GetClientConfiguration(String cacheId) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        return ClientConfigManager.GetClientConfiguration(cacheId);
    }

    @Override
    @TargetMethodAttribute(privateMethod="UpdateClientConfiguration", privateOverload=1)
    public final void UpdateClientConfiguration(String cacheId, ClientConfiguration configuration) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        ClientConfigManager.UpdateCacheConfiguration(cacheId, configuration);
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetBindIP", privateOverload=1)
    public final String GetBindIP() {
        return ClientConfigManager.getBindIP();
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetClientConfigId", privateOverload=1)
    public final int GetClientConfigId() throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        return ClientConfigManager.GetConfigurationId();
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetClientNodeStatus", privateOverload=1)
    public final ClientNodeStatusWrapper GetClientNodeStatus(String cacheId) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException {
        StatusInfo statusInfo;
        String clientCacheId = "";
        RefObject tempRef_clientCacheId = new RefObject((Object)clientCacheId);
        ClientNodeStatus status = ClientConfigManager.GetClientNodeStatus(cacheId, (RefObject<String>)tempRef_clientCacheId);
        clientCacheId = (String)tempRef_clientCacheId.argvalue;
        if (status == ClientNodeStatus.ClientCacheUnavailable) {
            statusInfo = this.GetCacheStatus(clientCacheId, null);
            if (statusInfo.getIsRunning()) {
                status = ClientNodeStatus.ClientCacheDisabled;
            }
        } else if (status == ClientNodeStatus.ClientCacheDisabled) {
            statusInfo = this.GetCacheStatus(clientCacheId, null);
            if (statusInfo.getIsRunning()) {
                status = ClientNodeStatus.ClientCacheEnabled;
            } else if (statusInfo.getIsUnavailable()) {
                status = ClientNodeStatus.ClientCacheUnavailable;
            }
        }
        ClientNodeStatusWrapper nodeStatus = new ClientNodeStatusWrapper();
        nodeStatus.value = status;
        return nodeStatus;
    }

    @TargetMethodAttribute(privateMethod="EnableLogging", privateOverload=1)
    public final void EnableLogging(LoggingInfo.LoggingSubsystem subsystem, LoggingInfo.LoggingType type) throws Exception {
        try {
            this._renderer.SetLoggingStatus(subsystem, type, LoggingInfo.LogsStatus.Enable);
            EventLogger.LogEvent((String)"NCache", (String)(subsystem.toString() + " logging enabled successfully"), (EventType)EventType.INFORMATION, (short)3, (int)1014);
        }
        catch (Exception exc) {
            EventLogger.LogEvent((String)"NCache", (String)exc.toString(), (EventType)EventType.ERROR, (short)1, (int)1017);
            throw exc;
        }
    }

    private boolean VerifySystemAdministrator(String userName, String password) {
        return true;
    }

    @Override
    @TargetMethodAttribute(privateMethod="VerifyWindowsUser", privateOverload=1)
    public final boolean VerifyWindowsUser(String nodeName, String userName, String password) {
        throw new UnsupportedOperationException("Security not supported yet.");
    }

    @Override
    @TargetMethodAttribute(privateMethod="VerfyAdministrator", privateOverload=1)
    public final boolean VerfyAdministrator(String userName, String password) {
        throw new UnsupportedOperationException("Security not supported yet.");
    }

    @Override
    @TargetMethodAttribute(privateMethod="VerifyNodeAdministrator", privateOverload=1)
    public final boolean VerifyNodeAdministrator(String userName, String password) {
        return NodeSecurityProvider.getNodeSecurity().Authorize(userName, password, null);
    }

    @Override
    @TargetMethodAttribute(privateMethod="DisableLogging", privateOverload=1)
    public final void DisableLogging(LoggingInfo.LoggingSubsystem subsystem, LoggingInfo.LoggingType type) throws Exception {
        try {
            this._renderer.SetLoggingStatus(subsystem, type, LoggingInfo.LogsStatus.Disable);
            EventLogger.LogEvent((String)"NCache", (String)(subsystem.toString() + " logging disabled successfully"), (EventType)EventType.INFORMATION, (short)3, (int)1015);
        }
        catch (Exception exc) {
            EventLogger.LogEvent((String)"NCache", (String)exc.toString(), (EventType)EventType.ERROR, (short)1, (int)1017);
            throw exc;
        }
    }

    @Override
    @TargetMethodAttribute(privateMethod="SynchronizeClientConfig", privateOverload=1)
    public final void SynchronizeClientConfig() throws UnknownHostException, ManagementException {
        String bindIP = ServicePropValues.BIND_toClient_IP;
        Object ipAddr = null;
        if (bindIP != null && !bindIP.equals("")) {
            try {
                String[] str = bindIP.split("\\.");
                byte[] bite = new byte[]{new Integer(str[0]).byteValue(), new Integer(str[1]).byteValue(), new Integer(str[2]).byteValue(), new Integer(str[3]).byteValue()};
                InetAddress.getByAddress(bite);
            }
            catch (Exception e) {
                bindIP = InetAddress.getLocalHost().getHostName().toLowerCase();
            }
        } else {
            bindIP = InetAddress.getLocalHost().getHostName().toLowerCase();
        }
        _clientserverip = bindIP;
        ClientConfigManager.setBindIP(bindIP);
        ClientConfigManager.AvailableNIC(this.DetectNICs());
        try {
            ClientConfigManager.LoadConfiguration();
        }
        catch (Exception parserConfigurationException) {
            throw new ManagementException(parserConfigurationException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetMethodAttribute(privateMethod="ApplyCacheConfiguration", privateOverload=1)
    public final boolean ApplyCacheConfiguration(String cacheId, CacheServerConfig props, byte[] userId, byte[] password, boolean hotApply) throws ManagementException, IllegalArgumentException, IllegalAccessException, SecurityException {
        if (cacheId == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cacheId");
        }
        if (!NodeSecurityProvider.getNodeSecurity().Authorize(this.Decrypt(userId), this.Decrypt(password), null) && !this.VerifySystemAdministrator(this.Decrypt(userId), this.Decrypt(password))) {
            throw new SecurityException("You do not have permissions to perform this operation");
        }
        if (s_caches.containsKey(cacheId = cacheId.toLowerCase())) {
            this._rwLock.AcquireWriterLock();
            try {
                CacheInfo cacheInfo = (CacheInfo)s_caches.get(cacheId.toLowerCase());
                if (cacheInfo != null) {
                    cacheInfo.setCacheProps(props);
                    CacheServer.SaveConfiguration();
                }
            }
            finally {
                this._rwLock.ReleaseWriterLock();
            }
            return true;
        }
        return false;
    }

    @Override
    @TargetMethodAttribute(privateMethod="ApplyCacheConfiguration", privateOverload=2)
    public final boolean ApplyCacheConfiguration(String cacheId, Alachisoft.NCache.Config.NewDom.CacheServerConfig props, byte[] userId, byte[] password, boolean hotApply) throws ManagementException, IllegalArgumentException, IllegalAccessException, SecurityException, Exception {
        CacheServerConfig oldDom = DomHelper.convertToOldDom((Alachisoft.NCache.Config.NewDom.CacheServerConfig)props);
        return this.ApplyCacheConfiguration(cacheId, oldDom, userId, password, hotApply);
    }

    private boolean RemoveDeployedAssemblies(String cacheId) {
        String path = AppUtil.getInstallDir();
        if (path != null) {
            String deployedAssembliesFolder = new File(AppUtil.DeployedAssemblyDir, cacheId.toLowerCase()).getPath();
            try {
                new File(deployedAssembliesFolder).delete();
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetMethodAttribute(privateMethod="UnregisterCache", privateOverload=1)
    public final void UnregisterCache(String cacheId, String partId, byte[] userId, byte[] password, Boolean isGracefulShutdown, Boolean removeServerOnly) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, Exception, SecurityException {
        if (cacheId == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cacheId");
        }
        if (!NodeSecurityProvider.getNodeSecurity().Authorize(this.Decrypt(userId), this.Decrypt(password), null) && !this.VerifySystemAdministrator(this.Decrypt(userId), this.Decrypt(password))) {
            throw new SecurityException("You do not have permissions to perform this operation");
        }
        cacheId = cacheId.toLowerCase();
        this._rwLock.AcquireWriterLock();
        try {
            if (s_caches.containsKey(cacheId.toLowerCase())) {
                this.RemoveClientCacheConfiguration(cacheId.toLowerCase(), removeServerOnly);
                this.StopCache(cacheId, userId, password, isGracefulShutdown);
                CacheInfo cacheInfo = (CacheInfo)s_caches.get(cacheId.toLowerCase());
                LeasedCache cache = null;
                if (cacheInfo != null) {
                    cache = cacheInfo.getCache();
                }
                if (cache != null) {
                    cache.dispose();
                }
                s_caches.remove(cacheId);
                this.RemoveDeployedAssemblies(cacheId);
            } else if (s_partitionedCaches.containsKey(cacheId.toLowerCase())) {
                this.RemoveClientCacheConfiguration(cacheId.toLowerCase(), removeServerOnly);
                this.StopCache(cacheId, userId, password, isGracefulShutdown);
                HashMap partitionedTable = s_partitionedCaches.get(cacheId.toLowerCase()) instanceof HashMap ? s_partitionedCaches.get(cacheId.toLowerCase()) : null;
                if (partitionedTable != null) {
                    for (Map.Entry current : partitionedTable.entrySet()) {
                        CacheInfo cacheInfo = current.getValue() instanceof CacheInfo ? current.getValue() : null;
                        LeasedCache cache = null;
                        if (cacheInfo != null) {
                            cache = cacheInfo.getCache();
                        }
                        if (cache == null) continue;
                        cache.dispose();
                    }
                    s_partitionedCaches.remove(cacheId);
                }
            }
            CacheServer.SaveConfiguration();
        }
        finally {
            this._rwLock.ReleaseWriterLock();
        }
    }

    private void RemoveClientCacheConfiguration(String cacheId, Boolean removeServerOnly) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, Exception, SecurityException {
        if (!removeServerOnly.booleanValue()) {
            ClientConfigManager.RemoveCache(cacheId.toLowerCase());
        } else {
            CacheConfiguration[] cacheConfigurations;
            Boolean serverListChanged = false;
            Boolean serverExistsAsClient = false;
            String serverIP = this.GetBindIP();
            ClientConfiguration clientConfiguration = ClientConfigManager.GetClientConfiguration(cacheId);
            for (CacheConfiguration cc : cacheConfigurations = clientConfiguration.getCacheConfigurations()) {
                if (cc.getCacheId() != cacheId) continue;
                ArrayList servers = new ArrayList();
                if (servers.size() == 1 && ((Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer)servers.get(0)).getServerName() == serverIP) {
                    ClientConfigManager.RemoveCache(cacheId.toLowerCase());
                    break;
                }
                CacheServerConfig serverConfig = this.GetCacheConfiguration(cacheId);
                if (serverConfig == null || serverConfig.getClientNodes() == null || serverConfig.getClientNodes().getNodesList().size() <= 0) continue;
                for (ClientNode clientNode : serverConfig.getClientNodes().getNodesList()) {
                    if (clientNode.getName() != serverIP) continue;
                    serverExistsAsClient = true;
                    break;
                }
                if (serverExistsAsClient.booleanValue()) {
                    if (!cc.RemoveServer(serverIP)) continue;
                    serverListChanged = true;
                    CacheServerList serversList = new CacheServerList();
                    serversList.setServersList(this.UpdateServerPriorityList(cc.getServersPriorityList().getServersList()));
                    cc.setServersPriorityList(serversList);
                    clientConfiguration.getCacheConfigurationsMap().put(cacheId, cc);
                    ClientConfigManager.UpdateCacheConfiguration(cacheId, clientConfiguration);
                    break;
                }
                ClientConfigManager.RemoveCache(cacheId.toLowerCase());
            }
            if (!serverListChanged.booleanValue()) {
                ClientConfigManager.RemoveCache(cacheId.toLowerCase());
            }
        }
    }

    private HashMap<Integer, Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer> UpdateServerPriorityList(HashMap<Integer, Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer> dictionary) {
        HashMap<Integer, Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer> newDictionary = new HashMap<Integer, Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer>();
        Integer i = 0;
        for (Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer vals : dictionary.values()) {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            newDictionary.put(n, vals);
        }
        return newDictionary;
    }

    @Override
    @TargetMethodAttribute(privateMethod="ReloadSrvcConfig", privateOverload=1)
    public final void ReloadSrvcConfig() {
        ServiceConfiguration.Load();
        ServicePropValues.initialize();
    }

    @Override
    @TargetMethodAttribute(privateMethod="StartCache", privateOverload=1)
    public final void StartCache(String cacheId) throws Exception {
        this.StartCache(cacheId, null, null, null);
    }

    @Override
    @TargetMethodAttribute(privateMethod="StartCache", privateOverload=2)
    public final void StartCache(String cacheId, String partitionId) throws Exception {
        this.StartCache(cacheId, partitionId, null, null);
    }

    @Override
    @TargetMethodAttribute(privateMethod="StartCache", privateOverload=3)
    public final void StartCache(String cacheId, byte[] userId, byte[] password) throws Exception {
        this.StartCache(cacheId, null, null, null, null, null, null, null, userId, password, false);
    }

    @Override
    @TargetMethodAttribute(privateMethod="StartCache", privateOverload=4)
    public final void StartCache(String cacheId, String partitionId, byte[] userId, byte[] password, boolean twoPhaseInitialization) throws SecurityException, Exception {
        this.StartCache(cacheId, partitionId, null, null, null, null, null, null, userId, password, twoPhaseInitialization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetMethodAttribute(privateMethod="StartCachePhase2", privateOverload=1)
    public final void StartCachePhase2(String cacheId) {
        this._rwLock.AcquireWriterLock();
        try {
            Cache tempVar = this.GetCacheInstance(cacheId, null);
            LeasedCache cache = (LeasedCache)((Object)(tempVar instanceof LeasedCache ? tempVar : null));
            if (cache != null) {
                cache.StartInstancePhase2();
            }
        }
        finally {
            this._rwLock.ReleaseWriterLock();
        }
    }

    @Override
    @TargetMethodAttribute(privateMethod="StartCache", privateOverload=5)
    public final void StartCache(String cacheId, String partitionId, byte[] userId, byte[] password) throws Exception {
        this.StartCache(cacheId, partitionId, null, null, null, null, null, null, userId, password, false);
    }

    @Override
    @TargetMethodAttribute(privateMethod="StartCache", privateOverload=6)
    public final void StartCache(String cacheId, ItemAddedCallback itemAdded, ItemRemovedCallback itemRemoved, ItemUpdatedListener itemUpdated, CacheClearedCallback cacheCleared, CustomRemoveCallback customRemove, CustomUpdateCallback customUpdate) throws Exception, SecurityException {
        this.StartCache(cacheId, null, itemAdded, itemRemoved, itemUpdated, cacheCleared, customRemove, customUpdate, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetMethodAttribute(privateMethod="StartCache", privateOverload=7)
    public final void StartCache(String cacheId, String partitionId, ItemAddedCallback itemAdded, ItemRemovedCallback itemRemoved, ItemUpdatedListener itemUpdated, CacheClearedCallback cacheCleared, CustomRemoveCallback customRemove, CustomUpdateCallback customUpdate, byte[] userId, byte[] password, boolean twoPhaseInitialization) throws Exception, SecurityException {
        if (cacheId == null) {
            throw new IllegalArgumentException("Value cannot be null.\nParameter name: cacheId");
        }
        if (!NodeSecurityProvider.getNodeSecurity().Authorize(this.Decrypt(userId), this.Decrypt(password), cacheId) && !this.VerifySystemAdministrator(this.Decrypt(userId), this.Decrypt(password))) {
            EventLogger.LogEvent((String)"NCache", (String)("\"" + cacheId + "\" can not be started. You do not have permissions to perform this operation."), (EventType)EventType.ERROR, (short)2, (int)1002);
            throw new SecurityException("You do not have permissions to perform this operation");
        }
        CacheInfo cacheInfo = null;
        ArrayList<LeasedCache> caches = null;
        LeasedCache cache = null;
        ArrayList<CacheInfo> cacheInfos = null;
        this._rwLock.AcquireWriterLock();
        try {
            HashMap partitionTable;
            try {
                CacheServer.LoadConfiguration();
            }
            catch (Exception e) {
                String msg = String.format("CacheServer failed to load configuration, Error %1$s", e.getMessage());
                EventLogger.LogEvent((String)msg, (EventType)EventType.WARNING);
            }
            if (s_caches.containsKey(cacheId.toLowerCase())) {
                cacheInfo = (CacheInfo)s_caches.get(cacheId.toLowerCase());
                if (cacheInfo != null) {
                    cache = cacheInfo.getCache();
                }
                if (cache != null) {
                    if (caches == null) {
                        caches = new ArrayList<LeasedCache>();
                    }
                    if (cacheInfos == null) {
                        cacheInfos = new ArrayList<CacheInfo>();
                    }
                    caches.add(cache);
                    cacheInfos.add(cacheInfo);
                }
            } else if (s_partitionedCaches.containsKey(cacheId.toLowerCase()) && (partitionTable = (HashMap)(s_partitionedCaches.get(cacheId.toLowerCase()) instanceof HashMap ? s_partitionedCaches.get(cacheId.toLowerCase()) : null)) != null) {
                for (Map.Entry current : partitionTable.entrySet()) {
                    cacheInfo = (CacheInfo)current.getValue();
                    if (cacheInfo != null) {
                        cache = cacheInfo.getCache();
                    }
                    if (cache == null) continue;
                    if (caches == null) {
                        caches = new ArrayList();
                    }
                    if (cacheInfos == null) {
                        cacheInfos = new ArrayList();
                    }
                    caches.add(cache);
                    cacheInfos.add(cacheInfo);
                }
            }
            try {
                this.StartCacheInstance(caches, cacheInfos, itemAdded, itemRemoved, itemUpdated, cacheCleared, customRemove, customUpdate, userId, password, twoPhaseInitialization);
                EventLogger.LogEvent((String)"NCache", (String)("\"" + cacheId + "\" started successfully."), (EventType)EventType.INFORMATION, (short)3, (int)1000);
            }
            catch (Exception e) {
                EventLogger.LogEvent((String)"NCache", (String)("\"" + cacheId + "\" can not be started.\n" + e.toString()), (EventType)EventType.ERROR, (short)1, (int)1002);
                throw e;
            }
        }
        finally {
            this._rwLock.ReleaseWriterLock();
        }
    }

    private void StartCacheInstance(ArrayList caches, ArrayList cacheInfos, final ItemAddedCallback itemAdded, final ItemRemovedCallback itemRemoved, final ItemUpdatedListener itemUpdated, final CacheClearedCallback cacheCleared, final CustomRemoveCallback customRemove, final CustomUpdateCallback customUpdate, byte[] userId, byte[] password, boolean twoPhaseInitialization) throws ManagementException, Exception {
        if (caches != null && caches.size() > 0) {
            for (int i = 0; i < caches.size(); ++i) {
                LeasedCache cache = caches.get(i) instanceof LeasedCache ? caches.get(i) : null;
                CacheInfo cacheInfo = cacheInfos.get(i) instanceof CacheInfo ? cacheInfos.get(i) : null;
                if (itemAdded != null) {
                    cache.addItemAddedListner(new NEventStart(){

                        public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                            itemAdded.invoke(obj[0], (EventContext)obj[1]);
                            return null;
                        }
                    }, null);
                }
                if (itemRemoved != null) {
                    cache.addItemRemovedListner(new NEventStart(){

                        public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                            itemRemoved.invoke(obj[0], obj[1], (ItemRemoveReason)obj[2], (BitSet)obj[3], (EventContext)obj[4]);
                            return null;
                        }
                    }, null);
                }
                if (itemUpdated != null) {
                    cache.addItemAddedListner(new NEventStart(){

                        public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                            itemUpdated.invoke(obj[0], (EventContext)obj[1]);
                            return null;
                        }
                    }, null);
                }
                if (cacheCleared != null) {
                    cache.addCacheClearedListner(new NEventStart(){

                        public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                            cacheCleared.invoke((EventContext)obj[0]);
                            return null;
                        }
                    }, null);
                }
                if (customRemove != null) {
                    cache.addCustomRemoveNotifListner(new NEventStart(){

                        public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                            customRemove.invoke(obj[0], obj[1], (ItemRemoveReason)obj[2], (BitSet)obj[3], (EventContext)obj[4]);
                            return null;
                        }
                    }, null);
                }
                if (customUpdate != null) {
                    cache.addCustomUpdateNotifListner(new NEventStart(){

                        public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                            customUpdate.invoke((Object)_evalWarningTask, (Object)_evalWarningTask, (EventContext)obj[2]);
                            return null;
                        }
                    }, null);
                }
                if (cache.getIsRunning()) continue;
                cacheInfo.SyncConfiguration();
                cache.StartInstance(this._renderer, this.Decrypt(userId), this.Decrypt(password), twoPhaseInitialization);
                if (!LicenseManager.isEntCacheServer() || Cache.OnCacheStarted == null) continue;
                Cache.OnCacheStarted.invoke(cache.getName());
            }
        } else {
            throw new ManagementException("Specified cacheId is not registered");
        }
    }

    @Override
    @TargetMethodAttribute(privateMethod="StopCache", privateOverload=1)
    public final void StopCache(String cacheId, byte[] userId, byte[] password, Boolean isGracefulShutdown) throws Exception, SecurityException {
        this.StopCache(cacheId, null, userId, password, isGracefulShutdown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetMethodAttribute(privateMethod="StopCache", privateOverload=2)
    public final void StopCache(String cacheId, String partitionId, byte[] userId, byte[] password, boolean isGraceFulShutDown) throws Exception, SecurityException {
        if (cacheId == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cacheId");
        }
        if (!NodeSecurityProvider.getNodeSecurity().Authorize(this.Decrypt(userId), this.Decrypt(password), null) && !this.VerifySystemAdministrator(this.Decrypt(userId), this.Decrypt(password))) {
            EventLogger.LogEvent((String)"NCache", (String)("\"" + cacheId + "\" can not be stopped. You do not have permissions to perform this operation"), (EventType)EventType.ERROR, (short)1, (int)1021);
            throw new SecurityException("You do not have permissions to perform this operation");
        }
        ArrayList<CacheInfo> cacheInfos = null;
        ArrayList<LeasedCache> caches = null;
        CacheInfo cacheInfo = null;
        LeasedCache cache = null;
        this._rwLock.AcquireWriterLock();
        try {
            cacheInfo = this.GetCacheInfo(cacheId.toLowerCase());
            if (cacheInfo != null) {
                cache = cacheInfo.getCache();
            }
            if (cache != null) {
                if (caches == null) {
                    caches = new ArrayList<LeasedCache>();
                }
                if (cacheInfos == null) {
                    cacheInfos = new ArrayList<CacheInfo>();
                }
                caches.add(cache);
                cacheInfos.add(cacheInfo);
            }
            try {
                this.StopCacheInstance(caches, cacheInfos, CacheStopReason.Stoped, userId, password, isGraceFulShutDown);
                EventLogger.LogEvent((String)"NCache", (String)("\"" + cacheId + "\" stopped successfully."), (EventType)EventType.INFORMATION, (short)3, (int)1001);
            }
            catch (Exception e) {
                EventLogger.LogEvent((String)"NCache", (String)("\"" + cacheId + "\" can not be stopped.\n" + e.toString()), (EventType)EventType.ERROR, (short)1, (int)1003);
                throw e;
            }
        }
        finally {
            this._rwLock.ReleaseWriterLock();
        }
    }

    @TargetMethodAttribute(privateMethod="GetShutdownTimeout", privateOverload=1)
    public int GetShutdownTimeout() {
        int shutdownTimeout = 180;
        int blockTimeout = 3;
        RefObject tempRef_shutdownTimeout = new RefObject((Object)shutdownTimeout);
        RefObject tempRef_blockTimeout = new RefObject((Object)blockTimeout);
        String expMsg = GracefulTimeout.GetGracefulShutDownTimeout((RefObject)tempRef_shutdownTimeout, (RefObject)tempRef_blockTimeout);
        shutdownTimeout = (Integer)tempRef_shutdownTimeout.argvalue;
        blockTimeout = (Integer)tempRef_blockTimeout.argvalue;
        if (expMsg != null) {
            EventLogger.LogEvent((String)"NCache", (String)expMsg, (EventType)EventType.WARNING, (short)2, (int)1018);
        }
        return shutdownTimeout;
    }

    private void StopAllCaches(CacheStopReason reason) throws Exception {
        ArrayList<LeasedCache> caches = new ArrayList<LeasedCache>();
        ArrayList<CacheInfo> cacheInfos = new ArrayList<CacheInfo>();
        for (CacheInfo cacheInfo : s_caches.values()) {
            if (cacheInfo == null) continue;
            caches.add(cacheInfo.getCache());
            cacheInfos.add(cacheInfo);
        }
        this.StopCacheInstance(caches, cacheInfos, reason, null, null, false);
    }

    private void StopCacheInstance(ArrayList caches, ArrayList cacheInfos, CacheStopReason reason, byte[] userId, byte[] password, Boolean isGracefulShutdown) throws Exception {
        if (caches != null && caches.size() > 0) {
            for (int i = 0; i < caches.size(); ++i) {
                LeasedCache cache = caches.get(i) instanceof LeasedCache ? caches.get(i) : null;
                CacheInfo cacheInfo = cacheInfos.get(i) instanceof CacheInfo ? cacheInfos.get(i) : null;
                if (!cache.getIsRunning()) continue;
                if (!cache.VerifyNodeShutdownInProgress(isGracefulShutdown).booleanValue()) {
                    throw new ManagementException("Graceful shutdown is already in progress...");
                }
                if (reason == CacheStopReason.Expired) {
                    EventLogger.LogEvent((String)"NCache license has expired on this machine. Stopping cache...", (EventType)EventType.ERROR);
                }
                cache.StopInstance(isGracefulShutdown);
                cacheInfo.SyncConfiguration();
                if (!LicenseManager.isEntCacheServer() || Cache.OnCacheStopped == null) continue;
                Cache.OnCacheStopped.invoke(cache.getName());
            }
        } else {
            throw new ManagementException("Specified cacheId is not registered");
        }
    }

    @Override
    @TargetMethodAttribute(privateMethod="DetectNICs", privateOverload=1)
    public final HashMap DetectNICs() {
        HashMap<String, String> connectedNICs = new HashMap<String, String>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface net = enumeration.nextElement();
                List<InterfaceAddress> list = net.getInterfaceAddresses();
                for (InterfaceAddress interf : list) {
                    if (interf.getAddress() instanceof Inet6Address) continue;
                    connectedNICs.put(interf.getAddress().getHostAddress(), net.getDisplayName());
                }
            }
            return connectedNICs;
        }
        catch (Exception exception) {
            return connectedNICs;
        }
    }

    @Override
    @TargetMethodAttribute(privateMethod="BindToIP", privateOverload=1)
    public final void BindToIP(BindedIpMap bindedIpMap) throws Exception {
        HashMap bindTable = bindedIpMap.getMap();
        if (bindTable.size() == 0) {
            return;
        }
        String path = this.getServiceFilePath();
        if (new File(path).isFile()) {
            String[] elementKeys = new String[]{"CacheServer.BindToClusterIP", "CacheServer.BindToClientServerIP"};
            String[] elementValues = new String[]{bindTable.containsKey((Object)Channel.Cluster) ? (String)bindTable.get((Object)Channel.Cluster) : "", bindTable.containsKey((Object)Channel.SocketServer) ? (String)bindTable.get((Object)Channel.SocketServer) : ""};
            Properties loadProp = new Properties();
            loadProp.load(new FileInputStream(path));
            Properties alterProps = loadProp;
            String key = "";
            for (int i = 0; i < elementKeys.length; ++i) {
                Enumeration<?> enumProps = loadProp.propertyNames();
                while (enumProps.hasMoreElements()) {
                    key = (String)enumProps.nextElement();
                    if (!key.equals(elementKeys[i].toString())) continue;
                    alterProps.setProperty(key, elementValues[i]);
                }
            }
            File file = new File(path);
            FileOutputStream fileOut = new FileOutputStream(file);
            alterProps.store(fileOut, "NCache Service Properties");
            fileOut.close();
        }
    }

    private void ChangeAttribute(Document document, String path, String key, String newValue) throws ParserConfigurationException, SAXException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @TargetMethodAttribute(privateMethod="BindedIp", privateOverload=1)
    public final BindedIpMap BindedIp() throws Exception {
        HashMap<Channel, String> bindedIps = new HashMap<Channel, String>(2);
        bindedIps.put(Channel.Cluster, ServicePropValues.BIND_ToCLUSTER_IP);
        bindedIps.put(Channel.SocketServer, ServicePropValues.BIND_toClient_IP);
        return new BindedIpMap(bindedIps);
    }

    private String getServiceFilePath() throws Exception {
        Object path = ServicePropValues.INSTALLDIR_DIR + "/config/server.properties";
        if (new File((String)path).isFile()) {
            return path;
        }
        path = AppUtil.getInstallDir();
        if (path == null || ((String)path).equals("")) {
            throw new Exception("Missing installation folder information");
        }
        return (String)path + "/bin/service/server.properties";
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetMaxPort", privateOverload=1)
    public final int GetMaxPort() throws UnknownHostException {
        Map regCaches = this.getCacheProps();
        Iterator ie = regCaches.entrySet().iterator();
        CacheConfig cfg = null;
        int maxPort = 0;
        int loop = 1;
        while (ie.hasNext()) {
            Iterator ide;
            Map.Entry current = ie.next();
            if (current.getValue() instanceof CacheServerConfig) {
                cfg = CacheConfig.FromConfiguration(current.getValue() instanceof CacheServerConfig ? current.getValue() : null);
            } else if (current.getValue() instanceof HashMap && (ide = ((HashMap)current.getValue()).entrySet().iterator()).hasNext()) {
                Map.Entry subcurrent = ide.next();
                cfg = CacheConfig.FromConfiguration(current.getValue() instanceof CacheServerConfig ? current.getValue() : null);
            }
            if (cfg.getClusterPort() == 0) continue;
            if (loop == 1) {
                maxPort = cfg.getClusterPort() + cfg.getClusterPortRange() - 1;
                ++loop;
                continue;
            }
            if (maxPort >= cfg.getClusterPort() + cfg.getClusterPortRange()) continue;
            maxPort = cfg.getClusterPort() + cfg.getClusterPortRange() - 1;
        }
        return maxPort;
    }

    @Override
    @TargetMethodAttribute(privateMethod="IsClusteredCache", privateOverload=1)
    public final CacheStatusOnServerContainer IsClusteredCache(String cacheId) {
        CacheStatusOnServer result = CacheStatusOnServer.Unregistered;
        CacheStatusOnServerContainer status = new CacheStatusOnServerContainer();
        if (cacheId != null && !cacheId.equals("")) {
            if (s_caches.containsKey(cacheId = cacheId.toLowerCase())) {
                CacheInfo cacheInfo = s_caches.get(cacheId) instanceof CacheInfo ? s_caches.get(cacheId) : null;
                result = cacheInfo.getCache().getStatistics().getClassName().equals("replicated-server") || cacheInfo.getCache().getStatistics().getClassName().equals("partitioned-server") || cacheInfo.getCache().getStatistics().getClassName().equals("partitioned-replicas-server") ? CacheStatusOnServer.ClusteredCache : (cacheInfo.getCache().getStatistics().getClassName().equals("mirror-server") ? CacheStatusOnServer.MirrorCache : CacheStatusOnServer.LocalCache);
            }
            status.cacheStatus = result;
            return status;
        }
        throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cacheId");
    }

    @Override
    @TargetMethodAttribute(privateMethod="PortIsAvailable", privateOverload=1)
    public final boolean PortIsAvailable(int port) throws UnknownHostException {
        Map regCaches = this.getCacheProps();
        Iterator ie = regCaches.entrySet().iterator();
        boolean isAvailable = true;
        while (ie.hasNext()) {
            HashMap partitionedTable;
            Iterator ide;
            CacheConfig cfg;
            Map.Entry current = ie.next();
            if (current.getValue() instanceof CacheServerConfig) {
                cfg = CacheConfig.FromConfiguration(current.getValue() instanceof CacheServerConfig ? current.getValue() : null);
                if (cfg.getClusterPort() == 0) continue;
                for (int i = 0; i < cfg.getClusterPortRange(); ++i) {
                    if (port != cfg.getClusterPort() + i) continue;
                    isAvailable = false;
                }
                continue;
            }
            if (!(current.getValue() instanceof HashMap) || !(ide = (partitionedTable = (HashMap)(current.getValue() instanceof HashMap ? current.getValue() : null)).entrySet().iterator()).hasNext() || (cfg = CacheConfig.FromConfiguration(current.getValue() instanceof CacheServerConfig ? current.getValue() : null)).getClusterPort() == 0) continue;
            for (int i = 0; i < cfg.getClusterPortRange(); ++i) {
                if (port != cfg.getClusterPort() + i) continue;
                isAvailable = false;
            }
        }
        return isAvailable;
    }

    @Override
    @TargetMethodAttribute(privateMethod="NodeIsAllowed", privateOverload=1)
    public final boolean NodeIsAllowed(int port, String id) throws UnknownHostException {
        Map regCaches = this.getCacheProps();
        Iterator ie = regCaches.entrySet().iterator();
        CacheConfig cfg = null;
        boolean isAllowed = true;
        while (ie.hasNext()) {
            Iterator it;
            Map.Entry current = ie.next();
            if (current.getValue() instanceof CacheServerConfig) {
                cfg = CacheConfig.FromConfiguration(current.getValue() instanceof CacheServerConfig ? current.getValue() : null);
            } else if (current.getValue() instanceof HashMap && (it = ((HashMap)current.getValue()).entrySet().iterator()).hasNext()) {
                Map.Entry de = it.next();
                cfg = CacheConfig.FromConfiguration(current.getValue() instanceof CacheServerConfig ? current.getValue() : null);
            }
            if (cfg == null || cfg.getClusterPort() != port || cfg.getCacheId().equals(id)) continue;
            isAllowed = false;
        }
        return isAllowed;
    }

    public final String Decrypt(byte[] cypherText) {
        return EncryptionUtil.Decrypt((byte[])cypherText);
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetCacheStatus", privateOverload=1)
    public final StatusInfo GetCacheStatus(String cacheId, String partitionId) {
        LeasedCache cache;
        LicenseManager.LicenseType lic;
        StatusInfo status = new StatusInfo();
        CacheInfo cacheInfo = this.GetCacheInfo(cacheId);
        if (cacheInfo != null && cacheInfo.getCacheProps() != null) {
            status.setConfigID(cacheInfo.getCacheProps().getConfigID());
        }
        try {
            lic = LicenseManager.LicenseMode(null);
        }
        catch (Exception ex) {
            lic = LicenseManager.LicenseType.Expired;
        }
        if (lic == LicenseManager.LicenseType.Expired) {
            status.Status = CacheStatus.Expired;
        } else if (cacheInfo != null && (cache = cacheInfo.getCache()) != null) {
            CacheStatus cacheStatus = status.Status = cache.getIsRunning() ? CacheStatus.Running : CacheStatus.Registered;
            if (LicenseManager.isEntCacheServer() || LicenseManager.isProCacheServer()) {
                status.setIsCoordinator(cache.getIsCoordinator());
            }
        }
        return status;
    }

    private String GetConfigID(String cacheId) {
        try {
            CacheServerConfig config = this.GetCacheConfiguration(cacheId);
            if (config != null) {
                return config.getConfigID();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    @TargetMethodAttribute(privateMethod="StartMonitoringActivity", privateOverload=1)
    public final void StartMonitoringActivity() throws Exception {
        try {
            ServerMonitor.StartMonitoring();
            EventLogger.LogEvent((String)"Activity monitoring is started", (EventType)EventType.INFORMATION);
        }
        catch (Exception e) {
            EventLogger.LogEvent((String)("An error occured while starting activity monitoring " + e.toString()), (EventType)EventType.ERROR);
            throw e;
        }
    }

    @Override
    @TargetMethodAttribute(privateMethod="StopMonitoringActivity", privateOverload=1)
    public final void StopMonitoringActivity() throws Exception {
        try {
            ServerMonitor.StopMonitoring();
            EventLogger.LogEvent((String)"Activity monitoring is stopped", (EventType)EventType.INFORMATION);
        }
        catch (Exception e) {
            EventLogger.LogEvent((String)("An error occured while stopping activity monitoring " + e.toString()), (EventType)EventType.ERROR);
            throw e;
        }
    }

    @Override
    @TargetMethodAttribute(privateMethod="PublishActivity", privateOverload=1)
    public final void PublishActivity() throws CloneNotSupportedException, Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetMethodAttribute(privateMethod="GetConfiguredPartitionedReplicaCaches", privateOverload=1)
    public ConfiguredCacheInfo[] GetConfiguredPartitionedReplicaCaches() {
        ConfiguredCacheInfo[] configuredCaches = new ConfiguredCacheInfo[s_partitionedCaches.size()];
        this._rwLock.AcquireReaderLock();
        try {
            Iterator en = s_partitionedCaches.entrySet().iterator();
            int i = 0;
            while (en.hasNext()) {
                Map.Entry current = en.next();
                String cacheId = (String)Common.readAs(current.getKey(), String.class);
                HashMap partitionedCaches = (HashMap)Common.readAs(current.getValue(), HashMap.class);
                if (partitionedCaches == null) continue;
                for (Map.Entry de : partitionedCaches.entrySet()) {
                    String partId = (String)Common.readAs(de.getKey(), String.class);
                    CacheInfo cacheInfo = (CacheInfo)de.getValue();
                    ConfiguredCacheInfo configuredCache = new ConfiguredCacheInfo();
                    configuredCache.setCacheId(cacheInfo.getCacheProps().getName());
                    configuredCache.setIsRunning(cacheInfo.getCache().getIsRunning());
                    configuredCache.setDataCapacity(cacheInfo.getCacheProps().getStorage().getSize());
                    configuredCache.setCachePropString(CacheServer.GetProps(cacheInfo.getCacheProps()));
                    configuredCache.setPartId(partId);
                    if (cacheInfo.getCacheProps().getCacheType() == "clustered-cache") {
                        if (cacheInfo.getCacheProps().getCluster() != null) {
                            String topology = cacheInfo.getCacheProps().getCluster().getTopology();
                            if (topology.equals("replicated-server")) {
                                configuredCache.setTopology(Alachisoft.NCache.Common.Enum.CacheTopology.Replicated);
                            } else if (topology.equals("partitioned-server")) {
                                configuredCache.setTopology(Alachisoft.NCache.Common.Enum.CacheTopology.Partitioned);
                            } else if (topology.equals("partitioned-replicas-server")) {
                                configuredCache.setTopology(Alachisoft.NCache.Common.Enum.CacheTopology.PartitionedOfReplica);
                            } else if (topology.equals("mirror-server")) {
                                configuredCache.setTopology(Alachisoft.NCache.Common.Enum.CacheTopology.Mirror);
                            }
                        }
                    } else if (cacheInfo.getCacheProps().getCacheType() == "local-cache") {
                        configuredCache.setTopology(Alachisoft.NCache.Common.Enum.CacheTopology.Local);
                    }
                    configuredCaches[i] = configuredCache;
                    ++i;
                }
            }
            ConfiguredCacheInfo[] configuredCacheInfoArray = configuredCaches;
            return configuredCacheInfoArray;
        }
        finally {
            this._rwLock.ReleaseReaderLock();
        }
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetCacheStatistics", privateOverload=1)
    public final CacheNodeStatistics[] GetCacheStatistics(String cacheId) throws CacheException {
        Cache cache = this.GetCacheInstance(cacheId, null);
        ArrayList statistics = null;
        if (cache != null) {
            statistics = cache.GetCacheNodeStatistics();
            return statistics.toArray(new CacheNodeStatistics[statistics.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetMethodAttribute(privateMethod="GetCacheStatistics2", privateOverload=1)
    public CacheStatistics GetCacheStatistics2(String cacheId) throws IllegalArgumentException {
        if (cacheId == null) {
            throw new IllegalArgumentException(cacheId);
        }
        try {
            this._rwLock.AcquireReaderLock();
            if (s_caches.containsKey(cacheId.toLowerCase())) {
                CacheInfo cacheInfo = (CacheInfo)Common.readAs(s_caches.get(cacheId.toLowerCase()), CacheInfo.class);
                CacheStatistics cacheStatistics = cacheInfo == null ? null : cacheInfo.getCache().getStatistics();
                return cacheStatistics;
            }
        }
        finally {
            this._rwLock.ReleaseReaderLock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetMethodAttribute(privateMethod="GetCacheServers", privateOverload=1)
    public final Node[] GetCacheServers(String cacheId) throws UnknownHostException {
        if (cacheId == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cacheId");
        }
        ArrayList<Alachisoft.NCache.Common.Monitoring.ServerNode> serverNodes = new ArrayList<Alachisoft.NCache.Common.Monitoring.ServerNode>();
        try {
            CacheInfo cacheInfo;
            this._rwLock.AcquireReaderLock();
            if (s_caches.containsKey(cacheId.toLowerCase()) && (cacheInfo = (CacheInfo)(s_caches.get(cacheId.toLowerCase()) instanceof CacheInfo ? s_caches.get(cacheId.toLowerCase()) : null)).getCacheProps().getCacheType().equals("clustered-cache")) {
                ArrayList nodeAddresses = cacheInfo.getCacheProps().getCluster().GetAllConfiguredNodes();
                Alachisoft.NCache.Common.Monitoring.ServerNode server = null;
                for (Address node : nodeAddresses) {
                    server = new Alachisoft.NCache.Common.Monitoring.ServerNode();
                    server.setAddress(node);
                    serverNodes.add(server);
                }
            }
        }
        finally {
            this._rwLock.ReleaseReaderLock();
        }
        return serverNodes.toArray(new Node[serverNodes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetMethodAttribute(privateMethod="GetRunningCacheServers", privateOverload=1)
    public final ArrayList<Alachisoft.NCache.Common.Monitoring.ServerNode> GetRunningCacheServers(String cacheId) {
        ArrayList<Alachisoft.NCache.Common.Monitoring.ServerNode> serverNodes;
        block9: {
            if (cacheId == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cacheId");
            }
            serverNodes = new ArrayList<Alachisoft.NCache.Common.Monitoring.ServerNode>();
            try {
                CacheStatistics tempVar;
                ClusterCacheStatistics stats;
                CacheInfo cacheInfo;
                this._rwLock.AcquireReaderLock();
                if (!s_caches.containsKey(cacheId.toLowerCase()) || !(cacheInfo = (CacheInfo)(s_caches.get(cacheId.toLowerCase()) instanceof CacheInfo ? s_caches.get(cacheId.toLowerCase()) : null)).getCache().getIsRunning() || !cacheInfo.getCacheProps().getCacheType().equals("clustered-cache") || (stats = (ClusterCacheStatistics)((tempVar = cacheInfo.getCache().getStatistics()) instanceof ClusterCacheStatistics ? tempVar : null)) == null) break block9;
                Iterator it = stats.getNodes().iterator();
                while (it.hasNext()) {
                    NodeInfo node = (NodeInfo)it.next();
                    Alachisoft.NCache.Common.Monitoring.ServerNode serverNode = new Alachisoft.NCache.Common.Monitoring.ServerNode();
                    serverNode.setAddress(node.getAddress());
                    serverNode.setIsReplica(node.getIsStartedAsMirror());
                    serverNode.setInProcInstance(node.getIsInproc());
                    if (node.getRendererAddress() != null) {
                        serverNode.setClientPort(node.getRendererAddress().getPort());
                    }
                    if (node.getIsStartedAsMirror() && stats.getNodes().size() > 2) {
                        Iterator its = stats.getNodes().iterator();
                        while (it.hasNext()) {
                            NodeInfo node2 = (NodeInfo)its.next();
                            if (!node2.getSubgroupName().equals(node.getSubgroupName()) || node2.getAddress().getIpAddress().toString().equals(node.getAddress().getIpAddress().toString())) continue;
                            serverNode.setNodeAt(node2.getAddress().getIpAddress().toString());
                            break;
                        }
                    } else {
                        serverNode.setNodeAt(node.getAddress().getIpAddress().toString());
                    }
                    serverNodes.add(serverNode);
                }
            }
            finally {
                this._rwLock.ReleaseReaderLock();
            }
        }
        return serverNodes;
    }

    @TargetMethodAttribute(privateMethod="GetCacheClients", privateOverload=1)
    public final ArrayList<Alachisoft.NCache.Common.Monitoring.ClientNode> GetCacheClients(String cacheId) throws UnknownHostException {
        if (cacheId == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cacheId");
        }
        ArrayList clients = this._renderer.GetClientList(cacheId);
        return clients;
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetClientProcessStats", privateOverload=1)
    public final ArrayList<ClientProcessStats> GetClientProcessStats(String cacheId) throws UnknownHostException {
        if (cacheId == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cacheId");
        }
        ArrayList clients = this._renderer.GetClientProcessStats(cacheId);
        return clients;
    }

    @Override
    public void PublishCustomClientCounters(String cacheId, ClientCustomCounters customCounters) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetMethodAttribute(privateMethod="GetAllConfiguredCaches", privateOverload=1)
    public final ConfiguredCacheInfo[] GetAllConfiguredCaches() {
        ConfiguredCacheInfo[] configuredCaches = new ConfiguredCacheInfo[s_caches.size()];
        try {
            this._rwLock.AcquireReaderLock();
            Iterator ide = s_caches.entrySet().iterator();
            int tmp = 0;
            while (ide.hasNext()) {
                Map.Entry current = ide.next();
                CacheInfo cacheInfo = current.getValue() instanceof CacheInfo ? current.getValue() : null;
                ConfiguredCacheInfo configuredCache = new ConfiguredCacheInfo();
                configuredCache.setCacheId(cacheInfo.getCacheProps().getName());
                configuredCache.setIsRunning(cacheInfo.getCache().getIsRunning());
                configuredCache.setDataCapacity(cacheInfo.getCacheProps().getStorage().getSize());
                configuredCache.setCachePropString(_clusterIp);
                if (cacheInfo.getCacheProps().getCacheType().equals("clustered-cache")) {
                    if (cacheInfo.getCacheProps().getCluster() != null) {
                        String tempVar = cacheInfo.getCacheProps().getCluster().getTopology();
                        if (tempVar.equals("replicated-server")) {
                            configuredCache.setTopology(Alachisoft.NCache.Common.Enum.CacheTopology.Replicated);
                        } else if (tempVar.equals("partitioned-server")) {
                            configuredCache.setTopology(Alachisoft.NCache.Common.Enum.CacheTopology.Partitioned);
                        } else if (tempVar.equals("partitioned-replicas-server")) {
                            configuredCache.setTopology(Alachisoft.NCache.Common.Enum.CacheTopology.PartitionedOfReplica);
                        } else if (tempVar.equals("mirror-server")) {
                            configuredCache.setTopology(Alachisoft.NCache.Common.Enum.CacheTopology.Mirror);
                        }
                    }
                } else if (cacheInfo.getCacheProps().getCacheType().equals("local-cache")) {
                    configuredCache.setTopology(Alachisoft.NCache.Common.Enum.CacheTopology.Local);
                }
                configuredCaches[tmp++] = configuredCache;
            }
        }
        finally {
            this._rwLock.ReleaseReaderLock();
        }
        return configuredCaches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetMethodAttribute(privateMethod="GetCacheConfigurationInfo", privateOverload=1)
    public final ConfiguredCacheInfo GetCacheConfigurationInfo(String cacheId) {
        if (cacheId == null) {
            throw new IllegalArgumentException("Value cannot be null.\nParameter name: cacheId");
        }
        ConfiguredCacheInfo configuredCache = null;
        try {
            this._rwLock.AcquireReaderLock();
            if (s_caches.containsKey(cacheId.toLowerCase())) {
                CacheInfo cacheInfo = s_caches.get(cacheId.toLowerCase()) instanceof CacheInfo ? s_caches.get(cacheId.toLowerCase()) : null;
                configuredCache = new ConfiguredCacheInfo();
                configuredCache.setCacheId(cacheInfo.getCacheProps().getName());
                configuredCache.setIsRunning(cacheInfo.getCache().getIsRunning());
                configuredCache.setDataCapacity(cacheInfo.getCacheProps().getStorage().getSize());
                if (cacheInfo.getCacheProps().getCacheType().equals("clustered-cache")) {
                    if (cacheInfo.getCacheProps().getCluster() != null) {
                        String tempVar = cacheInfo.getCacheProps().getCluster().getTopology();
                        if (tempVar.equals("replicated-server")) {
                            configuredCache.setTopology(Alachisoft.NCache.Common.Enum.CacheTopology.Replicated);
                        } else if (tempVar.equals("partitioned-server")) {
                            configuredCache.setTopology(Alachisoft.NCache.Common.Enum.CacheTopology.Partitioned);
                        } else if (tempVar.equals("partitioned-replicas-server")) {
                            configuredCache.setTopology(Alachisoft.NCache.Common.Enum.CacheTopology.PartitionedOfReplica);
                        } else if (tempVar.equals("mirror-server")) {
                            configuredCache.setTopology(Alachisoft.NCache.Common.Enum.CacheTopology.Mirror);
                        }
                    }
                } else if (cacheInfo.getCacheProps().getCacheType().equals("local-cache")) {
                    configuredCache.setTopology(Alachisoft.NCache.Common.Enum.CacheTopology.Local);
                }
            }
        }
        finally {
            this._rwLock.ReleaseReaderLock();
        }
        return configuredCache;
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetClusterIP", privateOverload=1)
    public final String GetClusterIP() {
        return this.getClusterIP();
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetLocalCacheIP", privateOverload=1)
    public final String GetLocalCacheIP() {
        return this.getLocalCacheIP();
    }

    @Override
    @TargetMethodAttribute(privateMethod="CacheProps", privateOverload=1)
    public Map CacheProps() {
        throw new UnsupportedOperationException();
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetSocketServerPort", privateOverload=1)
    public final int GetSocketServerPort() {
        return _socketServerPort;
    }

    @Override
    @TargetMethodAttribute(privateMethod="MakeCacheActive", privateOverload=1)
    public final void MakeCacheActive(String cacheId, boolean active) {
        Cache cache = this.GetCacheInstance(cacheId, null);
        if (cache != null && cache.getIsRunning()) {
            cache.MakeCacheActiveNCManager(active);
        }
    }

    @Override
    @TargetMethodAttribute(privateMethod="IsBridgeTargetCache", privateOverload=1)
    public final boolean IsBridgeTargetCache(String cacheId) {
        Cache cache = this.GetCacheInstance(cacheId, null);
        if (cache != null) {
            return cache.getIsBridgeTargetCache();
        }
        return false;
    }

    @Override
    @TargetMethodAttribute(privateMethod="ClearCacheContent", privateOverload=1)
    public final void ClearCacheContent(String cacheId) throws OperationFailedException {
        Cache cache = this.GetCacheInstance(cacheId, null);
        if (cache != null) {
            cache.Clear();
        }
    }

    @Override
    @TargetMethodAttribute(privateMethod="IsRunning", privateOverload=1)
    public final boolean IsRunning(String cacheId) {
        Cache cache = this.GetCacheInstance(cacheId, null);
        if (cache != null) {
            return cache.getIsRunning();
        }
        return false;
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetStatistics", privateOverload=1)
    public final CacheStatistics GetStatistics(String cacheId) {
        Cache cache = this.GetCacheInstance(cacheId, null);
        if (cache != null && cache.getIsRunning()) {
            return cache.getStatistics();
        }
        return null;
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetCacheCount", privateOverload=1)
    public final long GetCacheCount(String cacheId) throws GeneralFailureException, OperationFailedException, CacheException {
        Cache cache = this.GetCacheInstance(cacheId, null);
        if (cache != null) {
            return cache.getCount();
        }
        return 0L;
    }

    @Override
    @TargetMethodAttribute(privateMethod="SetLocalCacheIP", privateOverload=1)
    public final void SetLocalCacheIP(String ip) {
        this.setLocalCacheIP(ip);
    }

    @Override
    @TargetMethodAttribute(privateMethod="BalanceDataloadOnCache", privateOverload=1)
    public void BalanceDataloadOnCache(String cacheId) throws SuspectedException, TimeoutException, GeneralFailureException {
        Cache cache = this.GetCacheInstance(cacheId, null);
        if (cache != null) {
            cache.BalanceDataLoad();
        }
    }

    @Override
    @TargetMethodAttribute(privateMethod="IsCacheRegistered", privateOverload=1)
    public boolean IsCacheRegistered(String cacheId) {
        return cacheId != null && s_caches.get(cacheId.toLowerCase()) != null;
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetSnmpPorts", privateOverload=1)
    public HashMap GetSnmpPorts() {
        HashMap snmpPorts = new HashMap();
        Map temp = PortPool.getInstance().getSNMPMap();
        Iterator iterator = temp.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = iterator.next();
            snmpPorts.put(entry.getKey(), entry.getValue());
        }
        return snmpPorts;
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetServerLicenseInfo", privateOverload=1)
    public ServerLicenseInfo GetServerLicenseInfo() throws Exception {
        return new ServerLicenseInfo();
    }

    @Override
    @TargetMethodAttribute(privateMethod="StopServer", privateOverload=1)
    public void StopServer() {
        CacheServer.ReleaseServiceObject();
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetServerPlatform", privateOverload=1)
    public String GetServerPlatform() {
        return "Java";
    }

    @Override
    @TargetMethodAttribute(privateMethod="GetClientCacheStatus", privateOverload=1)
    public ClientCacheStatus GetClientCahceStatus(String clientCacheID) throws ManagementException, ParserConfigurationException, ParserConfigurationException, InstantiationException, SAXException, IOException, IllegalAccessException {
        ClientCacheStatus clientCachestatus = new ClientCacheStatus();
        try {
            Alachisoft.NCache.Config.NewDom.CacheServerConfig existConfig = DomHelper.convertToNewDom((CacheServerConfig)this.GetCacheConfiguration(clientCacheID));
            if (existConfig == null) {
                clientCachestatus.setStatus((byte)1);
                return clientCachestatus;
            }
            if (!existConfig.getCacheSettings().getCacheType().equals("client-cache")) {
                clientCachestatus.setStatus((byte)3);
                return clientCachestatus;
            }
            clientCachestatus.setStatus((byte)2);
            ClientConfiguration clientConfig = ClientConfigManager.GetClientConfiguration(clientCacheID);
            for (int i = 0; i < clientConfig.getCacheConfigurations().length; ++i) {
                if (clientConfig.getCacheConfigurations()[i].getClientCacheId() == null || !clientCacheID.toLowerCase().equals(clientConfig.getCacheConfigurations()[i].getClientCacheId().toLowerCase())) continue;
                clientCachestatus.setClusteredCacheId(clientConfig.getCacheConfigurations()[i].getCacheId());
                return clientCachestatus;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            Logger.getLogger(CacheServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return clientCachestatus;
    }

    public boolean getIsConnected() {
        throw new UnsupportedOperationException();
    }

    public void PublishMetadata(String sessionId, String version, ClientMetaData clientMeta) throws Exception {
    }

    public void PublishMetadata(String sessionId, CounterMetadataCollection counterMeta) throws Exception {
    }

    public int PublishData(String session, CounterDataCollection data) throws Exception {
        return 0;
    }

    static {
        serviceObject = new Object();
        s_caches = new HashMap();
        s_partitionedCaches = new HashMap();
        stopEvalWarning = false;
        try {
            CacheServer.LoadConfiguration();
            licenseLogger = new LicenseLogger();
            try {
                licenseLogger.Load();
            }
            catch (Exception e) {
                EventLogger.LogEvent((String)"Failed to load license log. Suspected tampering.", (EventType)EventType.WARNING);
            }
            licenseLogger.setAutoSave(true);
            licenseLogger.setEnabled(CacheServer.GetLicenseLoggingStatus());
            CacheServer.RegisterCompactTypes();
            try {
                LicenseManager.setIsService((boolean)true);
                LicenseManager.registerLicenseExpirationCallBack((ILicenseExpiration)s_instance);
                if (LicenseManager.LicenseMode(null) == LicenseManager.LicenseType.InEvaluation) {
                    _evalWarningTask = new Thread(new Runnable(){
                        public long interval = 43200000L;

                        @Override
                        public void run() {
                            while (!stopEvalWarning) {
                                try {
                                    Thread.sleep(this.interval);
                                    CacheServer.NotifyEvalLicense(this, null);
                                }
                                catch (InterruptedException interruptedException) {
                                    CacheServer.NotifyEvalLicense(this, null);
                                }
                            }
                        }
                    });
                    _evalWarningTask.setDaemon(true);
                    CacheServer.NotifyEvalLicense(null, null);
                }
            }
            catch (Exception e) {}
        }
        catch (Exception e) {
            String msg = String.format("CacheServer failed to load configuration, Error %1$s", e.getMessage());
            EventLogger.LogEvent((String)msg, (EventType)EventType.WARNING);
        }
    }

    public static enum Channel {
        Cluster(0),
        SocketServer(1);

        private static HashMap<Integer, Channel> mappings;
        private int intValue;

        private Channel(int value) {
            this.intValue = value;
            Channel.getMappings().put(value, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static HashMap<Integer, Channel> getMappings() {
            if (mappings != null) return mappings;
            Class<Channel> clazz = Channel.class;
            synchronized (Channel.class) {
                if (mappings != null) return mappings;
                mappings = new HashMap();
                // ** MonitorExit[var0] (shouldn't be in output)
                return mappings;
            }
        }

        public static Channel forValue(int value) {
            return Channel.getMappings().get(value);
        }

        public int getValue() {
            return this.intValue;
        }
    }

    private static enum CacheStopReason {
        Expired,
        Stoped,
        ForcedStoped;

    }
}

