/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Management;

import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Caching.CacheFactory;
import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Management.CacheConfig;
import Alachisoft.NCache.Management.CacheConfigManager;
import Alachisoft.NCache.ServiceControl.NCacheService;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class CacheClient {
    private CacheClient() {
    }

    public static Cache GetCacheInstance(String cacheId) throws ConfigurationException, ManagementException, UnknownHostException {
        return CacheClient.GetCacheInstance(cacheId, new TimeSpan(30000L));
    }

    public static Cache GetCacheInstance(String cacheId, TimeSpan timeout) throws ConfigurationException, ManagementException, UnknownHostException {
        if (cacheId == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cacheId");
        }
        CacheConfig data = CacheConfigManager.GetCacheConfig(cacheId);
        return CacheClient.GetCacheInstance(data, timeout, false);
    }

    public static Cache GetCacheInstance(CacheConfig data, TimeSpan timeout, boolean autoStart) throws ConfigurationException, UnknownHostException {
        if (data == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: data");
        }
        if (data == null) {
            return null;
        }
        if (data.getUseInProc()) {
            return CacheFactory.CreateFromPropertyString((String)data.getPropertyString());
        }
        Cache cache = CacheClient.ConnectCacheInstance(data, timeout, autoStart);
        return cache;
    }

    private static Cache ConnectCacheInstance(CacheConfig data, TimeSpan timeout, boolean autoStart) throws UnknownHostException {
        NCacheService ncache = new NCacheService();
        try {
            ncache.setUseTcp(data.getUseTcp());
            ncache.setServerName(data.getServerName());
            ncache.setPort(data.getPort());
            if (ncache.getServerName() == null || ncache.getServerName().length() < 1 || ncache.getServerName().compareTo(".") == 0 || ncache.getServerName().compareTo("localhost") == 0) {
                ncache.setServerName(InetAddress.getLocalHost().getHostName());
            }
            Cache cache = null;
            return cache;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            ncache.dispose();
        }
    }
}

