/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.web.session;

import Alachisoft.NCache.Common.Util.ReaderWriterLock;
import com.alachisoft.ncache.client.Cache;
import com.alachisoft.ncache.client.CacheItem;
import com.alachisoft.ncache.client.CacheItemVersion;
import com.alachisoft.ncache.client.CacheManager;
import com.alachisoft.ncache.client.LockHandle;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.caching.Tag;
import com.alachisoft.ncache.runtime.caching.expiration.Expiration;
import com.alachisoft.ncache.runtime.caching.expiration.ExpirationType;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.web.CacheSession;
import com.alachisoft.ncache.web.EmptySession;
import com.alachisoft.ncache.web.LockException;
import com.alachisoft.ncache.web.config.dom.MultiSiteConfig;
import com.alachisoft.ncache.web.session.SessionMonitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class NCacheManager {
    protected Cache cache = null;
    protected Logger logger = Logger.getLogger(NCacheManager.class);
    protected boolean lockRemoteSession = false;
    protected int lockTimeOut = 0;
    protected HashMap locks = new HashMap();
    protected int numberOfRetries = 0;
    protected int retryInterval = 0;
    protected String _cacheId = null;
    protected ReaderWriterLock _sync = new ReaderWriterLock();
    boolean _emptySessionWhenLocked = false;
    protected String _primaryCache = "";
    protected String _currentSessionCache = "";
    private String SESSION_TAG = "NCache_session_data";

    public NCacheManager(String string, boolean bl, int n, int n2, int n3, boolean bl2, String string2, MultiSiteConfig multiSiteConfig) throws Exception {
        this.lockRemoteSession = bl;
        this.lockTimeOut = n;
        this.numberOfRetries = n2;
        this.retryInterval = n3;
        this._emptySessionWhenLocked = bl2;
        if (bl) {
            if (n < 0) {
                throw new IllegalArgumentException("lock-timeout must be a non-negative value: " + n);
            }
            if (n2 < 0) {
                throw new IllegalArgumentException("retries-count must be a non-negative value: " + n2);
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("retry-interval must be a non-negative value: " + n3);
            }
        }
        this._cacheId = string;
        this.initializeCache(string, string2, multiSiteConfig);
    }

    public boolean initializeCache(String string, String string2, MultiSiteConfig multiSiteConfig) throws Exception {
        try {
            this.logger.debug((Object)("Initializing cache: " + string));
            if (string2 != null) {
                this.logger.debug((Object)("Using cache config path: " + string2));
                CacheManager.setConfigPath((String)string2);
            }
            this.cache = CacheManager.getCache((String)string);
            this.logger.debug((Object)("Cache [" + string + "] is initialized successfully."));
            return true;
        }
        catch (Exception exception) {
            this.logger.error((Object)("Unable to initialize the cache [" + string + "]. See log for more details."), (Throwable)exception);
            throw exception;
        }
    }

    public void disconnect() {
        if (this.cache == null) {
            this.logger.debug((Object)"No valid cache instance to disconnect with.");
            return;
        }
        try {
            this.logger.debug((Object)("Disconnecting with cache: " + this._cacheId));
            this.cache.close();
            this.logger.debug((Object)("Successfully disconnected with cache: " + this._cacheId));
        }
        catch (Exception exception) {
            this.logger.error((Object)("Could not disconnect with cache [" + this._cacheId + "]. See log for more details."), (Throwable)exception);
        }
    }

    public boolean isConnected() {
        boolean bl = this.cache != null;
        this.logger.debug((Object)("Is Connected with cache [" + this._cacheId + "]: " + bl));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateCacheItem(String string, Serializable serializable, int n, Cache cache) throws Exception {
        this.logger.debug((Object)("Updating cache item: " + string + " , with sliding expiration: " + n));
        CacheItem cacheItem = new CacheItem((Object)serializable);
        ArrayList<Tag> arrayList = new ArrayList<Tag>(1);
        arrayList.add(new Tag(this.SESSION_TAG));
        cacheItem.setTags(arrayList);
        if (cache != null) {
            try {
                if (n < 0) {
                    this.logger.debug((Object)"Item will never expire.");
                    if (this.locks.get(string) == null) return;
                    this.logger.debug((Object)"Will release the lock.");
                    cacheItem.setCacheItemPriority(CacheItemPriority.Default);
                    cache.insert(string, cacheItem, null, (LockHandle)this.locks.get(string), true);
                    this.locks.remove(string);
                    return;
                }
                this.logger.debug((Object)"Item will expire.");
                if (this.locks.get(string) != null) {
                    this.logger.debug((Object)"Will release the lock.");
                    cacheItem.setCacheItemPriority(CacheItemPriority.Default);
                    cacheItem.setExpiration(new Expiration(ExpirationType.Sliding, new TimeSpan(0, 0, n)));
                    CacheItemVersion cacheItemVersion = cache.insert(string, cacheItem, null, (LockHandle)this.locks.get(string), true);
                    this.locks.remove(string);
                    return;
                }
                cacheItem.setCacheItemPriority(CacheItemPriority.Default);
                cacheItem.setExpiration(new Expiration(ExpirationType.Sliding, new TimeSpan(0, 0, n)));
                CacheItemVersion cacheItemVersion = cache.insert(string, cacheItem, null, new LockHandle(), true);
                return;
            }
            catch (Exception exception) {
                this.logger.error((Object)("Unable to update session [" + string + "] in cache [" + this._cacheId + "]. See logs for more details."), (Throwable)exception);
                throw exception;
            }
        } else {
            this.logger.debug((Object)("Cache [" + cache + "] is not initialized."));
            throw new Exception("Cache [" + cache + "] is not initialized.");
        }
    }

    public void removeCacheItem(String string, Cache cache) throws Exception {
        this.logger.debug((Object)("Removing session: " + string));
        if (cache != null) {
            try {
                if (this.locks.get(string) != null) {
                    cache.delete(string, (LockHandle)this.locks.get(string), null, null);
                    this.locks.remove(string);
                } else {
                    cache.delete(string);
                }
                this.logger.debug((Object)"Session is removed.");
            }
            catch (Exception exception) {
                this.logger.error((Object)"Could not remove session. See log for more detail.", (Throwable)exception);
            }
        } else {
            this.logger.debug((Object)("Cache " + this._cacheId + " is not initialized."));
        }
    }

    public Object getCacheItem(String string, Cache cache, int n) throws LockException, Exception {
        this.logger.debug((Object)("Getting session: " + string));
        if (cache != null) {
            try {
                Object object = null;
                if (this.lockRemoteSession && this._primaryCache.equalsIgnoreCase(this._currentSessionCache)) {
                    LockHandle lockHandle = new LockHandle();
                    object = cache.get(string, true, new TimeSpan((long)this.lockTimeOut), lockHandle, null);
                    this.logger.debug((Object)("object is: " + object + ", lockid is: " + lockHandle.getLockId()));
                    if (object == null && lockHandle.getLockId() != null && lockHandle.getLockId().length() > 0) {
                        try {
                            if (++n < this.numberOfRetries) {
                                this.logger.debug((Object)("Waiting ... for " + this.retryInterval + " ms"));
                                Thread.sleep(this.retryInterval);
                                this.logger.debug((Object)("Retrying ... retry count: " + n));
                                if (SessionMonitor.getRequestCount(string) == 0) {
                                    this.logger.debug((Object)"Local Request Count is 0");
                                    return this.getCacheItem(string, cache, n);
                                }
                                return null;
                            }
                            if (this.isEmptySession()) {
                                return new EmptySession();
                            }
                            this.logger.debug((Object)"Terminating ...");
                            throw new LockException("Session is locked. please retry after few seconds.");
                        }
                        catch (LockException lockException) {
                            throw lockException;
                        }
                        catch (Exception exception) {
                            this.logger.debug((Object)("Could not get session: " + this._cacheId + ". See log for more details."), (Throwable)exception);
                        }
                    }
                    if (object != null) {
                        this.locks.put(string, lockHandle);
                    }
                } else {
                    object = cache.get(string, null);
                }
                return object;
            }
            catch (LockException lockException) {
                throw lockException;
            }
            catch (Exception exception) {
                this.logger.debug((Object)("Could not get session: " + this._cacheId + ". See log for more details."), (Throwable)exception);
                throw exception;
            }
        }
        this.logger.debug((Object)("Cache " + this._cacheId + " is not initialized."));
        throw new Exception();
    }

    public CacheSession findSessionById(String string) throws LockException, Exception {
        this.logger.debug((Object)("Trying to find session by id: " + string));
        Object object = this.getCacheItem(string, this.cache, 0);
        if (object != null && object instanceof CacheSession) {
            this.logger.debug((Object)"Found valid session object.");
            return (CacheSession)object;
        }
        this.logger.debug((Object)("Could not find session [" + string + "] in cache [" + this._cacheId + "]. Returning null."));
        return null;
    }

    public CacheSession initializeCacheSession(HttpServletRequest httpServletRequest, CacheSession cacheSession) throws LockException {
        String string;
        this.logger.debug((Object)("Initializing sessioin for request -> " + httpServletRequest.getRemoteAddr() + ":" + httpServletRequest.getRemotePort()));
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return cacheSession;
        }
        String string2 = string = cacheSession != null ? cacheSession.getSessionId() : null;
        if (string == null) {
            string = httpSession.getId();
        }
        if (cacheSession == null) {
            this.logger.debug((Object)("Creating new session with id: " + this.getPrimaryPrefix() + httpSession.getId()));
            cacheSession = new CacheSession(this.getPrimaryPrefix());
            cacheSession.setSessionId(string);
            cacheSession.setMaxInactiveInterval(httpSession.getMaxInactiveInterval());
        }
        SessionMonitor.addRequest(cacheSession.getSessionId());
        return cacheSession;
    }

    public void finalizeCacheSession(HttpSession httpSession, CacheSession cacheSession) throws Exception {
        this.logger.debug((Object)"Finalizing session ..");
        if (httpSession == null) {
            Cache cache = this.getCache();
            this.removeCacheItem(cacheSession.getSessionId(), cache);
            this.logger.debug((Object)("Session invalidated. Removing from cache: " + this._cacheId));
            return;
        }
        SessionMonitor.removeRequest(cacheSession.getSessionId());
        if (SessionMonitor.getRequestCount(cacheSession.getSessionId()) == 0 && cacheSession.updateToCache()) {
            this.logger.debug((Object)"Filling the session attributes...");
            Enumeration enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.logger.debug((Object)("Updating key: " + string));
                cacheSession.setAttribute(string, httpSession.getAttribute(string));
                this.logger.debug((Object)("Removing key [" + string + "] from local session"));
                httpSession.removeAttribute(string);
            }
            cacheSession.setIsNew(false);
            cacheSession.setMaxInactiveInterval(httpSession.getMaxInactiveInterval());
            this.logger.debug((Object)"Saving session state...");
            this.updateCacheItem(cacheSession.getSessionId(), cacheSession, httpSession.getMaxInactiveInterval(), this.cache);
        }
    }

    public CacheSession findValidRemoteSession(HttpServletRequest httpServletRequest, String[] stringArray) throws LockException {
        int n;
        if (stringArray == null) {
            return null;
        }
        CacheSession cacheSession = null;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null || stringArray[n].trim().length() == 0) continue;
            try {
                cacheSession = this.findSessionById(stringArray[n].trim());
                if (cacheSession == null) continue;
                cacheSession.setPrefix(this.getPrimaryPrefix());
                cacheSession = this.initializeCacheSession(httpServletRequest, cacheSession);
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cacheSession == null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n] == null || stringArray[n].trim().length() == 0 || SessionMonitor.getRequestCount(stringArray[n].trim()) <= 0) continue;
                cacheSession = new CacheSession(this.getPrimaryPrefix());
                cacheSession.setSessionId(stringArray[n].trim());
                break;
            }
        }
        return cacheSession;
    }

    public String getPrimaryPrefix() {
        return "";
    }

    public Cache getCache() {
        return this.cache;
    }

    public boolean isEmptySession() {
        return false;
    }
}

